/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.config;

import com.feed_the_beast.ftblib.lib.config.ConfigValueInstance;
import com.feed_the_beast.ftblib.lib.config.IIteratingConfig;
import com.feed_the_beast.ftblib.lib.gui.IOpenableGui;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiEditConfigValue;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.io.DataReader;
import com.feed_the_beast.ftblib.lib.math.Ticks;
import com.feed_the_beast.ftblib.lib.util.IWithID;
import com.feed_the_beast.ftblib.lib.util.JsonUtils;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.google.gson.JsonElement;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public abstract class ConfigValue
implements IWithID {
    public abstract String getString();

    public abstract boolean getBoolean();

    public abstract int getInt();

    public double getDouble() {
        return this.getLong();
    }

    public long getLong() {
        return this.getInt();
    }

    public Ticks getTimer() {
        return Ticks.get(this.getLong());
    }

    public abstract ConfigValue copy();

    public boolean equalsValue(ConfigValue value) {
        return value == this || this.getString().equals(value.getString());
    }

    public Color4I getColor() {
        return Color4I.GRAY;
    }

    public void addInfo(ConfigValueInstance inst, List<String> list) {
        if (inst.getCanEdit() && !inst.getDefaultValue().isNull()) {
            list.add(TextFormatting.AQUA + "Default: " + TextFormatting.RESET + inst.getDefaultValue().getStringForGUI().func_150254_d());
        }
    }

    public List<String> getVariants() {
        return Collections.emptyList();
    }

    public boolean isNull() {
        return false;
    }

    public void onClicked(IOpenableGui gui, ConfigValueInstance inst, MouseButton button, Runnable callback) {
        if (this instanceof IIteratingConfig) {
            if (inst.getCanEdit()) {
                this.setValueFromOtherValue(((IIteratingConfig)((Object)this)).getIteration(button.isLeft()));
                callback.run();
            }
            return;
        }
        new GuiEditConfigValue(inst, (value, set) -> {
            if (set) {
                this.setValueFromOtherValue(value);
                callback.run();
            }
            gui.openGui();
        }).openGui();
    }

    public boolean setValueFromString(@Nullable ICommandSender sender, String string, boolean simulate) {
        JsonElement json = DataReader.get(string).safeJson();
        if (!json.isJsonNull()) {
            if (!simulate) {
                NBTTagCompound nbt = new NBTTagCompound();
                NBTBase nbt1 = JsonUtils.toNBT(json);
                if (nbt1 != null) {
                    nbt.func_74782_a("x", nbt1);
                }
                this.readFromNBT(nbt, "x");
            }
            return true;
        }
        return false;
    }

    public void setValueFromOtherValue(ConfigValue value) {
        this.setValueFromString(null, value.getString(), false);
    }

    public void setValueFromJson(JsonElement json) {
        if (json.isJsonPrimitive()) {
            this.setValueFromString(null, json.getAsString(), false);
        }
    }

    public boolean equals(Object o) {
        return o instanceof ConfigValue && this.equalsValue((ConfigValue)o);
    }

    public final String toString() {
        return this.getString();
    }

    public ITextComponent getStringForGUI() {
        return new TextComponentString(this.getString());
    }

    public abstract void writeToNBT(NBTTagCompound var1, String var2);

    public abstract void readFromNBT(NBTTagCompound var1, String var2);

    public abstract void writeData(DataOut var1);

    public abstract void readData(DataIn var1);

    public boolean isEmpty() {
        return !this.getBoolean();
    }
}

