/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.data;

import com.feed_the_beast.ftblib.FTBLib;
import com.feed_the_beast.ftblib.FTBLibConfig;
import com.feed_the_beast.ftblib.events.ServerReloadEvent;
import com.feed_the_beast.ftblib.events.player.ForgePlayerLoadedEvent;
import com.feed_the_beast.ftblib.events.player.ForgePlayerSavedEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamDeletedEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamLoadedEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamSavedEvent;
import com.feed_the_beast.ftblib.events.universe.PersistentScheduledTaskEvent;
import com.feed_the_beast.ftblib.events.universe.UniverseClearCacheEvent;
import com.feed_the_beast.ftblib.events.universe.UniverseClosedEvent;
import com.feed_the_beast.ftblib.events.universe.UniverseLoadedEvent;
import com.feed_the_beast.ftblib.events.universe.UniverseSavedEvent;
import com.feed_the_beast.ftblib.lib.ATHelper;
import com.feed_the_beast.ftblib.lib.EnumReloadType;
import com.feed_the_beast.ftblib.lib.EnumTeamColor;
import com.feed_the_beast.ftblib.lib.data.FTBLibAPI;
import com.feed_the_beast.ftblib.lib.data.FakeForgePlayer;
import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.data.ForgeTeam;
import com.feed_the_beast.ftblib.lib.data.TeamType;
import com.feed_the_beast.ftblib.lib.io.DataReader;
import com.feed_the_beast.ftblib.lib.math.MathUtils;
import com.feed_the_beast.ftblib.lib.math.Ticks;
import com.feed_the_beast.ftblib.lib.util.FileUtils;
import com.feed_the_beast.ftblib.lib.util.NBTUtils;
import com.feed_the_beast.ftblib.lib.util.ServerUtils;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftblib.lib.util.misc.IScheduledTask;
import com.feed_the_beast.ftblib.lib.util.misc.TimeType;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="ftblib")
public class Universe {
    private static final HashSet<UUID> LOGGED_IN_PLAYERS = new HashSet();
    private static Universe INSTANCE = null;
    @Nonnull
    public final MinecraftServer server;
    public WorldServer world;
    public final Map<UUID, ForgePlayer> players;
    private final Map<String, ForgeTeam> teams;
    private final Short2ObjectOpenHashMap<ForgeTeam> teamMap;
    private final ForgeTeam noneTeam;
    private UUID uuid;
    private boolean needsSaving;
    boolean checkSaving;
    public ForgeTeam fakePlayerTeam;
    public FakeForgePlayer fakePlayer;
    private final List<ScheduledTask> scheduledTasks;
    private final List<PersistentScheduledTask> persistentScheduledTasks;
    private final List<ScheduledTask> scheduledTaskQueue;
    private final List<PersistentScheduledTask> persistentScheduledTaskQueue;
    public Ticks ticks;
    private boolean prevCheats = false;

    public static boolean loaded() {
        return INSTANCE != null;
    }

    public static Universe get() {
        if (INSTANCE == null) {
            throw new NullPointerException("FTBLib Universe == null!");
        }
        return INSTANCE;
    }

    public static void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        INSTANCE = new Universe(event.getServer());
    }

    public static void onServerStarted(FMLServerStartedEvent event) {
        Universe.INSTANCE.world = Universe.INSTANCE.server.func_71218_a(0);
        Universe.INSTANCE.ticks = Ticks.get(Universe.INSTANCE.world.func_82737_E());
        INSTANCE.load();
    }

    public static void onServerStopping(FMLServerStoppingEvent event) {
        if (Universe.loaded()) {
            for (ForgePlayer player : INSTANCE.getPlayers()) {
                if (!player.isOnline()) continue;
                player.onLoggedOut(player.getPlayer());
            }
            LOGGED_IN_PLAYERS.clear();
            INSTANCE.save();
            new UniverseClosedEvent(INSTANCE).post();
            INSTANCE = null;
        }
    }

    @SubscribeEvent
    public static void onWorldSaved(WorldEvent.Save event) {
        if (Universe.loaded()) {
            INSTANCE.save();
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (Universe.loaded() && event.player instanceof EntityPlayerMP && !ServerUtils.isFake((EntityPlayerMP)event.player)) {
            LOGGED_IN_PLAYERS.add(event.player.func_110124_au());
            INSTANCE.onPlayerLoggedIn((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        ForgePlayer p;
        if (Universe.loaded() && event.player instanceof EntityPlayerMP && LOGGED_IN_PLAYERS.remove(event.player.func_110124_au()) && (p = INSTANCE.getPlayer(event.player.func_146103_bH())) != null) {
            p.onLoggedOut((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (event.getEntity() instanceof EntityPlayerMP) {
            ForgePlayer p = INSTANCE.getPlayer(event.getEntityPlayer().func_146103_bH());
            if (p != null) {
                p.tempPlayer = (EntityPlayerMP)event.getEntity();
            }
            INSTANCE.clearCache();
            if (p != null) {
                p.tempPlayer = null;
            }
        }
    }

    @SubscribeEvent
    public static void onTickEvent(TickEvent.WorldTickEvent event) {
        if (!Universe.loaded()) {
            return;
        }
        Universe universe = Universe.get();
        if (event.phase == TickEvent.Phase.START) {
            universe.ticks = Ticks.get(event.world.func_82737_E());
        } else if (!event.world.field_72995_K && event.world.field_73011_w.getDimension() == 0) {
            boolean cheats;
            universe.scheduledTasks.addAll(universe.scheduledTaskQueue);
            universe.scheduledTaskQueue.clear();
            universe.persistentScheduledTasks.addAll(universe.persistentScheduledTaskQueue);
            universe.persistentScheduledTaskQueue.clear();
            Iterator<ScheduledTask> iterator = universe.scheduledTasks.iterator();
            while (iterator.hasNext()) {
                ScheduledTask task = iterator.next();
                if (!task.task.isComplete(universe, task.type, task.time)) continue;
                task.task.execute(universe);
                iterator.remove();
            }
            Iterator<PersistentScheduledTask> piterator = universe.persistentScheduledTasks.iterator();
            while (piterator.hasNext()) {
                PersistentScheduledTask task = piterator.next();
                if ((task.type == TimeType.TICKS ? universe.ticks.ticks() : System.currentTimeMillis()) < task.time) continue;
                new PersistentScheduledTaskEvent(universe, task.id, task.data).post();
                piterator.remove();
            }
            if (universe.server.func_71264_H() && universe.prevCheats != (cheats = ATHelper.areCommandsAllowedForAll(universe.server.func_184103_al()))) {
                universe.prevCheats = cheats;
                universe.clearCache();
            }
        }
    }

    public Universe(MinecraftServer s) {
        this.server = s;
        this.ticks = Ticks.NO_TICKS;
        this.players = new HashMap<UUID, ForgePlayer>();
        this.teams = new HashMap<String, ForgeTeam>();
        this.teamMap = new Short2ObjectOpenHashMap();
        this.noneTeam = new ForgeTeam(this, 0, "", TeamType.NONE);
        this.uuid = null;
        this.needsSaving = false;
        this.checkSaving = true;
        this.scheduledTasks = new ArrayList<ScheduledTask>();
        this.persistentScheduledTasks = new ArrayList<PersistentScheduledTask>();
        this.scheduledTaskQueue = new ArrayList<ScheduledTask>();
        this.persistentScheduledTaskQueue = new ArrayList<PersistentScheduledTask>();
    }

    public void markDirty() {
        this.needsSaving = true;
        this.checkSaving = true;
    }

    public UUID getUUID() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
            this.markDirty();
        }
        return this.uuid;
    }

    public void scheduleTask(TimeType type, long time, IScheduledTask task) {
        this.scheduledTaskQueue.add(new ScheduledTask(type, time, task));
    }

    public void scheduleTask(ResourceLocation id, TimeType type, long time, NBTTagCompound data) {
        this.persistentScheduledTaskQueue.add(new PersistentScheduledTask(id, type, time, data));
        this.markDirty();
    }

    private void load() {
        NBTTagCompound nbt;
        File[] files;
        File worldDataJsonFile;
        JsonElement worldData;
        File folder = new File(this.getWorldDirectory(), "data/ftb_lib/");
        NBTTagCompound universeData = NBTUtils.readNBT(new File(folder, "universe.dat"));
        if (universeData == null) {
            universeData = new NBTTagCompound();
        }
        if ((worldData = DataReader.get(worldDataJsonFile = new File(this.getWorldDirectory(), "world_data.json")).safeJson()).isJsonObject()) {
            JsonObject jsonWorldData = worldData.getAsJsonObject();
            if (jsonWorldData.has("world_id")) {
                universeData.func_74778_a("UUID", jsonWorldData.get("world_id").getAsString());
            }
            worldDataJsonFile.delete();
        }
        this.uuid = StringUtils.fromString(universeData.func_74779_i("UUID"));
        if (this.uuid != null && this.uuid.getLeastSignificantBits() == 0L && this.uuid.getMostSignificantBits() == 0L) {
            this.uuid = null;
        }
        NBTTagList taskTag = universeData.func_150295_c("PersistentScheduledTasks", 10);
        for (int i = 0; i < taskTag.func_74745_c(); ++i) {
            NBTTagCompound taskData = taskTag.func_150305_b(i);
            this.persistentScheduledTasks.add(new PersistentScheduledTask(new ResourceLocation(taskData.func_74779_i("ID")), TimeType.NAME_MAP.get(taskData.func_74779_i("Type")), taskData.func_74763_f("Time"), taskData.func_74775_l("Data")));
        }
        NBTTagCompound data = universeData.func_74775_l("Data");
        new UniverseLoadedEvent.Pre(this, data).post();
        HashMap<UUID, NBTTagCompound> playerNBT = new HashMap<UUID, NBTTagCompound>();
        HashMap<String, NBTTagCompound> teamNBT = new HashMap<String, NBTTagCompound>();
        try {
            files = new File(folder, "players").listFiles();
            if (files != null && files.length > 0) {
                for (File file : files) {
                    UUID uuid;
                    if (file.getName().indexOf(46) != file.getName().lastIndexOf(46) || (nbt = NBTUtils.readNBT(file)) == null) continue;
                    String uuidString = nbt.func_74779_i("UUID");
                    if (uuidString.isEmpty()) {
                        uuidString = FileUtils.getBaseName(file);
                        FileUtils.deleteSafe(file);
                    }
                    if ((uuid = StringUtils.fromString(uuidString)) == null) continue;
                    playerNBT.put(uuid, nbt);
                    ForgePlayer player = new ForgePlayer(this, uuid, nbt.func_74779_i("Name"));
                    this.players.put(uuid, player);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            files = new File(folder, "teams").listFiles();
            if (files != null && files.length > 0) {
                for (File file : files) {
                    if (!file.isFile() || file.getName().indexOf(46) != file.getName().lastIndexOf(46) || (nbt = NBTUtils.readNBT(file)) == null) continue;
                    String s = nbt.func_74779_i("ID");
                    if (s.isEmpty()) {
                        s = FileUtils.getBaseName(file);
                    }
                    teamNBT.put(s, nbt);
                    short uid = nbt.func_74765_d("UID");
                    ForgeTeam team = new ForgeTeam(this, this.generateTeamUID(uid), s, TeamType.NAME_MAP.get(nbt.func_74779_i("Type")));
                    this.addTeam(team);
                    if (uid != 0) continue;
                    team.markDirty();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.fakePlayerTeam = new ForgeTeam(this, 1, "fakeplayer", TeamType.SERVER_NO_SAVE){

            @Override
            public void markDirty() {
                Universe.this.markDirty();
            }
        };
        this.fakePlayer = new FakeForgePlayer(this);
        this.fakePlayer.team = this.fakePlayerTeam;
        this.fakePlayerTeam.setColor(EnumTeamColor.GRAY);
        new UniverseLoadedEvent.CreateServerTeams(this).post();
        for (ForgePlayer player : this.players.values()) {
            NBTTagCompound nbt2 = (NBTTagCompound)playerNBT.get(player.getId());
            if (nbt2 != null && !nbt2.func_82582_d()) {
                player.team = this.getTeam(nbt2.func_74779_i("TeamID"));
                player.deserializeNBT(nbt2);
            }
            new ForgePlayerLoadedEvent(player).post();
        }
        for (ForgeTeam team : this.getTeams()) {
            if (!team.type.save) continue;
            NBTTagCompound nbt3 = (NBTTagCompound)teamNBT.get(team.getId());
            if (nbt3 != null && !nbt3.func_82582_d()) {
                team.deserializeNBT(nbt3);
            }
            new ForgeTeamLoadedEvent(team).post();
        }
        if (universeData.func_74764_b("FakePlayer")) {
            this.fakePlayer.deserializeNBT(universeData.func_74775_l("FakePlayer"));
        }
        if (universeData.func_74764_b("FakeTeam")) {
            this.fakePlayerTeam.deserializeNBT(universeData.func_74775_l("FakeTeam"));
        }
        this.fakePlayerTeam.owner = this.fakePlayer;
        new UniverseLoadedEvent.Post(this, data).post();
        new UniverseLoadedEvent.Finished(this).post();
        FTBLibAPI.reloadServer(this, (ICommandSender)this.server, EnumReloadType.CREATED, ServerReloadEvent.ALL);
    }

    private void save() {
        if (!this.checkSaving) {
            return;
        }
        if (this.needsSaving) {
            if (FTBLibConfig.debugging.print_more_info) {
                FTBLib.LOGGER.info("Saving universe data");
            }
            NBTTagCompound universeData = new NBTTagCompound();
            NBTTagCompound data = new NBTTagCompound();
            new UniverseSavedEvent(this, data).post();
            universeData.func_74782_a("Data", (NBTBase)data);
            universeData.func_74778_a("UUID", StringUtils.fromUUID(this.getUUID()));
            NBTTagList taskTag = new NBTTagList();
            for (PersistentScheduledTask task : this.persistentScheduledTasks) {
                NBTTagCompound taskData = new NBTTagCompound();
                taskData.func_74778_a("ID", task.id.toString());
                taskData.func_74778_a("Type", TimeType.NAME_MAP.getName(task.type));
                taskData.func_74772_a("Time", task.time);
                taskData.func_74782_a("Data", (NBTBase)task.data);
                taskTag.func_74742_a((NBTBase)taskData);
            }
            universeData.func_74782_a("PersistentScheduledTasks", (NBTBase)taskTag);
            universeData.func_74782_a("FakePlayer", (NBTBase)this.fakePlayer.serializeNBT());
            universeData.func_74782_a("FakeTeam", (NBTBase)this.fakePlayerTeam.serializeNBT());
            NBTUtils.writeNBTSafe(new File(this.getWorldDirectory(), "data/ftb_lib/universe.dat"), universeData);
            this.needsSaving = false;
        }
        for (ForgePlayer player : this.players.values()) {
            if (!player.needsSaving) continue;
            if (FTBLibConfig.debugging.print_more_info) {
                FTBLib.LOGGER.info("Saved player data for " + player.getName());
            }
            NBTTagCompound nbt = player.serializeNBT();
            nbt.func_74778_a("Name", player.getName());
            nbt.func_74778_a("UUID", StringUtils.fromUUID(player.getId()));
            nbt.func_74778_a("TeamID", player.team.getId());
            NBTUtils.writeNBTSafe(player.getDataFile(""), nbt);
            new ForgePlayerSavedEvent(player).post();
            player.needsSaving = false;
        }
        for (ForgeTeam team : this.getTeams()) {
            if (!team.needsSaving) continue;
            if (FTBLibConfig.debugging.print_more_info) {
                FTBLib.LOGGER.info("Saved team data for " + team.getId());
            }
            File file = team.getDataFile("");
            if (team.type.save && team.isValid()) {
                NBTTagCompound nbt = team.serializeNBT();
                nbt.func_74778_a("ID", team.getId());
                nbt.func_74777_a("UID", team.getUID());
                nbt.func_74778_a("Type", team.type.func_176610_l());
                NBTUtils.writeNBTSafe(file, nbt);
                new ForgeTeamSavedEvent(team).post();
                team.needsSaving = false;
            } else if (file.exists()) {
                file.delete();
            }
            team.needsSaving = false;
        }
        this.checkSaving = false;
    }

    public File getWorldDirectory() {
        return this.server.func_71218_a(0).func_72860_G().func_75765_b();
    }

    private void onPlayerLoggedIn(EntityPlayerMP player) {
        boolean firstLogin;
        if (!player.field_71133_b.func_184103_al().func_152607_e(player.func_146103_bH())) {
            return;
        }
        ForgePlayer p = this.getPlayer(player.func_146103_bH());
        if (p != null && p.isOnline()) {
            return;
        }
        boolean bl = firstLogin = p == null;
        if (firstLogin) {
            p = new ForgePlayer(this, player.func_110124_au(), player.func_70005_c_());
            this.players.put(p.getId(), p);
        } else if (!p.getName().equals(player.func_70005_c_())) {
            p.setName(player.func_70005_c_());
        }
        p.onLoggedIn(player, this, firstLogin);
    }

    public Collection<ForgePlayer> getPlayers() {
        return this.players.values();
    }

    @Nullable
    public ForgePlayer getPlayer(@Nullable UUID id) {
        if (id == null) {
            return null;
        }
        if (id.equals(ServerUtils.FAKE_PLAYER_PROFILE.getId())) {
            return this.fakePlayer;
        }
        return this.players.get(id);
    }

    @Nullable
    public ForgePlayer getPlayer(CharSequence nameOrId) {
        String s = nameOrId.toString().toLowerCase();
        if (s.isEmpty()) {
            return null;
        }
        UUID id = StringUtils.fromString(s);
        if (id != null) {
            return this.getPlayer(id);
        }
        if (s.equals(ServerUtils.FAKE_PLAYER_PROFILE.getName().toLowerCase())) {
            return this.fakePlayer;
        }
        for (ForgePlayer p : this.players.values()) {
            if (!p.getName().toLowerCase().equals(s)) continue;
            return p;
        }
        for (ForgePlayer p : this.players.values()) {
            if (!p.getName().toLowerCase().contains(s)) continue;
            return p;
        }
        return null;
    }

    public ForgePlayer getPlayer(@Nullable ICommandSender sender) {
        if (sender instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)sender;
            if (ServerUtils.isFake(player)) {
                this.fakePlayer.tempPlayer = player;
                this.fakePlayer.clearCache();
                return this.fakePlayer;
            }
            ForgePlayer p = this.getPlayer(player.func_146103_bH());
            if (p == null) {
                throw new NullPointerException("Player can't be found for " + player.func_70005_c_() + ":" + StringUtils.fromUUID(player.func_110124_au()) + ":" + player.getClass().getName());
            }
            return p;
        }
        throw new IllegalArgumentException("Sender is not a player!");
    }

    public ForgePlayer getPlayer(ForgePlayer player) {
        ForgePlayer p = this.getPlayer(player.getId());
        return p == null ? player : p;
    }

    @Nullable
    public ForgePlayer getPlayer(GameProfile profile) {
        ForgePlayer player = this.getPlayer(profile.getId());
        if (player == null && FTBLibConfig.general.merge_offline_mode_players.get(!this.server.func_71262_S()) && (player = this.getPlayer(profile.getName())) != null) {
            this.players.put(profile.getId(), player);
            player.markDirty();
        }
        return player;
    }

    public Collection<ForgeTeam> getTeams() {
        return this.teams.values();
    }

    public ForgeTeam getTeam(String id) {
        ForgeTeam team2;
        if (id.isEmpty()) {
            return this.noneTeam;
        }
        if (id.length() == 4) {
            try {
                team2 = this.getTeam(Integer.valueOf(id, 16).shortValue());
                if (team2.isValid()) {
                    return team2;
                }
            }
            catch (Exception team2) {
                // empty catch block
            }
        }
        if (id.equals("fakeplayer")) {
            return this.fakePlayerTeam;
        }
        team2 = this.teams.get(id);
        if (team2 != null) {
            return team2;
        }
        ForgePlayer player = this.getPlayer(id);
        if (player != null) {
            return player.team;
        }
        return this.noneTeam;
    }

    public ForgeTeam getTeam(short uid) {
        if (uid == 0) {
            return this.noneTeam;
        }
        if (uid == 1) {
            return this.fakePlayerTeam;
        }
        ForgeTeam team = (ForgeTeam)this.teamMap.get(uid);
        return team == null ? this.noneTeam : team;
    }

    public Collection<ForgePlayer> getOnlinePlayers() {
        Set<ForgePlayer> set = Collections.emptySet();
        for (ForgePlayer player : this.getPlayers()) {
            if (!player.isOnline()) continue;
            if (set.isEmpty()) {
                set = new HashSet<ForgePlayer>();
            }
            set.add(player);
        }
        return set;
    }

    public void clearCache() {
        new UniverseClearCacheEvent(this).post();
        this.getTeams().forEach(ForgeTeam::clearCache);
        this.getPlayers().forEach(ForgePlayer::clearCache);
        this.fakePlayer.clearCache();
    }

    public void addTeam(ForgeTeam team) {
        this.teamMap.put(team.getUID(), (Object)team);
        this.teams.put(team.getId(), team);
    }

    public void removeTeam(ForgeTeam team) {
        File folder = new File(this.getWorldDirectory(), "data/ftb_lib/teams/");
        new ForgeTeamDeletedEvent(team, folder).post();
        this.teamMap.remove(team.getUID());
        this.teams.remove(team.getId());
        FileUtils.deleteSafe(new File(folder, team.getId() + ".dat"));
        this.markDirty();
        this.clearCache();
    }

    public short generateTeamUID(short id) {
        while (id == 0 || id == 1 || id == 2 || this.teamMap.containsKey(id)) {
            id = (short)MathUtils.RAND.nextInt();
        }
        return id;
    }

    private static class PersistentScheduledTask {
        private final ResourceLocation id;
        private final TimeType type;
        private final long time;
        private final NBTTagCompound data;

        public PersistentScheduledTask(ResourceLocation i, TimeType tt, long t, NBTTagCompound d) {
            this.id = i;
            this.type = tt;
            this.time = t;
            this.data = d;
        }
    }

    private static class ScheduledTask {
        private final TimeType type;
        private final long time;
        private final IScheduledTask task;

        public ScheduledTask(TimeType tt, long t, IScheduledTask tk) {
            this.type = tt;
            this.time = t;
            this.task = tk;
        }
    }
}

