/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.command;

import com.feed_the_beast.ftblib.lib.command.ICommandWithParent;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public abstract class CmdBase
extends CommandBase
implements ICommandWithParent {
    private final String name;
    public final Level level;
    private ICommand parent;

    public CmdBase(String n, Level l) {
        this.name = n;
        this.level = l;
    }

    public final String func_71517_b() {
        return this.name;
    }

    public int func_82362_a() {
        return this.level.requiredPermissionLevel;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return this.level.permissionChecker.checkPermission(server, sender, this);
    }

    public void checkArgs(ICommandSender sender, String[] args, int i) throws CommandException {
        if (args.length < i) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        if (args.length == 0) {
            return Collections.emptyList();
        }
        if (this.func_82358_a(args, args.length - 1)) {
            return CmdBase.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        return super.func_184883_a(server, sender, args, pos);
    }

    @Override
    public ICommand getParent() {
        return this.parent;
    }

    @Override
    public void setParent(@Nullable ICommand c) {
        this.parent = c;
    }

    public static class Level {
        public static final Level ALL = new Level(0, (server, sender, command) -> true);
        public static final Level OP_OR_SP = new Level(2, (server, sender, command) -> server.func_71264_H() || sender.func_70003_b(2, command.func_71517_b()));
        public static final Level OP = new Level(2, (server, sender, command) -> sender.func_70003_b(2, command.func_71517_b()));
        public static final Level STRONG_OP_OR_SP = new Level(4, (server, sender, command) -> server.func_71264_H() || sender.func_70003_b(4, command.func_71517_b()));
        public static final Level STRONG_OP = new Level(4, (server, sender, command) -> sender.func_70003_b(4, command.func_71517_b()));
        public static final Level SERVER = new Level(4, (server, sender, command) -> sender instanceof MinecraftServer);
        public final int requiredPermissionLevel;
        public final PermissionChecker permissionChecker;

        public Level(int l, PermissionChecker p) {
            this.requiredPermissionLevel = l;
            this.permissionChecker = p;
        }

        public static interface PermissionChecker {
            public boolean checkPermission(MinecraftServer var1, ICommandSender var2, ICommand var3);
        }
    }
}

