/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client;

import dev.ftb.mods.ftbchunks.client.MinimapPosition;
import dev.ftb.mods.ftbchunks.client.map.BiomeBlendMode;
import dev.ftb.mods.ftbchunks.client.map.MapManager;
import dev.ftb.mods.ftbchunks.client.map.MapMode;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.snbt.config.BooleanValue;
import dev.ftb.mods.ftblibrary.snbt.config.DoubleValue;
import dev.ftb.mods.ftblibrary.snbt.config.EnumValue;
import dev.ftb.mods.ftblibrary.snbt.config.IntValue;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import me.shedaniel.architectury.platform.Platform;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;

public interface FTBChunksClientConfig {
    public static final SNBTConfig CONFIG = SNBTConfig.create((String)"ftbchunks-client");
    public static final DoubleValue NOISE = (DoubleValue)CONFIG.getDouble("noise", 0.05, 0.0, 0.5).fader().comment(new String[]{"Noise added to map to make it look less plastic"});
    public static final DoubleValue SHADOWS = (DoubleValue)CONFIG.getDouble("shadows", 0.1, 0.0, 0.3).fader().comment(new String[]{"Shadow intensity"});
    public static final BooleanValue CHUNK_GRID = (BooleanValue)CONFIG.getBoolean("chunk_grid", false).comment(new String[]{"Chunk grid overlay in large map"});
    public static final BooleanValue REDUCED_COLOR_PALETTE = (BooleanValue)CONFIG.getBoolean("reduced_color_palette", false).comment(new String[]{"Reduces color palette to 256 colors"});
    public static final DoubleValue SATURATION = (DoubleValue)CONFIG.getDouble("saturation", 1.0, 0.0, 1.0).fader().comment(new String[]{"Color intensity"});
    public static final BooleanValue CLAIMED_CHUNKS_ON_MAP = (BooleanValue)CONFIG.getBoolean("claimed_chunks_on_map", true).comment(new String[]{"Show claimed chunks on the map"});
    public static final BooleanValue OWN_CLAIMED_CHUNKS_ON_MAP = (BooleanValue)CONFIG.getBoolean("own_claimed_chunks_on_map", true).comment(new String[]{"Show your own claimed chunks on the map"});
    public static final BooleanValue IN_WORLD_WAYPOINTS = (BooleanValue)CONFIG.getBoolean("in_world_waypoints", true).comment(new String[]{"Show waypoints in world"});
    public static final BooleanValue DEATH_WAYPOINTS = (BooleanValue)CONFIG.getBoolean("death_waypoints", true).comment(new String[]{"Enables creation of death waypoints"});
    public static final EnumValue<MapMode> MAP_MODE = (EnumValue)CONFIG.getEnum("map_mode", MapMode.NAME_MAP).comment(new String[]{"Different ways to render map"});
    public static final IntValue WATER_HEIGHT_FACTOR = (IntValue)CONFIG.getInt("water_height_factor", 8, 0, 128).comment(new String[]{"How many blocks should height checks skip in water. 0 means flat water, ignoring terrain"});
    public static final EnumValue<BiomeBlendMode> BIOME_BLEND = (EnumValue)CONFIG.getEnum("biome_blend", BiomeBlendMode.NAME_MAP).comment(new String[]{"Biome blend"});
    public static final SNBTConfig MINIMAP = CONFIG.getGroup("minimap");
    public static final BooleanValue MINIMAP_ENABLED = (BooleanValue)MINIMAP.getBoolean("enabled", !FTBChunksClientConfig.hasOtherMinimapMod()).comment(new String[]{"Enable minimap"});
    public static final EnumValue<MinimapPosition> MINIMAP_POSITION = (EnumValue)MINIMAP.getEnum("position", MinimapPosition.NAME_MAP).comment(new String[]{"Enables minimap to show up in corner"});
    public static final DoubleValue MINIMAP_SCALE = (DoubleValue)MINIMAP.getDouble("scale", 1.0, 0.25, 4.0).comment(new String[]{"Scale of minimap"});
    public static final BooleanValue MINIMAP_LOCKED_NORTH = (BooleanValue)MINIMAP.getBoolean("locked_north", true).comment(new String[]{"Minimap will not rotate"});
    public static final BooleanValue MINIMAP_WAYPOINTS = (BooleanValue)MINIMAP.getBoolean("waypoints", true).comment(new String[]{"Show waypoints on minimap"});
    public static final BooleanValue MINIMAP_PLAYER_HEADS = (BooleanValue)MINIMAP.getBoolean("player_heads", true).comment(new String[]{"Show player heads on minimap"});
    public static final BooleanValue MINIMAP_ENTITIES = (BooleanValue)MINIMAP.getBoolean("entities", true).comment(new String[]{"Show entities on minimap"});
    public static final BooleanValue MINIMAP_ENTITY_HEADS = (BooleanValue)MINIMAP.getBoolean("entity_heads", true).comment(new String[]{"Show entity heads on minimap"});
    public static final BooleanValue MINIMAP_LARGE_ENTITIES = (BooleanValue)MINIMAP.getBoolean("large_entities", false).comment(new String[]{"Entities in minimap will be larger"});
    public static final BooleanValue MINIMAP_XYZ = (BooleanValue)MINIMAP.getBoolean("xyz", true).comment(new String[]{"Show XYZ under minimap"});
    public static final BooleanValue MINIMAP_BIOME = (BooleanValue)MINIMAP.getBoolean("biome", true).comment(new String[]{"Show biome under minimap"});
    public static final BooleanValue MINIMAP_BLUR = (BooleanValue)MINIMAP.getBoolean("blur", false).comment(new String[]{"Blurs minimap"});
    public static final BooleanValue MINIMAP_COMPASS = (BooleanValue)MINIMAP.getBoolean("compass", true).comment(new String[]{"Adds NWSE compass inside minimap"});
    public static final IntValue MINIMAP_VISIBILITY = (IntValue)MINIMAP.getInt("visibility", 255, 0, 255).comment(new String[]{"Minimap visibility"});
    public static final BooleanValue MINIMAP_ZONE = (BooleanValue)MINIMAP.getBoolean("zone", true).comment(new String[]{"Show zone (claimed chunk or wilderness) under minimap"});
    public static final DoubleValue MINIMAP_ZOOM = (DoubleValue)MINIMAP.getDouble("zoom", 1.0, 1.0, 4.0).comment(new String[]{"Zoom distance of the minimap"});
    public static final BooleanValue DEBUG_INFO = (BooleanValue)CONFIG.getBoolean("debug_info", false).comment(new String[]{"Enables debug info"});
    public static final IntValue TASK_QUEUE_TICKS = (IntValue)CONFIG.getInt("task_queue_ticks", 4, 1, 300).excluded().comment(new String[]{"Advanced option. How often queued tasks will run"});
    public static final IntValue RERENDER_QUEUE_TICKS = (IntValue)CONFIG.getInt("rerender_queue_ticks", 60, 1, 600).excluded().comment(new String[]{"Advanced option. How often map render update will be queued"});
    public static final IntValue TASK_QUEUE_MAX = (IntValue)CONFIG.getInt("task_queue_max", 100, 1, 10000).excluded().comment(new String[]{"Advanced option. Max tasks that can queue up"});
    public static final IntValue WATER_VISIBILITY = (IntValue)CONFIG.getInt("water_visibility", 220, 0, 255).excluded().comment(new String[]{"Advanced option. Water visibility"});
    public static final IntValue GRASS_DARKNESS = (IntValue)CONFIG.getInt("grass_darkness", 50, 0, 255).excluded().comment(new String[]{"Advanced option. Grass darkness"});
    public static final IntValue FOLIAGE_DARKNESS = (IntValue)CONFIG.getInt("foliage_darkness", 50, 0, 255).excluded().comment(new String[]{"Advanced option. Foliage darkness"});

    public static boolean hasOtherMinimapMod() {
        return Platform.isModLoaded((String)"journeymap") || Platform.isModLoaded((String)"voxelmap");
    }

    public static void init() {
        CONFIG.load(Platform.getGameFolder().resolve("local/ftbchunks/client-config.snbt"));
    }

    public static void openSettings(Screen screen) {
        ConfigGroup group = new ConfigGroup("ftbchunks");
        CONFIG.createClientConfig(group);
        EditConfigScreen gui = new EditConfigScreen(group);
        group.savedCallback = b -> {
            if (b) {
                FTBChunksClientConfig.saveConfig();
            }
            if (MapManager.inst != null) {
                MapManager.inst.updateAllRegions(false);
            }
            Minecraft.func_71410_x().func_147108_a(screen);
        };
        gui.openGui();
    }

    public static void saveConfig() {
        CONFIG.save(Platform.getGameFolder().resolve("local/ftbchunks/client-config.snbt"));
    }
}

