/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.statements.ITriggerInternalSided;
import buildcraft.api.statements.ITriggerProvider;
import buildcraft.api.statements.StatementManager;
import forestry.api.modules.ForestryModule;
import forestry.core.utils.ModUtil;
import forestry.modules.BlankForestryModule;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.Optional;

@ForestryModule(containerID="forestry_compat", moduleID="buildcraft.statements", name="BuildCraft 6 Statements", author="mezz", url="http://forestry.sengir.net/", unlocalizedDescription="for.module.buildcraft6.description")
@Optional.Interface(iface="buildcraft.api.statements.ITriggerProvider", modid="buildcraftlib")
public class PluginBuildCraftStatements
extends BlankForestryModule
implements ITriggerProvider {
    @Override
    public boolean isAvailable() {
        return ModUtil.isModLoaded("buildcraftlib", "[7.99.17,8.0)");
    }

    @Override
    public String getFailMessage() {
        return "Compatible BuildCraftAPI|statements version not found";
    }

    @Override
    @Optional.Method(modid="buildcraftlib")
    public void doInit() {
        StatementManager.registerTriggerProvider((ITriggerProvider)this);
    }

    @Optional.Method(modid="buildcraftlib")
    public void addInternalTriggers(Collection<ITriggerInternal> triggers, IStatementContainer container) {
        TileEntity tile = container.getTile();
        if (tile instanceof ITriggerProvider) {
            ((ITriggerProvider)tile).addInternalTriggers(triggers, container);
        }
    }

    @Optional.Method(modid="buildcraftlib")
    public void addInternalSidedTriggers(Collection<ITriggerInternalSided> triggers, IStatementContainer container, @Nonnull EnumFacing side) {
        TileEntity tile = container.getTile();
        if (tile instanceof ITriggerProvider) {
            ((ITriggerProvider)tile).addInternalSidedTriggers(triggers, container, side);
        }
    }

    @Optional.Method(modid="buildcraftlib")
    public void addExternalTriggers(Collection<ITriggerExternal> triggers, @Nonnull EnumFacing side, TileEntity tile) {
        if (tile instanceof ITriggerProvider) {
            ((ITriggerProvider)tile).addExternalTriggers(triggers, side, tile);
        }
    }
}

