/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.util;

import com.mojang.datafixers.util.Pair;
import java.nio.ByteBuffer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.vertex.VertexFormat;

public class BufferBuilderReader {
    private final ByteBuffer buffer;
    private final int vertexCount;
    private final int formatSize;
    private final int size;

    public BufferBuilderReader(BufferBuilder builder) {
        VertexFormat vertexFormat = builder.getVertexFormat();
        Pair data = builder.func_227832_f_();
        this.buffer = (ByteBuffer)data.getSecond();
        this.formatSize = vertexFormat.func_177338_f();
        this.vertexCount = ((BufferBuilder.DrawState)data.getFirst()).func_227839_b_();
        this.size = this.vertexCount * this.formatSize;
    }

    public boolean isEmpty() {
        return this.vertexCount == 0;
    }

    public int vertIdx(int vertexIndex) {
        return vertexIndex * this.formatSize;
    }

    public float getX(int index) {
        return this.buffer.getFloat(this.vertIdx(index));
    }

    public float getY(int index) {
        return this.buffer.getFloat(this.vertIdx(index) + 4);
    }

    public float getZ(int index) {
        return this.buffer.getFloat(this.vertIdx(index) + 8);
    }

    public byte getR(int index) {
        return this.buffer.get(this.vertIdx(index) + 12);
    }

    public byte getG(int index) {
        return this.buffer.get(this.vertIdx(index) + 13);
    }

    public byte getB(int index) {
        return this.buffer.get(this.vertIdx(index) + 14);
    }

    public byte getA(int index) {
        return this.buffer.get(this.vertIdx(index) + 15);
    }

    public float getU(int index) {
        return this.buffer.getFloat(this.vertIdx(index) + 16);
    }

    public float getV(int index) {
        return this.buffer.getFloat(this.vertIdx(index) + 20);
    }

    public int getLight(int index) {
        return this.buffer.getInt(this.vertIdx(index) + 24);
    }

    public byte getNX(int index) {
        return this.buffer.get(this.vertIdx(index) + 28);
    }

    public byte getNY(int index) {
        return this.buffer.get(this.vertIdx(index) + 29);
    }

    public byte getNZ(int index) {
        return this.buffer.get(this.vertIdx(index) + 30);
    }

    public int getVertexCount() {
        return this.vertexCount;
    }

    public int getSize() {
        return this.size;
    }
}

