/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.mixin.light;

import com.jozufozu.flywheel.backend.RenderWork;
import com.jozufozu.flywheel.backend.instancing.InstanceManager;
import com.jozufozu.flywheel.backend.instancing.InstancedRenderDispatcher;
import com.jozufozu.flywheel.light.LightUpdater;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.network.play.server.SUpdateLightPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPlayNetHandler.class})
public class NetworkLightUpdateMixin {
    @Inject(at={@At(value="TAIL")}, method={"handleLightUpdatePacked"})
    private void onLightPacket(SUpdateLightPacket packet, CallbackInfo ci) {
        RenderWork.enqueue(() -> {
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            if (world == null) {
                return;
            }
            int chunkX = packet.func_218716_b();
            int chunkZ = packet.func_218714_c();
            Chunk chunk = world.func_72863_F().func_217205_a(chunkX, chunkZ, false);
            if (chunk != null) {
                InstanceManager<TileEntity> tiles = InstancedRenderDispatcher.getTiles((IWorld)world);
                InstanceManager<Entity> entities = InstancedRenderDispatcher.getEntities((IWorld)world);
                chunk.func_177434_r().values().forEach(tiles::onLightUpdate);
                Arrays.stream(chunk.func_177429_s()).flatMap(Collection::stream).forEach(entities::onLightUpdate);
            }
            LightUpdater.getInstance().onLightPacket((IBlockDisplayReader)world, chunkX, chunkZ);
        });
    }
}

