/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.mixin;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.OptifineHandler;
import com.jozufozu.flywheel.backend.instancing.InstancedRenderDispatcher;
import com.jozufozu.flywheel.core.crumbling.CrumblingRenderer;
import com.jozufozu.flywheel.event.ReloadRenderersEvent;
import com.jozufozu.flywheel.event.RenderLayerEvent;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeBuffers;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.lwjgl.opengl.GL20;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={WorldRenderer.class})
public class RenderHooksMixin {
    @Shadow
    private ClientWorld field_72769_h;
    @Shadow
    @Final
    private RenderTypeBuffers field_228415_m_;

    @Inject(at={@At(value="TAIL")}, method={"renderChunkLayer"})
    private void renderLayer(RenderType type, MatrixStack stack, double camX, double camY, double camZ, CallbackInfo ci) {
        RenderTypeBuffers renderBuffers = this.field_228415_m_;
        MinecraftForge.EVENT_BUS.post((Event)new RenderLayerEvent(this.field_72769_h, type, stack, renderBuffers, camX, camY, camZ));
        if (!OptifineHandler.usingShaders()) {
            GL20.glUseProgram((int)0);
        }
        renderBuffers.func_228487_b_().func_228462_a_(type);
    }

    @Inject(at={@At(value="TAIL")}, method={"allChanged"})
    private void refresh(CallbackInfo ci) {
        Backend.getInstance().refresh();
        MinecraftForge.EVENT_BUS.post((Event)new ReloadRenderersEvent(this.field_72769_h));
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/WorldRenderer;checkPoseStack(Lcom/mojang/blaze3d/matrix/MatrixStack;)V", ordinal=2)}, method={"renderLevel"})
    private void renderBlockBreaking(MatrixStack stack, float p_228426_2_, long p_228426_3_, boolean p_228426_5_, ActiveRenderInfo info, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f p_228426_9_, CallbackInfo ci) {
        if (!Backend.getInstance().available()) {
            return;
        }
        Matrix4f view = stack.func_227866_c_().func_227870_a_();
        Matrix4f viewProjection = view.func_226601_d_();
        viewProjection.multiplyBackward(Backend.getInstance().getProjectionMatrix());
        Vector3d cameraPos = info.func_216785_c();
        CrumblingRenderer.renderBreaking(this.field_72769_h, viewProjection, cameraPos.field_72450_a, cameraPos.field_72448_b, cameraPos.field_72449_c);
        if (!OptifineHandler.usingShaders()) {
            GL20.glUseProgram((int)0);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"setBlockDirty(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/block/BlockState;)V"})
    private void checkUpdate(BlockPos pos, BlockState lastState, BlockState newState, CallbackInfo ci) {
        InstancedRenderDispatcher.getTiles((IWorld)this.field_72769_h).update(this.field_72769_h.func_175625_s(pos));
    }
}

