/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.state;

import com.google.common.collect.ImmutableList;
import com.jozufozu.flywheel.backend.gl.GlTextureUnit;
import com.jozufozu.flywheel.backend.state.IRenderState;
import com.jozufozu.flywheel.backend.state.TextureRenderState;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;

public class RenderState
implements IRenderState {
    private final Map<GlTextureUnit, ResourceLocation> textures;
    private final ImmutableList<IRenderState> states;

    public RenderState(Map<GlTextureUnit, ResourceLocation> textures, ImmutableList<IRenderState> states) {
        this.textures = textures;
        this.states = states;
    }

    @Override
    public void bind() {
        this.states.forEach(IRenderState::bind);
    }

    @Override
    public void unbind() {
        this.states.forEach(IRenderState::unbind);
    }

    @Override
    @Nullable
    public ResourceLocation getTexture(GlTextureUnit textureUnit) {
        return this.textures.get((Object)textureUnit);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RenderState that = (RenderState)o;
        return this.states.equals(that.states);
    }

    public int hashCode() {
        return Objects.hash(this.states);
    }

    public static StateBuilder builder() {
        return new StateBuilder();
    }

    public static class StateBuilder {
        private final ImmutableList.Builder<IRenderState> states = ImmutableList.builder();
        private final Map<GlTextureUnit, ResourceLocation> textures = new EnumMap<GlTextureUnit, ResourceLocation>(GlTextureUnit.class);

        public StateBuilder texture(ResourceLocation name) {
            return this.addState(TextureRenderState.get(name));
        }

        public StateBuilder addState(IRenderState state) {
            if (state instanceof TextureRenderState) {
                TextureRenderState tex = (TextureRenderState)state;
                if (this.textures.put(tex.unit, tex.location) == null) {
                    this.states.add((Object)state);
                }
            } else {
                this.states.add((Object)state);
            }
            return this;
        }

        public RenderState build() {
            return new RenderState(this.textures, (ImmutableList<IRenderState>)this.states.build());
        }
    }
}

