/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.tileentity;

import cofh.redstoneflux.api.IEnergyContainerItem;
import crazypants.enderio.base.power.wireless.WirelessChargedLocation;
import de.keridos.floodlights.capability.CustomEnergyStorage;
import de.keridos.floodlights.compatability.ModCompatibility;
import de.keridos.floodlights.core.NetworkDataList;
import de.keridos.floodlights.handler.ConfigHandler;
import de.keridos.floodlights.tileentity.TileEntityMetaFloodlight;
import de.keridos.floodlights.util.MathUtil;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="ic2")})
public class TileEntityFLElectric
extends TileEntityMetaFloodlight
implements IEnergySink {
    protected int energyUsage = ConfigHandler.energyUsage;
    protected int realEnergyUsage;
    protected boolean wasAddedToEnergyNet = false;
    private CustomEnergyStorage energy = new CustomEnergyStorage();
    private WirelessChargedLocation wirelessChargedLocation;

    public TileEntityFLElectric() {
        this.updateEnergyUsage();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (ModCompatibility.IC2Loaded && !this.wasAddedToEnergyNet && !this.field_145850_b.field_72995_K) {
            this.addToIc2EnergyNetwork();
            this.wasAddedToEnergyNet = true;
        }
        if (this.field_145850_b.field_72995_K || !this.isReady()) {
            return;
        }
        this.tryDischargeItem(this.inventory.getStackInSlot(0));
        this.tryChargeFromWirelessCharger();
        if (this.energy.storageChanged()) {
            this.syncWithAccessors();
        }
        if (this.active && this.hasEnergy()) {
            this.energy.extractEnergy(this.realEnergyUsage, false);
        }
    }

    @Override
    protected boolean hasEnergy() {
        return this.energy.getEnergyStored() >= this.realEnergyUsage;
    }

    private void tryDischargeItem(ItemStack itemStack) {
        if (itemStack != ItemStack.field_190927_a) {
            if (ModCompatibility.IC2Loaded && this.inventory.getStackInSlot(0).func_77973_b() instanceof IElectricItem) {
                double dischargeValue = ((double)this.energy.getMaxEnergyStored() - (double)this.energy.getEnergyStored()) / 8.0;
                double discharged = ElectricItem.manager.discharge(this.inventory.getStackInSlot(0), dischargeValue, 4, false, true, false);
                this.energy.receiveEnergy(MathUtil.truncateDoubleToInt(8.0 * discharged), false);
            }
            if (itemStack.func_77973_b() instanceof IEnergyContainerItem) {
                IEnergyContainerItem item = (IEnergyContainerItem)itemStack.func_77973_b();
                int dischargeValue = Math.min(item.getEnergyStored(itemStack), this.energy.getMaxEnergyStored() - this.energy.getEnergyStored());
                this.energy.receiveEnergy(item.extractEnergy(itemStack, dischargeValue, false), false);
            }
        }
    }

    private void tryChargeFromWirelessCharger() {
        if (!ModCompatibility.EnderIOLoaded || this.energy.isFull()) {
            return;
        }
        if (this.wirelessChargedLocation == null) {
            this.wirelessChargedLocation = new WirelessChargedLocation((TileEntity)this);
        }
        int taken = this.wirelessChargedLocation.takeEnergy(this.energy.getMaxEnergyStored() - this.energy.getEnergyStored());
        this.energy.receiveEnergy(taken, false);
    }

    @Override
    public void setMode(int mode) {
        super.setMode(mode);
        this.updateEnergyUsage();
    }

    @Override
    public void changeMode(EntityPlayer player) {
        super.changeMode(player);
        this.updateEnergyUsage();
    }

    protected void updateEnergyUsage() {
        this.realEnergyUsage = this.energyUsage * (this.mode == 0 ? 1 : 4);
    }

    @Override
    public void readOwnFromNBT(NBTTagCompound nbtTagCompound) {
        super.readOwnFromNBT(nbtTagCompound);
        this.energy.readFromNBT(nbtTagCompound);
        this.updateEnergyUsage();
    }

    @Override
    public NBTTagCompound writeOwnToNBT(NBTTagCompound nbtTagCompound) {
        nbtTagCompound = super.writeOwnToNBT(nbtTagCompound);
        this.energy.writeToNBT(nbtTagCompound);
        return nbtTagCompound;
    }

    @Override
    public NetworkDataList getSyncData(@Nonnull NetworkDataList data) {
        super.getSyncData(data);
        data.add(this.energy.getEnergyStored());
        return data;
    }

    @Override
    public void applySyncData(ByteBuf buffer) {
        super.applySyncData(buffer);
        this.energy.setEnergyStored(buffer.readInt());
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    public CustomEnergyStorage getEnergy() {
        return this.energy;
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this.energy);
        }
        return super.getCapability(capability, facing);
    }

    @Optional.Method(modid="ic2")
    public double injectEnergy(EnumFacing forgeDirection, double amount, double voltage) {
        return this.energy.receiveEU(amount);
    }

    @Optional.Method(modid="ic2")
    public int getSinkTier() {
        return 4;
    }

    @Optional.Method(modid="ic2")
    public double getDemandedEnergy() {
        return (double)this.energy.getMaxEnergyStored() / 4.0;
    }

    @Optional.Method(modid="ic2")
    public boolean acceptsEnergyFrom(IEnergyEmitter iEnergyEmitter, EnumFacing forgeDirection) {
        return true;
    }

    @Optional.Method(modid="ic2")
    public void addToIc2EnergyNetwork() {
        if (!this.field_145850_b.field_72995_K) {
            EnergyTileLoadEvent event = new EnergyTileLoadEvent((IEnergyTile)this);
            MinecraftForge.EVENT_BUS.post((Event)event);
        }
    }

    @Optional.Method(modid="ic2")
    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            EnergyTileUnloadEvent event = new EnergyTileUnloadEvent((IEnergyTile)this);
            MinecraftForge.EVENT_BUS.post((Event)event);
        }
    }
}

