/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.handler;

import de.keridos.floodlights.core.network.message.TileEntitySyncMessage;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class PacketHandler {
    public static final SimpleNetworkWrapper INSTANCE = NetworkRegistry.INSTANCE.newSimpleChannel("FloodLights");

    public static void init() {
        int id = 0;
        INSTANCE.registerMessage(TileEntitySyncMessage.Handler.class, TileEntitySyncMessage.class, id++, Side.CLIENT);
    }

    public static void encode(Object[] dataValues, ByteBuf output) {
        try {
            for (Object data : dataValues) {
                if (data instanceof Byte) {
                    output.writeByte((int)((Byte)data).byteValue());
                    continue;
                }
                if (data instanceof Integer) {
                    output.writeInt(((Integer)data).intValue());
                    continue;
                }
                if (data instanceof Short) {
                    output.writeShort((int)((Short)data).shortValue());
                    continue;
                }
                if (data instanceof Long) {
                    output.writeLong(((Long)data).longValue());
                    continue;
                }
                if (data instanceof Boolean) {
                    output.writeBoolean(((Boolean)data).booleanValue());
                    continue;
                }
                if (data instanceof Double) {
                    output.writeDouble(((Double)data).doubleValue());
                    continue;
                }
                if (data instanceof Float) {
                    output.writeFloat(((Float)data).floatValue());
                    continue;
                }
                if (data instanceof String) {
                    output.writeBytes(((String)data).getBytes(Charset.forName("UTF-8")));
                    continue;
                }
                if (data instanceof EnumFacing) {
                    output.writeInt(((EnumFacing)data).ordinal());
                    continue;
                }
                if (data instanceof int[]) {
                    for (int i : (int[])data) {
                        output.writeInt(i);
                    }
                    continue;
                }
                if (data instanceof byte[]) {
                    for (byte b : (byte[])data) {
                        output.writeByte((int)b);
                    }
                    continue;
                }
                if (data instanceof List) {
                    PacketHandler.encode(((List)data).toArray(), output);
                    continue;
                }
                throw new RuntimeException("Un-encodable data passed to encode(): " + data + ", full data: " + Arrays.toString(dataValues));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

