/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.util;

import com.mjr.extraplanets.world.features.WorldGenCustomLake;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenHelper {
    public static void generateStructure(WorldGenerator worldGen, World world, Random rand, int x, int y, int z) {
        y = world.func_72825_h(x += 8, z += 8);
        worldGen.func_76484_a(world, rand, x, y, z);
    }

    public static void generateStructureWithRandom(WorldGenerator worldGen, World world, Random rand, int x, int y, int z, int randomAmount) {
        WorldGenHelper.generateStructure(worldGen, world, rand, rand.nextInt(randomAmount), 0, rand.nextInt(randomAmount));
    }

    public static void generateLake(World world, Random rand, int x, int y, int z, Block fluid, Block block) {
        y = world.func_72825_h(x += 8, z += 8) - 2;
        new WorldGenCustomLake(fluid).generate(world, rand, x, y, z, block);
    }

    public static boolean checkValidSpawn(World world, int x, int y, int z, int size) {
        if (!world.func_72904_c(x, y, z, x + size, y + size, z + size)) {
            return false;
        }
        int i = y;
        while (i > 5 && world.func_147437_c(x, y, z) || world.func_147439_a(x, y, z).func_149688_o().func_76224_d()) {
            --y;
        }
        if (y <= 4) {
            return false;
        }
        for (i = -size; i <= size; ++i) {
            for (int j = -size; j <= size; ++j) {
                if ((!world.func_147437_c(x, y - 1, z) || !world.func_147437_c(x, y - 2, z)) && (!world.func_147439_a(x, y - 1, z).func_149688_o().func_76224_d() || !world.func_147439_a(x, y - 2, z).func_149688_o().func_76224_d())) continue;
                return false;
            }
        }
        return true;
    }
}

