/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.planets.Uranus.worldgen;

import com.mjr.extraplanets.Config;
import com.mjr.extraplanets.blocks.ExtraPlanets_Blocks;
import com.mjr.extraplanets.blocks.fluid.ExtraPlanets_Fluids;
import com.mjr.extraplanets.util.WorldGenHelper;
import com.mjr.extraplanets.world.features.WorldGenCustomIceSpike;
import com.mjr.extraplanets.world.features.WorldGenIgloo;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.world.gen.WorldGenMinableMeta;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;

public class BiomeDecoratorUranus
extends BiomeDecorator {
    private WorldGenerator iceGen = new WorldGenMinableMeta(Blocks.field_150432_aD, 18, 0, true, ExtraPlanets_Blocks.uranusBlocks, 2);
    private WorldGenerator crystalGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.uranusBlocks, 4, 3, true, ExtraPlanets_Blocks.uranusBlocks, 2);
    private WorldGenerator denseIceGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.denseIce, 8, 0, true, ExtraPlanets_Blocks.uranusBlocks, 0);
    private WorldGenerator whiteGemGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.uranusBlocks, 4, 6, true, ExtraPlanets_Blocks.uranusBlocks, 2);
    private World currentWorld;
    protected Random rand;
    protected int chunkX;
    protected int chunkZ;
    private int iceSpikesPerChunk = 5;
    private int LakesPerChunk = 5;
    private boolean isDecorating = false;

    protected void generateOre(int amountPerChunk, WorldGenerator worldGenerator, int minY, int maxY) {
        for (int var5 = 0; var5 < amountPerChunk; ++var5) {
            int var6 = this.chunkX + this.rand.nextInt(16);
            int var7 = this.rand.nextInt(maxY - minY) + minY;
            int var8 = this.chunkZ + this.rand.nextInt(16);
            worldGenerator.func_76484_a(this.currentWorld, this.rand, var6, var7, var8);
        }
    }

    public void func_150512_a(World world, Random rand, BiomeGenBase biome, int xChunk, int zChunk) {
        int i;
        this.currentWorld = world;
        this.rand = rand;
        this.chunkX = xChunk;
        this.chunkZ = zChunk;
        if (this.isDecorating) {
            return;
        }
        this.isDecorating = true;
        this.generateOre(8, this.iceGen, 50, 120);
        this.generateOre(20, this.crystalGen, 0, 32);
        this.generateOre(20, this.denseIceGen, 0, 256);
        this.generateOre(5, this.whiteGemGen, 0, 10);
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(this.currentWorld, this.rand, this.chunkX, this.chunkZ));
        for (i = 0; i < this.LakesPerChunk; ++i) {
            if (this.rand.nextInt(10) != 0) continue;
            WorldGenHelper.generateLake(this.currentWorld, this.rand, this.chunkX, 0, this.chunkZ, ExtraPlanets_Fluids.frozen_water, ExtraPlanets_Blocks.uranusBlocks);
        }
        if (Config.genUranusIceSpikes) {
            for (i = 0; i < this.iceSpikesPerChunk; ++i) {
                if (this.rand.nextInt(20) != 0) continue;
                int x = this.chunkX + 6;
                int z = this.chunkZ + 6;
                int y = this.currentWorld.func_72976_f(x, z);
                new WorldGenCustomIceSpike().generate(this.currentWorld, this.rand, x, y, z, ExtraPlanets_Blocks.uranusBlocks);
            }
        }
        if (Config.genUranusIgloos && this.rand.nextInt(300) == 1) {
            WorldGenHelper.generateStructure(new WorldGenIgloo(), this.currentWorld, this.rand, this.chunkX, 0, this.chunkZ);
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(this.currentWorld, this.rand, this.chunkX, this.chunkZ));
        this.isDecorating = false;
    }
}

