/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.planets.Mercury.worldgen;

import com.google.common.collect.Lists;
import com.mjr.extraplanets.Config;
import com.mjr.extraplanets.blocks.ExtraPlanets_Blocks;
import com.mjr.extraplanets.entities.monsters.EntityEvolvedBlaze;
import com.mjr.extraplanets.entities.monsters.EntityEvolvedEnderman;
import com.mjr.extraplanets.entities.monsters.EntityEvolvedWitch;
import com.mjr.extraplanets.planets.Mercury.worldgen.BiomeDecoratorMercury;
import com.mjr.extraplanets.planets.Mercury.worldgen.MapGenCaveMercury;
import com.mjr.extraplanets.planets.Mercury.worldgen.MapGenRavineMercury;
import com.mjr.extraplanets.planets.Mercury.worldgen.MercuryBiomes;
import com.mjr.extraplanets.planets.Mercury.worldgen.village.MapGenVillageMercury;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeDecoratorSpace;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.ChunkProviderSpace;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.MapGenBaseMeta;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;

public class ChunkProviderMercury
extends ChunkProviderSpace {
    private final BiomeDecoratorMercury biomeDecorator = new BiomeDecoratorMercury();
    private final MapGenCaveMercury caveGenerator = new MapGenCaveMercury();
    private final MapGenRavineMercury ravineGenerator = new MapGenRavineMercury();
    private final MapGenVillageMercury villageGenerator = new MapGenVillageMercury();

    public ChunkProviderMercury(World par1World, long seed, boolean mapFeaturesEnabled) {
        super(par1World, seed, mapFeaturesEnabled);
    }

    protected BiomeDecoratorSpace getBiomeGenerator() {
        return this.biomeDecorator;
    }

    protected BiomeGenBase[] getBiomesForGeneration() {
        return new BiomeGenBase[]{MercuryBiomes.mercury};
    }

    protected int getSeaLevel() {
        return 64;
    }

    protected List<MapGenBaseMeta> getWorldGenerators() {
        ArrayList generators = Lists.newArrayList();
        generators.add(this.caveGenerator);
        return generators;
    }

    protected BiomeGenBase.SpawnListEntry[] getMonsters() {
        ArrayList<BiomeGenBase.SpawnListEntry> monsters = new ArrayList<BiomeGenBase.SpawnListEntry>();
        monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedZombie.class, 8, 2, 3));
        monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedSpider.class, 8, 2, 3));
        monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedSkeleton.class, 8, 2, 3));
        monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedCreeper.class, 8, 2, 3));
        if (Config.evolvedWitch) {
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedWitch.class, 8, 2, 3));
        }
        if (Config.evolvedEnderman) {
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedEnderman.class, 8, 2, 3));
        }
        if (Config.evolvedBlaze) {
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedBlaze.class, 8, 2, 3));
        }
        return monsters.toArray(new BiomeGenBase.SpawnListEntry[monsters.size()]);
    }

    protected BiomeGenBase.SpawnListEntry[] getCreatures() {
        return new BiomeGenBase.SpawnListEntry[0];
    }

    protected BlockMetaPair getGrassBlock() {
        return new BlockMetaPair(ExtraPlanets_Blocks.mercuryBlocks, 0);
    }

    protected BlockMetaPair getDirtBlock() {
        return new BlockMetaPair(ExtraPlanets_Blocks.mercuryBlocks, 1);
    }

    protected BlockMetaPair getStoneBlock() {
        return new BlockMetaPair(ExtraPlanets_Blocks.mercuryBlocks, 2);
    }

    public double getHeightModifier() {
        return 24.0;
    }

    public double getSmallFeatureHeightModifier() {
        return 40.0;
    }

    public double getMountainHeightModifier() {
        return 160.0;
    }

    public double getValleyHeightModifier() {
        return 75.0;
    }

    public int getCraterProbability() {
        return 75;
    }

    public void onChunkProvide(int cX, int cZ, Block[] blocks, byte[] metadata) {
        this.ravineGenerator.func_151539_a((IChunkProvider)this, this.field_73230_p, cX, cZ, blocks);
    }

    public void onPopulate(IChunkProvider provider, int cX, int cZ) {
        if (Config.mercuryVillages) {
            this.villageGenerator.func_75051_a(this.field_73230_p, this.field_73220_k, cX, cZ);
        }
    }

    public void func_82695_e(int par1, int par2) {
        if (Config.mercuryVillages) {
            this.villageGenerator.func_151539_a((IChunkProvider)this, this.field_73230_p, par1, par2, null);
        }
    }
}

