/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.network;

import com.mjr.extraplanets.client.gui.vehicles.GuiPoweredVehicleBase;
import com.mjr.extraplanets.client.gui.vehicles.GuiVehicleBase;
import com.mjr.extraplanets.entities.vehicles.EntityPoweredVehicleBase;
import com.mjr.extraplanets.entities.vehicles.EntityVehicleBase;
import com.mjr.extraplanets.util.ExtraPlanetsUtli;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStatsClient;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.NetworkUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.network.INetHandler;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;

public class PacketSimple
extends Packet
implements IPacket {
    private EnumSimplePacket type;
    private List<Object> data;

    public PacketSimple() {
    }

    public PacketSimple(EnumSimplePacket packetType, Object[] data) {
        this(packetType, Arrays.asList(data));
    }

    public PacketSimple(EnumSimplePacket packetType, List<Object> data) {
        if (packetType.getDecodeClasses().length != data.size()) {
            GCLog.info((String)"[ExtraPlanets] Simple Packet Core found data length different than packet type");
            new RuntimeException().printStackTrace();
        }
        this.type = packetType;
        this.data = data;
    }

    public void encodeInto(ChannelHandlerContext context, ByteBuf buffer) {
        buffer.writeInt(this.type.ordinal());
        try {
            NetworkUtil.encodeData((ByteBuf)buffer, this.data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void decodeInto(ChannelHandlerContext context, ByteBuf buffer) {
        this.type = EnumSimplePacket.values()[buffer.readInt()];
        try {
            if (this.type.getDecodeClasses().length > 0) {
                this.data = NetworkUtil.decodeData((Class[])this.type.getDecodeClasses(), (ByteBuf)buffer);
            }
            if (buffer.readableBytes() > 0) {
                GCLog.severe((String)("ExtraPlanets packet length problem for packet type " + this.type.toString()));
            }
        }
        catch (Exception e) {
            System.err.println("[ExtraPlanets] Error handling simple packet type: " + this.type.toString() + " " + buffer.toString());
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer player) {
        EntityClientPlayerMP playerBaseClient = null;
        GCPlayerStatsClient stats = null;
        if (player instanceof EntityClientPlayerMP) {
            playerBaseClient = (EntityClientPlayerMP)player;
            stats = GCPlayerStatsClient.get((EntityPlayerSP)playerBaseClient);
        }
        switch (this.type) {
            case C_OPEN_PARACHEST_GUI: {
                switch ((Integer)this.data.get(1)) {
                    case 0: {
                        if (player.field_70154_o instanceof EntityVehicleBase) {
                            FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)new GuiVehicleBase((IInventory)player.field_71071_by, (EntityVehicleBase)player.field_70154_o, ((EntityVehicleBase)player.field_70154_o).getType()));
                            player.field_71070_bA.field_75152_c = (Integer)this.data.get(0);
                            break;
                        }
                        if (!(player.field_70154_o instanceof EntityPoweredVehicleBase)) break;
                        FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)new GuiPoweredVehicleBase((IInventory)player.field_71071_by, (EntityPoweredVehicleBase)player.field_70154_o, ((EntityPoweredVehicleBase)player.field_70154_o).getType()));
                        player.field_71070_bA.field_75152_c = (Integer)this.data.get(0);
                    }
                }
                break;
            }
        }
    }

    public void handleServerSide(EntityPlayer player) {
        EntityPlayerMP playerBase = PlayerUtil.getPlayerBaseServerFromPlayer((EntityPlayer)player, (boolean)false);
        if (playerBase == null) {
            return;
        }
        switch (this.type) {
            case S_OPEN_FUEL_GUI: {
                if (!(player.field_70154_o instanceof EntityVehicleBase)) break;
                ExtraPlanetsUtli.openFuelVehicleInv(playerBase, (EntityVehicleBase)player.field_70154_o, ((EntityVehicleBase)player.field_70154_o).getType());
                break;
            }
            case S_OPEN_POWER_GUI: {
                if (!(player.field_70154_o instanceof EntityPoweredVehicleBase)) break;
                ExtraPlanetsUtli.openPowerVehicleInv(playerBase, (EntityPoweredVehicleBase)player.field_70154_o, ((EntityPoweredVehicleBase)player.field_70154_o).getType());
                break;
            }
        }
    }

    public void func_148837_a(PacketBuffer var1) {
        this.decodeInto(null, (ByteBuf)var1);
    }

    public void func_148840_b(PacketBuffer var1) {
        this.encodeInto(null, (ByteBuf)var1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_148833_a(INetHandler var1) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.handleClientSide((EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity());
        }
    }

    public static enum EnumSimplePacket {
        S_OPEN_FUEL_GUI(Side.SERVER, String.class),
        S_OPEN_POWER_GUI(Side.SERVER, String.class),
        C_OPEN_PARACHEST_GUI(Side.CLIENT, Integer.class, Integer.class, Integer.class);

        private Side targetSide;
        private Class<?>[] decodeAs;

        private EnumSimplePacket(Side targetSide, Class<?> ... decodeAs) {
            this.targetSide = targetSide;
            this.decodeAs = decodeAs;
        }

        public Side getTargetSide() {
            return this.targetSide;
        }

        public Class<?>[] getDecodeClasses() {
            return this.decodeAs;
        }
    }
}

