/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.entities.vehicles;

import com.mjr.extraplanets.api.IPowerDock;
import com.mjr.extraplanets.api.IPoweredDockable;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import micdoodle8.mods.galacticraft.api.entity.ICargoEntity;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.IControllableEntity;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.network.PacketControllableEntity;
import micdoodle8.mods.galacticraft.core.network.PacketDynamic;
import micdoodle8.mods.galacticraft.core.network.PacketEntityUpdate;
import micdoodle8.mods.galacticraft.core.tick.KeyHandlerClient;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public abstract class EntityPoweredVehicleBase
extends Entity
implements IInventory,
IPacketReceiver,
IPoweredDockable,
IControllableEntity,
PacketEntityUpdate.IEntityFullSync {
    protected long ticks = 0L;
    public int roverType;
    private int currentDamage;
    private int timeSinceHit;
    private int rockDirection;
    private double speed;
    public float wheelRotationZ;
    public float wheelRotationX;
    private float maxSpeed = 0.6f;
    private float accel = 0.8f;
    private float turnFactor = 3.0f;
    public String texture;
    ItemStack[] cargoItems = new ItemStack[60];
    private double boatX;
    private double boatY;
    private double boatZ;
    private double boatYaw;
    private double boatPitch;
    private int boatPosRotationIncrements;
    protected IPowerDock landingPad;
    private int timeClimbing;
    private boolean shouldClimb;
    private float currentPowerCapacity;
    private float powerMaxCapacity;

    public EntityPoweredVehicleBase(World var1) {
        super(var1);
        this.func_70105_a(0.98f, 1.0f);
        this.field_70129_M = 2.5f;
        this.currentDamage = 18;
        this.timeSinceHit = 19;
        this.rockDirection = 20;
        this.speed = 0.0;
        this.field_70156_m = true;
        this.field_70180_af.func_75682_a(this.currentDamage, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(this.timeSinceHit, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(this.rockDirection, (Object)new Integer(1));
        this.field_70158_ak = true;
        this.field_70178_ae = true;
        this.currentPowerCapacity = 0.0f;
        this.powerMaxCapacity = 10000.0f;
        if (var1 != null && var1.field_72995_K) {
            GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketDynamic((Entity)this));
        }
    }

    public EntityPoweredVehicleBase(World var1, double var2, double var4, double var6, int type) {
        this(var1);
        this.func_70107_b(var2, var4 + (double)this.field_70129_M, var6);
        this.setBuggyType(type);
        this.cargoItems = new ItemStack[this.roverType * 18];
    }

    public ModelBase getModel() {
        return null;
    }

    public int getType() {
        return this.roverType;
    }

    protected void func_70088_a() {
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public boolean func_70104_M() {
        return false;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O - 3.0;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void setBuggyType(int par1) {
        this.roverType = par1;
    }

    public void func_70043_V() {
        if (this.field_70153_n != null) {
            double var1 = Math.cos((double)this.field_70177_z * Math.PI / 180.0 + 114.8) * 0.4;
            double var3 = Math.sin((double)this.field_70177_z * Math.PI / 180.0 + 114.8) * -0.4;
            this.field_70153_n.func_70107_b(this.field_70165_t + var1, this.field_70163_u - 2.4 + this.field_70153_n.func_70033_W() + 0.6, this.field_70161_v + var3);
        }
    }

    public void setPositionRotationAndMotion(double x, double y, double z, float yaw, float pitch, double motX, double motY, double motZ, boolean onGround) {
        if (this.field_70170_p.field_72995_K) {
            this.boatX = x;
            this.boatY = y;
            this.boatZ = z;
            this.boatYaw = yaw;
            this.boatPitch = pitch;
            this.field_70159_w = motX;
            this.field_70181_x = motY;
            this.field_70179_y = motZ;
            this.boatPosRotationIncrements = 5;
        } else {
            this.func_70107_b(x, y, z);
            this.func_70101_b(yaw, pitch);
            this.field_70159_w = motX;
            this.field_70181_x = motY;
            this.field_70179_y = motZ;
        }
    }

    public void func_70057_ab() {
        this.field_70180_af.func_75692_b(this.rockDirection, (Object)(-this.field_70180_af.func_75679_c(this.rockDirection)));
        this.field_70180_af.func_75692_b(this.timeSinceHit, (Object)10);
        this.field_70180_af.func_75692_b(this.currentDamage, (Object)(this.field_70180_af.func_75679_c(this.currentDamage) * 5));
    }

    public boolean func_70097_a(DamageSource var1, float var2) {
        boolean flag;
        if (this.field_70128_L || var1.equals(DamageSource.field_76367_g)) {
            return true;
        }
        Entity e = var1.func_76346_g();
        boolean bl = flag = var1.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)var1.func_76346_g()).field_71075_bZ.field_75098_d;
        if (this.func_85032_ar() || e instanceof EntityLivingBase && !(e instanceof EntityPlayer)) {
            return false;
        }
        this.field_70180_af.func_75692_b(this.rockDirection, (Object)(-this.field_70180_af.func_75679_c(this.rockDirection)));
        this.field_70180_af.func_75692_b(this.timeSinceHit, (Object)10);
        this.field_70180_af.func_75692_b(this.currentDamage, (Object)((int)((float)this.field_70180_af.func_75679_c(this.currentDamage) + var2 * 10.0f)));
        this.func_70018_K();
        if (e instanceof EntityPlayer && ((EntityPlayer)e).field_71075_bZ.field_75098_d) {
            this.field_70180_af.func_75692_b(this.currentDamage, (Object)100);
        }
        if (flag || this.field_70180_af.func_75679_c(this.currentDamage) > 2) {
            if (this.field_70153_n != null) {
                this.field_70153_n.func_70078_a((Entity)this);
            }
            if (!this.field_70170_p.field_72995_K && this.field_70153_n != null) {
                this.field_70153_n.func_70078_a((Entity)this);
            }
            if (flag) {
                this.func_70106_y();
            } else {
                this.func_70106_y();
                if (!this.field_70170_p.field_72995_K) {
                    this.dropBuggyAsItem();
                }
            }
            this.func_70106_y();
        }
        return true;
    }

    public void dropBuggyAsItem() {
        List<ItemStack> dropped = this.getItemsDropped();
        if (dropped == null) {
            return;
        }
        for (ItemStack item : dropped) {
            EntityItem entityItem = this.func_70099_a(item, 0.0f);
            if (!item.func_77942_o()) continue;
            entityItem.func_92059_d().func_77982_d((NBTTagCompound)item.func_77978_p().func_74737_b());
        }
    }

    public void func_70056_a(double d, double d1, double d2, float f, float f1, int i) {
        if (!(this.field_70153_n == null || this.field_70153_n instanceof EntityPlayer && FMLClientHandler.instance().getClient().field_71439_g.equals((Object)this.field_70153_n))) {
            this.boatPosRotationIncrements = i + 5;
            this.boatX = d;
            this.boatY = d1 + (double)(this.field_70153_n == null ? 1 : 0);
            this.boatZ = d2;
            this.boatYaw = f;
            this.boatPitch = f1;
        }
    }

    public void func_70071_h_() {
        double d;
        if (this.ticks >= Long.MAX_VALUE) {
            this.ticks = 1L;
        }
        ++this.ticks;
        this.featureUpdate();
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.wheelRotationX = (float)((double)this.wheelRotationX + Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y) * 150.0 * (double)(this.speed < 0.0 ? 1 : -1));
            this.wheelRotationX %= 360.0f;
            this.wheelRotationZ = Math.max(-30.0f, Math.min(30.0f, this.wheelRotationZ * 0.9f));
        }
        if (this.field_70170_p.field_72995_K && !FMLClientHandler.instance().getClient().field_71439_g.equals((Object)this.field_70170_p.func_72890_a((Entity)this, -1.0))) {
            if (this.boatPosRotationIncrements > 0) {
                double x = this.field_70165_t + (this.boatX - this.field_70165_t) / (double)this.boatPosRotationIncrements;
                double y = this.field_70163_u + (this.boatY - this.field_70163_u) / (double)this.boatPosRotationIncrements;
                double z = this.field_70161_v + (this.boatZ - this.field_70161_v) / (double)this.boatPosRotationIncrements;
                double var12 = MathHelper.func_76138_g((double)(this.boatYaw - (double)this.field_70177_z));
                this.field_70177_z = (float)((double)this.field_70177_z + var12 / (double)this.boatPosRotationIncrements);
                this.field_70125_A = (float)((double)this.field_70125_A + (this.boatPitch - (double)this.field_70125_A) / (double)this.boatPosRotationIncrements);
                --this.boatPosRotationIncrements;
                this.func_70107_b(x, y, z);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            } else {
                double x = this.field_70165_t + this.field_70159_w;
                double y = this.field_70163_u + this.field_70181_x;
                double z = this.field_70161_v + this.field_70179_y;
                if (this.field_70153_n != null) {
                    this.func_70107_b(x, y, z);
                }
                if (this.field_70122_E) {
                    this.field_70159_w *= 0.5;
                    this.field_70181_x *= 0.5;
                    this.field_70179_y *= 0.5;
                }
                this.field_70159_w *= (double)0.99f;
                this.field_70181_x *= (double)0.95f;
                this.field_70179_y *= (double)0.99f;
            }
            return;
        }
        if (this.field_70180_af.func_75679_c(this.timeSinceHit) > 0) {
            this.field_70180_af.func_75692_b(this.timeSinceHit, (Object)(this.field_70180_af.func_75679_c(this.timeSinceHit) - 1));
        }
        if (this.field_70180_af.func_75679_c(this.currentDamage) > 0) {
            this.field_70180_af.func_75692_b(this.currentDamage, (Object)(this.field_70180_af.func_75679_c(this.currentDamage) - 1));
        }
        if (!this.field_70122_E) {
            this.field_70181_x -= WorldUtil.getGravityForEntity((Entity)this) * 0.5;
        }
        if (this.field_70171_ac && this.speed > 0.2) {
            this.field_70170_p.func_72908_a((double)((float)this.field_70165_t), (double)((float)this.field_70163_u), (double)((float)this.field_70161_v), "random.fizz", 0.5f, 2.6f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.8f);
        }
        this.speed *= 0.98;
        if (this.speed > (double)this.maxSpeed) {
            this.speed = this.maxSpeed;
        }
        if (this.field_70123_F && this.shouldClimb) {
            this.speed *= 0.9;
            this.field_70181_x = 0.15 * (-Math.pow(this.timeClimbing - 1, 2.0) / 250.0) + (double)0.15f;
            this.field_70181_x = Math.max(-0.15, this.field_70181_x);
            this.shouldClimb = false;
        }
        this.timeClimbing = !(this.field_70159_w != 0.0 && this.field_70179_y != 0.0 || this.field_70122_E) ? ++this.timeClimbing : 0;
        if (this.field_70170_p.field_72995_K && this.currentPowerCapacity > 0.0f) {
            this.field_70159_w = -(this.speed * Math.cos((double)(this.field_70177_z - 90.0f) * Math.PI / 180.0));
            this.field_70179_y = -(this.speed * Math.sin((double)(this.field_70177_z - 90.0f) * Math.PI / 180.0));
        }
        if (this.field_70170_p.field_72995_K) {
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        if (!this.field_70170_p.field_72995_K && Math.abs(this.field_70159_w * this.field_70179_y) > 0.0 && (d = this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y) != 0.0 && this.ticks % (long)(MathHelper.func_76128_c((double)(2.0 / d)) + 1) == 0L) {
            this.removePower(10.0f);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (this.field_70170_p.field_72995_K) {
            GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketEntityUpdate((Entity)this));
        } else if (this.ticks % 5L == 0L) {
            GalacticraftCore.packetPipeline.sendToAllAround((IPacket)new PacketEntityUpdate((Entity)this), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0));
            GalacticraftCore.packetPipeline.sendToAllAround((IPacket)new PacketDynamic((Entity)this), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0));
        }
    }

    public void getNetworkedData(ArrayList<Object> sendData) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        sendData.add(this.roverType);
        sendData.add(Float.valueOf(this.currentPowerCapacity));
    }

    public void decodePacketdata(ByteBuf buffer) {
        this.roverType = buffer.readInt();
        this.currentPowerCapacity = buffer.readFloat();
    }

    public void handlePacketData(Side side, EntityPlayer player) {
    }

    protected void func_70037_a(NBTTagCompound var1) {
        this.roverType = var1.func_74762_e("roverType");
        NBTTagList var2 = var1.func_150295_c("Items", 10);
        this.cargoItems = new ItemStack[this.func_70302_i_()];
        this.currentPowerCapacity = var1.func_74760_g("currentPowerCapacity");
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = var2.func_150305_b(var3);
            int var5 = var4.func_74771_c("Slot") & 0xFF;
            if (var5 >= this.cargoItems.length) continue;
            this.cargoItems[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
    }

    protected void func_70014_b(NBTTagCompound var1) {
        var1.func_74768_a("roverType", this.roverType);
        NBTTagList var2 = new NBTTagList();
        var1.func_74776_a("currentPowerCapacity", this.currentPowerCapacity);
        for (int var3 = 0; var3 < this.cargoItems.length; ++var3) {
            if (this.cargoItems[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.cargoItems[var3].func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        var1.func_74782_a("Items", (NBTBase)var2);
    }

    public int func_70302_i_() {
        return this.roverType * 18;
    }

    public ItemStack func_70301_a(int var1) {
        return this.cargoItems[var1];
    }

    public ItemStack func_70298_a(int var1, int var2) {
        if (this.cargoItems[var1] != null) {
            if (this.cargoItems[var1].field_77994_a <= var2) {
                ItemStack var3 = this.cargoItems[var1];
                this.cargoItems[var1] = null;
                return var3;
            }
            ItemStack var3 = this.cargoItems[var1].func_77979_a(var2);
            if (this.cargoItems[var1].field_77994_a == 0) {
                this.cargoItems[var1] = null;
            }
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int var1) {
        if (this.cargoItems[var1] != null) {
            ItemStack var2 = this.cargoItems[var1];
            this.cargoItems[var1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int var1, ItemStack var2) {
        this.cargoItems[var1] = var2;
        if (var2 != null && var2.field_77994_a > this.func_70297_j_()) {
            var2.field_77994_a = this.func_70297_j_();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return !this.field_70128_L && var1.func_70068_e((Entity)this) <= 64.0;
    }

    public void func_70296_d() {
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_130002_c(EntityPlayer var1) {
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70153_n == null) {
                var1.func_145747_a((IChatComponent)new ChatComponentText(GameSettings.func_74298_c((int)KeyHandlerClient.leftKey.func_151463_i()) + " / " + GameSettings.func_74298_c((int)KeyHandlerClient.rightKey.func_151463_i()) + "  - " + GCCoreUtil.translate((String)"gui.buggy.turn.name")));
                var1.func_145747_a((IChatComponent)new ChatComponentText(GameSettings.func_74298_c((int)KeyHandlerClient.accelerateKey.func_151463_i()) + "       - " + GCCoreUtil.translate((String)"gui.buggy.accel.name")));
                var1.func_145747_a((IChatComponent)new ChatComponentText(GameSettings.func_74298_c((int)KeyHandlerClient.decelerateKey.func_151463_i()) + "       - " + GCCoreUtil.translate((String)"gui.buggy.decel.name")));
                var1.func_145747_a((IChatComponent)new ChatComponentText(GameSettings.func_74298_c((int)KeyHandlerClient.openFuelGui.func_151463_i()) + "       - " + GCCoreUtil.translate((String)"gui.buggy.inv.name")));
            }
            return true;
        }
        if (this.field_70153_n != null) {
            if (this.field_70153_n == var1) {
                var1.func_70078_a(null);
            }
            return true;
        }
        var1.func_70078_a((Entity)this);
        return true;
    }

    public boolean pressKey(int key) {
        if (this.field_70170_p.field_72995_K && (key == 6 || key == 8 || key == 9)) {
            GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketControllableEntity(key));
            return true;
        }
        switch (key) {
            case 0: {
                if (this.currentPowerCapacity < 10.0f) {
                    return false;
                }
                this.speed -= (double)this.accel / 20.0;
                this.shouldClimb = true;
                return true;
            }
            case 1: {
                if (this.currentPowerCapacity < 10.0f) {
                    return false;
                }
                this.speed += (double)this.accel / 20.0;
                this.shouldClimb = true;
                return true;
            }
            case 2: {
                this.field_70177_z -= 0.5f * this.turnFactor;
                this.wheelRotationZ = Math.max(-30.0f, Math.min(30.0f, this.wheelRotationZ + 0.5f));
                return true;
            }
            case 3: {
                this.field_70177_z += 0.5f * this.turnFactor;
                this.wheelRotationZ = Math.max(-30.0f, Math.min(30.0f, this.wheelRotationZ - 0.5f));
                return true;
            }
        }
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    public ICargoEntity.EnumCargoLoadingState addCargo(ItemStack stack, boolean doAdd) {
        ItemStack stackAt;
        if (this.roverType == 0) {
            return ICargoEntity.EnumCargoLoadingState.NOINVENTORY;
        }
        int count = 0;
        for (count = 0; count < this.cargoItems.length; ++count) {
            stackAt = this.cargoItems[count];
            if (stackAt == null || stackAt.func_77973_b() != stack.func_77973_b() || stackAt.func_77960_j() != stack.func_77960_j() || stackAt.field_77994_a >= stackAt.func_77976_d()) continue;
            if (stackAt.field_77994_a + stack.field_77994_a <= stackAt.func_77976_d()) {
                if (doAdd) {
                    this.cargoItems[count].field_77994_a += stack.field_77994_a;
                    this.func_70296_d();
                }
                return ICargoEntity.EnumCargoLoadingState.SUCCESS;
            }
            int origSize = stackAt.field_77994_a;
            int surplus = origSize + stack.field_77994_a - stackAt.func_77976_d();
            if (doAdd) {
                this.cargoItems[count].field_77994_a = stackAt.func_77976_d();
                this.func_70296_d();
            }
            stack.field_77994_a = surplus;
            if (this.addCargo(stack, doAdd) == ICargoEntity.EnumCargoLoadingState.SUCCESS) {
                return ICargoEntity.EnumCargoLoadingState.SUCCESS;
            }
            this.cargoItems[count].field_77994_a = origSize;
            return ICargoEntity.EnumCargoLoadingState.FULL;
        }
        for (count = 0; count < this.cargoItems.length; ++count) {
            stackAt = this.cargoItems[count];
            if (stackAt != null) continue;
            if (doAdd) {
                this.cargoItems[count] = stack;
                this.func_70296_d();
            }
            return ICargoEntity.EnumCargoLoadingState.SUCCESS;
        }
        return ICargoEntity.EnumCargoLoadingState.FULL;
    }

    public ICargoEntity.RemovalResult removeCargo(boolean doRemove) {
        for (int i = 0; i < this.cargoItems.length; ++i) {
            ItemStack stackAt = this.cargoItems[i];
            if (stackAt == null) continue;
            ItemStack resultStack = stackAt.func_77946_l();
            resultStack.field_77994_a = 1;
            if (doRemove && --stackAt.field_77994_a <= 0) {
                this.cargoItems[i] = null;
            }
            if (doRemove) {
                this.func_70296_d();
            }
            return new ICargoEntity.RemovalResult(ICargoEntity.EnumCargoLoadingState.SUCCESS, resultStack);
        }
        return new ICargoEntity.RemovalResult(ICargoEntity.EnumCargoLoadingState.EMPTY, null);
    }

    public boolean func_145818_k_() {
        return true;
    }

    public UUID getOwnerUUID() {
        if (this.field_70153_n != null && !(this.field_70153_n instanceof EntityPlayer)) {
            return null;
        }
        return this.field_70153_n != null ? ((EntityPlayer)this.field_70153_n).getPersistentID() : null;
    }

    @Override
    public void onPadDestroyed() {
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public float getMaxSpeed() {
        return this.maxSpeed;
    }

    public void setMaxSpeed(float maxSpeed) {
        this.maxSpeed = maxSpeed;
    }

    public float getAccel() {
        return this.accel;
    }

    public void setAccel(float accel) {
        this.accel = accel;
    }

    public float getCurrentPowerCapacity() {
        return this.currentPowerCapacity;
    }

    public void setCurrentPowerCapacity(float currentPowerCapacity) {
        this.currentPowerCapacity = currentPowerCapacity;
    }

    public float getPowerMaxCapacity() {
        return this.powerMaxCapacity;
    }

    public void setPowerMaxCapacity(float powerMaxCapacity) {
        this.powerMaxCapacity = powerMaxCapacity;
    }

    @Override
    public float addPower(float amount, boolean doDrain) {
        float beforePower = this.getCurrentPowerCapacity();
        if (this.getCurrentPowerCapacity() >= this.getPowerMaxCapacity()) {
            this.setCurrentPowerCapacity(this.getPowerMaxCapacity());
        } else {
            this.setCurrentPowerCapacity(this.getCurrentPowerCapacity() + amount);
        }
        return this.getCurrentPowerCapacity() - beforePower;
    }

    @Override
    public float removePower(float amount) {
        float beforePower = this.getCurrentPowerCapacity();
        if (this.getCurrentPowerCapacity() - amount <= 0.0f) {
            this.setCurrentPowerCapacity(0.0f);
        } else {
            this.setCurrentPowerCapacity(this.getCurrentPowerCapacity() - amount);
        }
        return beforePower - this.getCurrentPowerCapacity();
    }

    public abstract String func_145825_b();

    public abstract List<ItemStack> getItemsDropped();

    public abstract ItemStack getPickedResult(MovingObjectPosition var1);

    @Override
    public abstract void setPad(IPowerDock var1);

    @Override
    public abstract IPowerDock getLandingPad();

    @Override
    public abstract boolean isDockValid(IPowerDock var1);

    public abstract void featureUpdate();
}

