/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.client.gui.screen;

import com.google.common.collect.Maps;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.List;
import micdoodle8.mods.galacticraft.api.event.client.CelestialBodyRenderEvent;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.IChildBody;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldProviderSpace;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GuiCelestialSelection;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;

public class CustomCelestialSelection
extends GuiCelestialSelection {
    public CustomCelestialSelection(boolean mapMode, List<CelestialBody> possibleBodies) {
        super(mapMode, possibleBodies);
    }

    public HashMap<CelestialBody, Matrix4f> drawCelestialBodies(Matrix4f worldMatrix) {
        Matrix4f worldMatrix0;
        CelestialBodyRenderEvent.Post postEvent;
        Matrix4f worldMatrix1;
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        FloatBuffer fb = BufferUtils.createFloatBuffer((int)512);
        HashMap matrixMap = Maps.newHashMap();
        for (SolarSystem solarSystem : GalaxyRegistry.getRegisteredSolarSystems().values()) {
            Star star = solarSystem.getMainStar();
            if (star == null || star.getBodyIcon() == null) continue;
            GL11.glPushMatrix();
            Matrix4f worldMatrix02 = new Matrix4f(worldMatrix);
            Matrix4f.translate((Vector3f)this.getCelestialBodyPosition((CelestialBody)star), (Matrix4f)worldMatrix02, (Matrix4f)worldMatrix02);
            Matrix4f worldMatrix12 = new Matrix4f();
            Matrix4f.rotate((float)((float)Math.toRadians(45.0)), (Vector3f)new Vector3f(0.0f, 0.0f, 1.0f), (Matrix4f)worldMatrix12, (Matrix4f)worldMatrix12);
            Matrix4f.rotate((float)((float)Math.toRadians(-55.0)), (Vector3f)new Vector3f(1.0f, 0.0f, 0.0f), (Matrix4f)worldMatrix12, (Matrix4f)worldMatrix12);
            worldMatrix12 = Matrix4f.mul((Matrix4f)worldMatrix02, (Matrix4f)worldMatrix12, (Matrix4f)worldMatrix12);
            fb.rewind();
            worldMatrix12.store(fb);
            fb.flip();
            GL11.glMultMatrix((FloatBuffer)fb);
            float alpha = 1.0f;
            if (this.selectedBody != null && this.selectedBody != star && this.selectionCount >= 2) {
                alpha = 1.0f - Math.min((float)this.ticksSinceSelection / 25.0f, 1.0f);
            }
            if (this.selectedBody != null && this.selectionCount >= 2 && star != this.selectedBody) {
                alpha = 1.0f - Math.min((float)this.ticksSinceSelection / 25.0f, 1.0f);
                if (!(this.lastSelectedBody instanceof Star) && this.lastSelectedBody != null) {
                    alpha = 0.0f;
                }
            }
            if (alpha != 0.0f) {
                CelestialBodyRenderEvent.Pre preEvent = new CelestialBodyRenderEvent.Pre((CelestialBody)star, star.getBodyIcon(), 8);
                MinecraftForge.EVENT_BUS.post((Event)preEvent);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                if (preEvent.celestialBodyTexture != null) {
                    this.field_146297_k.field_71446_o.func_110577_a(preEvent.celestialBodyTexture);
                }
                if (!preEvent.isCanceled()) {
                    int size = GuiCelestialSelection.getWidthForCelestialBodyStatic((CelestialBody)star);
                    if (star == this.selectedBody && this.selectionCount == 1) {
                        size /= 2;
                        size *= 3;
                    }
                    this.drawTexturedModalRect(-size / 2, -size / 2, size, size, 0.0f, 0.0f, preEvent.textureSize, preEvent.textureSize, false, false, preEvent.textureSize, preEvent.textureSize);
                    matrixMap.put(star, worldMatrix12);
                }
                CelestialBodyRenderEvent.Post postEvent2 = new CelestialBodyRenderEvent.Post((CelestialBody)star);
                MinecraftForge.EVENT_BUS.post((Event)postEvent2);
            }
            fb.clear();
            GL11.glPopMatrix();
        }
        for (Planet planet : GalaxyRegistry.getRegisteredPlanets().values()) {
            if (planet.getBodyIcon() == null) continue;
            GL11.glPushMatrix();
            Matrix4f worldMatrix03 = new Matrix4f(worldMatrix);
            Matrix4f.translate((Vector3f)this.getCelestialBodyPosition((CelestialBody)planet), (Matrix4f)worldMatrix03, (Matrix4f)worldMatrix03);
            worldMatrix1 = new Matrix4f();
            Matrix4f.rotate((float)((float)Math.toRadians(45.0)), (Vector3f)new Vector3f(0.0f, 0.0f, 1.0f), (Matrix4f)worldMatrix1, (Matrix4f)worldMatrix1);
            Matrix4f.rotate((float)((float)Math.toRadians(-55.0)), (Vector3f)new Vector3f(1.0f, 0.0f, 0.0f), (Matrix4f)worldMatrix1, (Matrix4f)worldMatrix1);
            worldMatrix1 = Matrix4f.mul((Matrix4f)worldMatrix03, (Matrix4f)worldMatrix1, (Matrix4f)worldMatrix1);
            fb.rewind();
            worldMatrix1.store(fb);
            fb.flip();
            GL11.glMultMatrix((FloatBuffer)fb);
            float alpha = 1.0f;
            if (this.selectedBody instanceof IChildBody && ((IChildBody)this.selectedBody).getParentPlanet() != planet || this.selectedBody instanceof Planet && this.selectedBody != planet && this.selectionCount >= 2) {
                alpha = this.lastSelectedBody == null && !(this.selectedBody instanceof IChildBody) ? 1.0f - Math.min((float)this.ticksSinceSelection / 25.0f, 1.0f) : 0.0f;
            }
            if (alpha != 0.0f) {
                if (!(this.selectedBody instanceof Planet)) {
                    this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain1);
                    this.func_73732_a(this.field_146289_q, planet.getLocalizedName(), 0, 5, 0xE0E0E0);
                }
                CelestialBodyRenderEvent.Pre preEvent = new CelestialBodyRenderEvent.Pre((CelestialBody)planet, planet.getBodyIcon(), 12);
                MinecraftForge.EVENT_BUS.post((Event)preEvent);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                if (preEvent.celestialBodyTexture != null) {
                    this.field_146297_k.field_71446_o.func_110577_a(preEvent.celestialBodyTexture);
                }
                if (!preEvent.isCanceled()) {
                    int size = GuiCelestialSelection.getWidthForCelestialBodyStatic((CelestialBody)planet);
                    this.drawTexturedModalRect(-size / 2, -size / 2, size, size, 0.0f, 0.0f, preEvent.textureSize, preEvent.textureSize, false, false, preEvent.textureSize, preEvent.textureSize);
                    matrixMap.put(planet, worldMatrix1);
                }
                postEvent = new CelestialBodyRenderEvent.Post((CelestialBody)planet);
                MinecraftForge.EVENT_BUS.post((Event)postEvent);
            }
            fb.clear();
            GL11.glPopMatrix();
        }
        if (this.selectedBody != null) {
            worldMatrix0 = new Matrix4f(worldMatrix);
            for (Moon moon : GalaxyRegistry.getRegisteredMoons().values()) {
                if ((moon != this.selectedBody && (moon.getParentPlanet() != this.selectedBody || this.selectionCount == 1) || this.ticksSinceSelection <= 35 && this.selectedBody != moon && (!(this.lastSelectedBody instanceof Moon) || !GalaxyRegistry.getMoonsForPlanet((Planet)((Moon)this.lastSelectedBody).getParentPlanet()).contains(moon))) && !this.getSiblings(this.selectedBody).contains(moon)) continue;
                GL11.glPushMatrix();
                worldMatrix1 = new Matrix4f(worldMatrix0);
                Matrix4f.translate((Vector3f)this.getCelestialBodyPosition((CelestialBody)moon), (Matrix4f)worldMatrix1, (Matrix4f)worldMatrix1);
                Matrix4f worldMatrix2 = new Matrix4f();
                Matrix4f.rotate((float)((float)Math.toRadians(45.0)), (Vector3f)new Vector3f(0.0f, 0.0f, 1.0f), (Matrix4f)worldMatrix2, (Matrix4f)worldMatrix2);
                Matrix4f.rotate((float)((float)Math.toRadians(-55.0)), (Vector3f)new Vector3f(1.0f, 0.0f, 0.0f), (Matrix4f)worldMatrix2, (Matrix4f)worldMatrix2);
                Matrix4f.scale((Vector3f)new Vector3f(0.25f, 0.25f, 1.0f), (Matrix4f)worldMatrix2, (Matrix4f)worldMatrix2);
                worldMatrix2 = Matrix4f.mul((Matrix4f)worldMatrix1, (Matrix4f)worldMatrix2, (Matrix4f)worldMatrix2);
                fb.rewind();
                worldMatrix2.store(fb);
                fb.flip();
                GL11.glMultMatrix((FloatBuffer)fb);
                CelestialBodyRenderEvent.Pre preEvent = new CelestialBodyRenderEvent.Pre((CelestialBody)moon, moon.getBodyIcon(), 8);
                MinecraftForge.EVENT_BUS.post((Event)preEvent);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (preEvent.celestialBodyTexture != null) {
                    this.field_146297_k.field_71446_o.func_110577_a(preEvent.celestialBodyTexture);
                }
                if (!preEvent.isCanceled()) {
                    int size = GuiCelestialSelection.getWidthForCelestialBodyStatic((CelestialBody)moon);
                    this.drawTexturedModalRect(-size / 2, -size / 2, size, size, 0.0f, 0.0f, preEvent.textureSize, preEvent.textureSize, false, false, preEvent.textureSize, preEvent.textureSize);
                    matrixMap.put(moon, worldMatrix1);
                }
                postEvent = new CelestialBodyRenderEvent.Post((CelestialBody)moon);
                MinecraftForge.EVENT_BUS.post((Event)postEvent);
                fb.clear();
                GL11.glPopMatrix();
            }
        }
        if (this.selectedBody != null) {
            worldMatrix0 = new Matrix4f(worldMatrix);
            for (Satellite satellite : GalaxyRegistry.getRegisteredSatellites().values()) {
                if (this.possibleBodies == null || !this.possibleBodies.contains(satellite) || satellite != this.selectedBody && (satellite.getParentPlanet() != this.selectedBody || this.selectionCount == 1) || this.ticksSinceSelection <= 35 && this.selectedBody != satellite && (!(this.lastSelectedBody instanceof Satellite) || !GalaxyRegistry.getSatellitesForCelestialBody((CelestialBody)((Satellite)this.lastSelectedBody).getParentPlanet()).contains(satellite))) continue;
                GL11.glPushMatrix();
                worldMatrix1 = new Matrix4f(worldMatrix0);
                Matrix4f.translate((Vector3f)this.getCelestialBodyPosition((CelestialBody)satellite), (Matrix4f)worldMatrix1, (Matrix4f)worldMatrix1);
                Matrix4f worldMatrix2 = new Matrix4f();
                Matrix4f.rotate((float)((float)Math.toRadians(45.0)), (Vector3f)new Vector3f(0.0f, 0.0f, 1.0f), (Matrix4f)worldMatrix2, (Matrix4f)worldMatrix2);
                Matrix4f.rotate((float)((float)Math.toRadians(-55.0)), (Vector3f)new Vector3f(1.0f, 0.0f, 0.0f), (Matrix4f)worldMatrix2, (Matrix4f)worldMatrix2);
                Matrix4f.scale((Vector3f)new Vector3f(0.25f, 0.25f, 1.0f), (Matrix4f)worldMatrix2, (Matrix4f)worldMatrix2);
                worldMatrix2 = Matrix4f.mul((Matrix4f)worldMatrix1, (Matrix4f)worldMatrix2, (Matrix4f)worldMatrix2);
                fb.rewind();
                worldMatrix2.store(fb);
                fb.flip();
                GL11.glMultMatrix((FloatBuffer)fb);
                CelestialBodyRenderEvent.Pre preEvent = new CelestialBodyRenderEvent.Pre((CelestialBody)satellite, satellite.getBodyIcon(), 8);
                MinecraftForge.EVENT_BUS.post((Event)preEvent);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146297_k.field_71446_o.func_110577_a(preEvent.celestialBodyTexture);
                if (!preEvent.isCanceled()) {
                    int size = GuiCelestialSelection.getWidthForCelestialBodyStatic((CelestialBody)satellite);
                    this.drawTexturedModalRect(-size / 2, -size / 2, size, size, 0.0f, 0.0f, preEvent.textureSize, preEvent.textureSize, false, false, preEvent.textureSize, preEvent.textureSize);
                    matrixMap.put(satellite, worldMatrix1);
                }
                postEvent = new CelestialBodyRenderEvent.Post((CelestialBody)satellite);
                MinecraftForge.EVENT_BUS.post((Event)postEvent);
                fb.clear();
                GL11.glPopMatrix();
            }
        }
        return matrixMap;
    }

    public void drawButtons(int mousePosX, int mousePosY) {
        block23: {
            try {
                if (this.selectionState == GuiCelestialSelection.EnumSelectionState.PROFILE || this.selectedBody == null) break block23;
                GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain1);
                int yOffset = 35;
                int widthSizeOffset = 75;
                int xOffset = 100 + (GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH);
                this.drawTexturedModalRect(xOffset, yOffset, 93 + widthSizeOffset, 4, 159, 102, 93, 4, false, false);
                for (int barY = 0; barY < 25; ++barY) {
                    this.drawTexturedModalRect(xOffset, yOffset + barY * this.field_146289_q.field_78288_b + 4, 93 + widthSizeOffset, this.field_146289_q.field_78288_b, 159, 106, 93, this.field_146289_q.field_78288_b, false, false);
                }
                if (!(this.selectedBody instanceof Star)) {
                    WorldProvider temp = null;
                    if (this.selectedBody.getReachable() && !this.selectedBody.getUnlocalizedName().contains("overworld") && !(this.selectedBody instanceof Satellite)) {
                        temp = FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT ? WorldUtil.getProviderForDimensionClient((int)this.selectedBody.getDimensionID()) : WorldUtil.getProviderForDimensionServer((int)this.selectedBody.getDimensionID());
                    }
                    this.func_73731_b(this.field_146289_q, "------------------------", xOffset + 10, yOffset + 2, ColorUtil.to32BitColor((int)255, (int)0, (int)150, (int)255));
                    this.func_73731_b(this.field_146289_q, GCCoreUtil.translate((String)"gui.general_details.name") + ": ", xOffset + 10, yOffset + 8, ColorUtil.to32BitColor((int)255, (int)0, (int)150, (int)255));
                    this.func_73731_b(this.field_146289_q, "------------------------", xOffset + 10, yOffset + 14, ColorUtil.to32BitColor((int)255, (int)0, (int)150, (int)255));
                    String type = GalaxyRegistry.getRegisteredPlanets().containsValue(this.selectedBody) ? "Planet" : (GalaxyRegistry.getRegisteredMoons().containsValue(this.selectedBody) ? "Moon" : (GalaxyRegistry.getRegisteredSatellites().containsValue(this.selectedBody) ? "Satellite" : "Unknown"));
                    this.func_73731_b(this.field_146289_q, GCCoreUtil.translate((String)"gui.celestial_body_type.name") + ": " + type, xOffset + 10, yOffset + 23, 0xE0E0E0);
                    if (this.selectedBody instanceof Planet) {
                        this.func_73731_b(this.field_146289_q, GCCoreUtil.translate((String)"gui.celestial_body_amount_of_moons.name") + ": " + this.getChildren(this.selectedBody).size(), xOffset + 10, yOffset + 33, 0xE0E0E0);
                    }
                    this.func_73731_b(this.field_146289_q, "------------------------", xOffset + 10, (yOffset += 45) + 2, ColorUtil.to32BitColor((int)255, (int)0, (int)150, (int)255));
                    this.func_73731_b(this.field_146289_q, GCCoreUtil.translate((String)"gui.celestial_details.name") + ": ", xOffset + 10, yOffset + 8, ColorUtil.to32BitColor((int)255, (int)0, (int)150, (int)255));
                    this.func_73731_b(this.field_146289_q, "------------------------", xOffset + 10, yOffset + 14, ColorUtil.to32BitColor((int)255, (int)0, (int)150, (int)255));
                    this.func_73731_b(this.field_146289_q, GCCoreUtil.translate((String)"gui.celestial_body_orbit_time.name") + ": " + this.selectedBody.getRelativeOrbitTime() * 24.0f + " days", xOffset + 10, yOffset + 23, 0xE0E0E0);
                    float gravity = 0.0f;
                    long dayLength = 0L;
                    if (this.selectedBody.getReachable() && !(this.selectedBody instanceof Satellite) && !this.selectedBody.getUnlocalizedName().toLowerCase().contains("overworld")) {
                        gravity = ((WorldProviderSpace)temp).getGravity();
                        dayLength = ((WorldProviderSpace)temp).getDayLength() / 1000L;
                    } else if (this.selectedBody.getUnlocalizedName().toLowerCase().contains("overworld")) {
                        gravity = 1.0f;
                        dayLength = 24L;
                    }
                    this.func_73731_b(this.field_146289_q, GCCoreUtil.translate((String)"gui.celestial_body_gravity.name") + ": " + (this.selectedBody.getReachable() ? Float.valueOf(gravity) : "Unknown"), xOffset + 10, yOffset + 33, 0xE0E0E0);
                    this.func_73731_b(this.field_146289_q, GCCoreUtil.translate((String)"gui.celestial_body_day_lengh.name") + ": " + (this.selectedBody.getReachable() ? dayLength + " hours" : "Unknown"), xOffset + 10, yOffset + 43, 0xE0E0E0);
                    this.func_73731_b(this.field_146289_q, "------------------------", xOffset + 10, (yOffset += 55) + 2, ColorUtil.to32BitColor((int)255, (int)0, (int)150, (int)255));
                    this.func_73731_b(this.field_146289_q, GCCoreUtil.translate((String)"gui.general_features_details.name") + ": ", xOffset + 10, yOffset + 8, ColorUtil.to32BitColor((int)255, (int)0, (int)150, (int)255));
                    this.func_73731_b(this.field_146289_q, "------------------------", xOffset + 10, yOffset + 14, ColorUtil.to32BitColor((int)255, (int)0, (int)150, (int)255));
                    double meteorFrequency = 0.0;
                    if (temp != null && !(this.selectedBody instanceof Satellite) && !this.selectedBody.getUnlocalizedName().contains("overworld")) {
                        double number = ((WorldProviderSpace)temp).getMeteorFrequency();
                        BigDecimal bd = new BigDecimal(number).setScale(7, RoundingMode.DOWN);
                        meteorFrequency = bd.doubleValue();
                    } else {
                        meteorFrequency = 0.0;
                    }
                    this.func_73731_b(this.field_146289_q, GCCoreUtil.translate((String)"gui.celestial_body_meteor_frequency.name") + ": " + (this.selectedBody.getReachable() ? Double.valueOf(meteorFrequency) : "Unknown"), xOffset + 10, yOffset + 23, 0xE0E0E0);
                    String name = this.selectedBody.getUnlocalizedName().toLowerCase();
                    String hasDungeon = "Unknown";
                    if (name.contains("moon") || name.contains("venus") || name.contains("mars") || name.contains("jupiter") || name.contains("saturn") || name.contains("uranus") || name.contains("neptune") || name.contains("pluto") || name.contains("eris")) {
                        hasDungeon = "true";
                    }
                    if (name.contains("overworld") || name.contains("ceres") || name.contains("kepler22b") || name.contains("asteroids") || name.contains("phobos") || name.contains("deimos") || name.contains("io") || name.contains("europa") || name.contains("ganymede") || name.contains("callisto") || name.contains("rhea") || name.contains("titan") || name.contains("iapetus") || name.contains("titania") || name.contains("oberon") || name.contains("triton") || name.contains("mercury")) {
                        hasDungeon = "false";
                    }
                    this.func_73731_b(this.field_146289_q, "Has Dungeon: " + hasDungeon, xOffset + 10, yOffset + 32, 0xE0E0E0);
                    this.func_73731_b(this.field_146289_q, "------------------------", xOffset + 10, (yOffset += 5) + 39, ColorUtil.to32BitColor((int)255, (int)0, (int)150, (int)255));
                    this.func_73731_b(this.field_146289_q, GCCoreUtil.translate((String)"gui.atmosphere_details.name") + ": ", xOffset + 10, yOffset + 45, ColorUtil.to32BitColor((int)255, (int)0, (int)150, (int)255));
                    this.func_73731_b(this.field_146289_q, "------------------------", xOffset + 10, yOffset + 51, ColorUtil.to32BitColor((int)255, (int)0, (int)150, (int)255));
                    float windLevel = 0.0f;
                    if (this.selectedBody.getReachable() && !this.selectedBody.getUnlocalizedName().toLowerCase().contains("overworld") && !(this.selectedBody instanceof Satellite)) {
                        windLevel = ((WorldProviderSpace)temp).getWindLevel() * 10.0f;
                    }
                    this.func_73731_b(this.field_146289_q, GCCoreUtil.translate((String)"gui.celestial_body_wind_level.name") + ": " + (this.selectedBody.getReachable() ? windLevel + "%" : "Unknown"), xOffset + 10, yOffset + 60, 0xE0E0E0);
                    float temperature = 0.0f;
                    if (this.selectedBody.getReachable() && !this.selectedBody.getUnlocalizedName().toLowerCase().contains("overworld") && !(this.selectedBody instanceof Satellite)) {
                        try {
                            temperature = ((WorldProviderSpace)temp).getThermalLevelModifier();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.func_73731_b(this.field_146289_q, GCCoreUtil.translate((String)"gui.celestial_body_temperature.name") + ": " + (this.selectedBody.getReachable() ? temperature + "\ufffdC" : "Unknown"), xOffset + 10, yOffset + 70, 0xE0E0E0);
                    boolean breathable = false;
                    try {
                        if (temp != null && !(this.selectedBody instanceof Satellite)) {
                            breathable = ((WorldProviderSpace)temp).hasBreathableAtmosphere();
                        }
                        if (this.selectedBody.getUnlocalizedName().contains("overworld")) {
                            breathable = true;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.func_73731_b(this.field_146289_q, GCCoreUtil.translate((String)"gui.celestial_body_breathable.name") + ": " + (this.selectedBody.getReachable() ? Boolean.valueOf(breathable) : "Unknown"), xOffset + 10, yOffset + 80, 0xE0E0E0);
                    break block23;
                }
                if (this.selectedBody instanceof Star) {
                    this.func_73731_b(this.field_146289_q, "------------------------", xOffset + 10, yOffset + 2, ColorUtil.to32BitColor((int)255, (int)0, (int)150, (int)255));
                    this.func_73731_b(this.field_146289_q, GCCoreUtil.translate((String)"gui.general_details.name") + ": ", xOffset + 10, yOffset + 8, ColorUtil.to32BitColor((int)255, (int)0, (int)150, (int)255));
                    this.func_73731_b(this.field_146289_q, "------------------------", xOffset + 10, yOffset + 14, ColorUtil.to32BitColor((int)255, (int)0, (int)150, (int)255));
                    this.func_73731_b(this.field_146289_q, GCCoreUtil.translate((String)"gui.celestial_body_type.name") + ": Star", xOffset + 10, yOffset + 23, 0xE0E0E0);
                    List planets = this.getChildren(((Star)this.selectedBody).getParentSolarSystem());
                    int amountofPlanets = planets.size();
                    this.func_73731_b(this.field_146289_q, GCCoreUtil.translate((String)"gui.celestial_body_amount_of_planets.name") + ": " + amountofPlanets, xOffset + 10, yOffset + 33, 0xE0E0E0);
                    this.func_73731_b(this.field_146289_q, "------------------------", xOffset + 10, (yOffset += 50) + 2, ColorUtil.to32BitColor((int)255, (int)0, (int)150, (int)255));
                    this.func_73731_b(this.field_146289_q, GCCoreUtil.translate((String)"gui.parent_solar_system_details.name") + ": ", xOffset + 10, yOffset + 8, ColorUtil.to32BitColor((int)255, (int)0, (int)150, (int)255));
                    this.func_73731_b(this.field_146289_q, "------------------------", xOffset + 10, yOffset + 14, ColorUtil.to32BitColor((int)255, (int)0, (int)150, (int)255));
                    int amountofMoons = 0;
                    for (int i = 0; i < amountofPlanets; ++i) {
                        amountofMoons += this.getChildren(planets.get(i)).size();
                    }
                    this.func_73731_b(this.field_146289_q, GCCoreUtil.translate((String)"gui.celestial_body_amount_of_moons.name") + ": " + amountofMoons, xOffset + 10, yOffset + 23, 0xE0E0E0);
                }
            }
            catch (Exception e) {
                System.out.println("An error has occurred while rendering custom features on the Celestial Selection screen, Please check log for errors!");
                e.printStackTrace();
            }
        }
        super.drawButtons(mousePosX, mousePosY);
    }
}

