/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.entities.bosses;

import com.mjr.extraplanets.Config;
import com.mjr.extraplanets.items.ExtraPlanets_Items;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import micdoodle8.mods.galacticraft.core.entities.EntityBossBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityEvolvedFireBatBoss
extends EntityBossBase
implements IMob,
IEntityBreathable {
    private int explosionStrength = 2;
    private static final DataParameter<Boolean> ATTACKING = EntityDataManager.func_187226_a(EntityEvolvedFireBatBoss.class, (DataSerializer)DataSerializers.field_187198_h);
    private BlockPos spawnPosition;

    public EntityEvolvedFireBatBoss(World world) {
        super(world);
        this.func_70105_a(6.5f, 6.9f);
        this.field_70178_ae = true;
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AIFireballAttack(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACKING, (Object)false);
    }

    protected float func_70599_aP() {
        return 0.1f;
    }

    protected float func_70647_i() {
        return super.func_70647_i() * 0.95f;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return this.field_70146_Z.nextInt(4) != 0 ? null : SoundEvents.field_187740_w;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187743_y;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187742_x;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_82167_n(Entity entity) {
    }

    protected void func_85033_bc() {
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(800.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(100.0);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isAttacking() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.field_70180_af.func_187227_b(ATTACKING, (Object)attacking);
    }

    public int getFireballStrength() {
        return this.explosionStrength;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
        this.field_70181_x *= (double)0.6f;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (!(this.spawnPosition == null || this.field_70170_p.func_175623_d(this.spawnPosition) && this.spawnPosition.func_177956_o() >= 1)) {
            this.spawnPosition = null;
        }
        if (this.spawnPosition == null || this.field_70146_Z.nextInt(30) == 0 || this.spawnPosition.func_177954_c((double)((int)this.field_70165_t), (double)((int)this.field_70163_u), (double)((int)this.field_70161_v)) < 4.0) {
            this.spawnPosition = new BlockPos((int)this.field_70165_t + this.field_70146_Z.nextInt(7) - this.field_70146_Z.nextInt(7), (int)this.field_70163_u + this.field_70146_Z.nextInt(6) - 2, (int)this.field_70161_v + this.field_70146_Z.nextInt(7) - this.field_70146_Z.nextInt(7));
        }
        double d0 = (double)this.spawnPosition.func_177958_n() + 0.5 - this.field_70165_t;
        double d1 = (double)this.spawnPosition.func_177956_o() + 1.5 - this.field_70163_u;
        double d2 = (double)this.spawnPosition.func_177952_p() + 0.5 - this.field_70161_v;
        this.field_70159_w += (Math.signum(d0) * 0.5 - this.field_70159_w) * (double)0.1f;
        this.field_70181_x += (Math.signum(d1) * (double)0.7f - this.field_70181_x) * (double)0.1f;
        this.field_70179_y += (Math.signum(d2) * 0.5 - this.field_70179_y) * (double)0.1f;
        float f = (float)(MathHelper.func_181159_b((double)this.field_70179_y, (double)this.field_70159_w) * 57.29577951308232) - 90.0f;
        float f1 = MathHelper.func_76142_g((float)(f - this.field_70177_z));
        this.field_191988_bg = 0.5f;
        this.field_70177_z += f1;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public boolean func_145773_az() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public static void registerFixesBat(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityEvolvedFireBatBoss.class);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("ExplosionPower", this.explosionStrength);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_150297_b("ExplosionPower", 99)) {
            this.explosionStrength = nbt.func_74762_e("ExplosionPower");
        }
    }

    public float func_70047_e() {
        return this.field_70131_O / 2.0f;
    }

    public EntityItem func_70099_a(ItemStack itemStack, float par2) {
        EntityItem EntityItem2 = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)par2, this.field_70161_v, itemStack);
        EntityItem2.field_70181_x = -2.0;
        EntityItem2.func_174869_p();
        if (this.captureDrops) {
            this.capturedDrops.add(EntityItem2);
        } else {
            this.field_70170_p.func_72838_d((Entity)EntityItem2);
        }
        return EntityItem2;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186377_ab;
    }

    public boolean canBreath() {
        return true;
    }

    public int getChestTier() {
        return 5;
    }

    public void dropKey() {
        this.func_70099_a(new ItemStack(ExtraPlanets_Items.TIER_5_KEY, 1, 0), 0.5f);
    }

    public ItemStack getGuaranteedLoot(Random rand) {
        List stackList = Config.MORE_PLANETS_COMPATIBILITY ? GalacticraftRegistry.getDungeonLoot((int)4) : GalacticraftRegistry.getDungeonLoot((int)5);
        return ((ItemStack)stackList.get(rand.nextInt(stackList.size()))).func_77946_l();
    }

    public BossInfo.Color getHealthBarColor() {
        return BossInfo.Color.BLUE;
    }

    static class AIFireballAttack
    extends EntityAIBase {
        private EntityEvolvedFireBatBoss parentEntity;
        public int attackTimer;

        public AIFireballAttack(EntityEvolvedFireBatBoss entityEvolvedFireBatBoss) {
            this.parentEntity = entityEvolvedFireBatBoss;
        }

        public boolean func_75250_a() {
            return this.parentEntity.func_70638_az() != null;
        }

        public void func_75249_e() {
            this.attackTimer = 0;
        }

        public void func_75251_c() {
            this.parentEntity.setAttacking(false);
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = this.parentEntity.func_70638_az();
            if (entitylivingbase.func_70068_e((Entity)this.parentEntity) < 4096.0 && this.parentEntity.func_70685_l((Entity)entitylivingbase)) {
                World world = this.parentEntity.field_70170_p;
                ++this.attackTimer;
                if (this.attackTimer == 10) {
                    world.func_180498_a((EntityPlayer)null, 1015, new BlockPos((Entity)this.parentEntity), 0);
                }
                if (this.attackTimer == 10 || this.attackTimer == 30 || this.attackTimer == 50 || this.attackTimer == 70) {
                    Vec3d vec3d = this.parentEntity.func_70676_i(1.0f);
                    double d2 = entitylivingbase.field_70165_t - (this.parentEntity.field_70165_t + vec3d.field_72450_a * 4.0);
                    double d3 = entitylivingbase.func_174813_aQ().field_72338_b + (double)(entitylivingbase.field_70131_O / 2.0f) - (0.5 + this.parentEntity.field_70163_u + (double)(this.parentEntity.field_70131_O / 2.0f));
                    double d4 = entitylivingbase.field_70161_v - (this.parentEntity.field_70161_v + vec3d.field_72449_c * 4.0);
                    world.func_180498_a((EntityPlayer)null, 1016, new BlockPos((Entity)this.parentEntity), 0);
                    EntityLargeFireball entitylargefireball = new EntityLargeFireball(world, (EntityLivingBase)this.parentEntity, d2, d3, d4);
                    entitylargefireball.field_92057_e = this.parentEntity.getFireballStrength();
                    entitylargefireball.field_70165_t = this.parentEntity.field_70165_t + vec3d.field_72450_a * 4.0;
                    entitylargefireball.field_70163_u = this.parentEntity.field_70163_u + (double)(this.parentEntity.field_70131_O / 2.0f) + 0.5;
                    entitylargefireball.field_70161_v = this.parentEntity.field_70161_v + vec3d.field_72449_c * 4.0;
                    world.func_72838_d((Entity)entitylargefireball);
                    if (this.attackTimer == 70) {
                        this.attackTimer = -40;
                    }
                }
            } else if (this.attackTimer > 0) {
                --this.attackTimer;
            }
            this.parentEntity.setAttacking(this.attackTimer > 10);
        }
    }
}

