/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.entities.rockets;

import com.mjr.extraplanets.blocks.BlockCustomLandingPadFull;
import com.mjr.extraplanets.blocks.ExtraPlanets_Blocks;
import com.mjr.extraplanets.items.ExtraPlanets_Items;
import com.mjr.extraplanets.tileEntities.blocks.TileEntityTier2LandingPad;
import com.mjr.mjrlegendslib.util.TranslateUtilities;
import java.util.List;
import micdoodle8.mods.galacticraft.api.entity.IRocketType;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityTieredRocket;
import micdoodle8.mods.galacticraft.api.tile.IFuelDock;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.player.GCCapabilities;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.event.EventLandingPadRemoval;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntityTier6Rocket
extends EntityTieredRocket {
    public EntityTier6Rocket(World world) {
        super(world);
        this.func_70105_a(1.8f, 6.0f);
    }

    public EntityTier6Rocket(World world, double x, double y, double z, IRocketType.EnumRocketType type) {
        super(world, x, y, z);
        this.rocketType = type;
        this.stacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }

    public double func_70033_W() {
        return 1.5;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(ExtraPlanets_Items.TIER_6_ROCKET, 1, this.rocketType.getIndex());
    }

    public double func_70042_X() {
        return 1.75;
    }

    public float getRotateOffset() {
        return 1.1f;
    }

    public double getOnPadYOffset() {
        return 0.8;
    }

    public void onLaunch() {
        if (this.field_70170_p.field_73011_w.getDimension() != GalacticraftCore.planetOverworld.getDimensionID() && !(this.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider)) {
            if (ConfigManagerCore.disableRocketLaunchAllNonGC) {
                this.cancelLaunch();
                return;
            }
            for (int i = ConfigManagerCore.disableRocketLaunchDimensions.length - 1; i >= 0; --i) {
                if (ConfigManagerCore.disableRocketLaunchDimensions[i] != this.field_70170_p.field_73011_w.getDimension()) continue;
                this.cancelLaunch();
                return;
            }
        }
        super.onLaunch();
        if (!this.field_70170_p.field_72995_K) {
            GCPlayerStats stats = null;
            if (!this.func_184188_bt().isEmpty() && this.func_184188_bt().get(0) instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)this.func_184188_bt().get(0);
                stats = GCPlayerStats.get((Entity)player);
                if (!(this.field_70170_p.field_73011_w instanceof IOrbitDimension)) {
                    stats.setCoordsTeleportedFromX(player.field_70165_t);
                    stats.setCoordsTeleportedFromZ(player.field_70161_v);
                }
            }
            int amountRemoved = 0;
            block1: for (int x = MathHelper.func_76128_c((double)this.field_70165_t) - 1; x <= MathHelper.func_76128_c((double)this.field_70165_t) + 1; ++x) {
                for (int y = MathHelper.func_76128_c((double)this.field_70163_u) - 3; y <= MathHelper.func_76128_c((double)this.field_70163_u) + 1; ++y) {
                    for (int z = MathHelper.func_76128_c((double)this.field_70161_v) - 1; z <= MathHelper.func_76128_c((double)this.field_70161_v) + 1; ++z) {
                        BlockPos pos = new BlockPos(x, y, z);
                        Block block = this.field_70170_p.func_180495_p(pos).func_177230_c();
                        if (block == null || !(block instanceof BlockCustomLandingPadFull) || amountRemoved >= 9) continue;
                        EventLandingPadRemoval event = new EventLandingPadRemoval(this.field_70170_p, pos);
                        MinecraftForge.EVENT_BUS.post((Event)event);
                        if (!event.allow) break block1;
                        this.field_70170_p.func_175698_g(pos);
                        amountRemoved = 9;
                        break block1;
                    }
                }
            }
            if (stats != null) {
                stats.setLaunchpadStack(new ItemStack(ExtraPlanets_Blocks.ADVANCED_LAUCHPAD, 25, 0));
            }
            this.func_184185_a(SoundEvents.field_187638_cR, 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        int i = this.timeUntilLaunch >= 100 ? Math.abs(this.timeUntilLaunch / 100) : 1;
        if ((this.getLaunched() || this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.IGNITED.ordinal() && this.field_70146_Z.nextInt(i) == 0) && !ConfigManagerCore.disableSpaceshipParticles && this.hasValidFuel() && this.field_70170_p.field_72995_K) {
            this.spawnParticles(this.getLaunched());
        }
        if (this.launchPhase >= EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal() && this.hasValidFuel()) {
            if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal()) {
                double d = this.timeSinceLaunch / 150.0f;
                if ((d = Math.min(d, 1.0)) != 0.0) {
                    this.field_70181_x = -d * 2.5 * Math.cos((double)(this.field_70125_A - 180.0f) / 57.2957795);
                }
            } else {
                this.field_70181_x -= 0.008;
            }
            double multiplier = 1.0;
            if (this.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && (multiplier = ((IGalacticraftWorldProvider)this.field_70170_p.field_73011_w).getFuelUsageMultiplier()) <= 0.0) {
                multiplier = 1.0;
            }
            if (this.timeSinceLaunch % (float)MathHelper.func_76128_c((double)(2.0 * (1.0 / multiplier))) == 0.0f) {
                this.removeFuel(1);
                if (!this.hasValidFuel()) {
                    this.stopRocketSound();
                }
            }
        } else if (!this.hasValidFuel() && this.getLaunched() && !this.field_70170_p.field_72995_K && Math.abs(Math.sin(this.timeSinceLaunch / 1000.0f)) / 10.0 != 0.0) {
            this.field_70181_x -= Math.abs(Math.sin(this.timeSinceLaunch / 1000.0f)) / 20.0;
        }
    }

    public void onTeleport(EntityPlayerMP player) {
        EntityPlayerMP playerBase = PlayerUtil.getPlayerBaseServerFromPlayer((EntityPlayer)player, (boolean)false);
        if (playerBase != null) {
            GCPlayerStats stats = (GCPlayerStats)playerBase.getCapability(GCCapabilities.GC_STATS_CAPABILITY, null);
            if (this.stacks == null || this.stacks.isEmpty()) {
                stats.setRocketStacks(NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a));
            } else {
                stats.setRocketStacks(this.stacks);
            }
            stats.setRocketType(this.rocketType.getIndex());
            stats.setRocketItem(ExtraPlanets_Items.TIER_6_ROCKET);
            stats.setFuelLevel(this.fuelTank.getFluidAmount());
        }
    }

    protected void spawnParticles(boolean launched) {
        if (!this.field_70128_L) {
            double sinPitch = Math.sin((double)this.field_70125_A / 57.29577951308232);
            double x1 = 3.2 * Math.cos((double)this.field_70177_z / 57.29577951308232) * sinPitch;
            double z1 = 3.2 * Math.sin((double)this.field_70177_z / 57.29577951308232) * sinPitch;
            double y1 = 3.2 * Math.cos((double)(this.field_70125_A - 180.0f) / 57.29577951308232);
            if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LANDING.ordinal() && this.targetVec != null) {
                double modifier = this.field_70163_u - (double)this.targetVec.func_177956_o();
                modifier = Math.max(modifier, 180.0);
                x1 *= modifier / 200.0;
                y1 *= Math.min(modifier / 200.0, 2.5);
                z1 *= modifier / 200.0;
            }
            double y2 = this.field_70167_r + (this.field_70163_u - this.field_70167_r) + y1 - 0.75 * this.field_70181_x - 0.3 + 1.2;
            double x2 = this.field_70165_t + x1 + this.field_70159_w;
            double z2 = this.field_70161_v + z1 + this.field_70179_y;
            Vector3 motionVec = new Vector3(x1 + this.field_70159_w, y1 + this.field_70181_x, z1 + this.field_70179_y);
            Vector3 d1 = new Vector3(y1 * 0.1, -x1 * 0.1, z1 * 0.1).rotate(315.0f - this.field_70177_z, motionVec);
            Vector3 d2 = new Vector3(x1 * 0.1, -z1 * 0.1, y1 * 0.1).rotate(315.0f - this.field_70177_z, motionVec);
            Vector3 d3 = new Vector3(-y1 * 0.1, x1 * 0.1, z1 * 0.1).rotate(315.0f - this.field_70177_z, motionVec);
            Vector3 d4 = new Vector3(x1 * 0.1, z1 * 0.1, -y1 * 0.1).rotate(315.0f - this.field_70177_z, motionVec);
            Vector3 mv1 = motionVec.clone().translate(d1);
            Vector3 mv2 = motionVec.clone().translate(d2);
            Vector3 mv3 = motionVec.clone().translate(d3);
            Vector3 mv4 = motionVec.clone().translate(d4);
            EntityLivingBase riddenByEntity = this.func_184188_bt().isEmpty() || !(this.func_184188_bt().get(0) instanceof EntityLivingBase) ? null : (EntityLivingBase)this.func_184188_bt().get(0);
            Object[] rider = new Object[]{riddenByEntity};
            this.makeFlame(x2 + d1.x, y2 + d1.y, z2 + d1.z, mv1, this.getLaunched(), rider);
            this.makeFlame(x2 + d2.x, y2 + d2.y, z2 + d2.z, mv2, this.getLaunched(), rider);
            this.makeFlame(x2 + d3.x, y2 + d3.y, z2 + d3.z, mv3, this.getLaunched(), rider);
            this.makeFlame(x2 + d4.x, y2 + d4.y, z2 + d4.z, mv4, this.getLaunched(), rider);
        }
    }

    private void makeFlame(double x2, double y2, double z2, Vector3 motionVec, boolean getLaunched, Object[] rider) {
        if (getLaunched) {
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0, y2, z2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0, y2, z2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0, y2, z2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0, y2, z2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2, y2, z2), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 + 0.4, y2, z2), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 - 0.4, y2, z2), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2, y2, z2 + 0.4), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2, y2, z2 - 0.4), motionVec, rider);
            return;
        }
        if (this.field_70173_aa % 2 == 0) {
            return;
        }
        double x1 = motionVec.x;
        double y1 = motionVec.y;
        double z1 = motionVec.z;
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0, y2 += 1.2, z2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0), new Vector3(x1 + 0.5, y1 - 0.3, z1 + 0.5), rider);
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0, y2, z2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0), new Vector3(x1 - 0.5, y1 - 0.3, z1 + 0.5), rider);
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0, y2, z2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0), new Vector3(x1 - 0.5, y1 - 0.3, z1 - 0.5), rider);
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0, y2, z2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0), new Vector3(x1 + 0.5, y1 - 0.3, z1 - 0.5), rider);
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 + 0.4, y2, z2), new Vector3(x1 + 0.8, y1 - 0.3, z1), rider);
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 - 0.4, y2, z2), new Vector3(x1 - 0.8, y1 - 0.3, z1), rider);
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2, y2, z2 + 0.4), new Vector3(x1, y1 - 0.3, z1 + 0.8), rider);
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2, y2, z2 - 0.4), new Vector3(x1, y1 - 0.3, z1 - 0.8), rider);
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return !this.field_70128_L && entityPlayer.func_70068_e((Entity)this) <= 64.0;
    }

    public void onPadDestroyed() {
        if (!this.field_70128_L && this.launchPhase != EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal()) {
            this.dropShipAsItem();
            this.func_70106_y();
        }
    }

    public int getRocketTier() {
        return 6;
    }

    public int getFuelTankCapacity() {
        return 1500;
    }

    public int getPreLaunchWait() {
        return 400;
    }

    public float getCameraZoom() {
        return 15.0f;
    }

    public boolean defaultThirdPerson() {
        return true;
    }

    public List<ItemStack> getItemsDropped(List<ItemStack> droppedItems) {
        super.getItemsDropped(droppedItems);
        ItemStack rocket = new ItemStack(ExtraPlanets_Items.TIER_6_ROCKET, 1, this.rocketType.getIndex());
        rocket.func_77982_d(new NBTTagCompound());
        rocket.func_77978_p().func_74768_a("RocketFuel", this.fuelTank.getFluidAmount());
        droppedItems.add(rocket);
        return droppedItems;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public float getRenderOffsetY() {
        return 1.1f;
    }

    public boolean isDockValid(IFuelDock dock) {
        return dock instanceof TileEntityTier2LandingPad;
    }

    public String func_70005_c_() {
        return TranslateUtilities.translate((String)"entity.extraplanets.EntityTier6Rocket.name");
    }
}

