/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.api.prefabs.entity;

import com.mjr.mjrlegendslib.inventory.IInventoryDefaults;
import com.mjr.mjrlegendslib.util.MCUtilities;
import com.mjr.mjrlegendslib.util.PlayerUtilties;
import com.mjr.mjrlegendslib.util.TranslateUtilities;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import micdoodle8.mods.galacticraft.api.entity.ICargoEntity;
import micdoodle8.mods.galacticraft.api.entity.IDockable;
import micdoodle8.mods.galacticraft.api.tile.IFuelDock;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.TransformerHooks;
import micdoodle8.mods.galacticraft.core.entities.IControllableEntity;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.network.NetworkUtil;
import micdoodle8.mods.galacticraft.core.network.PacketDynamic;
import micdoodle8.mods.galacticraft.core.network.PacketEntityUpdate;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.tick.KeyHandlerClient;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityVehicleBase
extends Entity
implements IInventoryDefaults,
IPacketReceiver,
IDockable,
IControllableEntity,
PacketEntityUpdate.IEntityFullSync {
    private static final DataParameter<Integer> CURRENT_DAMAGE = EntityDataManager.func_187226_a(EntityVehicleBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TIME_SINCE_HIT = EntityDataManager.func_187226_a(EntityVehicleBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> ROCK_DIRECTION = EntityDataManager.func_187226_a(EntityVehicleBase.class, (DataSerializer)DataSerializers.field_187192_b);
    public final int tankCapacity = 1000;
    public FluidTank roverFuelTank = new FluidTank(this.tankCapacity);
    protected long ticks = 0L;
    public int roverType;
    private double speed;
    public float wheelRotationZ;
    public float wheelRotationX;
    private float maxSpeed = 0.5f;
    private float accel = 0.2f;
    private float turnFactor = 3.0f;
    public String texture;
    protected NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)60, (Object)ItemStack.field_190927_a);
    private double boatX;
    private double boatY;
    private double boatZ;
    private double boatYaw;
    private double boatPitch;
    private int boatPosRotationIncrements;
    protected IFuelDock landingPad;
    private int timeClimbing;
    private boolean shouldClimb;

    public EntityVehicleBase(World var1) {
        super(var1);
        this.func_70105_a(0.98f, 1.0f);
        this.speed = 0.0;
        this.field_70156_m = true;
        this.field_70180_af.func_187214_a(CURRENT_DAMAGE, (Object)0);
        this.field_70180_af.func_187214_a(TIME_SINCE_HIT, (Object)0);
        this.field_70180_af.func_187214_a(ROCK_DIRECTION, (Object)1);
        this.field_70158_ak = true;
        this.field_70178_ae = true;
        if (var1 != null && var1.field_72995_K) {
            GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketDynamic((Entity)this));
        }
    }

    public EntityVehicleBase(World var1, double var2, double var4, double var6, int type) {
        this(var1);
        this.func_70107_b(var2, var4, var6);
        this.setBuggyType(type);
        this.stacks = NonNullList.func_191197_a((int)(this.roverType * 18), (Object)ItemStack.field_190927_a);
    }

    public int getScaledFuelLevel(int i) {
        double fuelLevel = this.roverFuelTank.getFluid() == null ? 0.0 : (double)this.roverFuelTank.getFluid().amount;
        return (int)(fuelLevel * (double)i / (double)this.tankCapacity);
    }

    public ModelBase getModel() {
        return null;
    }

    public int getType() {
        return this.roverType;
    }

    protected void func_70088_a() {
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O - 3.0;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void setBuggyType(int par1) {
        this.roverType = par1;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            double offsetX = Math.cos((double)this.field_70177_z / 57.29577951308232 + 114.8) * -0.5;
            double offsetZ = Math.sin((double)this.field_70177_z / 57.29577951308232 + 114.8) * -0.5;
            passenger.func_70107_b(this.field_70165_t + offsetX, this.field_70163_u + (double)0.4f + passenger.func_70033_W(), this.field_70161_v + offsetZ);
        }
    }

    public void setPositionRotationAndMotion(double x, double y, double z, float yaw, float pitch, double motX, double motY, double motZ, boolean onGround) {
        if (this.field_70170_p.field_72995_K) {
            this.boatX = x;
            this.boatY = y;
            this.boatZ = z;
            this.boatYaw = yaw;
            this.boatPitch = pitch;
            this.field_70159_w = motX;
            this.field_70181_x = motY;
            this.field_70179_y = motZ;
            this.boatPosRotationIncrements = 5;
        } else {
            this.func_70107_b(x, y, z);
            this.func_70101_b(yaw, pitch);
            this.field_70159_w = motX;
            this.field_70181_x = motY;
            this.field_70179_y = motZ;
        }
    }

    public void func_70057_ab() {
        this.field_70180_af.func_187227_b(ROCK_DIRECTION, (Object)(-((Integer)this.field_70180_af.func_187225_a(ROCK_DIRECTION)).intValue()));
        this.field_70180_af.func_187227_b(TIME_SINCE_HIT, (Object)10);
        this.field_70180_af.func_187227_b(CURRENT_DAMAGE, (Object)((Integer)this.field_70180_af.func_187225_a(CURRENT_DAMAGE) * 5));
    }

    public boolean func_70097_a(DamageSource var1, float var2) {
        boolean flag;
        if (this.field_70128_L || var1.equals(DamageSource.field_76367_g)) {
            return true;
        }
        Entity e = var1.func_76346_g();
        boolean bl = flag = var1.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)var1.func_76346_g()).field_71075_bZ.field_75098_d;
        if (this.func_180431_b(var1) || e instanceof EntityLivingBase && !(e instanceof EntityPlayer)) {
            return false;
        }
        this.field_70180_af.func_187227_b(ROCK_DIRECTION, (Object)(-((Integer)this.field_70180_af.func_187225_a(ROCK_DIRECTION)).intValue()));
        this.field_70180_af.func_187227_b(TIME_SINCE_HIT, (Object)10);
        this.field_70180_af.func_187227_b(CURRENT_DAMAGE, (Object)((int)((float)((Integer)this.field_70180_af.func_187225_a(CURRENT_DAMAGE)).intValue() + var2 * 10.0f)));
        this.func_70018_K();
        if (e instanceof EntityPlayer && ((EntityPlayer)e).field_71075_bZ.field_75098_d) {
            this.field_70180_af.func_187227_b(CURRENT_DAMAGE, (Object)100);
        }
        if (flag || (Integer)this.field_70180_af.func_187225_a(CURRENT_DAMAGE) > 2) {
            if (!this.func_184188_bt().isEmpty()) {
                this.func_184226_ay();
            }
            if (flag) {
                this.func_70106_y();
            } else {
                this.func_70106_y();
                if (!this.field_70170_p.field_72995_K) {
                    this.dropBuggyAsItem();
                }
            }
            this.func_70106_y();
        }
        return true;
    }

    public void dropBuggyAsItem() {
        List<ItemStack> dropped = this.getItemsDropped();
        if (dropped == null) {
            return;
        }
        for (ItemStack item : dropped) {
            EntityItem EntityItem2 = this.func_70099_a(item, 0.0f);
            if (!item.func_77942_o()) continue;
            EntityItem2.func_92059_d().func_77982_d(item.func_77978_p().func_74737_b());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean b) {
        if (!this.func_184188_bt().isEmpty() && !this.func_184188_bt().contains(MCUtilities.getClient().field_71439_g)) {
            this.boatPosRotationIncrements = posRotationIncrements + 5;
            this.boatX = x;
            this.boatY = y;
            this.boatZ = z;
            this.boatYaw = yaw;
            this.boatPitch = pitch;
        }
    }

    public void func_70071_h_() {
        double d;
        if (this.ticks >= Long.MAX_VALUE) {
            this.ticks = 1L;
        }
        ++this.ticks;
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.wheelRotationX = (float)((double)this.wheelRotationX + Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y) * 150.0 * (double)(this.speed < 0.0 ? 1 : -1));
            this.wheelRotationX %= 360.0f;
            this.wheelRotationZ = Math.max(-30.0f, Math.min(30.0f, this.wheelRotationZ * 0.9f));
        }
        if (this.field_70170_p.field_72995_K && !MCUtilities.getClient().field_71439_g.equals((Object)this.field_70170_p.func_72890_a((Entity)this, -1.0))) {
            if (this.boatPosRotationIncrements > 0) {
                double x = this.field_70165_t + (this.boatX - this.field_70165_t) / (double)this.boatPosRotationIncrements;
                double y = this.field_70163_u + (this.boatY - this.field_70163_u) / (double)this.boatPosRotationIncrements;
                double z = this.field_70161_v + (this.boatZ - this.field_70161_v) / (double)this.boatPosRotationIncrements;
                double var12 = MathHelper.func_76138_g((double)(this.boatYaw - (double)this.field_70177_z));
                this.field_70177_z = (float)((double)this.field_70177_z + var12 / (double)this.boatPosRotationIncrements);
                this.field_70125_A = (float)((double)this.field_70125_A + (this.boatPitch - (double)this.field_70125_A) / (double)this.boatPosRotationIncrements);
                --this.boatPosRotationIncrements;
                this.func_70107_b(x, y, z);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            } else {
                double x = this.field_70165_t + this.field_70159_w;
                double y = this.field_70163_u + this.field_70181_x;
                double z = this.field_70161_v + this.field_70179_y;
                if (this.func_184188_bt() != null) {
                    this.func_70107_b(x, y, z);
                }
                if (this.field_70122_E) {
                    this.field_70159_w *= 0.5;
                    this.field_70181_x *= 0.5;
                    this.field_70179_y *= 0.5;
                }
                this.field_70159_w *= (double)0.99f;
                this.field_70181_x *= (double)0.95f;
                this.field_70179_y *= (double)0.99f;
            }
            return;
        }
        if ((Integer)this.field_70180_af.func_187225_a(TIME_SINCE_HIT) > 0) {
            this.field_70180_af.func_187227_b(TIME_SINCE_HIT, (Object)((Integer)this.field_70180_af.func_187225_a(TIME_SINCE_HIT) - 1));
        }
        if ((Integer)this.field_70180_af.func_187225_a(CURRENT_DAMAGE) > 0) {
            this.field_70180_af.func_187227_b(CURRENT_DAMAGE, (Object)((Integer)this.field_70180_af.func_187225_a(CURRENT_DAMAGE) - 1));
        }
        if (!this.field_70122_E) {
            this.field_70181_x -= TransformerHooks.getGravityForEntity((Entity)this) * 0.5;
        }
        if (this.field_70171_ac && this.speed > 0.2) {
            this.field_70170_p.func_184148_a(null, (double)((float)this.field_70165_t), (double)((float)this.field_70163_u), (double)((float)this.field_70161_v), SoundEvents.field_187658_bx, SoundCategory.NEUTRAL, 0.5f, 2.6f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.8f);
        }
        this.speed *= 0.98;
        if (this.speed > (double)this.maxSpeed) {
            this.speed = this.maxSpeed;
        }
        if (this.field_70123_F && this.shouldClimb) {
            this.speed *= 0.9;
            this.field_70181_x = 0.15 * (-Math.pow(this.timeClimbing - 1, 2.0) / 250.0) + (double)0.15f;
            this.field_70181_x = Math.max(-0.15, this.field_70181_x);
            this.shouldClimb = false;
        }
        this.timeClimbing = !(this.field_70159_w != 0.0 && this.field_70179_y != 0.0 || this.field_70122_E) ? ++this.timeClimbing : 0;
        if (this.field_70170_p.field_72995_K && this.roverFuelTank.getFluid() != null && this.roverFuelTank.getFluid().amount > 0) {
            this.field_70159_w = -(this.speed * Math.cos((double)(this.field_70177_z - 90.0f) * Math.PI / 180.0));
            this.field_70179_y = -(this.speed * Math.sin((double)(this.field_70177_z - 90.0f) * Math.PI / 180.0));
        }
        if (this.field_70170_p.field_72995_K) {
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        if (!this.field_70170_p.field_72995_K && Math.abs(this.field_70159_w * this.field_70179_y) > 1.0E-6 && (d = this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y) != 0.0 && this.ticks % (long)(MathHelper.func_76128_c((double)(2.0 / d)) + 1) == 0L) {
            this.removeFuel(1);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (this.field_70170_p.field_72995_K) {
            GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketEntityUpdate((Entity)this));
        } else if (this.ticks % 5L == 0L) {
            GalacticraftCore.packetPipeline.sendToAllAround((IPacket)new PacketEntityUpdate((Entity)this), new NetworkRegistry.TargetPoint(GCCoreUtil.getDimensionID((World)this.field_70170_p), this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0));
            GalacticraftCore.packetPipeline.sendToAllAround((IPacket)new PacketDynamic((Entity)this), new NetworkRegistry.TargetPoint(GCCoreUtil.getDimensionID((World)this.field_70170_p), this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0));
        }
    }

    public void getNetworkedData(ArrayList<Object> sendData) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        sendData.add(this.roverType);
        sendData.add(this.roverFuelTank);
    }

    public void decodePacketdata(ByteBuf buffer) {
        this.roverType = buffer.readInt();
        try {
            this.roverFuelTank = NetworkUtil.readFluidTank((ByteBuf)buffer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void func_70037_a(NBTTagCompound var1) {
        this.roverType = var1.func_74762_e("roverType");
        ItemStackHelper.func_191283_b((NBTTagCompound)var1, this.stacks);
        if (var1.func_74764_b("fuelTank")) {
            this.roverFuelTank.readFromNBT(var1.func_74775_l("fuelTank"));
        }
    }

    protected void func_70014_b(NBTTagCompound var1) {
        var1.func_74768_a("roverType", this.roverType);
        if (this.roverFuelTank.getFluid() != null) {
            var1.func_74782_a("fuelTank", (NBTBase)this.roverFuelTank.writeToNBT(new NBTTagCompound()));
        }
        ItemStackHelper.func_191282_a((NBTTagCompound)var1, this.stacks);
    }

    public int func_70302_i_() {
        return this.roverType * 18;
    }

    public ItemStack func_70301_a(int var1) {
        return (ItemStack)this.stacks.get(var1);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemStack = ItemStackHelper.func_188382_a(this.stacks, (int)index, (int)count);
        if (!itemStack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.stacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.stacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return !this.field_70128_L && var1.func_70068_e((Entity)this) <= 64.0;
    }

    public void func_70296_d() {
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (this.field_70170_p.field_72995_K) {
            if (this.func_184188_bt() == null) {
                PlayerUtilties.sendMessage((EntityPlayer)player, (String)(GameSettings.func_74298_c((int)KeyHandlerClient.leftKey.func_151463_i()) + " / " + GameSettings.func_74298_c((int)KeyHandlerClient.rightKey.func_151463_i()) + "  - " + TranslateUtilities.translate((String)"gui.buggy.turn.name")));
                PlayerUtilties.sendMessage((EntityPlayer)player, (String)(GameSettings.func_74298_c((int)KeyHandlerClient.accelerateKey.func_151463_i()) + "       - " + TranslateUtilities.translate((String)"gui.buggy.accel.name")));
                PlayerUtilties.sendMessage((EntityPlayer)player, (String)(GameSettings.func_74298_c((int)KeyHandlerClient.decelerateKey.func_151463_i()) + "       - " + TranslateUtilities.translate((String)"gui.buggy.decel.name")));
                PlayerUtilties.sendMessage((EntityPlayer)player, (String)(GameSettings.func_74298_c((int)KeyHandlerClient.openFuelGui.func_151463_i()) + "       - " + TranslateUtilities.translate((String)"gui.buggy.inv.name")));
            }
            return true;
        }
        if (this.func_184188_bt().contains(player)) {
            this.func_184225_p((Entity)player);
            return true;
        }
        player.func_184220_m((Entity)this);
        return true;
    }

    public boolean pressKey(int key) {
        if (this.field_70170_p.field_72995_K && (key == 6 || key == 8 || key == 9)) {
            GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.S_CONTROL_ENTITY, GCCoreUtil.getDimensionID((World)this.field_70170_p), new Object[]{key}));
            return true;
        }
        switch (key) {
            case 0: {
                this.speed += (double)this.accel / 20.0;
                this.shouldClimb = true;
                return true;
            }
            case 1: {
                this.speed -= (double)this.accel / 20.0;
                this.shouldClimb = true;
                return true;
            }
            case 2: {
                this.field_70177_z -= 0.5f * this.turnFactor;
                this.wheelRotationZ = Math.max(-30.0f, Math.min(30.0f, this.wheelRotationZ + 0.5f));
                return true;
            }
            case 3: {
                this.field_70177_z += 0.5f * this.turnFactor;
                this.wheelRotationZ = Math.max(-30.0f, Math.min(30.0f, this.wheelRotationZ - 0.5f));
                return true;
            }
        }
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return false;
    }

    public int addFuel(FluidStack liquid, boolean doDrain) {
        if (this.landingPad != null) {
            return FluidUtil.fillWithGCFuel((FluidTank)this.roverFuelTank, (FluidStack)liquid, (boolean)doDrain);
        }
        return 0;
    }

    public FluidStack removeFuel(int amount) {
        return this.roverFuelTank.drain(amount, true);
    }

    public ICargoEntity.EnumCargoLoadingState addCargo(ItemStack stack, boolean doAdd) {
        ItemStack stackAt;
        if (this.roverType == 0) {
            return ICargoEntity.EnumCargoLoadingState.NOINVENTORY;
        }
        int count = 0;
        for (count = 0; count < this.stacks.size(); ++count) {
            stackAt = (ItemStack)this.stacks.get(count);
            if (stackAt == null || stackAt.func_77973_b() != stack.func_77973_b() || stackAt.func_77952_i() != stack.func_77952_i() || stackAt.func_190916_E() >= stackAt.func_77976_d()) continue;
            if (stackAt.func_190916_E() + stack.func_190916_E() <= stackAt.func_77976_d()) {
                if (doAdd) {
                    stackAt.func_190917_f(stack.func_190916_E());
                    this.func_70296_d();
                }
                return ICargoEntity.EnumCargoLoadingState.SUCCESS;
            }
            int origSize = stackAt.func_190916_E();
            int surplus = origSize + stack.func_190916_E() - stackAt.func_77976_d();
            if (doAdd) {
                stackAt.func_190920_e(stackAt.func_77976_d());
                this.func_70296_d();
            }
            stack.func_190920_e(surplus);
            if (this.addCargo(stack, doAdd) == ICargoEntity.EnumCargoLoadingState.SUCCESS) {
                return ICargoEntity.EnumCargoLoadingState.SUCCESS;
            }
            stackAt.func_190920_e(origSize);
            return ICargoEntity.EnumCargoLoadingState.FULL;
        }
        for (count = 0; count < this.stacks.size(); ++count) {
            stackAt = (ItemStack)this.stacks.get(count);
            if (stackAt != null) continue;
            if (doAdd) {
                this.stacks.set(count, (Object)stack);
                this.func_70296_d();
            }
            return ICargoEntity.EnumCargoLoadingState.SUCCESS;
        }
        return ICargoEntity.EnumCargoLoadingState.FULL;
    }

    public ICargoEntity.RemovalResult removeCargo(boolean doRemove) {
        for (int i = 0; i < this.stacks.size(); ++i) {
            ItemStack stackAt = this.func_70301_a(i);
            if (stackAt == null) continue;
            ItemStack resultStack = stackAt.func_77946_l();
            resultStack.func_190920_e(1);
            if (doRemove) {
                stackAt.func_190918_g(1);
                this.func_70296_d();
            }
            return new ICargoEntity.RemovalResult(ICargoEntity.EnumCargoLoadingState.SUCCESS, resultStack);
        }
        return new ICargoEntity.RemovalResult(ICargoEntity.EnumCargoLoadingState.EMPTY, ItemStack.field_190927_a);
    }

    public boolean func_145818_k_() {
        return true;
    }

    public UUID getOwnerUUID() {
        if (!this.func_184188_bt().isEmpty() && !(this.func_184188_bt().get(0) instanceof EntityPlayer)) {
            return null;
        }
        return !this.func_184188_bt().isEmpty() ? ((Entity)this.func_184188_bt().get(0)).getPersistentID() : null;
    }

    public void onPadDestroyed() {
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public float getMaxSpeed() {
        return this.maxSpeed;
    }

    public void setMaxSpeed(float maxSpeed) {
        this.maxSpeed = maxSpeed;
    }

    public float getAccel() {
        return this.accel;
    }

    public void setAccel(float accel) {
        this.accel = accel;
    }

    public abstract String getInventoryName();

    public abstract List<ItemStack> getItemsDropped();

    public abstract ItemStack getPickedResult(RayTraceResult var1);

    public abstract void setPad(IFuelDock var1);

    public abstract IFuelDock getLandingPad();

    public abstract boolean isDockValid(IFuelDock var1);
}

