/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets;

import com.mjr.extraplanets.Config;
import com.mjr.extraplanets.ExtraPlanetsDimensions;
import com.mjr.extraplanets.ExtraPlanets_SolarSystems;
import com.mjr.extraplanets.blocks.ExtraPlanets_Blocks;
import com.mjr.extraplanets.blocks.fluid.ExtraPlanets_Fluids;
import com.mjr.extraplanets.blocks.machines.ExtraPlanets_Machines;
import com.mjr.extraplanets.client.gui.GuiHandler;
import com.mjr.extraplanets.client.handlers.capabilities.CapabilityStatsClientHandler;
import com.mjr.extraplanets.compatibility.ExtremeReactorsCompatibility;
import com.mjr.extraplanets.compatibility.MCMultiPartCompatibility;
import com.mjr.extraplanets.compatibility.MachineMusePowersuitsCompatibility;
import com.mjr.extraplanets.compatibility.MorePlanetsCompatibility;
import com.mjr.extraplanets.entities.EntityFireBombPrimed;
import com.mjr.extraplanets.entities.EntityNuclearBombPrimed;
import com.mjr.extraplanets.entities.bosses.EntityEvolvedFireBatBoss;
import com.mjr.extraplanets.entities.bosses.EntityEvolvedGhastBoss;
import com.mjr.extraplanets.entities.bosses.EntityEvolvedGiantZombieBoss;
import com.mjr.extraplanets.entities.bosses.EntityEvolvedIceSlimeBoss;
import com.mjr.extraplanets.entities.bosses.EntityEvolvedMagmaCubeBoss;
import com.mjr.extraplanets.entities.bosses.EntityEvolvedSnowmanBoss;
import com.mjr.extraplanets.entities.bosses.EntityEvolvedSpacemanBoss;
import com.mjr.extraplanets.entities.bosses.defaultBosses.EntityCreeperBossEris;
import com.mjr.extraplanets.entities.bosses.defaultBosses.EntityCreeperBossJupiter;
import com.mjr.extraplanets.entities.bosses.defaultBosses.EntityCreeperBossMercury;
import com.mjr.extraplanets.entities.bosses.defaultBosses.EntityCreeperBossNeptune;
import com.mjr.extraplanets.entities.bosses.defaultBosses.EntityCreeperBossPluto;
import com.mjr.extraplanets.entities.bosses.defaultBosses.EntityCreeperBossSaturn;
import com.mjr.extraplanets.entities.bosses.defaultBosses.EntityCreeperBossUranus;
import com.mjr.extraplanets.entities.landers.EntityGeneralLander;
import com.mjr.extraplanets.entities.landers.EntityJupiterLander;
import com.mjr.extraplanets.entities.landers.EntityMercuryLander;
import com.mjr.extraplanets.entities.landers.EntityNeptuneLander;
import com.mjr.extraplanets.entities.landers.EntitySaturnLander;
import com.mjr.extraplanets.entities.landers.EntityUranusLander;
import com.mjr.extraplanets.entities.rockets.EntityElectricRocket;
import com.mjr.extraplanets.entities.rockets.EntityTier10Rocket;
import com.mjr.extraplanets.entities.rockets.EntityTier4Rocket;
import com.mjr.extraplanets.entities.rockets.EntityTier5Rocket;
import com.mjr.extraplanets.entities.rockets.EntityTier6Rocket;
import com.mjr.extraplanets.entities.rockets.EntityTier7Rocket;
import com.mjr.extraplanets.entities.rockets.EntityTier8Rocket;
import com.mjr.extraplanets.entities.rockets.EntityTier9Rocket;
import com.mjr.extraplanets.entities.vehicles.EntityMarsRover;
import com.mjr.extraplanets.entities.vehicles.EntityVenusRover;
import com.mjr.extraplanets.handlers.BoneMealHandler;
import com.mjr.extraplanets.handlers.MainHandlerServer;
import com.mjr.extraplanets.handlers.capabilities.CapabilityStatsHandler;
import com.mjr.extraplanets.items.ExtraPlanets_Items;
import com.mjr.extraplanets.items.armor.ExtraPlanets_Armor;
import com.mjr.extraplanets.items.armor.modules.ExtraPlanets_Modules;
import com.mjr.extraplanets.items.schematics.ItemSchematicMarsRover;
import com.mjr.extraplanets.items.schematics.ItemSchematicTier10ElectricRocket;
import com.mjr.extraplanets.items.schematics.ItemSchematicTier10Rocket;
import com.mjr.extraplanets.items.schematics.ItemSchematicTier4Rocket;
import com.mjr.extraplanets.items.schematics.ItemSchematicTier5Rocket;
import com.mjr.extraplanets.items.schematics.ItemSchematicTier6Rocket;
import com.mjr.extraplanets.items.schematics.ItemSchematicTier7Rocket;
import com.mjr.extraplanets.items.schematics.ItemSchematicTier8Rocket;
import com.mjr.extraplanets.items.schematics.ItemSchematicTier9Rocket;
import com.mjr.extraplanets.items.schematics.ItemSchematicVenusRover;
import com.mjr.extraplanets.items.tools.ExtraPlanets_Tools;
import com.mjr.extraplanets.moons.Callisto.event.CallistoEvents;
import com.mjr.extraplanets.moons.Deimos.event.DeimosEvents;
import com.mjr.extraplanets.moons.Europa.event.EuropaEvents;
import com.mjr.extraplanets.moons.ExtraPlanets_Moons;
import com.mjr.extraplanets.moons.Ganymede.event.GanymedeEvents;
import com.mjr.extraplanets.moons.Iapetus.event.IapetusEvents;
import com.mjr.extraplanets.moons.Io.event.IoEvents;
import com.mjr.extraplanets.moons.Oberon.event.OberonEvents;
import com.mjr.extraplanets.moons.Phobos.event.PhobosEvents;
import com.mjr.extraplanets.moons.Rhea.event.RheaEvents;
import com.mjr.extraplanets.moons.Titan.event.TitanEvents;
import com.mjr.extraplanets.moons.Titania.event.TitaniaEvents;
import com.mjr.extraplanets.moons.Triton.event.TritonEvents;
import com.mjr.extraplanets.network.ExtraPlanetsChannelHandler;
import com.mjr.extraplanets.planets.Ceres.event.CeresEvents;
import com.mjr.extraplanets.planets.Ceres.spacestation.WorldProviderCeresOrbit;
import com.mjr.extraplanets.planets.Eris.event.ErisEvents;
import com.mjr.extraplanets.planets.Eris.spacestation.WorldProviderErisOrbit;
import com.mjr.extraplanets.planets.ExtraPlanets_Planets;
import com.mjr.extraplanets.planets.ExtraPlanets_SpaceStations;
import com.mjr.extraplanets.planets.Jupiter.event.JupiterEvents;
import com.mjr.extraplanets.planets.Jupiter.spacestation.WorldProviderJupiterOrbit;
import com.mjr.extraplanets.planets.Kepler22b.event.Kepler22bEvents;
import com.mjr.extraplanets.planets.Kepler22b.spacestation.WorldProviderKepler22bOrbit;
import com.mjr.extraplanets.planets.KuiperBelt.KuiperBeltEvents;
import com.mjr.extraplanets.planets.Mercury.event.MercuryEvents;
import com.mjr.extraplanets.planets.Mercury.spacestation.WorldProviderMercuryOrbit;
import com.mjr.extraplanets.planets.Neptune.event.NeptuneEvents;
import com.mjr.extraplanets.planets.Neptune.spacestation.WorldProviderNeptuneOrbit;
import com.mjr.extraplanets.planets.Pluto.event.PlutoEvents;
import com.mjr.extraplanets.planets.Pluto.spacestation.WorldProviderPlutoOrbit;
import com.mjr.extraplanets.planets.Saturn.event.SaturnEvents;
import com.mjr.extraplanets.planets.Saturn.spacestation.WorldProviderSaturnOrbit;
import com.mjr.extraplanets.planets.Uranus.event.UranusEvents;
import com.mjr.extraplanets.planets.Uranus.spacestation.WorldProviderUranusOrbit;
import com.mjr.extraplanets.planets.mars.spacestation.WorldProviderMarsOrbit;
import com.mjr.extraplanets.planets.venus.spacestation.WorldProviderVenusOrbit;
import com.mjr.extraplanets.proxy.CommonProxy;
import com.mjr.extraplanets.recipes.ExtraPlanets_RecipeGeneration;
import com.mjr.extraplanets.recipes.ExtraPlanets_Recipes;
import com.mjr.extraplanets.recipes.MarsRoverRecipes;
import com.mjr.extraplanets.recipes.Tier10ElectricRocketRecipes;
import com.mjr.extraplanets.recipes.Tier10RocketRecipes;
import com.mjr.extraplanets.recipes.Tier4RocketRecipes;
import com.mjr.extraplanets.recipes.Tier5RocketRecipes;
import com.mjr.extraplanets.recipes.Tier6RocketRecipes;
import com.mjr.extraplanets.recipes.Tier7RocketRecipes;
import com.mjr.extraplanets.recipes.Tier8RocketRecipes;
import com.mjr.extraplanets.recipes.Tier9RocketRecipes;
import com.mjr.extraplanets.recipes.VenusRoverRecipes;
import com.mjr.extraplanets.schematicPages.SchematicMarsRover;
import com.mjr.extraplanets.schematicPages.SchematicTier10ElectricRocket;
import com.mjr.extraplanets.schematicPages.SchematicTier10Rocket;
import com.mjr.extraplanets.schematicPages.SchematicTier4Rocket;
import com.mjr.extraplanets.schematicPages.SchematicTier5Rocket;
import com.mjr.extraplanets.schematicPages.SchematicTier6Rocket;
import com.mjr.extraplanets.schematicPages.SchematicTier7Rocket;
import com.mjr.extraplanets.schematicPages.SchematicTier8Rocket;
import com.mjr.extraplanets.schematicPages.SchematicTier9Rocket;
import com.mjr.extraplanets.schematicPages.SchematicVenusRover;
import com.mjr.mjrlegendslib.util.MessageUtilities;
import com.mjr.mjrlegendslib.util.NetworkUtilities;
import com.mjr.mjrlegendslib.util.RegisterUtilities;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.recipe.ISchematicPage;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.tile.TileEntityDeconstructor;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.AsteroidsModule;
import micdoodle8.mods.galacticraft.planets.mars.MarsModule;
import micdoodle8.mods.galacticraft.planets.venus.VenusModule;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DimensionType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.core.util.Loader;

@Mod(modid="extraplanets", name="ExtraPlanets", version="1.12.2-0.6.2", dependencies="required-after:forge@[14.23.1.2555,);required-after:mjrlegendslib@[1.12.2-1.1.9,); required-after:galacticraftcore@[4.0.2.237,); required-after:galacticraftplanets@[4.0.2.237,); after:crafttweaker@[3.0.25.,); before:planetprogression@[1.12.2-0.3.8,]; after:powersuits;", guiFactory="com.mjr.extraplanets.client.gui.screen.ConfigGuiFactory", certificateFingerprint="b02331787272ec3515ebe63ecdeea0d746653468", acceptedMinecraftVersions="[1.12.2]")
public class ExtraPlanets {
    @SidedProxy(clientSide="com.mjr.extraplanets.proxy.ClientProxy", serverSide="com.mjr.extraplanets.proxy.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="extraplanets")
    public static ExtraPlanets instance;
    public static ExtraPlanetsChannelHandler packetPipeline;
    public static boolean generateRecipes;
    public static List<Item> itemList;
    public static List<Block> blocksList;
    public static CreativeTabs BlocksTab;
    public static CreativeTabs ItemsTab;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Config.load();
        RegisterUtilities.registerEventHandler((Object)new MainHandlerServer());
        if (Config.MERCURY) {
            RegisterUtilities.registerEventHandler((Object)new MercuryEvents());
        }
        if (Config.CERES) {
            RegisterUtilities.registerEventHandler((Object)new CeresEvents());
        }
        if (Config.JUPITER) {
            RegisterUtilities.registerEventHandler((Object)new JupiterEvents());
        }
        if (Config.SATURN) {
            RegisterUtilities.registerEventHandler((Object)new SaturnEvents());
        }
        if (Config.URANUS) {
            RegisterUtilities.registerEventHandler((Object)new UranusEvents());
        }
        if (Config.NEPTUNE) {
            RegisterUtilities.registerEventHandler((Object)new NeptuneEvents());
        }
        if (Config.PLUTO) {
            RegisterUtilities.registerEventHandler((Object)new PlutoEvents());
        }
        if (Config.ERIS) {
            RegisterUtilities.registerEventHandler((Object)new ErisEvents());
        }
        if (Config.KEPLER22B && Config.KEPLER_SOLAR_SYSTEMS) {
            RegisterUtilities.registerEventHandler((Object)new Kepler22bEvents());
        }
        if (Config.CALLISTO) {
            RegisterUtilities.registerEventHandler((Object)new CallistoEvents());
        }
        if (Config.DEIMOS) {
            RegisterUtilities.registerEventHandler((Object)new DeimosEvents());
        }
        if (Config.EUROPA) {
            RegisterUtilities.registerEventHandler((Object)new EuropaEvents());
        }
        if (Config.GANYMEDE) {
            RegisterUtilities.registerEventHandler((Object)new GanymedeEvents());
        }
        if (Config.IO) {
            RegisterUtilities.registerEventHandler((Object)new IoEvents());
        }
        if (Config.PHOBOS) {
            RegisterUtilities.registerEventHandler((Object)new PhobosEvents());
        }
        if (Config.TRITON) {
            RegisterUtilities.registerEventHandler((Object)new TritonEvents());
        }
        if (Config.RHEA) {
            RegisterUtilities.registerEventHandler((Object)new RheaEvents());
        }
        if (Config.TITAN) {
            RegisterUtilities.registerEventHandler((Object)new TitanEvents());
        }
        if (Config.OBERON) {
            RegisterUtilities.registerEventHandler((Object)new OberonEvents());
        }
        if (Config.IAPETUS) {
            RegisterUtilities.registerEventHandler((Object)new IapetusEvents());
        }
        if (Config.TITANIA) {
            RegisterUtilities.registerEventHandler((Object)new TitaniaEvents());
        }
        if (Config.KUIPER_BELT) {
            RegisterUtilities.registerEventHandler((Object)new KuiperBeltEvents());
        }
        ExtraPlanets_Blocks.init();
        ExtraPlanets_Machines.init();
        ExtraPlanets_Fluids.init();
        ExtraPlanets_Tools.init();
        ExtraPlanets_Armor.init();
        ExtraPlanets_Items.init();
        ExtraPlanets_SolarSystems.init();
        ExtraPlanets_Planets.init();
        ExtraPlanets_Moons.init();
        ExtraPlanets_SpaceStations.init();
        if (Loader.isClassAvailable((String)"net.machinemuse.numina.module.IPowerModule") && Loader.isClassAvailable((String)"net.machinemuse.powersuits.common.ModuleManager")) {
            MachineMusePowersuitsCompatibility.init();
        }
        RegisterUtilities.registerEventHandler((Object)new RegistrationHandler());
        RegisterUtilities.registerEventHandler((Object)new BoneMealHandler());
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.registerFluidSubmergedTextures();
        this.registerNonMobEntities();
        this.registerCreatures();
        packetPipeline = ExtraPlanetsChannelHandler.init();
        ExtraPlanets_Recipes.initOther();
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ExtraPlanets_Modules.init();
        CapabilityStatsHandler.register();
        CapabilityStatsClientHandler.register();
        this.registerSchematicsRecipes();
        this.registerSchematicsItems();
        this.addDungeonLoot();
        NetworkUtilities.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        if (Config.GC_DECONSTRUCTOR_SUPPORT) {
            this.RegisterDeconstructorCompatibility();
        }
        if (Config.EXTREME_REACTORS_SUPPORT) {
            ExtremeReactorsCompatibility.init();
        }
        if (Config.MC_MULITPART_SUPPORT) {
            MCMultiPartCompatibility.init();
        }
        if (generateRecipes) {
            ExtraPlanets_RecipeGeneration.generate();
            ExtraPlanets_RecipeGeneration.generateConstants();
        }
        if (Config.GC_PRESSURE || Config.GC_RADIATION) {
            MarsModule.planetMars.addChecklistKeys(new String[]{"space_suit"});
            GalacticraftCore.moonMoon.addChecklistKeys(new String[]{"space_suit"});
            VenusModule.planetVenus.addChecklistKeys(new String[]{"space_suit"});
            AsteroidsModule.planetAsteroids.addChecklistKeys(new String[]{"space_suit"});
        }
        ExtraPlanetsDimensions.CERES = WorldUtil.getDimensionTypeById((int)Config.CERES_ID);
        ExtraPlanetsDimensions.ERIS = WorldUtil.getDimensionTypeById((int)Config.ERIS_ID);
        ExtraPlanetsDimensions.JUPITER = WorldUtil.getDimensionTypeById((int)Config.JUPITER_ID);
        ExtraPlanetsDimensions.MERCURY = WorldUtil.getDimensionTypeById((int)Config.MERCURY_ID);
        ExtraPlanetsDimensions.NEPTUNE = WorldUtil.getDimensionTypeById((int)Config.NEPTUNE_ID);
        ExtraPlanetsDimensions.PLUTO = WorldUtil.getDimensionTypeById((int)Config.PLUTO_ID);
        ExtraPlanetsDimensions.SATURN = WorldUtil.getDimensionTypeById((int)Config.SATURN_ID);
        ExtraPlanetsDimensions.URANUS = WorldUtil.getDimensionTypeById((int)Config.URANUS_ID);
        ExtraPlanetsDimensions.KEPLER22B = WorldUtil.getDimensionTypeById((int)Config.KEPLER22B_ID);
        ExtraPlanetsDimensions.CALLISTO = WorldUtil.getDimensionTypeById((int)Config.CALLISTO_ID);
        ExtraPlanetsDimensions.DEIMOS = WorldUtil.getDimensionTypeById((int)Config.DEIMOS_ID);
        ExtraPlanetsDimensions.EUROPA = WorldUtil.getDimensionTypeById((int)Config.EUROPA_ID);
        ExtraPlanetsDimensions.GANYMEDE = WorldUtil.getDimensionTypeById((int)Config.GANYMEDE_ID);
        ExtraPlanetsDimensions.IAPETUS = WorldUtil.getDimensionTypeById((int)Config.IAPETUS_ID);
        ExtraPlanetsDimensions.IO = WorldUtil.getDimensionTypeById((int)Config.IO_ID);
        ExtraPlanetsDimensions.OBERON = WorldUtil.getDimensionTypeById((int)Config.OBERON_ID);
        ExtraPlanetsDimensions.PHOBOS = WorldUtil.getDimensionTypeById((int)Config.PHOBOS_ID);
        ExtraPlanetsDimensions.RHEA = WorldUtil.getDimensionTypeById((int)Config.RHEA_ID);
        ExtraPlanetsDimensions.TITAN = WorldUtil.getDimensionTypeById((int)Config.TITAN_ID);
        ExtraPlanetsDimensions.TITANIA = WorldUtil.getDimensionTypeById((int)Config.TITANIA_ID);
        ExtraPlanetsDimensions.TRITION = WorldUtil.getDimensionTypeById((int)Config.TRITON_ID);
        ExtraPlanetsDimensions.CERES_ORBIT = DimensionType.register((String)"Ceres Space Station", (String)"_ceres_orbit", (int)Config.CERES_SPACE_STATION_ID, WorldProviderCeresOrbit.class, (boolean)false);
        ExtraPlanetsDimensions.ERIS_ORBIT = DimensionType.register((String)"Eris Space Station", (String)"_eris_orbit", (int)Config.ERIS_SPACE_STATION_ID, WorldProviderErisOrbit.class, (boolean)false);
        ExtraPlanetsDimensions.JUPITER_ORBIT = DimensionType.register((String)"Jupiter Space Station", (String)"_jupiter_orbit", (int)Config.JUPITER_SPACE_STATION_ID, WorldProviderJupiterOrbit.class, (boolean)false);
        ExtraPlanetsDimensions.MERCURY_ORBIT = DimensionType.register((String)"Mercury Space Station", (String)"_mercury_orbit", (int)Config.MERCURY_SPACE_STATION_ID, WorldProviderMercuryOrbit.class, (boolean)false);
        ExtraPlanetsDimensions.NEPTUNE_ORBIT = DimensionType.register((String)"Neptune Space Station", (String)"_neptune_orbit", (int)Config.NEPTUNE_SPACE_STATION_ID, WorldProviderNeptuneOrbit.class, (boolean)false);
        ExtraPlanetsDimensions.PLUTO_ORBIT = DimensionType.register((String)"Pluto Space Station", (String)"_pluto_orbit", (int)Config.PLUTO_SPACE_STATION_ID, WorldProviderPlutoOrbit.class, (boolean)false);
        ExtraPlanetsDimensions.SATURN_ORBIT = DimensionType.register((String)"Saturn Space Station", (String)"_saturn_orbit", (int)Config.SATURN_SPACE_STATION_ID, WorldProviderSaturnOrbit.class, (boolean)false);
        ExtraPlanetsDimensions.URANUS_ORBIT = DimensionType.register((String)"Uranus Space Station", (String)"_uranus_orbit", (int)Config.URANUS_SPACE_STATION_ID, WorldProviderUranusOrbit.class, (boolean)false);
        ExtraPlanetsDimensions.KEPLER22B_ORBIT = DimensionType.register((String)"Kepler22b Space Station", (String)"orbit", (int)Config.KEPLER22B_SPACE_STATION_ID, WorldProviderKepler22bOrbit.class, (boolean)false);
        ExtraPlanetsDimensions.MARS_ORBIT = DimensionType.register((String)"Mars Space Station", (String)"_mars_orbit", (int)Config.MARS_SPACE_STATION_ID, WorldProviderMarsOrbit.class, (boolean)false);
        ExtraPlanetsDimensions.VENUS_ORBIT = DimensionType.register((String)"Venus Space Station", (String)"_venus_orbit", (int)Config.VENUS_SPACE_STATION_ID, WorldProviderVenusOrbit.class, (boolean)false);
        ExtraPlanetsDimensions.CERES_ORBIT_KEEPLOADED = DimensionType.register((String)"Ceres Space Station", (String)"_ceres_orbit", (int)Config.CERES_SPACE_STATION_STATIC_ID, WorldProviderCeresOrbit.class, (boolean)true);
        ExtraPlanetsDimensions.ERIS_ORBIT_KEEPLOADED = DimensionType.register((String)"Eris Space Station", (String)"_eris_orbit", (int)Config.ERIS_SPACE_STATION_STATIC_ID, WorldProviderErisOrbit.class, (boolean)true);
        ExtraPlanetsDimensions.JUPITER_ORBIT_KEEPLOADED = DimensionType.register((String)"Jupiter Space Station", (String)"_jupiter_orbit", (int)Config.JUPITER_SPACE_STATION_STATIC_ID, WorldProviderJupiterOrbit.class, (boolean)true);
        ExtraPlanetsDimensions.MERCURY_ORBIT_KEEPLOADED = DimensionType.register((String)"Mercury Space Station", (String)"_mercury_orbit", (int)Config.MERCURY_SPACE_STATION_STATIC_ID, WorldProviderMercuryOrbit.class, (boolean)true);
        ExtraPlanetsDimensions.NEPTUNE_ORBIT_KEEPLOADED = DimensionType.register((String)"Neptune Space Station", (String)"_neptune_orbit", (int)Config.NEPTUNE_SPACE_STATION_STATIC_ID, WorldProviderNeptuneOrbit.class, (boolean)true);
        ExtraPlanetsDimensions.PLUTO_ORBIT_KEEPLOADED = DimensionType.register((String)"Pluto Space Station", (String)"_pluto_orbit", (int)Config.PLUTO_SPACE_STATION_STATIC_ID, WorldProviderPlutoOrbit.class, (boolean)true);
        ExtraPlanetsDimensions.SATURN_ORBIT_KEEPLOADED = DimensionType.register((String)"Saturn Space Station", (String)"_saturn_orbit", (int)Config.SATURN_SPACE_STATION_STATIC_ID, WorldProviderSaturnOrbit.class, (boolean)true);
        ExtraPlanetsDimensions.URANUS_ORBIT_KEEPLOADED = DimensionType.register((String)"Uranus Space Station", (String)"_uranus_orbit", (int)Config.URANUS_SPACE_STATION_STATIC_ID, WorldProviderUranusOrbit.class, (boolean)true);
        ExtraPlanetsDimensions.KEPLER22B_ORBIT_KEEPLOADED = DimensionType.register((String)"Kepler22b Space Station", (String)"orbit", (int)Config.KEPLER22B_SPACE_STATION_STATIC_ID, WorldProviderKepler22bOrbit.class, (boolean)true);
        ExtraPlanetsDimensions.MARS_ORBIT_KEEPLOADED = DimensionType.register((String)"Mars Space Station", (String)"_mars_orbit", (int)Config.MARS_SPACE_STATION_STATIC_ID, WorldProviderMarsOrbit.class, (boolean)true);
        ExtraPlanetsDimensions.VENUS_ORBIT_KEEPLOADED = DimensionType.register((String)"Venus Space Station", (String)"_venus_orbit", (int)Config.VENUS_SPACE_STATION_STATIC_ID, WorldProviderVenusOrbit.class, (boolean)true);
        proxy.postInit(event);
    }

    private void registerFluidSubmergedTextures() {
        GalacticraftCore.proxy.registerFluidTexture(ExtraPlanets_Fluids.CLEAN_WATER_FLUID, new ResourceLocation("extraplanets", "textures/misc/under_clean_water.png"));
        GalacticraftCore.proxy.registerFluidTexture(ExtraPlanets_Fluids.FROZEN_WATER_FLUID, new ResourceLocation("extraplanets", "textures/misc/under_frozen_water.png"));
        GalacticraftCore.proxy.registerFluidTexture(ExtraPlanets_Fluids.GLOWSTONE_FLUID, new ResourceLocation("extraplanets", "textures/misc/under_glowstone.png"));
        GalacticraftCore.proxy.registerFluidTexture(ExtraPlanets_Fluids.INFECTED_WATER_FLUID, new ResourceLocation("extraplanets", "textures/misc/under_infected_water.png"));
        GalacticraftCore.proxy.registerFluidTexture(ExtraPlanets_Fluids.LIQUID_CARAMEL_FLUID, new ResourceLocation("extraplanets", "textures/misc/under_liquid_caramel.png"));
        GalacticraftCore.proxy.registerFluidTexture(ExtraPlanets_Fluids.LIQUID_CHOCOLATE_FLUID, new ResourceLocation("extraplanets", "textures/misc/under_liquid_chocolate.png"));
        GalacticraftCore.proxy.registerFluidTexture(ExtraPlanets_Fluids.LIQUID_HYDROCARBON_FLUID, new ResourceLocation("extraplanets", "textures/misc/under_liquid_hydrocarbon.png"));
        GalacticraftCore.proxy.registerFluidTexture(ExtraPlanets_Fluids.MAGMA_FLUID, new ResourceLocation("extraplanets", "textures/misc/under_magma.png"));
        GalacticraftCore.proxy.registerFluidTexture(ExtraPlanets_Fluids.METHANE_FLUID, new ResourceLocation("extraplanets", "textures/misc/under_methane.png"));
        GalacticraftCore.proxy.registerFluidTexture(ExtraPlanets_Fluids.NITROGEN_FLUID, new ResourceLocation("extraplanets", "textures/misc/under_nitrogen.png"));
        GalacticraftCore.proxy.registerFluidTexture(ExtraPlanets_Fluids.NITROGEN_ICE_FLUID, new ResourceLocation("extraplanets", "textures/misc/under_nitrogen_ice.png"));
        GalacticraftCore.proxy.registerFluidTexture(ExtraPlanets_Fluids.RADIO_ACTIVE_WATER_FLUID, new ResourceLocation("extraplanets", "textures/misc/under_radio_active_water.png"));
        GalacticraftCore.proxy.registerFluidTexture(ExtraPlanets_Fluids.SALT_FLUID, new ResourceLocation("extraplanets", "textures/misc/under_salt.png"));
    }

    private void registerNonMobEntities() {
        if (Config.CERES && Config.NUCLEAR_BOMB) {
            RegisterUtilities.registerNonMobEntity((String)"extraplanets", (Object)instance, EntityNuclearBombPrimed.class, (String)"extraplanets.NuclearBombPrimed", (int)150, (int)1, (boolean)true);
        }
        if (Config.SATURN && Config.FIRE_BOMB) {
            RegisterUtilities.registerNonMobEntity((String)"extraplanets", (Object)instance, EntityFireBombPrimed.class, (String)"extraplanets.FireBombPrimed", (int)150, (int)1, (boolean)true);
        }
        if (Config.MERCURY) {
            RegisterUtilities.registerNonMobEntity((String)"extraplanets", (Object)instance, EntityTier4Rocket.class, (String)"extraplanets.EntityTier4Rocket", (int)150, (int)1, (boolean)false);
            RegisterUtilities.registerNonMobEntity((String)"extraplanets", (Object)instance, EntityMercuryLander.class, (String)"extraplanets.EntityMercuryLander", (int)150, (int)5, (boolean)false);
        }
        if (Config.JUPITER) {
            RegisterUtilities.registerNonMobEntity((String)"extraplanets", (Object)instance, EntityTier5Rocket.class, (String)"extraplanets.EntityTier5Rocket", (int)150, (int)1, (boolean)false);
            RegisterUtilities.registerNonMobEntity((String)"extraplanets", (Object)instance, EntityJupiterLander.class, (String)"extraplanets.EntityJupiterLander", (int)150, (int)5, (boolean)false);
        }
        if (Config.SATURN) {
            RegisterUtilities.registerNonMobEntity((String)"extraplanets", (Object)instance, EntityTier6Rocket.class, (String)"extraplanets.EntityTier6Rocket", (int)150, (int)1, (boolean)false);
            RegisterUtilities.registerNonMobEntity((String)"extraplanets", (Object)instance, EntitySaturnLander.class, (String)"extraplanets.EntitSaturnLander", (int)150, (int)5, (boolean)false);
        }
        if (Config.URANUS) {
            RegisterUtilities.registerNonMobEntity((String)"extraplanets", (Object)instance, EntityTier7Rocket.class, (String)"extraplanets.EntityTier7Rocket", (int)150, (int)1, (boolean)false);
            RegisterUtilities.registerNonMobEntity((String)"extraplanets", (Object)instance, EntityUranusLander.class, (String)"extraplanets.EntityUranusLander", (int)150, (int)5, (boolean)false);
        }
        if (Config.NEPTUNE) {
            RegisterUtilities.registerNonMobEntity((String)"extraplanets", (Object)instance, EntityTier8Rocket.class, (String)"extraplanets.EntityTier8Rocket", (int)150, (int)1, (boolean)false);
            RegisterUtilities.registerNonMobEntity((String)"extraplanets", (Object)instance, EntityNeptuneLander.class, (String)"extraplanets.EntityNeptuneLander", (int)150, (int)5, (boolean)false);
        }
        if (Config.PLUTO) {
            RegisterUtilities.registerNonMobEntity((String)"extraplanets", (Object)instance, EntityTier9Rocket.class, (String)"extraplanets.EntityTier9Rocket", (int)150, (int)1, (boolean)false);
        }
        if (Config.ERIS) {
            RegisterUtilities.registerNonMobEntity((String)"extraplanets", (Object)instance, EntityTier10Rocket.class, (String)"extraplanets.EntityTier10Rocket", (int)150, (int)1, (boolean)false);
        }
        if (Config.ERIS && Config.KEPLER22B && Config.ELECTRIC_ROCKET) {
            RegisterUtilities.registerNonMobEntity((String)"extraplanets", (Object)instance, EntityElectricRocket.class, (String)"extraplanets.EntityTier10ElectricRocket", (int)150, (int)1, (boolean)false);
        }
        if (Config.MARS_ROVER) {
            RegisterUtilities.registerNonMobEntity((String)"extraplanets", (Object)instance, EntityMarsRover.class, (String)"extraplanets.EntityMarsRover", (int)150, (int)1, (boolean)false);
        }
        if (Config.VENUS_ROVER) {
            RegisterUtilities.registerNonMobEntity((String)"extraplanets", (Object)instance, EntityVenusRover.class, (String)"extraplanets.EntityVenusRover", (int)150, (int)1, (boolean)false);
        }
        RegisterUtilities.registerNonMobEntity((String)"extraplanets", (Object)instance, EntityGeneralLander.class, (String)"EntityGeneralLander", (int)150, (int)5, (boolean)false);
    }

    private void registerCreatures() {
        if (Config.MERCURY) {
            if (Config.USE_DEFAULT_BOSSES) {
                RegisterUtilities.registerMobEntity((String)"extraplanets", (Object)instance, EntityCreeperBossMercury.class, (String)"extraplanets.CreeperBossMercury", (int)894731, (int)0);
            } else {
                RegisterUtilities.registerMobEntity((String)"extraplanets", (Object)instance, EntityEvolvedMagmaCubeBoss.class, (String)"extraplanets.EvolvedMagmaCubeBoss", (int)0x340000, (int)0xFCFC00);
            }
        }
        if (Config.JUPITER) {
            if (Config.USE_DEFAULT_BOSSES) {
                RegisterUtilities.registerMobEntity((String)"extraplanets", (Object)instance, EntityCreeperBossJupiter.class, (String)"extraplanets.CreeperBossJupiter", (int)894731, (int)0);
            } else {
                RegisterUtilities.registerMobEntity((String)"extraplanets", (Object)instance, EntityEvolvedFireBatBoss.class, (String)"extraplanets.EvolvedFireBatBoss", (int)16167425, (int)0);
            }
        }
        if (Config.SATURN) {
            if (Config.USE_DEFAULT_BOSSES) {
                RegisterUtilities.registerMobEntity((String)"extraplanets", (Object)instance, EntityCreeperBossSaturn.class, (String)"extraplanets.CreeperBossSaturn", (int)894731, (int)0);
            } else {
                RegisterUtilities.registerMobEntity((String)"extraplanets", (Object)instance, EntityEvolvedGhastBoss.class, (String)"extraplanets.EvolvedGhastBoss", (int)894731, (int)0);
            }
        }
        if (Config.URANUS) {
            if (Config.USE_DEFAULT_BOSSES) {
                RegisterUtilities.registerMobEntity((String)"extraplanets", (Object)instance, EntityCreeperBossUranus.class, (String)"extraplanets.CreeperBossUranus", (int)894731, (int)0);
            } else {
                RegisterUtilities.registerMobEntity((String)"extraplanets", (Object)instance, EntityEvolvedIceSlimeBoss.class, (String)"extraplanets.EvolvedIceSlimeBoss", (int)0xF9F9F9, (int)44975);
            }
        }
        if (Config.NEPTUNE) {
            if (Config.USE_DEFAULT_BOSSES) {
                RegisterUtilities.registerMobEntity((String)"extraplanets", (Object)instance, EntityCreeperBossNeptune.class, (String)"extraplanets.CreeperBossNeptune", (int)894731, (int)0);
            } else {
                RegisterUtilities.registerMobEntity((String)"extraplanets", (Object)instance, EntityEvolvedSnowmanBoss.class, (String)"extraplanets.EvolvedSnowmanBoss", (int)894731, (int)0);
            }
        }
        if (Config.PLUTO) {
            if (Config.USE_DEFAULT_BOSSES) {
                RegisterUtilities.registerMobEntity((String)"extraplanets", (Object)instance, EntityCreeperBossPluto.class, (String)"extraplanets.CreeperBossPluto", (int)894731, (int)0);
            } else {
                RegisterUtilities.registerMobEntity((String)"extraplanets", (Object)instance, EntityEvolvedSpacemanBoss.class, (String)"extraplanets.EvolvedSpaceManBoss", (int)894731, (int)0);
            }
        }
        if (Config.ERIS) {
            if (Config.USE_DEFAULT_BOSSES) {
                RegisterUtilities.registerMobEntity((String)"extraplanets", (Object)instance, EntityCreeperBossEris.class, (String)"extraplanets.CreeperBossEris", (int)894731, (int)0);
            } else {
                RegisterUtilities.registerMobEntity((String)"extraplanets", (Object)instance, EntityEvolvedGiantZombieBoss.class, (String)"extraplanets.EvolvedGiantZombieBoss", (int)894731, (int)0);
            }
        }
    }

    private void registerSchematicsRecipes() {
        if (Config.MERCURY) {
            SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicTier4Rocket());
        }
        if (Config.JUPITER) {
            SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicTier5Rocket());
        }
        if (Config.SATURN) {
            SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicTier6Rocket());
        }
        if (Config.URANUS) {
            SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicTier7Rocket());
        }
        if (Config.NEPTUNE) {
            SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicTier8Rocket());
        }
        if (Config.PLUTO) {
            SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicTier9Rocket());
        }
        if (Config.ERIS) {
            SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicTier10Rocket());
        }
        if (Config.ERIS && Config.KEPLER22B && Config.ELECTRIC_ROCKET) {
            SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicTier10ElectricRocket());
        }
        if (Config.MARS_ROVER) {
            SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicMarsRover());
        }
        if (Config.VENUS_ROVER) {
            SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicVenusRover());
        }
    }

    private void registerSchematicsItems() {
        ItemSchematicTier4Rocket.registerSchematicItems();
        ItemSchematicTier5Rocket.registerSchematicItems();
        ItemSchematicTier6Rocket.registerSchematicItems();
        ItemSchematicTier7Rocket.registerSchematicItems();
        ItemSchematicTier8Rocket.registerSchematicItems();
        ItemSchematicTier9Rocket.registerSchematicItems();
        ItemSchematicTier10Rocket.registerSchematicItems();
        ItemSchematicTier10ElectricRocket.registerSchematicItems();
        ItemSchematicVenusRover.registerSchematicItems();
        ItemSchematicMarsRover.registerSchematicItems();
    }

    private void addDungeonLoot() {
        if (Config.MERCURY) {
            if (Config.MORE_PLANETS_COMPATIBILITY) {
                GalacticraftRegistry.addDungeonLoot((int)11, (ItemStack)new ItemStack(ExtraPlanets_Items.TIER_4_SCHEMATIC, 1, 0));
                GalacticraftRegistry.addDungeonLoot((int)11, (ItemStack)new ItemStack(ExtraPlanets_Items.GEIGER_COUNTER, 1, 0));
            } else {
                GalacticraftRegistry.addDungeonLoot((int)4, (ItemStack)new ItemStack(ExtraPlanets_Items.TIER_4_SCHEMATIC, 1, 0));
                GalacticraftRegistry.addDungeonLoot((int)4, (ItemStack)new ItemStack(ExtraPlanets_Items.GEIGER_COUNTER, 1, 0));
            }
        }
        if (Config.JUPITER) {
            if (Config.MORE_PLANETS_COMPATIBILITY) {
                GalacticraftRegistry.addDungeonLoot((int)4, (ItemStack)new ItemStack(ExtraPlanets_Items.TIER_5_SCHEMATIC, 1, 0));
            } else {
                GalacticraftRegistry.addDungeonLoot((int)5, (ItemStack)new ItemStack(ExtraPlanets_Items.TIER_5_SCHEMATIC, 1, 0));
            }
        }
        if (Config.SATURN) {
            if (Config.MORE_PLANETS_COMPATIBILITY) {
                GalacticraftRegistry.addDungeonLoot((int)5, (ItemStack)new ItemStack(ExtraPlanets_Items.TIER_6_SCHEMATIC, 1, 0));
            } else {
                GalacticraftRegistry.addDungeonLoot((int)6, (ItemStack)new ItemStack(ExtraPlanets_Items.TIER_6_SCHEMATIC, 1, 0));
            }
        }
        if (Config.URANUS) {
            GalacticraftRegistry.addDungeonLoot((int)7, (ItemStack)new ItemStack(ExtraPlanets_Items.TIER_7_SCHEMATIC, 1, 0));
        }
        if (Config.NEPTUNE) {
            GalacticraftRegistry.addDungeonLoot((int)8, (ItemStack)new ItemStack(ExtraPlanets_Items.TIER_8_SCHEMATIC, 1, 0));
        }
        if (Config.PLUTO) {
            GalacticraftRegistry.addDungeonLoot((int)9, (ItemStack)new ItemStack(ExtraPlanets_Items.TIER_9_SCHEMATIC, 1, 0));
        }
        if (Config.ERIS) {
            GalacticraftRegistry.addDungeonLoot((int)10, (ItemStack)new ItemStack(ExtraPlanets_Items.TIER_10_SCHEMATIC, 1, 0));
        }
        if (Config.ERIS && Config.KEPLER22B && Config.ELECTRIC_ROCKET) {
            GalacticraftRegistry.addDungeonLoot((int)10, (ItemStack)new ItemStack(ExtraPlanets_Items.TIER_10_ELECTRIC_ROCKET_SCHEMATIC, 1, 0));
        }
        if (Config.MARS_ROVER) {
            GalacticraftRegistry.addDungeonLoot((int)2, (ItemStack)new ItemStack(ExtraPlanets_Items.MARS_ROVER_SCHEMATIC, 1, 0));
        }
        if (Config.VENUS_ROVER) {
            GalacticraftRegistry.addDungeonLoot((int)3, (ItemStack)new ItemStack(ExtraPlanets_Items.VENUS_ROVER_SCHEMATIC, 1, 0));
        }
    }

    private void RegisterDeconstructorCompatibility() {
        TileEntityDeconstructor.knownRecipes.addAll(Tier4RocketRecipes.getTier4RocketRecipes());
        TileEntityDeconstructor.knownRecipes.addAll(Tier5RocketRecipes.getTier5RocketRecipes());
        TileEntityDeconstructor.knownRecipes.addAll(Tier6RocketRecipes.getTier6RocketRecipes());
        TileEntityDeconstructor.knownRecipes.addAll(Tier7RocketRecipes.getTier7RocketRecipes());
        TileEntityDeconstructor.knownRecipes.addAll(Tier8RocketRecipes.getTier8RocketRecipes());
        TileEntityDeconstructor.knownRecipes.addAll(Tier9RocketRecipes.getTier9RocketRecipes());
        TileEntityDeconstructor.knownRecipes.addAll(Tier10RocketRecipes.getTier10RocketRecipes());
        TileEntityDeconstructor.knownRecipes.addAll(Tier10ElectricRocketRecipes.getTier10ElectricRocketRecipes());
        TileEntityDeconstructor.knownRecipes.addAll(MarsRoverRecipes.getMarsRoverRecipes());
        TileEntityDeconstructor.knownRecipes.addAll(VenusRoverRecipes.getVenusRoverRecipes());
        TileEntityDeconstructor.addSalvage((ItemStack)new ItemStack(ExtraPlanets_Items.TIER_4_ITEMS, 1, 3));
        TileEntityDeconstructor.addSalvage((ItemStack)new ItemStack(ExtraPlanets_Items.TIER_4_ITEMS, 1, 4));
        TileEntityDeconstructor.addSalvage((ItemStack)new ItemStack(ExtraPlanets_Items.TIER_5_ITEMS, 1, 3));
        TileEntityDeconstructor.addSalvage((ItemStack)new ItemStack(ExtraPlanets_Items.TIER_5_ITEMS, 1, 4));
        TileEntityDeconstructor.addSalvage((ItemStack)new ItemStack(ExtraPlanets_Items.TIER_5_ITEMS, 1, 6));
        TileEntityDeconstructor.addSalvage((ItemStack)new ItemStack(ExtraPlanets_Items.TIER_6_ITEMS, 1, 3));
        TileEntityDeconstructor.addSalvage((ItemStack)new ItemStack(ExtraPlanets_Items.TIER_6_ITEMS, 1, 4));
        TileEntityDeconstructor.addSalvage((ItemStack)new ItemStack(ExtraPlanets_Items.TIER_7_ITEMS, 1, 3));
        TileEntityDeconstructor.addSalvage((ItemStack)new ItemStack(ExtraPlanets_Items.TIER_7_ITEMS, 1, 4));
        TileEntityDeconstructor.addSalvage((ItemStack)new ItemStack(ExtraPlanets_Items.TIER_7_ITEMS, 1, 6));
        TileEntityDeconstructor.addSalvage((ItemStack)new ItemStack(ExtraPlanets_Items.TIER_8_ITEMS, 1, 3));
        TileEntityDeconstructor.addSalvage((ItemStack)new ItemStack(ExtraPlanets_Items.TIER_8_ITEMS, 1, 4));
        TileEntityDeconstructor.addSalvage((ItemStack)new ItemStack(ExtraPlanets_Items.TIER_9_ITEMS, 1, 3));
        TileEntityDeconstructor.addSalvage((ItemStack)new ItemStack(ExtraPlanets_Items.TIER_9_ITEMS, 1, 4));
        TileEntityDeconstructor.addSalvage((ItemStack)new ItemStack(ExtraPlanets_Items.TIER_10_ITEMS, 1, 3));
        TileEntityDeconstructor.addSalvage((ItemStack)new ItemStack(ExtraPlanets_Items.TIER_10_ITEMS, 1, 4));
        TileEntityDeconstructor.addSalvage((ItemStack)new ItemStack(ExtraPlanets_Items.TIER_11_ITEMS, 1, 6));
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        MessageUtilities.fatalErrorMessageToLog((String)"extraplanets", (String)("Invalid fingerprint detected! The file " + event.getSource().getName() + " may have been tampered with. This version will NOT be supported!"));
    }

    @Mod.EventHandler
    public void onStartAboutToStartEvent(FMLServerAboutToStartEvent event) {
        File folder = new File(FMLCommonHandler.instance().getSavesDirectory() + "/" + event.getServer().func_71270_I());
        String[] idsOld = new String[]{"" + Config.IO_ID_LEGACY, "" + Config.EUROPA_ID_LEGACY, "" + Config.PHOBOS_ID_LEGACY, "" + Config.DEIMOS_ID_LEGACY, "" + Config.TRITON_ID_LEGACY, "" + Config.CALLISTO_ID_LEGACY, "" + Config.GANYMEDE_ID_LEGACY, "" + Config.RHEA_ID_LEGACY, "" + Config.TITAN_ID_LEGACY, "" + Config.OBERON_ID_LEGACY, "" + Config.TITANIA_ID_LEGACY, "" + Config.IAPETUS_ID_LEGACY};
        String[] idsNew = new String[12];
        idsNew[0] = "" + Config.IO_ID;
        idsNew[1] = "" + Config.EUROPA_ID;
        idsNew[2] = "" + Config.PHOBOS_ID;
        idsNew[3] = "" + Config.DEIMOS_ID;
        idsNew[4] = "" + Config.TRITON_ID;
        idsNew[5] = "" + Config.CALLISTO_ID;
        idsNew[6] = "" + Config.GANYMEDE_ID;
        idsNew[7] = "" + Config.RHEA_ID;
        idsOld[8] = "" + Config.TITAN_ID;
        idsOld[9] = "" + Config.OBERON_ID;
        idsOld[10] = "" + Config.TITANIA;
        idsOld[11] = "" + Config.IAPETUS;
        if (folder.exists()) {
            for (int i = 0; i < idsOld.length; ++i) {
                File tempFolder = new File(folder.getPath() + "/DIM" + idsOld[i]);
                File newFolder = new File(folder.getPath() + "/DIM" + idsNew[i]);
                if (!tempFolder.exists()) continue;
                if (!newFolder.exists()) {
                    MessageUtilities.infoMessageToLog((String)"extraplanets", (String)("Mirgrated Dimension Folder " + idsOld[i] + " to new name of " + idsNew[i]));
                    tempFolder.renameTo(newFolder);
                    continue;
                }
                MessageUtilities.infoMessageToLog((String)"extraplanets", (String)("Unable to Mrigrate Folder " + idsOld[i] + " to new name of " + idsNew[i] + " Due to this folder already exists"));
            }
        }
    }

    static {
        generateRecipes = false;
        itemList = new ArrayList<Item>();
        blocksList = new ArrayList<Block>();
        BlocksTab = new CreativeTabs("SpaceBlocksTab"){

            public ItemStack func_78016_d() {
                if (Config.REFINERY_ADVANCED) {
                    return new ItemStack(ExtraPlanets_Machines.REFINERY_ADVANCED);
                }
                return new ItemStack(ExtraPlanets_Blocks.DENSE_ICE);
            }
        };
        ItemsTab = new CreativeTabs("SpaceItemsTab"){

            public ItemStack func_78016_d() {
                if (Config.MERCURY) {
                    return new ItemStack(ExtraPlanets_Items.TIER_4_ROCKET);
                }
                if (Config.JUPITER) {
                    return new ItemStack(ExtraPlanets_Items.TIER_5_ROCKET);
                }
                if (Config.SATURN) {
                    return new ItemStack(ExtraPlanets_Items.TIER_6_ROCKET);
                }
                if (Config.URANUS) {
                    return new ItemStack(ExtraPlanets_Items.TIER_7_ROCKET);
                }
                if (Config.NEPTUNE) {
                    return new ItemStack(ExtraPlanets_Items.TIER_8_ROCKET);
                }
                if (Config.PLUTO) {
                    return new ItemStack(ExtraPlanets_Items.TIER_9_ROCKET);
                }
                if (Config.ERIS) {
                    return new ItemStack(ExtraPlanets_Items.TIER_10_ROCKET);
                }
                return new ItemStack(GCItems.rocketTier1);
            }
        };
        ExtraPlanets_Fluids.initFluid();
    }

    @Mod.EventBusSubscriber(modid="extraplanets")
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void registerBlocksEvent(RegistryEvent.Register<Block> event) {
            for (Block block : blocksList) {
                event.getRegistry().register((IForgeRegistryEntry)block);
            }
        }

        @SubscribeEvent
        public static void registerItemsEvent(RegistryEvent.Register<Item> event) {
            for (Item item : itemList) {
                event.getRegistry().register((IForgeRegistryEntry)item);
            }
            if (Config.ORE_DICTIONARY_INGOTS) {
                ExtraPlanets_Items.OreDictionaryIngotsRegister();
            }
            if (Config.ORE_DICTIONARY_OTHER) {
                ExtraPlanets_Items.OreDictionaryItemsRegister();
            }
            if (Config.ORE_DICTIONARY) {
                ExtraPlanets_Blocks.OreDictionaryRegister();
            }
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void registerRecipesEvent(RegistryEvent.Register<IRecipe> event) {
            ExtraPlanets_Recipes.init();
            if (Config.MORE_PLANETS_ROCKET_CRUSHER_SUPPORT) {
                MorePlanetsCompatibility.init();
            }
        }
    }
}

