/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.blocks.planetAndMoonBlocks.Kepler22b;

import com.mjr.extraplanets.ExtraPlanets;
import com.mjr.extraplanets.blocks.ExtraPlanets_Blocks;
import com.mjr.extraplanets.planets.Kepler22b.worldgen.features.WorldGenKepler22bTree;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockKepler22bMapleTreeSapling
extends BlockBush
implements IGrowable,
IPlantable {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    public static final PropertyInteger STAGE = PropertyInteger.func_177719_a((String)"stage", (int)0, (int)1);
    protected static final AxisAlignedBB SAPLING_AABB = new AxisAlignedBB(0.09999999403953552, 0.0, 0.09999999403953552, (double)0.9f, (double)0.8f, (double)0.9f);

    public BlockKepler22bMapleTreeSapling() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)EnumType.MAPLE_BLUE)).func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)));
        this.func_149647_a(ExtraPlanets.BlocksTab);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SAPLING_AABB;
    }

    public String func_149732_F() {
        return I18n.func_74838_a((String)(this.func_149739_a() + "." + this.func_149739_a() + ".name"));
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            super.func_180650_b(world, pos, state, rand);
            if (world.func_175671_l(pos.func_177984_a()) >= 9 && rand.nextInt(7) == 0) {
                this.grow(world, pos, state, rand);
            }
        }
    }

    public void grow(World world, BlockPos pos, IBlockState state, Random rand) {
        if ((Integer)state.func_177229_b((IProperty)STAGE) == 0) {
            world.func_180501_a(pos, state.func_177231_a((IProperty)STAGE), 4);
        } else {
            this.generateTree(world, pos, state, rand);
        }
    }

    public void generateTree(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!TerrainGen.saplingGrowTree((World)world, (Random)rand, (BlockPos)pos)) {
            return;
        }
        Object worldgenerator = rand.nextInt(10) == 0 ? new WorldGenBigTree(true) : new WorldGenTrees(true);
        switch ((EnumType)((Object)state.func_177229_b(VARIANT))) {
            case MAPLE_BLUE: {
                worldgenerator = new WorldGenKepler22bTree(true, 8, ExtraPlanets_Blocks.KEPLER22B_MAPLE_LOG.func_176203_a(0), ExtraPlanets_Blocks.KEPLER22B_MAPLE_LEAF.func_176203_a(0), false);
                break;
            }
            case MAPLE_RED: {
                worldgenerator = new WorldGenKepler22bTree(true, 8, ExtraPlanets_Blocks.KEPLER22B_MAPLE_LOG.func_176203_a(1), ExtraPlanets_Blocks.KEPLER22B_MAPLE_LEAF.func_176203_a(1), false);
                break;
            }
            case MAPLE_PURPLE: {
                worldgenerator = new WorldGenKepler22bTree(true, 8, ExtraPlanets_Blocks.KEPLER22B_MAPLE_LOG.func_176203_a(2), ExtraPlanets_Blocks.KEPLER22B_MAPLE_LEAF.func_176203_a(2), false);
                break;
            }
            case MAPLE_YELLOW: {
                worldgenerator = new WorldGenKepler22bTree(true, 8, ExtraPlanets_Blocks.KEPLER22B_MAPLE_LOG.func_176203_a(3), ExtraPlanets_Blocks.KEPLER22B_MAPLE_LEAF.func_176203_a(3), false);
                break;
            }
            case MAPLE_GREEN: {
                worldgenerator = new WorldGenKepler22bTree(true, 8, ExtraPlanets_Blocks.KEPLER22B_MAPLE_LOG_2.func_176203_a(0), ExtraPlanets_Blocks.KEPLER22B_MAPLE_LEAF2.func_176203_a(1), false);
                break;
            }
            case MAPLE_BROWN: {
                worldgenerator = new WorldGenKepler22bTree(true, 8, ExtraPlanets_Blocks.KEPLER22B_MAPLE_LOG_2.func_176203_a(1), ExtraPlanets_Blocks.KEPLER22B_MAPLE_LEAF2.func_176203_a(0), false);
            }
        }
        world.func_175698_g(pos);
        if (!worldgenerator.func_180709_b(world, rand, pos)) {
            world.func_180501_a(pos, state, 2);
        }
    }

    public boolean isTypeAt(World world, BlockPos pos, EnumType type) {
        IBlockState iblockstate = world.func_180495_p(pos);
        return iblockstate.func_177230_c() == this && iblockstate.func_177229_b(VARIANT) == type;
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumType blockplanks$enumtype : EnumType.values()) {
            list.add((Object)new ItemStack((Block)this, 1, blockplanks$enumtype.getMetadata()));
        }
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return (double)world.field_73012_v.nextFloat() < 0.45;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        this.grow(world, pos, state, rand);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byMetadata(meta & 7))).func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf((meta & 8) >> 3));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
        return i |= (Integer)state.func_177229_b((IProperty)STAGE) << 3;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, STAGE});
    }

    public static enum EnumType implements IStringSerializable
    {
        MAPLE_BLUE(0, "maple_blue_sapling", MapColor.field_151649_A),
        MAPLE_RED(1, "maple_red_sapling", MapColor.field_151645_D),
        MAPLE_PURPLE(2, "maple_purple_sapling", MapColor.field_151678_z),
        MAPLE_YELLOW(3, "maple_yellow_sapling", MapColor.field_151673_t),
        MAPLE_GREEN(4, "maple_green_sapling", MapColor.field_151651_C),
        MAPLE_BROWN(5, "maple_brown_sapling", MapColor.field_151650_B);

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final MapColor map_color;

        private EnumType(int meta, String name, MapColor map_color) {
            this.meta = meta;
            this.name = name;
            this.map_color = map_color;
        }

        public int getMetadata() {
            return this.meta;
        }

        public MapColor func_181070_c() {
            return this.map_color;
        }

        public String toString() {
            return this.name;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType blockleafs$enumtype;
                EnumType.META_LOOKUP[blockleafs$enumtype.getMetadata()] = blockleafs$enumtype = enumTypeArray[i];
            }
        }
    }
}

