/*
 * Decompiled with CFR 0.152.
 */
package extracells.part.fluid;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.events.MENetworkStorageEvent;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.parts.PartItemStack;
import appeng.api.storage.ICellContainer;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.util.AECableType;
import extracells.container.IUpgradeable;
import extracells.container.fluid.ContainerBusFluidStorage;
import extracells.gui.fluid.GuiBusFluidStorage;
import extracells.gui.widget.fluid.IFluidSlotListener;
import extracells.inventory.IInventoryListener;
import extracells.inventory.InventoryPlain;
import extracells.inventory.cell.HandlerPartStorageFluid;
import extracells.inventory.cell.IHandlerPartBase;
import extracells.models.PartModels;
import extracells.network.packet.other.PacketFluidSlotUpdate;
import extracells.network.packet.part.PacketPartConfig;
import extracells.part.PartECBase;
import extracells.util.NetworkUtil;
import extracells.util.PermissionUtil;
import extracells.util.StorageChannels;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class PartFluidStorage
extends PartECBase
implements ICellContainer,
IInventoryListener,
IFluidSlotListener,
IUpgradeable {
    private final HashMap<FluidStack, Integer> fluidList = new HashMap();
    private final Fluid[] filterFluids = new Fluid[54];
    private final InventoryPlain upgradeInventory = new InventoryPlain("", 1, 1, this){

        @Override
        public boolean func_94041_b(int i, ItemStack itemStack) {
            return itemStack != null && AEApi.instance().definitions().materials().cardInverter().isSameAs(itemStack);
        }

        @Override
        protected void onContentsChanged() {
            PartFluidStorage.this.saveData();
        }
    };
    private int priority = 0;
    protected IHandlerPartBase handler = new HandlerPartStorageFluid(this);
    protected AccessRestriction access = AccessRestriction.READ_WRITE;
    protected IStorageChannel channel = StorageChannels.FLUID();

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        for (ItemStack stack : this.upgradeInventory.slots) {
            if (stack == null) continue;
            drops.add(stack);
        }
    }

    @Override
    public ItemStack getItemStack(PartItemStack type) {
        ItemStack stack = super.getItemStack(type);
        if (type.equals((Object)PartItemStack.WRENCH)) {
            stack.func_77978_p().func_82580_o("upgradeInventory");
        }
        return stack;
    }

    public void blinkCell(int slot) {
    }

    public float getCableConnectionLength(AECableType aeCableType) {
        return 3.0f;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 15.0, 14.0, 14.0, 16.0);
        bch.addBox(4.0, 4.0, 14.0, 12.0, 12.0, 15.0);
        bch.addBox(5.0, 5.0, 13.0, 11.0, 11.0, 14.0);
    }

    public List<IMEInventoryHandler> getCellArray(IStorageChannel channel) {
        ArrayList<IMEInventoryHandler> list = new ArrayList<IMEInventoryHandler>();
        if (channel == this.channel) {
            list.add(this.handler);
        }
        this.updateNeighbor();
        return list;
    }

    @Override
    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiBusFluidStorage(this, player);
    }

    @Override
    public int getLightLevel() {
        return 0;
    }

    @Override
    public double getPowerUsage() {
        return 1.0;
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public Object getServerGuiElement(EntityPlayer player) {
        return new ContainerBusFluidStorage(this, player);
    }

    @Override
    public InventoryPlain getUpgradeInventory() {
        return this.upgradeInventory;
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        return PermissionUtil.hasPermission(player, SecurityPermissions.BUILD, this) && super.onActivate(player, hand, pos);
    }

    @Override
    public void onInventoryChanged() {
        this.handler.setInverted(AEApi.instance().definitions().materials().cardInverter().isSameAs(this.upgradeInventory.func_70301_a(0)));
        this.saveData();
    }

    @Override
    public void onNeighborChanged(IBlockAccess var1, BlockPos var2, BlockPos var3) {
        this.handler.onNeighborChange();
        IGridNode node = this.getGridNode();
        if (node != null) {
            IGrid grid = node.getGrid();
            if (grid != null && this.wasChanged()) {
                grid.postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
                grid.postEvent((MENetworkEvent)new MENetworkStorageEvent(this.getGridBlock().getFluidMonitor(), (IStorageChannel)StorageChannels.FLUID()));
                grid.postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
            }
            this.getHost().markForUpdate();
        }
        super.onNeighborChanged(null, null, null);
    }

    @MENetworkEventSubscribe
    public void powerChange(MENetworkPowerStatusChange event) {
        IGridNode node = this.getGridNode();
        if (node != null) {
            boolean isNowActive = node.isActive();
            if (isNowActive != this.isActive()) {
                this.setActive(isNowActive);
                this.onNeighborChanged();
                this.getHost().markForUpdate();
            }
            node.getGrid().postEvent((MENetworkEvent)new MENetworkStorageEvent(this.getGridBlock().getFluidMonitor(), (IStorageChannel)StorageChannels.FLUID()));
            node.getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.priority = data.func_74762_e("priority");
        for (int i = 0; i < 9; ++i) {
            this.filterFluids[i] = FluidRegistry.getFluid((String)data.func_74779_i("FilterFluid#" + i));
        }
        if (data.func_74764_b("access")) {
            try {
                this.access = AccessRestriction.valueOf((String)data.func_74779_i("access"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.upgradeInventory.readFromNBT(data.func_150295_c("upgradeInventory", 10));
        this.onInventoryChanged();
        this.onNeighborChanged();
        this.handler.setPrioritizedFluids(this.filterFluids);
        this.handler.setAccessRestriction(this.access);
    }

    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return PartModels.STORAGE_BUS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return PartModels.STORAGE_BUS_ON;
        }
        return PartModels.STORAGE_BUS_OFF;
    }

    public void saveChanges(ICellInventory<?> cellInventory) {
        this.saveData();
    }

    public void sendInformation(EntityPlayer player) {
        NetworkUtil.sendToPlayer(new PacketFluidSlotUpdate(Arrays.asList(this.filterFluids)), player);
        NetworkUtil.sendToPlayer(new PacketPartConfig(this, "FluidStorage.Access", this.access.toString()), player);
    }

    @Override
    public void setFluid(int index, Fluid fluid, EntityPlayer player) {
        this.filterFluids[index] = fluid;
        this.handler.setPrioritizedFluids(this.filterFluids);
        this.sendInformation(player);
        this.saveData();
    }

    public void updateAccess(AccessRestriction access) {
        this.access = access;
        this.handler.setAccessRestriction(access);
        this.onNeighborChanged();
    }

    @MENetworkEventSubscribe
    public void updateChannels(MENetworkChannelsChanged channel) {
        boolean isNowActive;
        IGridNode node = this.getGridNode();
        if (node != null && (isNowActive = node.isActive()) != this.isActive()) {
            this.setActive(isNowActive);
            this.onNeighborChanged();
            this.getHost().markForUpdate();
        }
        node.getGrid().postEvent((MENetworkEvent)new MENetworkStorageEvent(this.getGridBlock().getFluidMonitor(), (IStorageChannel)StorageChannels.FLUID()));
        node.getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74768_a("priority", this.priority);
        for (int i = 0; i < this.filterFluids.length; ++i) {
            Fluid fluid = this.filterFluids[i];
            if (fluid != null) {
                data.func_74778_a("FilterFluid#" + i, fluid.getName());
                continue;
            }
            data.func_74778_a("FilterFluid#" + i, "");
        }
        data.func_74782_a("upgradeInventory", (NBTBase)this.upgradeInventory.writeToNBT());
        data.func_74778_a("access", this.access.name());
    }

    protected void updateNeighbor() {
        this.updateNeighborFluids();
    }

    private void updateNeighborFluids() {
        this.fluidList.clear();
        if (this.access == AccessRestriction.READ || this.access == AccessRestriction.READ_WRITE) {
            for (IAEFluidStack stack : this.handler.getAvailableItems(StorageChannels.FLUID().createList())) {
                FluidStack s = stack.getFluidStack().copy();
                this.fluidList.put(s, s.amount);
            }
        }
    }

    protected boolean wasChanged() {
        HashMap<FluidStack, Integer> fluids = new HashMap<FluidStack, Integer>();
        for (IAEFluidStack stack : this.handler.getAvailableItems(StorageChannels.FLUID().createList())) {
            FluidStack s = stack.getFluidStack();
            fluids.put(s, s.amount);
        }
        return !fluids.equals(this.fluidList);
    }
}

