/*
 * Decompiled with CFR 0.152.
 */
package extracells;

import appeng.api.AEApi;
import appeng.api.features.IRegistryContainer;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.recipes.ISubItemResolver;
import appeng.api.storage.ICellHandler;
import com.google.common.base.Preconditions;
import extracells.integration.Integration;
import extracells.integration.mekanism.gas.GasCellHandler;
import extracells.item.storage.CellDefinition;
import extracells.network.GuiHandler$;
import extracells.network.PacketHandler;
import extracells.proxy.CommonProxy;
import extracells.util.ECConfigHandler;
import extracells.util.ExtraCellsEventHandler;
import extracells.util.FluidCellHandler;
import extracells.util.NameHandler;
import extracells.wireless.AEWirelessTermHandler;
import java.io.File;
import javax.annotation.Nullable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;

@Mod(modid="extracells", version="2.6.2", name="Extra Cells", dependencies="after:waila;required-after:appliedenergistics2", acceptedMinecraftVersions="[1.12.2]")
public class ExtraCells {
    @SidedProxy(clientSide="extracells.proxy.ClientProxy", serverSide="extracells.proxy.CommonProxy")
    public static CommonProxy proxy = null;
    @Mod.Instance(value="extracells")
    public static ExtraCells instance;
    public static final Integration integration;
    public static int bcBurnTimeMultiplicator;
    private File configFolder;
    @Nullable
    private static PacketHandler packetHandler;

    public ExtraCells() {
        FluidRegistry.enableUniversalBucket();
    }

    public static PacketHandler getPacketHandler() {
        Preconditions.checkState((packetHandler != null ? 1 : 0) != 0);
        return packetHandler;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        packetHandler = new PacketHandler();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)GuiHandler$.MODULE$);
        this.configFolder = event.getModConfigurationDirectory();
        Configuration config = new Configuration(new File(this.configFolder, "AppliedEnergistics2" + File.separator + "extracells.cfg"));
        ECConfigHandler configHandler = new ECConfigHandler(config);
        configHandler.reload();
        MinecraftForge.EVENT_BUS.register((Object)configHandler);
        integration.preInit();
        proxy.registerItems();
        proxy.registerBlocks();
        CellDefinition.create();
        proxy.registerModels();
        IRegistryContainer registries = AEApi.instance().registries();
        registries.recipes().addNewSubItemResolver((ISubItemResolver)new NameHandler());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        IRegistryContainer registries = AEApi.instance().registries();
        registries.wireless().registerWirelessHandler((IWirelessTermHandler)new AEWirelessTermHandler());
        registries.cell().addCellHandler((ICellHandler)new FluidCellHandler());
        registries.cell().addCellHandler((ICellHandler)new GasCellHandler());
        ExtraCellsEventHandler handler = new ExtraCellsEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)handler);
        proxy.registerMovables();
        proxy.registerRenderers();
        proxy.registerTileEntities();
        proxy.registerFluidBurnTimes();
        proxy.addRecipes(this.configFolder);
        proxy.registerPackets();
        integration.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        integration.postInit();
    }

    static {
        integration = new Integration();
        bcBurnTimeMultiplicator = 4;
    }
}

