#version 400 compatibility



/*






!! DO NOT REMOVE !! !! DO NOT REMOVE !!

This code is from Chocapic13' shaders
Read the terms of modification and sharing before changing something below please !
!! DO NOT REMOVE !! !! DO NOT REMOVE !!


Sharing and modification rules

Sharing a modified version of my shaders:
-You are not allowed to claim any of the code included in "Chocapic13' shaders" as your own
-You can share a modified version of my shaders if you respect the following title scheme : " -Name of the shaderpack- (Chocapic13' Shaders edit) "
-You cannot use any monetizing links
-The rules of modification and sharing have to be same as the one here (copy paste all these rules in your post), you cannot make your own rules
-I have to be clearly credited
-You cannot use any version older than "Chocapic13' Shaders V4" as a base, however you can modify older versions for personal use
-Common sense : if you want a feature from another shaderpack or want to use a piece of code found on the web, make sure the code is open source. In doubt ask the creator.
-Common sense #2 : share your modification only if you think it adds something really useful to the shaderpack(not only 2-3 constants changed)


Special level of permission; with written permission from Chocapic13, if you think your shaderpack is an huge modification from the original (code wise, the look/performance is not taken in account):
-Allows to use monetizing links
-Allows to create your own sharing rules
-Shaderpack name can be chosen
-Listed on Chocapic13' shaders official thread
-Chocapic13 still have to be clearly credited


Using this shaderpack in a video or a picture:
-You are allowed to use this shaderpack for screenshots and videos if you give the shaderpack name in the description/message
-You are allowed to use this shaderpack in monetized videos if you respect the rule above.


Minecraft website:
-The download link must redirect to the link given in the shaderpack's official thread
-You are not allowed to add any monetizing link to the shaderpack download

If you are not sure about what you are allowed to do or not, PM Chocapic13 on http://www.minecraftforum.net/
Not respecting these rules can and will result in a request of thread/download shutdown to the host/administrator, with or without warning. Intellectual property stealing is punished by law.











*/
//#define DISABLE_SSAO_DEPTH_FILTER //Keep it disabled unless you are using POM!
#define UNDERWATERFIX //fixes shadows and other stuff underwater

/*--------------------------------*/
in vec2 texcoord;
in vec3 lightColor;
in vec3 avgAmbient;
in vec3 lightVector;
in vec3 sunVec;
in vec3 moonVec;
in vec3 upVec;
in vec3 avgAmbient2;
in vec3 sky1;
in vec3 sky2;
in vec3 cloudColor;
in vec3 cloudColor2;
in float tr;

in vec4 lightS;
in vec2 lightPos;

in vec3 sunlight;
in vec3 ambient_color;
in vec3 nsunlight;

in float handItemLight;
in float eyeAdapt;
in vec3 rawAvg;

in float SdotU;
in float MdotU;
in float sunVisibility;
in float moonVisibility;

uniform sampler2D composite;
uniform sampler2D depthtex1;
uniform sampler2D gdepth;
uniform sampler2D gcolor;

const int 		noiseTextureResolution  = 1024;
uniform vec3 cameraPosition;
uniform float potato;
uniform vec3 previousCameraPosition;
uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferPreviousProjection;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
uniform mat4 shadowModelView;
uniform mat4 shadowProjection;
uniform mat4 gbufferPreviousModelView;
uniform ivec2 eyeBrightnessSmooth;
uniform ivec2 eyeBrightness;
uniform int isEyeInWater;
uniform int worldTime;
uniform float aspectRatio;
uniform float near;
uniform float far;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float frameTimeCounter;
uniform int fogMode;
uniform int heldBlockLightValue;
const vec3 moonlight = vec3(0.5, 0.9, 1.4) * 0.016;
const vec3 moonlightS = vec3(0.5, 0.9, 1.4) * 0.001;
float comp = 1.0-near/far/far;			//distance above that are considered as sky
float invRain06 = 1.0-rainStrength*0.6;


const vec2 check_offsets[25] = vec2[25](vec2(-0.4894566f,-0.3586783f),
									vec2(-0.1717194f,0.6272162f),
									vec2(-0.4709477f,-0.01774091f),
									vec2(-0.9910634f,0.03831699f),
									vec2(-0.2101292f,0.2034733f),
									vec2(-0.7889516f,-0.5671548f),
									vec2(-0.1037751f,-0.1583221f),
									vec2(-0.5728408f,0.3416965f),
									vec2(-0.1863332f,0.5697952f),
									vec2(0.3561834f,0.007138769f),
									vec2(0.2868255f,-0.5463203f),
									vec2(-0.4640967f,-0.8804076f),
									vec2(0.1969438f,0.6236954f),
									vec2(0.6999109f,0.6357007f),
									vec2(-0.3462536f,0.8966291f),
									vec2(0.172607f,0.2832828f),
									vec2(0.4149241f,0.8816f),
									vec2(0.136898f,-0.9716249f),
									vec2(-0.6272043f,0.6721309f),
									vec2(-0.8974028f,0.4271871f),
									vec2(0.5551881f,0.324069f),
									vec2(0.9487136f,0.2605085f),
									vec2(0.7140148f,-0.312601f),
									vec2(0.0440252f,0.9363738f),
									vec2(0.620311f,-0.6673451f)
									);
/*
vec3 calcFog(vec3 fposition, vec3 color, vec3 fogclr) {
	float density = 1.0/mix(600.0,120,rainStrength);

	float d = length(fposition);


	float fog =  pow(1.0-exp(-d*density),2.2-rainStrength*1.2);

return color*(1.0-fog*(vec3(1.0,0.3,0.1)+rainStrength*vec3(0.0,0.7,0.9))) + fog*length(avgAmbient)*normalize(fogclr)*(1.0-rainStrength*0.85);
}
*/


vec3 nvec3(vec4 pos) {
    return pos.xyz/pos.w;
}


vec3 decode (vec2 enc)
{
    vec2 fenc = enc*4-2;
    float f = dot(fenc,fenc);
    float g = sqrt(1-f/4.0);
    vec3 n;
    n.xy = fenc*g;
    n.z = 1-f/2;
    return n;
}

float ssao_blur(vec2 tex, vec2 dir,float z,float discard_threshold)
{
	float weights[9] =
	float[9](
		0.013519569015984728,
		0.047662179108871855,
		0.11723004402070096,
		0.20116755999375591,
		0.240841295721373,
		0.20116755999375591,
		0.11723004402070096,
		0.047662179108871855,
		0.013519569015984728
	);

	float indices[9] = float[9](-4.0, -3.0, -2.0, -1.0, 0.0, 1.0, 2.0, 3.0, 4.0);

	vec2 step = dir/vec2(viewWidth,viewHeight).xy;

	vec3 pos = nvec3(gbufferProjectionInverse*(vec4(tex,z,1.0)*2.0-1.0));	
	vec3 norm = decode(texture2D(gdepth, tex).xy);
	vec3 normal[9];

	normal[0] = normalize(pos-nvec3(gbufferProjectionInverse*(vec4(tex + indices[0]*step,texture2D(depthtex1, tex + indices[0]*step).x,1.0)*2.0-1.0)));
	normal[1] = normalize(pos-nvec3(gbufferProjectionInverse*(vec4(tex + indices[1]*step,texture2D(depthtex1, tex + indices[1]*step).x,1.0)*2.0-1.0)));
	normal[2] = normalize(pos-nvec3(gbufferProjectionInverse*(vec4(tex + indices[2]*step,texture2D(depthtex1, tex + indices[2]*step).x,1.0)*2.0-1.0)));
	normal[3] = normalize(pos-nvec3(gbufferProjectionInverse*(vec4(tex + indices[3]*step,texture2D(depthtex1, tex + indices[3]*step).x,1.0)*2.0-1.0)));
	normal[4] = vec3(0.);
	normal[5] = normalize(pos-nvec3(gbufferProjectionInverse*(vec4(tex + indices[5]*step,texture2D(depthtex1, tex + indices[5]*step).x,1.0)*2.0-1.0)));
	normal[6] = normalize(pos-nvec3(gbufferProjectionInverse*(vec4(tex + indices[6]*step,texture2D(depthtex1, tex + indices[6]*step).x,1.0)*2.0-1.0)));
	normal[7] = normalize(pos-nvec3(gbufferProjectionInverse*(vec4(tex + indices[7]*step,texture2D(depthtex1, tex + indices[7]*step).x,1.0)*2.0-1.0)));
	normal[8] = normalize(pos-nvec3(gbufferProjectionInverse*(vec4(tex + indices[8]*step,texture2D(depthtex1, tex + indices[8]*step).x,1.0)*2.0-1.0)));
	

	
	float total_weight = 1.0;

	int i;

	for( i=0; i<9; ++i )
	{
		if( abs(dot(norm, normal[i])) > discard_threshold )
		{
			total_weight -= weights[i];
			weights[i] = 0;
		}
	}

	//

	float res = 0.0;

	for( i=0; i<9; ++i )
	{
		res += texture2D(composite, tex + indices[i]*step).x * weights[i];
	}

	res /= total_weight;

	return res;
}
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
void main() {
//sample half-resolution buffer with correct texture coordinates
//vec4 hr = pow(texture2D(composite,(floor(gl_FragCoord.xy/2.)*2+1.0)/vec2(viewWidth,viewHeight)/2.0),vec4(2.2,2.2,2.2,1.0))*vec4(257.,257,257,1.0);



float depth = texture2D(depthtex1, texcoord).x;

vec4 albedo = texture2D(gcolor,texcoord);
bool land = !(dot(albedo.rgb,vec3(1.0))<0.00000000001 || (depth > comp));
if (!land) discard; //don't blur on sky

bool translucent = albedo.b > 0.69 && albedo.b < 0.71;
float thresh = translucent? 0.2 : 0.05;
#ifdef DISABLE_SSAO_DEPTH_FILTER 
thresh = 1.0;
#endif
float blur = ssao_blur(texcoord,vec2(1.0,0.0),depth,thresh);
/* DRAWBUFFERS:3 */
	gl_FragData[0] = vec4(vec3(blur),1.0);
}
