#version 120

/*
                            _____ _____ ___________ 
                           /  ___|_   _|  _  | ___ \
                           \ `--.  | | | | | | |_/ /
                            `--. \ | | | | | |  __/ 
                           /\__/ / | | \ \_/ / |    
                           \____/  \_/  \___/\_|    

						Before editing anything here make sure you've 
						read The agreement, which you accepted by downloading
						my shaderpack. The agreement can be found here:
			http://www.minecraftforum.net/topic/1953873-164-172-sildurs-shaders-pcmacintel/
						   
				This code is from Chocapic13' shaders adapted, modified and tweaked by Sildur 
		http://www.minecraftforum.net/forums/mapping-and-modding/minecraft-mods/1293898-chocapic13s-shaders			
*/

varying vec4 color;
varying vec2 texcoord;

varying vec4 ambientColor;
varying vec2 lmcoord;

uniform vec3 sunPosition;
uniform vec3 upPosition;
uniform int worldTime;
uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;

/* If you reached this line, then you're probably about to break the agreement which you accepted by downloading Sildur's shaders!
So stop your doing and ask Sildur before copying anything which would break the agreement, unless you're Chocapic then go ahead ;)
--------------------------------------------------------------------------------------------------------------------------------*/ 

void main() {

	float mat = 0.0;

	//Positioning
	texcoord = (gl_MultiTexCoord0).xy;
	vec4 position = gbufferModelViewInverse * gl_ModelViewMatrix * gl_Vertex;
	/*--------------------------------*/
	
	gl_Position = gl_ProjectionMatrix * gbufferModelView * position;	
	
	//Fog
	float distance = sqrt(position.x * position.x + position.y * position.y + position.z * position.z);
	gl_FogFragCoord = distance;
	//-------------------------
	
	//Lighting - Shadows
	lmcoord = (gl_TextureMatrix[1] * gl_MultiTexCoord1).xy;
	vec3 normal = normalize(gl_NormalMatrix * gl_Normal);
	
	float modlmap = 13.0-lmcoord.s*12.35; 
	float torch_lightmap = max(1.5/(modlmap*modlmap)-0.00945,0.0);

	vec3 sunVec = normalize(sunPosition);
	vec3 upVec = normalize(upPosition);
	float NdotL = dot(normal,normalize(sunPosition));
	if (worldTime > 12700 && worldTime < 23250) NdotL = -NdotL ;
	ambientColor.a = max(mix(NdotL,abs(dot(sunVec,upVec))*0.33+NdotL*0.33+0.33,mat),0.0);
	ambientColor.rgb = vec3(2.0)*torch_lightmap;
	color = gl_Color;
	//--------------------------------------------------------------------------------------
	

}