#version 120
#define MAX_COLOR_RANGE 48.0
/*
                            _____ _____ ___________ 
                           /  ___|_   _|  _  | ___ \
                           \ `--.  | | | | | | |_/ /
                            `--. \ | | | | | |  __/ 
                           /\__/ / | | \ \_/ / |    
                           \____/  \_/  \___/\_|    

						Before editing anything here make sure you've 
						read The agreement, which you accepted by downloading
						my shaderpack. The agreement can be found here:
			http://www.minecraftforum.net/topic/1953873-164-172-sildurs-shaders-pcmacintel/
						   
						Sildur's shaders, derived from Chocapic's shaders */

/*--------------------
//ADJUSTABLE VARIABLES//
---------------------*/

	#define WATER_REFLECTIONS			

/*---------------------------
//END OF ADJUSTABLE VARIABLES//
----------------------------*/

//don't touch these lines if you don't know what you do!
const int maxf = 8;				//number of refinements
const float stp = 1.0;			//size of one step for raytracing algorithm
const float ref = 0.05;			//refinement multiplier
const float inc = 2.2;			//increasement factor at each step

varying vec4 texcoord;

uniform sampler2D composite;
uniform sampler2D gaux1;
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;
uniform sampler2D gnormal;

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;

uniform int isEyeInWater;
uniform float far;
uniform float near;
uniform float rainStrength;

float matflag = texture2D(gaux1,texcoord.xy).g;

vec3 ambient_color;
vec3 fogclr = pow(mix(vec3(0.56,0.64,0.72),vec3(0.3,0.3,0.3),rainStrength)*ambient_color,vec3(2.2));
vec3 fragpos = vec3(texcoord.st, texture2D(depthtex0, texcoord.st).r);
vec3 normal = texture2D(gnormal, texcoord.st).rgb * 2.0 - 1.0;

vec4 color = texture2D(composite,texcoord.xy);
	
float ld(float depth) {
    return (2.0 * near) / (far + near - depth * (far - near));
}

vec3 nvec3(vec4 pos) {
    return pos.xyz/pos.w;
}

vec4 nvec4(vec3 pos) {
    return vec4(pos.xyz, 1.0);
}

float cdist(vec2 coord) {
	return max(abs(coord.s-0.5),abs(coord.t-0.5))*2.0;
}


//Fog generation
vec3 calcFog(vec3 fposition, vec3 color) {
	float fog = exp(-pow(length(fposition)/256.0,4.0-(1.2*rainStrength,2.2*isEyeInWater))*400.0);
	float fogfactor =  clamp(fog,-10.0,1.0);
	//fogclr = getFogColor(fposition.xyz);
	return mix((fogclr+color.rgb*2.0*(1-rainStrength*0.9))/(1+2.0*(1-rainStrength*0.9)),color.rgb,fogfactor);
/*----------*/
}

vec4 raytrace(vec3 fragpos, vec3 normal) {
    vec4 color = vec4(0.0);
    vec3 start = fragpos;
    vec3 rvector = normalize(reflect(normalize(fragpos), normalize(normal)));
    vec3 vector = stp * rvector;
    vec3 oldpos = fragpos;
    fragpos += vector;
	vec3 tvector = vector;
    int sr = 0;
    for(int i=0;i<40;i++){
        vec3 pos = nvec3(gbufferProjection * nvec4(fragpos)) * 0.5 + 0.5;
        if(pos.x < 0 || pos.x > 1 || pos.y < 0 || pos.y > 1 || pos.z < 0 || pos.z > 1.0) break;
        vec3 spos = vec3(pos.st, texture2D(depthtex1, pos.st).r);
        spos = nvec3(gbufferProjectionInverse * nvec4(spos * 2.0 - 1.0));
        float err = abs(fragpos.z-spos.z);
if(err < pow(length(vector)*1.85,1.15)){
	
                sr++;
                if(sr >= maxf){
                    float border = clamp(1.0 - pow(cdist(pos.st), 20.0), 0.0, 1.0);
                    color = texture2D(composite, pos.st);
					color.rgb = calcFog(spos,pow(color.rgb,vec3(2.2))*MAX_COLOR_RANGE);
					color.a = 1.0;
                    color.a *= border;
                    break;
                }
				tvector -=vector;
                vector *=ref;
				
        
}
        vector *= inc;
        oldpos = fragpos;
        tvector += vector;
		fragpos = start + tvector;
    }
    return color;
}


/* If you reached this line, then you're probably about to break the agreement which you accepted by downloading Sildur's shaders!
So stop your doing and ask Sildur before copying anything which would break the agreement, unless you're Chocapic then go ahead ;)
--------------------------------------------------------------------------------------------------------------------------------*/ 

void main() {
	color.rgb = pow(color.rgb,vec3(2.2))*MAX_COLOR_RANGE;
	int iswater = int(matflag > 0.04 && matflag < 0.07);
	
	fragpos = nvec3(gbufferProjectionInverse * nvec4(fragpos * 2.0 - 1.0));

	//Reflections
	float fresnel_pow = 4.0 * 1.0;
	float normalDotEye = dot(normal, normalize(fragpos));
	float fresnel = clamp(pow(1.0 + normalDotEye, fresnel_pow),0.0,1.0);
	float fmult = 0.95;
	fresnel = fresnel*fmult + (1-fmult);
	vec3 reflectedVector = reflect(normalize(fragpos), normalize(normal));


#ifdef WATER_REFLECTIONS
if (isEyeInWater > 0.9){
} else if (iswater > 0.9) {
		reflectedVector = fragpos + reflectedVector * (far-fragpos.z);
		vec4 reflection = raytrace(fragpos, normal);	
		
		reflection.rgb = mix(sqrt(gl_Fog.color.rgb*fogclr)*2.0, reflection.rgb, reflection.a);			//Normalize water color, avoid color differences
		reflection.a = min(reflection.a,1.0);
		color.rgb = reflection.rgb*1.0 *fresnel + (1-fresnel)*color.rgb;
	}
#endif	

	//Underwater lighting
	vec3 colmult = mix(vec3(1.0),vec3(0.1,0.25,0.45),isEyeInWater);
	float depth_diff = clamp(pow(ld(texture2D(depthtex0, texcoord.st).r)*3.4,2.0),0.0,1.0);
	color.rgb = mix(color.rgb*colmult,vec3(0.05,0.1,0.15),depth_diff*isEyeInWater);

/* DRAWBUFFERS:5 */

	color.rgb = clamp(pow(color.rgb/MAX_COLOR_RANGE,vec3(1.0/2.2)),0.0,1.0);
	gl_FragData[0] = vec4(color.rgb,0.0);
}