// Shader that makes you puke by Gaeel (Sugardude), modified daxnitro curvature.

#version 120 // This will always get moved to the top of the code in pre-processing.

const float WORLD_RADIUS         = 250.0;
const float WORLD_RADIUS_SQUARED = 62500.0;

#ifdef _ENABLE_GL_TEXTURE_2D
centroid varying vec4 texCoord;
#endif

uniform int worldTime;
varying vec4 vertColor;

varying vec4 color;
varying vec4 texcoord;
varying vec4 lmcoord;


attribute vec4 mc_Entity;

uniform int tick;
uniform float rainStrength;
uniform float frameTimeCounter;

varying vec3 tangent;
varying vec3 normal;
varying vec3 binormal;
varying vec3 viewVector;

varying float distance;
varying float translucent;
varying float test;

void main() {
	test = 0.0;
	texcoord = gl_MultiTexCoord0;
	bool istopv = gl_MultiTexCoord0.t < gl_MultiTexCoord3.t;
	vec4 position = gl_ModelViewMatrix * gl_Vertex;
	translucent = 0.0f;
	float tick = frameTimeCounter;
	
	if (gl_Color.a != 0.8) {
		// Not a cloud.
		
		float distanceSquared = position.x * position.x + position.z * position.z;
		position.y += 5*sin(distanceSquared*sin(float(worldTime)/143.0)/1000);
		float y = position.y;
		float x = position.x;
		float om = sin(distanceSquared*sin(float(worldTime)/256.0)/5000) * sin(float(worldTime)/200.0);
		position.y = x*sin(om)+y*cos(om);
		position.x = x*cos(om)-y*sin(om);
	}
	
	gl_Position = gl_ProjectionMatrix * position;

#ifdef _ENABLE_GL_TEXTURE_2D
	texCoord = gl_MultiTexCoord0;
#endif
		
	vertColor = gl_Color;
	
	color = gl_Color;
	
	lmcoord = gl_TextureMatrix[1] * gl_MultiTexCoord1;
	
	gl_FogFragCoord = gl_Position.z;
	

	
}