#version 120

#define World_Curvature
const float WORLD_RADIUS         = 3200.0;					//Increase for a stronger rounded world
const float WORLD_RADIUS_SQUARED = 6250000.0;


varying vec4 color;
varying vec4 texcoord;
varying vec4 lmcoord;

attribute vec4 mc_Entity;

uniform int worldTime;

void main() {

	texcoord = gl_TextureMatrix[0] * gl_MultiTexCoord0;
	
    vec4 position = gl_ModelViewMatrix * gl_Vertex;

#ifdef World_Curvature
if (gl_Color.a != 0.8) {
    float distanceSquared = position.x * position.x + position.z * position.z;
    position.y -= WORLD_RADIUS - sqrt(max(1.0 - distanceSquared / WORLD_RADIUS_SQUARED, 0.0)) * WORLD_RADIUS;
}	
#endif
	
    gl_Position = gl_ProjectionMatrix * position;
	
	color = gl_Color;
	
	lmcoord = gl_TextureMatrix[1] * gl_MultiTexCoord1;
	
	gl_FogFragCoord = gl_Position.z;
}