/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.zoo.spawn;

import crazypants.enderio.zoo.config.ZooConfig;
import crazypants.enderio.zoo.entity.EntityDireSlime;
import crazypants.enderio.zoo.spawn.ISpawnEntry;
import crazypants.enderio.zoo.spawn.MobSpawns;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="enderiozoo")
public class MobSpawnEventHandler {
    @SubscribeEvent
    public static void onBlockHarvest(BlockEvent.HarvestDropsEvent event) {
        if (!((Boolean)ZooConfig.direSlimeEnabled.get()).booleanValue() && !((Boolean)ZooConfig.direSlimeEnabledHand.get()).booleanValue() || event.isCanceled() || event.getWorld() == null || event.getWorld().field_72995_K || event.getHarvester() == null || event.getHarvester().field_71075_bZ.field_75098_d || !(event.getState().func_177230_c() instanceof BlockDirt) && !(event.getState().func_177230_c() instanceof BlockGrass)) {
            return;
        }
        if (!MobSpawnEventHandler.isToolEffective(event.getState(), event.getHarvester().func_184614_ca()) && event.getWorld().field_73012_v.nextFloat() < ((Float)ZooConfig.direSlime1Chance.get()).floatValue()) {
            EntityDireSlime direSlime = new EntityDireSlime(event.getWorld());
            direSlime.func_70107_b((double)event.getPos().func_177958_n() + 0.5, (double)event.getPos().func_177956_o() + 0.0, (double)event.getPos().func_177952_p() + 0.5);
            event.getWorld().func_72838_d((Entity)direSlime);
            direSlime.func_70642_aH();
            for (ItemStack drop : event.getDrops()) {
                if (drop == null || drop.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150346_d)) continue;
                if (drop.func_190916_E() > 1) {
                    drop.func_190918_g(1);
                } else if (event.getDrops().size() == 1) {
                    event.getDrops().clear();
                } else {
                    event.getDrops().remove(drop);
                }
                return;
            }
        }
    }

    public static boolean isToolEffective(IBlockState state, ItemStack stack) {
        if (stack.func_190926_b()) {
            return (Boolean)ZooConfig.direSlimeEnabledHand.get() == false;
        }
        if (!((Boolean)ZooConfig.direSlimeEnabled.get()).booleanValue()) {
            return true;
        }
        for (String type : stack.func_77973_b().getToolClasses(stack)) {
            if (type == null || !state.func_177230_c().isToolEffective(type, state) && !"shovel".equals(type)) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onCheckSpawn(@Nonnull LivingSpawnEvent.CheckSpawn evt) {
        if (evt.isSpawner()) {
            return;
        }
        EntityLivingBase entityLiving = evt.getEntityLiving();
        if (entityLiving == null) {
            return;
        }
        ResourceLocation resourceLocation = EntityList.func_191301_a((Entity)entityLiving);
        if (resourceLocation == null) {
            return;
        }
        for (ISpawnEntry ent : MobSpawns.instance.getEntries()) {
            if (!resourceLocation.toString().equals(ent.getMobName()) || ent.canSpawnInDimension(evt.getWorld())) continue;
            evt.setResult(Event.Result.DENY);
            return;
        }
    }
}

