/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.zoo.spawn;

import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.Log;
import crazypants.enderio.util.IoUtil;
import crazypants.enderio.zoo.spawn.ISpawnEntry;
import crazypants.enderio.zoo.spawn.SpawnConfigParser;
import crazypants.enderio.zoo.spawn.impl.SpawnEntry;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class SpawnConfig {
    public static final String CONFIG_NAME_CORE = "SpawnConfig_Core.xml";
    public static final String CONFIG_NAME_USER = "SpawnConfig_User.xml";

    public static List<SpawnEntry> loadSpawnConfig() {
        List<SpawnEntry> result;
        try {
            IoUtil.copyConfigFromJar((String)CONFIG_NAME_CORE, (boolean)true);
        }
        catch (IOException e) {
            Log.error((Object[])new Object[]{"Could not load core spawn config file SpawnConfig_Core.xml from jar: " + e.getMessage()});
            e.printStackTrace();
            return null;
        }
        String defaultVals = null;
        try {
            defaultVals = IoUtil.readConfigFile((String)CONFIG_NAME_CORE);
        }
        catch (IOException e) {
            Log.error((Object[])new Object[]{"Could not load core spawn config file SpawnConfig_Core.xml from jar: " + e.getMessage()});
            e.printStackTrace();
            return null;
        }
        try {
            result = SpawnConfigParser.parseSpawnConfig(defaultVals);
        }
        catch (Exception e) {
            Log.error((Object[])new Object[]{"Error parsing SpawnConfig_Core.xml:" + e});
            return Collections.emptyList();
        }
        Log.info((Object[])new Object[]{"Loaded " + result.size() + " entries from core spawn config."});
        try {
            IoUtil.copyConfigFromJar((String)CONFIG_NAME_USER, (boolean)false);
        }
        catch (IOException e) {
            Log.error((Object[])new Object[]{"Could not load user spawn config file SpawnConfig_User.xml from jar: " + e.getMessage()});
            e.printStackTrace();
            return null;
        }
        File userFile = new File(EnderIO.getConfigHandler().getConfigDirectory(), CONFIG_NAME_USER);
        String userText = null;
        try {
            userText = IoUtil.readConfigFile((String)CONFIG_NAME_USER);
            if (userText == null || userText.trim().length() == 0) {
                Log.error((Object[])new Object[]{"Empty user config file: " + userFile.getAbsolutePath()});
            } else {
                List<SpawnEntry> userEntries = SpawnConfigParser.parseSpawnConfig(userText);
                Log.info((Object[])new Object[]{"Loaded " + userEntries.size() + " entries from user spawn config."});
                SpawnConfig.merge(userEntries, result);
            }
        }
        catch (Exception e) {
            Log.error((Object[])new Object[]{"Could not load user defined spawn entries from file: SpawnConfig_User.xml"});
            e.printStackTrace();
        }
        return result;
    }

    private static void merge(List<SpawnEntry> userEntries, List<SpawnEntry> result) {
        for (SpawnEntry entry : userEntries) {
            SpawnConfig.removeFrom(entry, result);
            result.add(entry);
        }
    }

    private static void removeFrom(ISpawnEntry useEntry, List<SpawnEntry> result) {
        ISpawnEntry toRemove = null;
        for (ISpawnEntry iSpawnEntry : result) {
            if (!useEntry.getId().equals(iSpawnEntry.getId())) continue;
            toRemove = iSpawnEntry;
            break;
        }
        if (toRemove != null) {
            Log.info((Object[])new Object[]{"Replace spawn config for " + toRemove.getId() + " with user supplied entry."});
            result.remove(toRemove);
        }
    }
}

