/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderzoo;

import crazypants.enderzoo.CommonProxy;
import crazypants.enderzoo.EnderZoo;
import crazypants.enderzoo.charge.EntityPrimedCharge;
import crazypants.enderzoo.charge.RenderPrimedCharge;
import crazypants.enderzoo.config.Config;
import crazypants.enderzoo.entity.EntityConcussionCreeper;
import crazypants.enderzoo.entity.EntityDireSlime;
import crazypants.enderzoo.entity.EntityDireWolf;
import crazypants.enderzoo.entity.EntityEnderminy;
import crazypants.enderzoo.entity.EntityFallenKnight;
import crazypants.enderzoo.entity.EntityFallenMount;
import crazypants.enderzoo.entity.EntityOwl;
import crazypants.enderzoo.entity.EntityOwlEgg;
import crazypants.enderzoo.entity.EntityWitherCat;
import crazypants.enderzoo.entity.EntityWitherWitch;
import crazypants.enderzoo.entity.render.RenderConcussionCreeper;
import crazypants.enderzoo.entity.render.RenderDireSlime;
import crazypants.enderzoo.entity.render.RenderDirewolf;
import crazypants.enderzoo.entity.render.RenderEnderminy;
import crazypants.enderzoo.entity.render.RenderEntityOwlEgg;
import crazypants.enderzoo.entity.render.RenderFallenKnight;
import crazypants.enderzoo.entity.render.RenderFallenMount;
import crazypants.enderzoo.entity.render.RenderOwl;
import crazypants.enderzoo.entity.render.RenderWitherCat;
import crazypants.enderzoo.entity.render.RenderWitherWitch;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ClientProxy
extends CommonProxy {
    @Override
    public World getClientWorld() {
        return FMLClientHandler.instance().getClient().field_71441_e;
    }

    @Override
    public EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void preInit() {
        super.preInit();
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (Config.enderminyEnabled) {
            RenderingRegistry.registerEntityRenderingHandler(EntityEnderminy.class, (IRenderFactory)RenderEnderminy.FACTORY);
        }
        if (Config.concussionCreeperEnabled) {
            RenderingRegistry.registerEntityRenderingHandler(EntityConcussionCreeper.class, (IRenderFactory)RenderConcussionCreeper.FACTORY);
        }
        if (Config.fallenKnightEnabled) {
            RenderingRegistry.registerEntityRenderingHandler(EntityFallenKnight.class, (IRenderFactory)RenderFallenKnight.FACTORY);
        }
        if (Config.fallenMountEnabled) {
            RenderingRegistry.registerEntityRenderingHandler(EntityFallenMount.class, (IRenderFactory)RenderFallenMount.FACTORY);
        }
        if (Config.witherWitchEnabled) {
            RenderingRegistry.registerEntityRenderingHandler(EntityWitherWitch.class, (IRenderFactory)RenderWitherWitch.FACTORY);
        }
        if (Config.witherCatEnabled) {
            RenderingRegistry.registerEntityRenderingHandler(EntityWitherCat.class, (IRenderFactory)RenderWitherCat.FACTORY);
        }
        if (Config.direWolfEnabled) {
            RenderingRegistry.registerEntityRenderingHandler(EntityDireWolf.class, (IRenderFactory)RenderDirewolf.FACTORY);
        }
        if (Config.direSlimeEnabled) {
            RenderingRegistry.registerEntityRenderingHandler(EntityDireSlime.class, (IRenderFactory)RenderDireSlime.FACTORY);
        }
        if (Config.owlEnabled) {
            RenderingRegistry.registerEntityRenderingHandler(EntityOwl.class, (IRenderFactory)RenderOwl.FACTORY);
        }
        RenderingRegistry.registerEntityRenderingHandler(EntityPrimedCharge.class, (IRenderFactory)RenderPrimedCharge.FACTORY);
        RenderingRegistry.registerEntityRenderingHandler(EntityOwlEgg.class, (IRenderFactory)RenderEntityOwlEgg.FACTORY);
    }

    @SubscribeEvent
    public void onModelRegister(ModelRegistryEvent e) {
        this.regRenderer(EnderZoo.itemWitheringDust, "witheringdust");
        this.regRenderer(EnderZoo.itemConfusingDust, "confusingdust");
        this.regRenderer(EnderZoo.itemEnderFragment, "enderfragment");
        this.regRenderer(EnderZoo.itemOwlEgg, "owlegg");
        this.regRenderer(EnderZoo.itemForCreativeMenuIcon, "enderZooIcon");
        if (Config.guardiansBowEnabled) {
            this.regRenderer((Item)EnderZoo.itemGuardiansBow, "guardiansbow");
        }
        if (Config.confusingChargeEnabled) {
            this.regRenderer(Item.func_150898_a((Block)EnderZoo.blockConfusingCharge), "blockconfusingcharge");
        }
        if (Config.concussionChargeEnabled) {
            this.regRenderer(Item.func_150898_a((Block)EnderZoo.blockConcussionCharge), "blockconcussioncharge");
        }
        if (Config.enderChargeEnabled) {
            this.regRenderer(Item.func_150898_a((Block)EnderZoo.blockEnderCharge), "blockendercharge");
        }
    }

    private void regRenderer(Item item, int meta, String name) {
        this.regRenderer(item, meta, "enderzoo", name);
    }

    private void regRenderer(Item item, int meta, String modId, String name) {
        String resourceName = modId != null ? modId + ":" + name : name;
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(resourceName, "inventory"));
    }

    private void regRenderer(Item item, String name) {
        this.regRenderer(item, 0, name);
    }

    @Override
    public void setInstantConfusionOnPlayer(EntityPlayer ent, int duration) {
        ent.func_70690_d(new PotionEffect(MobEffects.field_76431_k, duration, 1, false, true));
        Minecraft.func_71410_x().field_71439_g.field_71086_bY = 1.0f;
    }

    @Override
    public String translate(String unlocalized) {
        return I18n.func_135052_a((String)unlocalized, (Object[])new Object[0]);
    }
}

