/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.stellarfluidconduits.common.conduit.stellar;

import com.enderio.core.common.fluid.IFluidWrapper;
import com.enderio.core.common.util.RoundRobinIterator;
import com.tfar.stellarfluidconduits.common.conduit.NetworkTank;
import com.tfar.stellarfluidconduits.common.conduit.stellar.StellarFluidConduit;
import com.tfar.stellarfluidconduits.common.config.StellarFluidConduitConfig;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.filter.fluid.IFluidFilter;
import crazypants.enderio.conduits.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduits.conduit.liquid.ILiquidConduit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class StellarFluidConduitNetwork
extends AbstractConduitNetwork<ILiquidConduit, StellarFluidConduit> {
    List<NetworkTank> tanks = new ArrayList<NetworkTank>();
    Map<NetworkTankKey, NetworkTank> tankMap = new HashMap<NetworkTankKey, NetworkTank>();
    Map<NetworkTank, RoundRobinIterator<NetworkTank>> iterators;
    boolean filling;

    public StellarFluidConduitNetwork() {
        super(StellarFluidConduit.class, ILiquidConduit.class);
    }

    public void connectionChanged(@Nonnull StellarFluidConduit con, @Nonnull EnumFacing conDir) {
        NetworkTankKey key = new NetworkTankKey(con, conDir);
        NetworkTank tank = new NetworkTank(con, conDir);
        this.tanks.remove(tank);
        this.tanks.add(tank);
        this.tankMap.remove(key);
        this.tankMap.put(key, tank);
        this.tanks.sort((left, right) -> right.priority - left.priority);
    }

    public boolean extractFrom(@Nonnull StellarFluidConduit con, @Nonnull EnumFacing conDir) {
        NetworkTank tank = this.getTank(con, conDir);
        if (!tank.isValid()) {
            return false;
        }
        int fullLimit = (int)((float)((Integer)StellarFluidConduitConfig.extractRate.get()).intValue() * this.getExtractSpeedMultiplier(tank));
        if (tank.supportsMultipleTanks) {
            int limit = fullLimit;
            for (IFluidWrapper.ITankInfoWrapper tankInfoWrapper : tank.externalTank.getTankInfoWrappers()) {
                IFluidTankProperties tankProperties = tankInfoWrapper.getIFluidTankProperties();
                if (!tankProperties.canDrain() || (limit -= this.tryTransfer(con, conDir, tank, tankProperties.getContents(), limit)) > 0) continue;
                return true;
            }
            return limit < fullLimit;
        }
        return this.tryTransfer(con, conDir, tank, tank.externalTank.getAvailableFluid(), fullLimit) > 0;
    }

    private int tryTransfer(@Nonnull StellarFluidConduit con, @Nonnull EnumFacing conDir, @Nonnull NetworkTank from, FluidStack toDrain, int limit) {
        if (toDrain == null || toDrain.amount <= 0 || !this.matchedFilter(toDrain, con, conDir, true)) {
            return 0;
        }
        FluidStack draining = toDrain.copy();
        draining.amount = Math.min(draining.amount, limit);
        int amountAccepted = this.fillFrom(from, draining.copy(), false);
        if (amountAccepted <= 0) {
            return 0;
        }
        draining.amount = Math.min(draining.amount, amountAccepted);
        FluidStack drained = from.externalTank.drain(draining);
        if (drained == null || drained.amount <= 0) {
            return 0;
        }
        int amountFilled = this.fillFrom(from, drained.copy(), true);
        if (amountFilled > drained.amount) {
            Log.warn((Object[])new Object[]{"StellarFluidConduit at " + con.getBundle().getLocation() + ": Inserted fluid volume (" + amountFilled + "mB) is more than we tried to insert (" + drained.amount + "mB)."});
        } else if (amountFilled < drained.amount) {
            Log.warn((Object[])new Object[]{"EnderLiquidConduit at " + con.getBundle().getLocation() + ": Inserted fluid volume (" + amountFilled + "mB) is less than when we asked the target how much to insert (" + drained.amount + "mB). This means that one of the blocks connected to this conduit line has a bug."});
            FluidStack toPutBack = toDrain.copy();
            toPutBack.amount = drained.amount - amountFilled;
            int putBack = from.externalTank.fill(toPutBack.copy());
            if (putBack < toPutBack.amount) {
                Log.warn((Object[])new Object[]{"EnderLiquidConduit at " + con.getBundle().getLocation() + ": In addition, putting back " + toPutBack.amount + "mB into the source tank failed, leading to " + (toPutBack.amount - putBack) + "mB being voided."});
            }
        }
        return amountFilled;
    }

    @Nonnull
    private NetworkTank getTank(@Nonnull StellarFluidConduit con, @Nonnull EnumFacing conDir) {
        return this.tankMap.get(new NetworkTankKey(con, conDir));
    }

    public int fillFrom(@Nonnull StellarFluidConduit con, @Nonnull EnumFacing conDir, FluidStack resource, boolean doFill) {
        return this.fillFrom(this.getTank(con, conDir), resource, doFill);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fillFrom(@Nonnull NetworkTank tank, FluidStack resource, boolean doFill) {
        if (this.filling) {
            return 0;
        }
        RoundRobinIterator iteratorForTank = this.getIteratorForTank(tank);
        if (!doFill) {
            iteratorForTank = iteratorForTank.copy();
        }
        try {
            this.filling = true;
            if (resource == null || !this.matchedFilter(resource, tank.con, tank.conDir, true)) {
                int n = 0;
                return n;
            }
            resource = resource.copy();
            resource.amount = Math.min(resource.amount, (int)((float)((Integer)StellarFluidConduitConfig.maxIO.get()).intValue() * this.getExtractSpeedMultiplier(tank)));
            int filled = 0;
            int remaining = resource.amount;
            for (NetworkTank target : iteratorForTank) {
                if (target.equals(tank) && !tank.selfFeed || !target.acceptsOuput || !target.isValid() || target.inputColor != tank.outputColor || !this.matchedFilter(resource, target.con, target.conDir, false)) continue;
                int vol = doFill ? target.externalTank.fill(resource.copy()) : target.externalTank.offer(resource.copy());
                filled += vol;
                if ((remaining -= vol) <= 0) {
                    int n = filled;
                    return n;
                }
                resource.amount = remaining;
            }
            int n = filled;
            return n;
        }
        finally {
            if (!tank.roundRobin) {
                iteratorForTank.reset();
            }
            this.filling = false;
        }
    }

    private float getExtractSpeedMultiplier(NetworkTank tank) {
        return tank.con.getExtractSpeedMultiplier(tank.conDir);
    }

    private boolean matchedFilter(FluidStack drained, @Nonnull StellarFluidConduit con, @Nonnull EnumFacing conDir, boolean isInput) {
        if (drained == null) {
            return false;
        }
        IFluidFilter filter = con.getFilter(conDir, isInput);
        if (filter == null || filter.isEmpty()) {
            return true;
        }
        return filter.matchesFilter(drained);
    }

    private RoundRobinIterator<NetworkTank> getIteratorForTank(@Nonnull NetworkTank tank) {
        RoundRobinIterator res;
        if (this.iterators == null) {
            this.iterators = new HashMap<NetworkTank, RoundRobinIterator<NetworkTank>>();
        }
        if ((res = this.iterators.get(tank)) == null) {
            res = new RoundRobinIterator(this.tanks);
            this.iterators.put(tank, (RoundRobinIterator<NetworkTank>)res);
        }
        return res;
    }

    public IFluidTankProperties[] getTankProperties(@Nonnull StellarFluidConduit con, @Nonnull EnumFacing conDir) {
        ArrayList<IFluidTankProperties> res = new ArrayList<IFluidTankProperties>(this.tanks.size());
        NetworkTank tank = this.getTank(con, conDir);
        for (NetworkTank target : this.tanks) {
            if (target.equals(tank) || !target.isValid()) continue;
            for (IFluidWrapper.ITankInfoWrapper info : target.externalTank.getTankInfoWrappers()) {
                res.add(info.getIFluidTankProperties());
            }
        }
        return res.toArray(new IFluidTankProperties[res.size()]);
    }

    static class NetworkTankKey {
        EnumFacing conDir;
        BlockPos conduitLoc;

        public NetworkTankKey(@Nonnull StellarFluidConduit con, @Nonnull EnumFacing conDir) {
            this(con.getBundle().getLocation(), conDir);
        }

        public NetworkTankKey(@Nonnull BlockPos conduitLoc, @Nonnull EnumFacing conDir) {
            this.conDir = conDir;
            this.conduitLoc = conduitLoc;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.conDir == null ? 0 : this.conDir.hashCode());
            result = 31 * result + (this.conduitLoc == null ? 0 : this.conduitLoc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NetworkTankKey other = (NetworkTankKey)obj;
            if (this.conDir != other.conDir) {
                return false;
            }
            return !(this.conduitLoc == null ? other.conduitLoc != null : !this.conduitLoc.equals((Object)other.conduitLoc));
        }
    }
}

