/*
 * Decompiled with CFR 0.152.
 */
package gg.galaxygaming.gasconduits.common.conduit.advanced;

import crazypants.enderio.base.diagnostics.Prof;
import gg.galaxygaming.gasconduits.common.conduit.AbstractGasTankConduitNetwork;
import gg.galaxygaming.gasconduits.common.conduit.ConduitGasTank;
import gg.galaxygaming.gasconduits.common.conduit.GasOutput;
import gg.galaxygaming.gasconduits.common.conduit.advanced.AdvancedGasConduit;
import gg.galaxygaming.gasconduits.common.config.GasConduitConfig;
import gg.galaxygaming.gasconduits.common.utils.GasUtil;
import gg.galaxygaming.gasconduits.common.utils.GasWrapper;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasHandler;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class AdvancedGasConduitNetwork
extends AbstractGasTankConduitNetwork<AdvancedGasConduit> {
    private final ConduitGasTank tank = new ConduitGasTank(0);
    private final Set<GasOutput> outputs = new HashSet<GasOutput>();
    private Iterator<GasOutput> outputIterator;
    private boolean lastSyncedActive = false;
    private int lastSyncedVolume = -1;
    private int ticksEmpty;

    public AdvancedGasConduitNetwork() {
        super(AdvancedGasConduit.class);
    }

    @Override
    public void addConduit(@Nonnull AdvancedGasConduit con) {
        this.tank.setMaxGas(this.tank.getMaxGas() + 1000);
        if (con.getTank().containsValidGas()) {
            this.tank.addAmount(con.getTank().getStored());
        }
        for (EnumFacing dir : con.getExternalConnections()) {
            if (!con.getConnectionMode(dir).acceptsOutput()) continue;
            this.outputs.add(new GasOutput(con.getBundle().getLocation().func_177972_a(dir), dir.func_176734_d()));
        }
        this.outputIterator = null;
        super.addConduit(con);
    }

    @Override
    public boolean setGasType(GasStack newType) {
        if (super.setGasType(newType)) {
            GasStack gt = this.getGasType();
            this.tank.setGas(gt == null ? null : gt.copy());
            return true;
        }
        return false;
    }

    @Override
    public void setGasTypeLocked(boolean gasTypeLocked) {
        super.setGasTypeLocked(gasTypeLocked);
        if (!gasTypeLocked && this.tank.isEmpty()) {
            this.setGasType(null);
        }
    }

    public void destroyNetwork() {
        this.setConduitVolumes();
        this.outputs.clear();
        super.destroyNetwork();
    }

    private void setConduitVolumes() {
        if (this.tank.getGas() != null && !this.getConduits().isEmpty()) {
            GasStack gasPerConduit = this.tank.getGas().copy();
            int numCons = this.getConduits().size();
            int leftOvers = gasPerConduit.amount % numCons;
            gasPerConduit.amount /= numCons;
            for (AdvancedGasConduit con : this.getConduits()) {
                GasStack g = gasPerConduit.copy();
                if (leftOvers > 0) {
                    ++g.amount;
                    --leftOvers;
                }
                con.getTank().setGas(g);
                BlockPos pos = con.getBundle().getLocation();
                con.getBundle().getEntity().func_145831_w().func_175646_b(pos, con.getBundle().getEntity());
            }
        }
    }

    public void tickEnd(TickEvent.ServerTickEvent event, @Nullable Profiler profiler) {
        if (this.gasType == null || this.outputs.isEmpty() || !this.tank.containsValidGas() || this.tank.isEmpty()) {
            Prof.start((Profiler)profiler, (String)"updateActiveState");
            this.updateActiveState();
            Prof.stop((Profiler)profiler);
            return;
        }
        if (this.outputIterator == null || !this.outputIterator.hasNext()) {
            this.outputIterator = this.outputs.iterator();
        }
        Prof.start((Profiler)profiler, (String)"updateActiveState");
        this.updateActiveState();
        Prof.next((Profiler)profiler, (String)"pushGas");
        for (int numVisited = 0; !this.tank.isEmpty() && numVisited < this.outputs.size(); ++numVisited) {
            GasOutput output;
            if (!this.outputIterator.hasNext()) {
                this.outputIterator = this.outputs.iterator();
            }
            if ((output = this.outputIterator.next()) == null) continue;
            Prof.start((Profiler)profiler, (String)"otherMod_getTankContainer");
            IGasHandler cont = this.getTankContainer(output);
            Prof.stop((Profiler)profiler);
            if (cont == null || this.tank.getGas() == null) continue;
            GasStack offer = this.tank.getGas().copy();
            Prof.start((Profiler)profiler, (String)"otherMod_fill");
            int filled = cont.receiveGas(output.getDir(), offer, true);
            Prof.stop((Profiler)profiler);
            if (filled <= 0) continue;
            this.tank.addAmount(-filled);
        }
        Prof.stop((Profiler)profiler);
    }

    private void updateActiveState() {
        boolean isActive;
        boolean bl = isActive = this.tank.containsValidGas() && !this.tank.isEmpty();
        if (!isActive) {
            if (!this.gasTypeLocked && this.gasType != null) {
                ++this.ticksEmpty;
                if (this.ticksEmpty > 40) {
                    this.setGasType(null);
                    this.ticksEmpty = 0;
                    this.getConduits().forEach(con -> con.setActive(false));
                    this.lastSyncedActive = false;
                }
            }
            return;
        }
        this.ticksEmpty = 0;
        if (!this.lastSyncedActive) {
            this.getConduits().forEach(con -> con.setActive(true));
            this.lastSyncedActive = true;
        }
    }

    public int receiveGas(GasStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        resource.amount = Math.min(resource.amount, (Integer)GasConduitConfig.tier2_maxIO.get());
        boolean gasWasValid = !this.tank.containsValidGas();
        int res = this.tank.receive(resource, doFill);
        if (doFill && res > 0 && !gasWasValid) {
            int vol = this.tank.getStored();
            this.setGasType(resource);
            this.tank.setAmount(vol);
        }
        return res;
    }

    public GasStack drawGas(int maxDrain, boolean doDrain) {
        if (this.tank.isEmpty() || this.tank.getGas() == null) {
            return null;
        }
        int amount = Math.min(maxDrain, this.tank.getStored());
        GasStack result = this.tank.getGas().copy();
        result.amount = amount;
        if (doDrain) {
            this.tank.addAmount(-amount);
        }
        return result;
    }

    public boolean extractFrom(@Nonnull AdvancedGasConduit advancedGasConduit, @Nonnull EnumFacing dir, int maxExtractPerTick) {
        if (this.tank.isFull()) {
            return false;
        }
        IGasHandler extTank = this.getTankContainer(advancedGasConduit, dir);
        if (extTank != null) {
            int maxExtract = Math.min(maxExtractPerTick, this.tank.getNeeded());
            if (this.gasType == null || !this.tank.containsValidGas()) {
                GasStack newGas = GasUtil.getGasStack(extTank, dir.func_176734_d());
                if (newGas == null) {
                    return false;
                }
                this.setGasType(newGas);
            }
            GasStack couldDrain = this.gasType.copy();
            couldDrain.amount = maxExtract;
            GasStack drained = extTank.drawGas(dir, couldDrain.amount, true);
            if (drained == null || drained.amount == 0) {
                return false;
            }
            if (drained.isGasEqual(this.getGasType())) {
                this.tank.addAmount(drained.amount);
            } else {
                extTank.receiveGas(dir, drained, true);
            }
            return true;
        }
        return false;
    }

    public IGasHandler getTankContainer(GasOutput output) {
        return GasWrapper.getGasHandler((IBlockAccess)this.getWorld(), output.getLocation(), output.getDir());
    }

    public IGasHandler getTankContainer(@Nonnull AdvancedGasConduit con, @Nonnull EnumFacing dir) {
        return GasWrapper.getGasHandler((IBlockAccess)this.getWorld(), con.getBundle().getLocation().func_177972_a(dir), dir.func_176734_d());
    }

    World getWorld() {
        if (this.getConduits().isEmpty()) {
            return null;
        }
        return ((AdvancedGasConduit)this.getConduits().get(0)).getBundle().getBundleworld();
    }

    public void removeInput(GasOutput lo) {
        this.outputs.remove(lo);
        this.outputIterator = null;
    }

    public void addInput(GasOutput lo) {
        this.outputs.add(lo);
        this.outputIterator = null;
    }

    public void updateConduitVolumes() {
        if (this.tank.getStored() == this.lastSyncedVolume) {
            return;
        }
        this.setConduitVolumes();
        this.lastSyncedVolume = this.tank.getStored();
    }
}

