/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.sagmill;

import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.lang.LangPower;
import crazypants.enderio.base.machine.gui.GuiInventoryMachineBase;
import crazypants.enderio.base.machine.gui.PowerBar;
import crazypants.enderio.base.recipe.sagmill.IGrindingMultiplier;
import crazypants.enderio.machines.machine.sagmill.ContainerSagMill;
import crazypants.enderio.machines.machine.sagmill.TileSagMill;
import java.awt.Rectangle;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.text.TextFormatting;

public class GuiSagMill
extends GuiInventoryMachineBase<TileSagMill> {
    boolean isSimple;

    public GuiSagMill(@Nonnull InventoryPlayer par1InventoryPlayer, @Nonnull TileSagMill inventory) {
        super(inventory, (Container)ContainerSagMill.create(par1InventoryPlayer, inventory), new String[]{"crusher", "crusher_light"});
        this.isSimple = inventory instanceof TileSagMill.Simple;
        if (!this.isSimple) {
            this.addToolTip(new GuiToolTip(new Rectangle(142, 23, 5, 17), new String[]{""}){

                protected void updateText() {
                    this.text.clear();
                    IGrindingMultiplier ball = ((TileSagMill)((GuiSagMill)GuiSagMill.this).getTileEntity()).grindingBall;
                    if (ball != null) {
                        this.text.add(Lang.GRINDING_BALL_DURABILITY.get(((TileSagMill)GuiSagMill.this.getTileEntity()).getBallDurationScaled(100)));
                        this.text.add(Lang.GRINDING_BALL_1.get(TextFormatting.BLUE));
                        this.text.add(Lang.GRINDING_BALL_2.get(TextFormatting.GRAY, LangPower.toPercent(ball.getGrindingMultiplier())));
                        this.text.add(Lang.GRINDING_BALL_3.get(TextFormatting.GRAY, LangPower.toPercent(ball.getChanceMultiplier())));
                        this.text.add(Lang.GRINDING_BALL_4.get(TextFormatting.GRAY, LangPower.toPercent(ball.getPowerMultiplier())));
                    }
                }
            });
        }
        this.addProgressTooltip(79, 31, 18, 24);
        this.redstoneButton.setIsVisible(!this.isSimple);
        this.addDrawingElement(new PowerBar(inventory, this));
    }

    @Override
    protected void func_146976_a(float par1, int par2, int par3) {
        int barHeight;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture(this.isSimple ? 1 : 0);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.shouldRenderProgress()) {
            barHeight = this.getProgressScaled(24);
            this.func_73729_b(this.field_147003_i + 79, this.field_147009_r + 31, 200, 0, 18, barHeight + 1);
        }
        barHeight = ((TileSagMill)this.getTileEntity()).getBallDurationScaled(16);
        if (!this.isSimple && barHeight > 0) {
            this.func_73729_b(this.field_147003_i + 142, this.field_147009_r + 23 + (16 - barHeight), 186, 31, 4, barHeight);
        }
        super.func_146976_a(par1, par2, par3);
    }

    @Override
    protected void renderSlotHighlight(@Nonnull Slot slot, @Nonnull Vector4f col) {
        if (this.isSimple && slot.getSlotIndex() == 1) {
            return;
        }
        super.renderSlotHighlight(slot, col);
    }
}

