/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.network;

import com.enderio.core.common.util.DyeColor;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.filter.IFilter;
import crazypants.enderio.base.filter.capability.CapabilityFilterHolder;
import crazypants.enderio.base.filter.capability.IFilterHolder;
import crazypants.enderio.conduits.conduit.liquid.EnderLiquidConduit;
import crazypants.enderio.conduits.network.PacketConduitFilter;
import crazypants.enderio.util.EnumReader;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketEnderLiquidConduit
extends PacketConduitFilter<EnderLiquidConduit> {
    @Nonnull
    private DyeColor colIn = DyeColor.BLACK;
    @Nonnull
    private DyeColor colOut = DyeColor.BLACK;
    private int priority;
    private boolean roundRobin;
    private boolean selfFeed;

    public PacketEnderLiquidConduit() {
    }

    public PacketEnderLiquidConduit(@Nonnull EnderLiquidConduit con, @Nonnull EnumFacing dir) {
        super(con, dir);
        this.colIn = con.getInputColor(dir);
        this.colOut = con.getOutputColor(dir);
        this.priority = con.getOutputPriority(dir);
        this.roundRobin = con.isRoundRobinEnabled(dir);
        this.selfFeed = con.isSelfFeedEnabled(dir);
    }

    @Override
    public void write(@Nonnull ByteBuf buf) {
        super.write(buf);
        buf.writeShort(this.colIn.ordinal());
        buf.writeShort(this.colOut.ordinal());
        buf.writeInt(this.priority);
        buf.writeBoolean(this.roundRobin);
        buf.writeBoolean(this.selfFeed);
    }

    @Override
    public void read(@Nonnull ByteBuf buf) {
        super.read(buf);
        this.colIn = EnumReader.get(DyeColor.class, buf.readShort());
        this.colOut = EnumReader.get(DyeColor.class, buf.readShort());
        this.priority = buf.readInt();
        this.roundRobin = buf.readBoolean();
        this.selfFeed = buf.readBoolean();
    }

    public static class Handler
    implements IMessageHandler<PacketEnderLiquidConduit, IMessage> {
        public IMessage onMessage(PacketEnderLiquidConduit message, MessageContext ctx) {
            EnderLiquidConduit conduit = (EnderLiquidConduit)message.getConduit(ctx);
            if (conduit != null) {
                IFilter outputFilter;
                conduit.setInputColor(message.dir, message.colIn);
                conduit.setOutputColor(message.dir, message.colOut);
                conduit.setOutputPriority(message.dir, message.priority);
                conduit.setRoundRobinEnabled(message.dir, message.roundRobin);
                conduit.setSelfFeedEnabled(message.dir, message.selfFeed);
                IFilter inputFilter = message.inputFilter;
                if (inputFilter != null) {
                    this.applyFilter(message.dir, conduit, inputFilter, true);
                }
                if ((outputFilter = message.outputFilter) != null) {
                    this.applyFilter(message.dir, conduit, outputFilter, false);
                }
                IBlockState bs = message.getWorld(ctx).func_180495_p(message.getPos());
                message.getWorld(ctx).func_184138_a(message.getPos(), bs, bs, 3);
            }
            return null;
        }

        private void applyFilter(@Nonnull EnumFacing dir, @Nonnull IConduit conduit, @Nonnull IFilter filter, boolean isInput) {
            IFilterHolder filterHolder;
            if (conduit.hasInternalCapability(CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY, dir) && (filterHolder = conduit.getInternalCapability(CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY, dir)) != null) {
                if (isInput) {
                    filterHolder.setFilter(filterHolder.getInputFilterIndex(), dir.ordinal(), filter);
                } else {
                    filterHolder.setFilter(filterHolder.getOutputFilterIndex(), dir.ordinal(), filter);
                }
            }
        }
    }
}

