/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.farming.farmers;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.api.farm.AbstractFarmerJoe;
import crazypants.enderio.api.farm.FarmNotification;
import crazypants.enderio.api.farm.FarmingAction;
import crazypants.enderio.api.farm.IFarmer;
import crazypants.enderio.api.farm.IHarvestResult;
import crazypants.enderio.base.config.config.FarmingConfig;
import crazypants.enderio.base.farming.FarmersRegistry;
import crazypants.enderio.base.farming.FarmingTool;
import crazypants.enderio.base.farming.farmers.HarvestResult;
import crazypants.enderio.base.farming.harvesters.FarmHarvestingTarget;
import crazypants.enderio.base.farming.harvesters.TreeHarvester;
import crazypants.enderio.util.NNPair;
import crazypants.enderio.util.Prep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;

public class TreeFarmer
extends AbstractFarmerJoe {
    @Nonnull
    protected static final HeightComparator comp = new HeightComparator();
    @Nonnull
    protected final Things saplings;
    @Nonnull
    protected final Things woods;
    private boolean ignoreMeta = false;
    protected boolean hasAxe;
    protected boolean hasShears;
    protected boolean hasHoe;
    protected int fortune;
    protected int noShearingPercentage;
    protected int shearCount;

    public TreeFarmer(@Nonnull Things saplings, @Nonnull Things woods) {
        this.woods = woods;
        FarmersRegistry.slotItemsProduce.add(woods);
        this.saplings = saplings;
        FarmersRegistry.slotItemsSeeds.add(saplings);
    }

    @Nonnull
    private static Things makeThings(Block ... wood) {
        Things result = new Things();
        for (Block block : wood) {
            result.add(block);
        }
        return result;
    }

    public TreeFarmer(Block sapling, Block ... wood) {
        this(TreeFarmer.makeThings(sapling), TreeFarmer.makeThings(wood));
    }

    public TreeFarmer(boolean ignoreMeta, Block sapling, Block ... wood) {
        this(sapling, wood);
        this.ignoreMeta = ignoreMeta;
    }

    @Override
    public boolean canHarvest(@Nonnull IFarmer farm, @Nonnull BlockPos bc, @Nonnull IBlockState state) {
        return this.isWood(state.func_177230_c());
    }

    public boolean isWood(Block block) {
        return this.woods.contains(block);
    }

    @Override
    public boolean canPlant(@Nonnull ItemStack stack) {
        return Prep.isValid(stack) && this.saplings.contains(stack) && Block.func_149634_a((Item)stack.func_77973_b()) != Blocks.field_150350_a;
    }

    @Override
    public boolean prepareBlock(@Nonnull IFarmer farm, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        if (this.saplings.contains(state.func_177230_c())) {
            return true;
        }
        if (!this.saplings.contains(farm.getSeedTypeInSuppliesFor(pos))) {
            return false;
        }
        return this.plantFromInventory(farm, pos, state);
    }

    protected boolean plantFromInventory(@Nonnull IFarmer farm, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        if (this.plant(farm, farm.getWorld(), pos, farm.takeSeedFromSupplies(pos, true))) {
            farm.takeSeedFromSupplies(pos, false);
            return true;
        }
        return false;
    }

    protected boolean canPlant(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull ItemStack sapling) {
        if (this.saplings.contains(sapling)) {
            BlockPos grnPos = pos.func_177977_b();
            IBlockState bs = world.func_180495_p(grnPos);
            Block ground = bs.func_177230_c();
            Block saplingBlock = Block.func_149634_a((Item)sapling.func_77973_b());
            if (saplingBlock != Blocks.field_150350_a && saplingBlock.func_176196_c(world, pos)) {
                if (saplingBlock instanceof IPlantable) {
                    return ground.canSustainPlant(bs, (IBlockAccess)world, grnPos, EnumFacing.UP, (IPlantable)saplingBlock);
                }
                return true;
            }
        }
        return false;
    }

    protected boolean plant(@Nonnull IFarmer farm, @Nonnull World world, @Nonnull BlockPos bc, @Nonnull ItemStack sapling) {
        if (this.canPlant(world, bc, sapling) && farm.checkAction(FarmingAction.PLANT, FarmingTool.HOE)) {
            world.func_175698_g(bc);
            Item item = sapling.func_77973_b();
            IBlockState state = Block.func_149634_a((Item)item).func_176203_a(item.func_77647_b(sapling.func_77960_j()));
            world.func_180501_a(bc, state, 3);
            farm.registerAction(FarmingAction.PLANT, FarmingTool.HOE, state, bc);
            return true;
        }
        return false;
    }

    protected void setupHarvesting(@Nonnull IFarmer farm, @Nonnull BlockPos harvestLocation) {
        this.hasAxe = farm.hasTool(FarmingTool.AXE);
        if (this.hasAxe) {
            this.fortune = farm.getLootingValue(FarmingTool.AXE);
            this.hasShears = farm.hasTool(FarmingTool.SHEARS);
            this.hasHoe = farm.hasTool(FarmingTool.HOE);
            this.noShearingPercentage = farm.isLowOnSaplings(harvestLocation);
            this.shearCount = 0;
        }
    }

    @Override
    public IHarvestResult harvestBlock(@Nonnull IFarmer farm, @Nonnull BlockPos bc, @Nonnull IBlockState state) {
        this.setupHarvesting(farm, bc);
        if (!this.hasAxe) {
            farm.setNotification(FarmNotification.NO_AXE);
            return null;
        }
        World world = farm.getWorld();
        HarvestResult res = new HarvestResult();
        FarmHarvestingTarget target = new FarmHarvestingTarget(this, farm, (Integer)FarmingConfig.treeHarvestRadius.get(), (Integer)FarmingConfig.treeHarvestHeight.get());
        TreeHarvester.harvest(world, bc, res, target);
        Collections.sort(res.getHarvestedBlocks(), comp);
        ArrayList<BlockPos> actualHarvests = new ArrayList<BlockPos>();
        for (int i = 0; i < res.getHarvestedBlocks().size() && this.hasAxe; ++i) {
            BlockPos coord = (BlockPos)res.getHarvestedBlocks().get(i);
            if (!this.harvestSingleBlock(farm, world, res, coord)) continue;
            actualHarvests.add(coord);
        }
        res.getHarvestedBlocks().clear();
        res.getHarvestedBlocks().addAll(actualHarvests);
        this.tryReplanting(farm, world, bc, res);
        return res;
    }

    boolean harvestSingleBlock(@Nonnull IFarmer farm, @Nonnull World world, final @Nonnull IHarvestResult result, final @Nonnull BlockPos harvestPos) {
        float chance = 1.0f;
        NNList drops = new NNList();
        IBlockState state = farm.getBlockState(harvestPos);
        Block blk = state.func_177230_c();
        if (blk instanceof IShearable && this.hasShears && this.shearCount / result.getHarvestedBlocks().size() + this.noShearingPercentage < 100) {
            if (!farm.checkAction(FarmingAction.HARVEST, FarmingTool.SHEARS)) {
                return false;
            }
            drops.addAll((Collection)((IShearable)blk).onSheared(farm.getTool(FarmingTool.SHEARS), (IBlockAccess)world, harvestPos, 0));
            this.shearCount += 100;
            farm.registerAction(FarmingAction.HARVEST, FarmingTool.SHEARS, state, harvestPos);
            this.hasShears = farm.hasTool(FarmingTool.SHEARS);
            if (!this.hasShears) {
                farm.setNotification(FarmNotification.NO_SHEARS);
            }
        } else {
            FarmingTool tool;
            FarmingTool farmingTool = tool = this.isWood(blk) || !this.hasHoe ? FarmingTool.AXE : FarmingTool.HOE;
            if (!farm.checkAction(FarmingAction.HARVEST, tool)) {
                return false;
            }
            blk.getDrops((NonNullList)drops, (IBlockAccess)world, harvestPos, state, this.fortune);
            FakePlayer joe = farm.startUsingItem(tool);
            chance = ForgeEventFactory.fireBlockHarvesting((List)drops, (World)joe.field_70170_p, (BlockPos)harvestPos, (IBlockState)state, (int)this.fortune, (float)chance, (boolean)false, (EntityPlayer)joe);
            farm.registerAction(FarmingAction.HARVEST, tool, state, harvestPos);
            NNList.wrap(farm.endUsingItem(tool)).apply((NNList.Callback)new NNList.Callback<ItemStack>(){

                public void apply(@Nonnull ItemStack drop) {
                    result.addDrop(harvestPos, drop.func_77946_l());
                }
            });
            if (tool == FarmingTool.AXE) {
                this.hasAxe = farm.hasTool(FarmingTool.AXE);
                if (!this.hasAxe) {
                    farm.setNotification(FarmNotification.NO_AXE);
                }
            } else {
                this.hasHoe = farm.hasTool(FarmingTool.HOE);
                if (!this.hasHoe) {
                    farm.setNotification(FarmNotification.NO_HOE);
                }
            }
        }
        for (ItemStack drop : drops) {
            if (!(world.field_73012_v.nextFloat() <= chance)) continue;
            result.addDrop(harvestPos, drop.func_77946_l());
        }
        farm.getWorld().func_175698_g(harvestPos);
        return true;
    }

    protected void tryReplanting(@Nonnull IFarmer farm, @Nonnull World world, @Nonnull BlockPos bc, @Nonnull HarvestResult res) {
        ItemStack seedTypeInSuppliesFor;
        if (!world.func_175623_d(bc)) {
            return;
        }
        ItemStack allowedSeed = Prep.getEmpty();
        if (farm.isSlotLocked(bc) && Prep.isValid(seedTypeInSuppliesFor = farm.getSeedTypeInSuppliesFor(bc))) {
            allowedSeed = seedTypeInSuppliesFor;
        }
        for (NNPair drop : res.getDrops()) {
            if (!Prep.isInvalid(allowedSeed) && !ItemStack.func_179545_c((ItemStack)allowedSeed, (ItemStack)((ItemStack)drop.getValue())) || !this.plant(farm, world, bc, (ItemStack)drop.getValue())) continue;
            res.getDrops().remove((Object)drop);
            return;
        }
    }

    public boolean getIgnoreMeta() {
        return this.ignoreMeta;
    }

    public void setIgnoreMeta(boolean ignoreMeta) {
        this.ignoreMeta = ignoreMeta;
    }

    private static class HeightComparator
    implements Comparator<BlockPos> {
        private HeightComparator() {
        }

        @Override
        public int compare(BlockPos o1, BlockPos o2) {
            return Integer.compare(o2.func_177956_o(), o1.func_177956_o());
        }
    }
}

