/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.AbstractConditional;
import crazypants.enderio.base.config.recipes.xml.FluidAmount;
import crazypants.enderio.base.config.recipes.xml.Item;
import crazypants.enderio.base.config.recipes.xml.ItemIntegerAmount;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.base.recipe.RecipeLevel;
import crazypants.enderio.base.recipe.tank.TankMachineRecipe;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import net.minecraftforge.fluids.FluidStack;

public class Tanking
extends AbstractConditional {
    private Optional<Item> input = this.empty();
    private Optional<ItemIntegerAmount> output = this.empty();
    private Optional<FluidAmount> fluid = this.empty();
    private TankMachineRecipe.Logic logic = TankMachineRecipe.Logic.NONE;
    private Optional<Type> type = this.empty();

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        try {
            super.readResolve();
            if (!this.input.isPresent()) {
                throw new InvalidRecipeConfigException("Missing <input>");
            }
            if (!this.fluid.isPresent()) {
                throw new InvalidRecipeConfigException("Missing <fluid>");
            }
            if (!this.type.isPresent()) {
                throw new InvalidRecipeConfigException("Missing attribute 'type'");
            }
            this.valid = this.input.get().isValid() && this.fluid.get().isValid() && (!this.output.isPresent() || this.output.get().isValid());
        }
        catch (InvalidRecipeConfigException e) {
            throw new InvalidRecipeConfigException(e, "in <tanking>");
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        this.input.get().enforceValidity();
        if (this.input.get().getThing().isEmpty()) {
            throw new InvalidRecipeConfigException("Valid <input> child elements are invalid in <tanking>");
        }
        this.fluid.get().enforceValidity();
        if (this.output.isPresent()) {
            this.output.get().enforceValidity();
            if (this.output.get().getThing().isEmpty()) {
                throw new InvalidRecipeConfigException("Valid <output> child elements are invalid in <tanking>");
            }
        }
    }

    @Override
    public void register(@Nonnull String recipeName) {
        Things inThing;
        if (this.isValid() && this.isActive() && !(inThing = this.input.get().getThing()).isEmpty()) {
            Things outThing = this.output.isPresent() ? this.output.get().getThing() : null;
            FluidStack fluidStack = this.fluid.get().getFluidStack();
            boolean isFilling = this.type.get() == Type.FILL;
            TankMachineRecipe recipe = new TankMachineRecipe(recipeName, isFilling, inThing, fluidStack, outThing, this.logic, RecipeLevel.IGNORE);
            MachineRecipeRegistry.instance.registerRecipe(recipe);
        }
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("logic".equals(name)) {
            try {
                this.logic = TankMachineRecipe.Logic.valueOf(value.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                throw new InvalidRecipeConfigException("'" + value + "' is not a valid value for 'logic'");
            }
            return true;
        }
        if ("type".equals(name)) {
            try {
                this.type = this.of(Type.valueOf((String)NullHelper.first((Object)value.toUpperCase(Locale.ENGLISH), (Supplier[])new Supplier[0])));
            }
            catch (IllegalArgumentException e) {
                throw new InvalidRecipeConfigException("'" + value + "' is not a valid value for 'type'");
            }
            return true;
        }
        return super.setAttribute(factory, name, value);
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        if ("input".equals(name) && !this.input.isPresent()) {
            this.input = this.of(factory.read(new Item().setAllowDelaying(false), startElement));
            return true;
        }
        if ("fluid".equals(name) && !this.fluid.isPresent()) {
            this.fluid = this.of(factory.read(new FluidAmount(), startElement));
            return true;
        }
        if ("output".equals(name) && !this.output.isPresent()) {
            this.output = this.of(factory.read(new ItemIntegerAmount().setAllowDelaying(false), startElement));
            return true;
        }
        return super.setElement(factory, name, startElement);
    }

    private static enum Type {
        EMPTY,
        FILL;

    }
}

