/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.network.BlockPlacedMessage;
import nl.requios.effortlessbuilding.network.PacketHandler;
import nl.requios.effortlessbuilding.proxy.ClientProxy;

public class RequestLookAtMessage {
    private final boolean placeStartPos;

    public RequestLookAtMessage() {
        this.placeStartPos = false;
    }

    public RequestLookAtMessage(boolean placeStartPos) {
        this.placeStartPos = placeStartPos;
    }

    public static void encode(RequestLookAtMessage message, FriendlyByteBuf buf) {
        buf.writeBoolean(message.placeStartPos);
    }

    public static RequestLookAtMessage decode(FriendlyByteBuf buf) {
        boolean placeStartPos = buf.readBoolean();
        return new RequestLookAtMessage(placeStartPos);
    }

    public boolean getPlaceStartPos() {
        return this.placeStartPos;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ClientHandler {
        public static void handle(RequestLookAtMessage message, Supplier<NetworkEvent.Context> ctx) {
            Player player = EffortlessBuilding.proxy.getPlayerEntityFromContext(ctx);
            if (ClientProxy.previousLookAt.m_6662_() == HitResult.Type.BLOCK) {
                PacketHandler.INSTANCE.sendToServer((Object)new BlockPlacedMessage((BlockHitResult)ClientProxy.previousLookAt, message.getPlaceStartPos()));
            } else {
                PacketHandler.INSTANCE.sendToServer((Object)new BlockPlacedMessage());
            }
        }
    }

    public static class Handler {
        public static void handle(RequestLookAtMessage message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                    DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> Handler.lambda$handle$1(message, (Supplier)ctx));
                }
            });
            ctx.get().setPacketHandled(true);
        }

        private static /* synthetic */ Runnable lambda$handle$1(RequestLookAtMessage message, Supplier ctx) {
            return () -> Handler.lambda$handle$0(message, (Supplier)ctx);
        }

        private static /* synthetic */ void lambda$handle$0(RequestLookAtMessage message, Supplier ctx) {
            ClientHandler.handle(message, ctx);
        }
    }
}

