/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.network;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmodifier.Array;
import nl.requios.effortlessbuilding.buildmodifier.Mirror;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.buildmodifier.RadialMirror;

public class ModifierSettingsMessage {
    private ModifierSettingsManager.ModifierSettings modifierSettings;

    public ModifierSettingsMessage() {
    }

    public ModifierSettingsMessage(ModifierSettingsManager.ModifierSettings modifierSettings) {
        this.modifierSettings = modifierSettings;
    }

    public static void encode(ModifierSettingsMessage message, FriendlyByteBuf buf) {
        Array.ArraySettings a;
        Mirror.MirrorSettings m = message.modifierSettings.getMirrorSettings();
        buf.writeBoolean(m != null);
        if (m != null) {
            buf.writeBoolean(m.enabled);
            buf.writeDouble(m.position.f_82479_);
            buf.writeDouble(m.position.f_82480_);
            buf.writeDouble(m.position.f_82481_);
            buf.writeBoolean(m.mirrorX);
            buf.writeBoolean(m.mirrorY);
            buf.writeBoolean(m.mirrorZ);
            buf.writeInt(m.radius);
            buf.writeBoolean(m.drawLines);
            buf.writeBoolean(m.drawPlanes);
        }
        buf.writeBoolean((a = message.modifierSettings.getArraySettings()) != null);
        if (a != null) {
            buf.writeBoolean(a.enabled);
            buf.writeInt(a.offset.m_123341_());
            buf.writeInt(a.offset.m_123342_());
            buf.writeInt(a.offset.m_123343_());
            buf.writeInt(a.count);
        }
        buf.writeBoolean(message.modifierSettings.doQuickReplace());
        buf.writeInt(message.modifierSettings.getReachUpgrade());
        RadialMirror.RadialMirrorSettings r = message.modifierSettings.getRadialMirrorSettings();
        buf.writeBoolean(r != null);
        if (r != null) {
            buf.writeBoolean(r.enabled);
            buf.writeDouble(r.position.f_82479_);
            buf.writeDouble(r.position.f_82480_);
            buf.writeDouble(r.position.f_82481_);
            buf.writeInt(r.slices);
            buf.writeBoolean(r.alternate);
            buf.writeInt(r.radius);
            buf.writeBoolean(r.drawLines);
            buf.writeBoolean(r.drawPlanes);
        }
    }

    public static ModifierSettingsMessage decode(FriendlyByteBuf buf) {
        Mirror.MirrorSettings m = new Mirror.MirrorSettings();
        if (buf.readBoolean()) {
            boolean mirrorEnabled = buf.readBoolean();
            Vec3 mirrorPosition = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
            boolean mirrorX = buf.readBoolean();
            boolean mirrorY = buf.readBoolean();
            boolean mirrorZ = buf.readBoolean();
            int mirrorRadius = buf.readInt();
            boolean mirrorDrawLines = buf.readBoolean();
            boolean mirrorDrawPlanes = buf.readBoolean();
            m = new Mirror.MirrorSettings(mirrorEnabled, mirrorPosition, mirrorX, mirrorY, mirrorZ, mirrorRadius, mirrorDrawLines, mirrorDrawPlanes);
        }
        Array.ArraySettings a = new Array.ArraySettings();
        if (buf.readBoolean()) {
            boolean arrayEnabled = buf.readBoolean();
            BlockPos arrayOffset = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
            int arrayCount = buf.readInt();
            a = new Array.ArraySettings(arrayEnabled, arrayOffset, arrayCount);
        }
        boolean quickReplace = buf.readBoolean();
        int reachUpgrade = buf.readInt();
        RadialMirror.RadialMirrorSettings r = new RadialMirror.RadialMirrorSettings();
        if (buf.readBoolean()) {
            boolean radialMirrorEnabled = buf.readBoolean();
            Vec3 radialMirrorPosition = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
            int radialMirrorSlices = buf.readInt();
            boolean radialMirrorAlternate = buf.readBoolean();
            int radialMirrorRadius = buf.readInt();
            boolean radialMirrorDrawLines = buf.readBoolean();
            boolean radialMirrorDrawPlanes = buf.readBoolean();
            r = new RadialMirror.RadialMirrorSettings(radialMirrorEnabled, radialMirrorPosition, radialMirrorSlices, radialMirrorAlternate, radialMirrorRadius, radialMirrorDrawLines, radialMirrorDrawPlanes);
        }
        ModifierSettingsManager.ModifierSettings modifierSettings = new ModifierSettingsManager.ModifierSettings(m, a, r, quickReplace, reachUpgrade);
        return new ModifierSettingsMessage(modifierSettings);
    }

    public static class Handler {
        public static void handle(ModifierSettingsMessage message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Player player = EffortlessBuilding.proxy.getPlayerEntityFromContext(ctx);
                ModifierSettingsManager.sanitize(message.modifierSettings, player);
                ModifierSettingsManager.setModifierSettings(player, message.modifierSettings);
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

