/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.network;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import nl.requios.effortlessbuilding.buildmode.BuildModes;
import nl.requios.effortlessbuilding.render.BlockPreviewRenderer;

public class BlockPlacedMessage {
    private final boolean blockHit;
    private final BlockPos blockPos;
    private final Direction sideHit;
    private final Vec3 hitVec;
    private final boolean placeStartPos;

    public BlockPlacedMessage() {
        this.blockHit = false;
        this.blockPos = BlockPos.f_121853_;
        this.sideHit = Direction.UP;
        this.hitVec = new Vec3(0.0, 0.0, 0.0);
        this.placeStartPos = true;
    }

    public BlockPlacedMessage(BlockHitResult result, boolean placeStartPos) {
        this.blockHit = result.m_6662_() == HitResult.Type.BLOCK;
        this.blockPos = result.m_82425_();
        this.sideHit = result.m_82434_();
        this.hitVec = result.m_82450_();
        this.placeStartPos = placeStartPos;
    }

    public BlockPlacedMessage(boolean blockHit, BlockPos blockPos, Direction sideHit, Vec3 hitVec, boolean placeStartPos) {
        this.blockHit = blockHit;
        this.blockPos = blockPos;
        this.sideHit = sideHit;
        this.hitVec = hitVec;
        this.placeStartPos = placeStartPos;
    }

    public static void encode(BlockPlacedMessage message, FriendlyByteBuf buf) {
        buf.writeBoolean(message.blockHit);
        buf.writeInt(message.blockPos.m_123341_());
        buf.writeInt(message.blockPos.m_123342_());
        buf.writeInt(message.blockPos.m_123343_());
        buf.writeInt(message.sideHit.m_122411_());
        buf.writeDouble(message.hitVec.f_82479_);
        buf.writeDouble(message.hitVec.f_82480_);
        buf.writeDouble(message.hitVec.f_82481_);
        buf.writeBoolean(message.placeStartPos);
    }

    public static BlockPlacedMessage decode(FriendlyByteBuf buf) {
        boolean blockHit = buf.readBoolean();
        BlockPos blockPos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        Direction sideHit = Direction.m_122376_((int)buf.readInt());
        Vec3 hitVec = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        boolean placeStartPos = buf.readBoolean();
        return new BlockPlacedMessage(blockHit, blockPos, sideHit, hitVec, placeStartPos);
    }

    public boolean isBlockHit() {
        return this.blockHit;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public Direction getSideHit() {
        return this.sideHit;
    }

    public Vec3 getHitVec() {
        return this.hitVec;
    }

    public boolean getPlaceStartPos() {
        return this.placeStartPos;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ClientHandler {
        public static void handle(BlockPlacedMessage message, Supplier<NetworkEvent.Context> ctx) {
            BlockPreviewRenderer.onBlocksPlaced();
        }
    }

    public static class Handler {
        public static void handle(BlockPlacedMessage message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                    DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> Handler.lambda$handle$1(message, (Supplier)ctx));
                } else {
                    BuildModes.onBlockPlacedMessage((Player)((NetworkEvent.Context)ctx.get()).getSender(), message);
                }
            });
            ctx.get().setPacketHandled(true);
        }

        private static /* synthetic */ Runnable lambda$handle$1(BlockPlacedMessage message, Supplier ctx) {
            return () -> Handler.lambda$handle$0(message, (Supplier)ctx);
        }

        private static /* synthetic */ void lambda$handle$0(BlockPlacedMessage message, Supplier ctx) {
            ClientHandler.handle(message, ctx);
        }
    }
}

