/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.buildmodifier;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import nl.requios.effortlessbuilding.buildmodifier.BuildModifiers;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.item.AbstractRandomizerBagItem;

public class Mirror {
    public static List<BlockPos> findCoordinates(Player player, BlockPos startPos) {
        ArrayList<BlockPos> coordinates = new ArrayList<BlockPos>();
        MirrorSettings m = ModifierSettingsManager.getModifierSettings(player).getMirrorSettings();
        if (!Mirror.isEnabled(m, startPos)) {
            return coordinates;
        }
        if (m.mirrorX) {
            Mirror.coordinateMirrorX(m, startPos, coordinates);
        }
        if (m.mirrorY) {
            Mirror.coordinateMirrorY(m, startPos, coordinates);
        }
        if (m.mirrorZ) {
            Mirror.coordinateMirrorZ(m, startPos, coordinates);
        }
        return coordinates;
    }

    private static void coordinateMirrorX(MirrorSettings m, BlockPos oldBlockPos, List<BlockPos> coordinates) {
        double x = m.position.f_82479_ + (m.position.f_82479_ - (double)oldBlockPos.m_123341_() - 0.5);
        BlockPos newBlockPos = new BlockPos(x, (double)oldBlockPos.m_123342_(), (double)oldBlockPos.m_123343_());
        coordinates.add(newBlockPos);
        if (m.mirrorY) {
            Mirror.coordinateMirrorY(m, newBlockPos, coordinates);
        }
        if (m.mirrorZ) {
            Mirror.coordinateMirrorZ(m, newBlockPos, coordinates);
        }
    }

    private static void coordinateMirrorY(MirrorSettings m, BlockPos oldBlockPos, List<BlockPos> coordinates) {
        double y = m.position.f_82480_ + (m.position.f_82480_ - (double)oldBlockPos.m_123342_() - 0.5);
        BlockPos newBlockPos = new BlockPos((double)oldBlockPos.m_123341_(), y, (double)oldBlockPos.m_123343_());
        coordinates.add(newBlockPos);
        if (m.mirrorZ) {
            Mirror.coordinateMirrorZ(m, newBlockPos, coordinates);
        }
    }

    private static void coordinateMirrorZ(MirrorSettings m, BlockPos oldBlockPos, List<BlockPos> coordinates) {
        double z = m.position.f_82481_ + (m.position.f_82481_ - (double)oldBlockPos.m_123343_() - 0.5);
        BlockPos newBlockPos = new BlockPos((double)oldBlockPos.m_123341_(), (double)oldBlockPos.m_123342_(), z);
        coordinates.add(newBlockPos);
    }

    public static List<BlockState> findBlockStates(Player player, BlockPos startPos, BlockState blockState, ItemStack itemStack, List<ItemStack> itemStacks) {
        ArrayList<BlockState> blockStates = new ArrayList<BlockState>();
        MirrorSettings m = ModifierSettingsManager.getModifierSettings(player).getMirrorSettings();
        if (!Mirror.isEnabled(m, startPos)) {
            return blockStates;
        }
        AbstractRandomizerBagItem randomizerBagItem = null;
        IItemHandler bagInventory = null;
        if (!itemStack.m_41619_() && itemStack.m_41720_() instanceof AbstractRandomizerBagItem) {
            randomizerBagItem = (AbstractRandomizerBagItem)itemStack.m_41720_();
            bagInventory = randomizerBagItem.getBagInventory(itemStack);
        }
        if (m.mirrorX) {
            Mirror.blockStateMirrorX(player, m, startPos, blockState, bagInventory, itemStack, InteractionHand.MAIN_HAND, blockStates, itemStacks);
        }
        if (m.mirrorY) {
            Mirror.blockStateMirrorY(player, m, startPos, blockState, bagInventory, itemStack, InteractionHand.MAIN_HAND, blockStates, itemStacks);
        }
        if (m.mirrorZ) {
            Mirror.blockStateMirrorZ(player, m, startPos, blockState, bagInventory, itemStack, InteractionHand.MAIN_HAND, blockStates, itemStacks);
        }
        return blockStates;
    }

    private static void blockStateMirrorX(Player player, MirrorSettings m, BlockPos oldBlockPos, BlockState oldBlockState, IItemHandler bagInventory, ItemStack itemStack, InteractionHand hand, List<BlockState> blockStates, List<ItemStack> itemStacks) {
        double x = m.position.f_82479_ + (m.position.f_82479_ - (double)oldBlockPos.m_123341_() - 0.5);
        BlockPos newBlockPos = new BlockPos(x, (double)oldBlockPos.m_123342_(), (double)oldBlockPos.m_123343_());
        if (bagInventory != null) {
            itemStack = ((AbstractRandomizerBagItem)itemStack.m_41720_()).pickRandomStack(bagInventory);
            oldBlockState = BuildModifiers.getBlockStateFromItem(itemStack, player, oldBlockPos, Direction.UP, new Vec3(0.0, 0.0, 0.0), hand);
        }
        BlockState newBlockState = oldBlockState == null ? null : oldBlockState.m_60715_(net.minecraft.world.level.block.Mirror.FRONT_BACK);
        blockStates.add(newBlockState);
        itemStacks.add(itemStack);
        if (m.mirrorY) {
            Mirror.blockStateMirrorY(player, m, newBlockPos, newBlockState, bagInventory, itemStack, hand, blockStates, itemStacks);
        }
        if (m.mirrorZ) {
            Mirror.blockStateMirrorZ(player, m, newBlockPos, newBlockState, bagInventory, itemStack, hand, blockStates, itemStacks);
        }
    }

    private static void blockStateMirrorY(Player player, MirrorSettings m, BlockPos oldBlockPos, BlockState oldBlockState, IItemHandler bagInventory, ItemStack itemStack, InteractionHand hand, List<BlockState> blockStates, List<ItemStack> itemStacks) {
        double y = m.position.f_82480_ + (m.position.f_82480_ - (double)oldBlockPos.m_123342_() - 0.5);
        BlockPos newBlockPos = new BlockPos((double)oldBlockPos.m_123341_(), y, (double)oldBlockPos.m_123343_());
        if (bagInventory != null) {
            itemStack = ((AbstractRandomizerBagItem)itemStack.m_41720_()).pickRandomStack(bagInventory);
            oldBlockState = BuildModifiers.getBlockStateFromItem(itemStack, player, oldBlockPos, Direction.UP, new Vec3(0.0, 0.0, 0.0), hand);
        }
        BlockState newBlockState = oldBlockState == null ? null : Mirror.getVerticalMirror(oldBlockState);
        blockStates.add(newBlockState);
        itemStacks.add(itemStack);
        if (m.mirrorZ) {
            Mirror.blockStateMirrorZ(player, m, newBlockPos, newBlockState, bagInventory, itemStack, hand, blockStates, itemStacks);
        }
    }

    private static void blockStateMirrorZ(Player player, MirrorSettings m, BlockPos oldBlockPos, BlockState oldBlockState, IItemHandler bagInventory, ItemStack itemStack, InteractionHand hand, List<BlockState> blockStates, List<ItemStack> itemStacks) {
        double z = m.position.f_82481_ + (m.position.f_82481_ - (double)oldBlockPos.m_123343_() - 0.5);
        BlockPos newBlockPos = new BlockPos((double)oldBlockPos.m_123341_(), (double)oldBlockPos.m_123342_(), z);
        if (bagInventory != null) {
            itemStack = ((AbstractRandomizerBagItem)itemStack.m_41720_()).pickRandomStack(bagInventory);
            oldBlockState = BuildModifiers.getBlockStateFromItem(itemStack, player, oldBlockPos, Direction.UP, new Vec3(0.0, 0.0, 0.0), hand);
        }
        BlockState newBlockState = oldBlockState == null ? null : oldBlockState.m_60715_(net.minecraft.world.level.block.Mirror.LEFT_RIGHT);
        blockStates.add(newBlockState);
        itemStacks.add(itemStack);
    }

    public static boolean isEnabled(MirrorSettings m, BlockPos startPos) {
        if (m == null || !m.enabled || !m.mirrorX && !m.mirrorY && !m.mirrorZ) {
            return false;
        }
        return !((double)startPos.m_123341_() + 0.5 < m.position.f_82479_ - (double)m.radius || (double)startPos.m_123341_() + 0.5 > m.position.f_82479_ + (double)m.radius || (double)startPos.m_123342_() + 0.5 < m.position.f_82480_ - (double)m.radius || (double)startPos.m_123342_() + 0.5 > m.position.f_82480_ + (double)m.radius || (double)startPos.m_123343_() + 0.5 < m.position.f_82481_ - (double)m.radius || (double)startPos.m_123343_() + 0.5 > m.position.f_82481_ + (double)m.radius);
    }

    private static BlockState getVerticalMirror(BlockState blockState) {
        if (blockState.m_60734_() instanceof StairBlock) {
            if (blockState.m_61143_((Property)StairBlock.f_56842_) == Half.BOTTOM) {
                return (BlockState)blockState.m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.TOP);
            }
            return (BlockState)blockState.m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.BOTTOM);
        }
        if (blockState.m_60734_() instanceof SlabBlock) {
            if (blockState.m_61143_((Property)SlabBlock.f_56353_) == SlabType.DOUBLE) {
                return blockState;
            }
            if (blockState.m_61143_((Property)SlabBlock.f_56353_) == SlabType.BOTTOM) {
                return (BlockState)blockState.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP);
            }
            return (BlockState)blockState.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.BOTTOM);
        }
        if (blockState.m_60734_() instanceof DirectionalBlock) {
            if (blockState.m_61143_((Property)DirectionalBlock.f_52588_) == Direction.DOWN) {
                return (BlockState)blockState.m_61124_((Property)DirectionalBlock.f_52588_, (Comparable)Direction.UP);
            }
            if (blockState.m_61143_((Property)DirectionalBlock.f_52588_) == Direction.UP) {
                return (BlockState)blockState.m_61124_((Property)DirectionalBlock.f_52588_, (Comparable)Direction.DOWN);
            }
        }
        if (blockState.m_60734_() instanceof DispenserBlock) {
            if (blockState.m_61143_((Property)DispenserBlock.f_52659_) == Direction.DOWN) {
                return (BlockState)blockState.m_61124_((Property)DispenserBlock.f_52659_, (Comparable)Direction.UP);
            }
            if (blockState.m_61143_((Property)DispenserBlock.f_52659_) == Direction.UP) {
                return (BlockState)blockState.m_61124_((Property)DispenserBlock.f_52659_, (Comparable)Direction.DOWN);
            }
        }
        return blockState;
    }

    public static class MirrorSettings {
        public boolean enabled = false;
        public Vec3 position = new Vec3(0.5, 64.5, 0.5);
        public boolean mirrorX = true;
        public boolean mirrorY = false;
        public boolean mirrorZ = false;
        public int radius = 10;
        public boolean drawLines = true;
        public boolean drawPlanes = true;

        public MirrorSettings() {
        }

        public MirrorSettings(boolean mirrorEnabled, Vec3 position, boolean mirrorX, boolean mirrorY, boolean mirrorZ, int radius, boolean drawLines, boolean drawPlanes) {
            this.enabled = mirrorEnabled;
            this.position = position;
            this.mirrorX = mirrorX;
            this.mirrorY = mirrorY;
            this.mirrorZ = mirrorZ;
            this.radius = radius;
            this.drawLines = drawLines;
            this.drawPlanes = drawPlanes;
        }

        public int getReach() {
            return this.radius * 2;
        }
    }
}

