/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.theme;

import de.matthiasmann.twl.Border;
import de.matthiasmann.twl.Color;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.renderer.Image;
import de.matthiasmann.twl.theme.HasBorder;
import de.matthiasmann.twl.utils.StateSelect;

public class StateSelectImage
implements Image,
HasBorder {
    final Image[] images;
    final StateSelect select;
    final Border border;

    public StateSelectImage(StateSelect select, Border border, Image ... images) {
        assert (images.length >= select.getNumExpressions());
        assert (images.length <= select.getNumExpressions() + 1);
        this.images = images;
        this.select = select;
        this.border = border;
    }

    @Override
    public int getWidth() {
        return this.images[0].getWidth();
    }

    @Override
    public int getHeight() {
        return this.images[0].getHeight();
    }

    @Override
    public void draw(AnimationState as, int x, int y) {
        this.draw(as, x, y, this.getWidth(), this.getHeight());
    }

    @Override
    public void draw(AnimationState as, int x, int y, int width, int height) {
        int idx = this.select.evaluate(as);
        if (idx < this.images.length) {
            this.images[idx].draw(as, x, y, width, height);
        }
    }

    @Override
    public Border getBorder() {
        return this.border;
    }

    @Override
    public Image createTintedVersion(Color color) {
        Image[] newImages = new Image[this.images.length];
        for (int i = 0; i < newImages.length; ++i) {
            newImages[i] = this.images[i].createTintedVersion(color);
        }
        return new StateSelectImage(this.select, this.border, newImages);
    }
}

