/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Objects;

import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;

public enum ArrowCharacters {
    RIGHT(8250, 0, 44),
    UPRIGHT(8989, 45, 89),
    UP(6356, 90, 134),
    UPLEFT(8988, 135, 179),
    LEFT(8249, 180, 224),
    DOWNLEFT(8990, 225, 269),
    DOWN(9013, 270, 314),
    DOWNRIGHT(8991, 315, 359);

    private static final ArrowCharacters[] arrowList;
    private char[] ch;
    private int min;
    private int max;

    private ArrowCharacters(int c, int lo, int hi) {
        this.ch = Character.toChars(c);
        this.min = lo;
        this.max = hi;
    }

    public static ArrowCharacters getFromAngle(double ang) {
        ang %= 360.0;
        for (int i = 0; i < arrowList.length; ++i) {
            if (!ReikaMathLibrary.isValueInsideBoundsIncl((double)arrowList[i].getMinAngle(), (double)arrowList[i].getMaxAngle(), ang)) continue;
            return arrowList[i];
        }
        return null;
    }

    public int getMinAngle() {
        return this.min;
    }

    public int getMaxAngle() {
        return this.max;
    }

    public String getStringValue() {
        return new String(this.ch);
    }

    static {
        arrowList = ArrowCharacters.values();
    }
}

