/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.ItemHandlers;

import Reika.DragonAPI.Base.CropHandlerBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModOreList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class MagicCropHandler
extends CropHandlerBase {
    public final Block oreID;
    public final Block netherOreID;
    public final Block endOreID;
    private final int configChance;
    private static final MagicCropHandler instance = new MagicCropHandler();

    private MagicCropHandler() {
        Block idore = null;
        Block idnether = null;
        Block idend = null;
        int chance = -1;
        if (this.hasMod()) {
            try {
                Enum type;
                int i;
                Class blocks = this.getMod().getBlockClass();
                Class<?> crops = Class.forName("com.mark719.magicalcrops.handlers.MCrops");
                Class<?> seeds = Class.forName("com.mark719.magicalcrops.handlers.MSeeds");
                Class<?> essences = Class.forName("com.mark719.magicalcrops.handlers.Essence");
                Class<?> mods = Class.forName("com.mark719.magicalcrops.handlers.ModCompat");
                for (i = 0; i < EssenceType.essenceList.length; ++i) {
                    type = EssenceType.essenceList[i];
                    String cropf = ((EssenceType)type).getCropFieldName();
                    String seedf = ((EssenceType)type).getSeedFieldName();
                    String essf = ((EssenceType)type).getEssenceFieldName();
                    try {
                        Item essence;
                        Item seed;
                        Block crop;
                        Field f;
                        if (((EssenceType)type).isModEssence()) {
                            f = mods.getField(cropf);
                            crop = (Block)f.get(null);
                            f = mods.getField(seedf);
                            seed = (Item)f.get(null);
                            f = mods.getField(essf);
                            essence = (Item)f.get(null);
                        } else {
                            f = crops.getField(cropf);
                            crop = (Block)f.get(null);
                            f = seeds.getField(seedf);
                            seed = (Item)f.get(null);
                            f = essences.getField(essf);
                            essence = (Item)f.get(null);
                        }
                        ((EssenceType)type).setIDs(crop, seed, essence);
                        continue;
                    }
                    catch (NoSuchFieldException e) {
                        DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
                        e.printStackTrace();
                        this.logFailure(e);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        DragonAPICore.logError("Illegal access exception for reading " + this.getMod() + "!");
                        e.printStackTrace();
                        this.logFailure(e);
                        continue;
                    }
                    catch (NullPointerException e) {
                        DragonAPICore.logError("Null pointer exception for reading " + this.getMod() + "! Was the class loaded?");
                        e.printStackTrace();
                        this.logFailure(e);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.logFailure(e);
                    }
                }
                for (i = 0; i < MiscEssence.list.length; ++i) {
                    type = MiscEssence.list[i];
                    String essf = ((MiscEssence)type).getEssenceFieldName();
                    try {
                        Field f = essences.getField(essf);
                        Item essence = (Item)f.get(null);
                        ((MiscEssence)type).setIDs(essence);
                        continue;
                    }
                    catch (NoSuchFieldException e) {
                        DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
                        e.printStackTrace();
                        this.logFailure(e);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        DragonAPICore.logError("Illegal access exception for reading " + this.getMod() + "!");
                        e.printStackTrace();
                        this.logFailure(e);
                        continue;
                    }
                    catch (NullPointerException e) {
                        DragonAPICore.logError("Null pointer exception for reading " + this.getMod() + "! Was the class loaded?");
                        e.printStackTrace();
                        this.logFailure(e);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.logFailure(e);
                    }
                }
                try {
                    Block ore;
                    Field f = blocks.getField("MinicioOre");
                    idore = ore = (Block)f.get(null);
                    f = blocks.getField("MinicioOreNether");
                    idnether = ore = (Block)f.get(null);
                    f = blocks.getField("MinicioOreEnd");
                    idend = ore = (Block)f.get(null);
                }
                catch (NoSuchFieldException e) {
                    DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
                    e.printStackTrace();
                    this.logFailure(e);
                }
                catch (IllegalAccessException e) {
                    DragonAPICore.logError("Illegal access exception for reading " + this.getMod() + "!");
                    e.printStackTrace();
                    this.logFailure(e);
                }
                catch (NullPointerException e) {
                    DragonAPICore.logError("Null pointer exception for reading " + this.getMod() + "! Was the class loaded?");
                    e.printStackTrace();
                    this.logFailure(e);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.logFailure(e);
                }
                try {
                    Class<?> c = Class.forName("com.mark719.magicalcrops.config.ConfigMain");
                    Field f = c.getDeclaredField("SECOND_SEED_CHANCE");
                    f.setAccessible(true);
                    chance = f.getInt(null);
                }
                catch (ClassNotFoundException e) {
                    DragonAPICore.logError(this.getMod() + " class not found! " + e.getMessage());
                    e.printStackTrace();
                    this.logFailure(e);
                }
                catch (NoSuchFieldException e) {
                    DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
                    e.printStackTrace();
                    this.logFailure(e);
                }
                catch (IllegalAccessException e) {
                    DragonAPICore.logError("Illegal access exception for reading " + this.getMod() + "!");
                    e.printStackTrace();
                    this.logFailure(e);
                }
                catch (NullPointerException e) {
                    DragonAPICore.logError("Null pointer exception for reading " + this.getMod() + "! Was the class loaded?");
                    e.printStackTrace();
                    this.logFailure(e);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.logFailure(e);
                }
            }
            catch (ClassNotFoundException e) {
                DragonAPICore.logError(this.getMod() + " class not found! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
        } else {
            this.noMod();
        }
        this.oreID = idore;
        this.netherOreID = idnether;
        this.endOreID = idend;
        this.configChance = chance >= 0 ? chance : 10;
    }

    @Override
    public boolean isCrop(Block id, int meta) {
        return EssenceType.cropIDs.containsKey(id);
    }

    @Override
    public boolean isSeedItem(ItemStack is) {
        return EssenceType.seedIDs.containsKey(is.func_77973_b());
    }

    @Override
    public boolean isRipeCrop(World world, int x, int y, int z) {
        int meta;
        Block b = world.func_147439_a(x, y, z);
        return this.isCrop(b, meta = world.func_72805_g(x, y, z)) && meta == 7;
    }

    @Override
    public void makeRipe(World world, int x, int y, int z) {
        world.func_72921_c(x, y, z, 7, 3);
    }

    public static MagicCropHandler getInstance() {
        return instance;
    }

    @Override
    public boolean initializedProperly() {
        return EssenceType.initialized() && MiscEssence.initialized() && this.configChance != -1 && this.oreID != null && this.netherOreID != null && this.endOreID != null;
    }

    public boolean isEssenceOre(Block id) {
        return id == this.netherOreID || id == this.oreID || id == this.endOreID;
    }

    @Override
    public ModList getMod() {
        return ModList.MAGICCROPS;
    }

    @Override
    public int getHarvestedMeta(World world, int x, int y, int z) {
        return 0;
    }

    @Override
    public ArrayList<ItemStack> getAdditionalDrops(World world, int x, int y, int z, Block id, int meta, int fortune) {
        ItemStack weak;
        ItemStack nature;
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        if (MiscEssence.CHRISTMAS.item != null && ReikaRandomHelper.doWithChance(20 * (1 + fortune))) {
            li.add(MiscEssence.CHRISTMAS.getItem());
        }
        if ((nature = EssenceType.NATURE.getEssence()) != null && ReikaRandomHelper.doWithChance(20 * (1 + fortune))) {
            li.add(nature);
        }
        if (ReikaRandomHelper.doWithChance(20 * (1 + fortune)) && (weak = EssenceType.ESSENCE.getEssence()) != null) {
            li.add(weak);
            if (ReikaRandomHelper.doWithChance(25 * (1 + fortune))) {
                li.add(weak);
            }
        }
        return li;
    }

    public void registerEssence() {
        ItemStack ore = new ItemStack(this.oreID, 1, 0);
        OreDictionary.registerOre((String)"oreEssence", (ItemStack)ore);
        ore = new ItemStack(this.netherOreID, 1, 0);
        OreDictionary.registerOre((String)"oreNetherEssence", (ItemStack)ore);
        ore = new ItemStack(this.endOreID, 1, 0);
        OreDictionary.registerOre((String)"oreEndEssence", (ItemStack)ore);
        ModOreList.ESSENCE.initialize();
        DragonAPICore.log("Registering Magic Crops Essence ore to the Ore Dictionary!");
    }

    @Override
    public ArrayList<ItemStack> getDropsOverride(World world, int x, int y, int z, Block id, int meta, int fortune) {
        return null;
    }

    @Override
    public int getGrowthState(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    @Override
    public boolean neverDropsSecondSeed() {
        return this.configChance == 0;
    }

    public static enum MiscEssence {
        CHRISTMAS("Christmas"),
        TAINTED("Tainted"),
        ACCIO("Accio"),
        CRUCIO("Crucio"),
        IMPERIO("Imperio"),
        ZIVICIO("Zivicio");

        private final String field;
        private Item item;
        private static final MiscEssence[] list;
        private static final HashMap<Item, MiscEssence> itemMap;

        private MiscEssence(String s) {
            this.field = s;
        }

        public ItemStack getItem() {
            return this.item != null ? new ItemStack(this.item) : null;
        }

        private void setIDs(Item essence) {
            this.item = essence;
            itemMap.put(essence, this);
        }

        public String getEssenceFieldName() {
            return this.field + "Essence";
        }

        private static boolean initialized() {
            return itemMap.size() == list.length;
        }

        static {
            list = MiscEssence.values();
            itemMap = new HashMap();
        }
    }

    private static enum EssenceClass {
        ANIMAL,
        MOB,
        MATERIAL,
        ELEMENT,
        POTION,
        MOD;

    }

    public static enum EssenceType {
        COW(EssenceClass.ANIMAL, "Cow"),
        SHEEP(EssenceClass.ANIMAL, "Sheep"),
        PIG(EssenceClass.ANIMAL, "Pig"),
        CHICKEN(EssenceClass.ANIMAL, "Chicken"),
        CREEPER(EssenceClass.MOB, "Creeper"),
        MAGMA(EssenceClass.MOB, "Magma"),
        SKELETON(EssenceClass.MOB, "Skeleton"),
        SLIME(EssenceClass.MOB, "Slime"),
        SPIDER(EssenceClass.MOB, "Spider"),
        GHAST(EssenceClass.MOB, "Ghast"),
        WITHER(EssenceClass.MOB, "Wither"),
        BLAZE(EssenceClass.MOB, "Blaze"),
        ENDER(EssenceClass.MOB, "Enderman"),
        ESSENCE(EssenceClass.MATERIAL, "Minicio"),
        NATURE(EssenceClass.MATERIAL, "Nature"),
        COAL(EssenceClass.MATERIAL, "Coal"),
        DYE(EssenceClass.MATERIAL, "Dye"),
        REDSTONE(EssenceClass.MATERIAL, "Redstone"),
        GLOWSTONE(EssenceClass.MATERIAL, "Glowstone"),
        OBSIDIAN(EssenceClass.MATERIAL, "Obsidian"),
        IRON(EssenceClass.MATERIAL, "Iron"),
        GOLD(EssenceClass.MATERIAL, "Gold"),
        LAPIS(EssenceClass.MATERIAL, "Lapis"),
        QUARTZ(EssenceClass.MATERIAL, "Quartz"),
        XP(EssenceClass.MATERIAL, "Experience"),
        DIAMOND(EssenceClass.MATERIAL, "Diamond"),
        EMERALD(EssenceClass.MATERIAL, "Emerald"),
        NETHER(EssenceClass.MATERIAL, "Nether"),
        WATER(EssenceClass.ELEMENT, "Water"),
        FIRE(EssenceClass.ELEMENT, "Fire"),
        EARTH(EssenceClass.ELEMENT, "Earth"),
        AIR(EssenceClass.ELEMENT, "Air"),
        ALUMINUM(EssenceClass.MOD, "Aluminium"),
        ARDITE(EssenceClass.MOD, "Ardite"),
        COBALT(EssenceClass.MOD, "Cobalt"),
        COPPER(EssenceClass.MOD, "Copper"),
        CERTUS(EssenceClass.MOD, "CertusQuartz"),
        LEAD(EssenceClass.MOD, "Lead"),
        NICKEL(EssenceClass.MOD, "Nickel"),
        OSMIUM(EssenceClass.MOD, "Osmium"),
        PERIDOT(EssenceClass.MOD, "Peridot"),
        RUBY(EssenceClass.MOD, "Ruby"),
        SAPPHIRE(EssenceClass.MOD, "Sapphire"),
        PLATINUM(EssenceClass.MOD, "Platinum"),
        RUBBER(EssenceClass.MOD, "Rubber"),
        SILVER(EssenceClass.MOD, "Silver"),
        TIN(EssenceClass.MOD, "Tin"),
        SULFUR(EssenceClass.MOD, "Sulfur"),
        YELLORITE(EssenceClass.MOD, "Yellorite"),
        ALUMITE(EssenceClass.MOD, "Alumite"),
        BLIZZ(EssenceClass.MOD, "Blizz"),
        BRONZE(EssenceClass.MOD, "Bronze"),
        ELECTRUM(EssenceClass.MOD, "Electrum"),
        ENDERIUM(EssenceClass.MOD, "Enderium"),
        FLUIX(EssenceClass.MOD, "Fluix"),
        INVAR(EssenceClass.MOD, "Invar"),
        LUMIUM(EssenceClass.MOD, "Lumium"),
        MANASTEEL(EssenceClass.MOD, "Manasteel"),
        MANYULLYN(EssenceClass.MOD, "Manyullyn"),
        SALTPETER(EssenceClass.MOD, "Saltpeter"),
        SIGNALUM(EssenceClass.MOD, "Signalum"),
        STEEL(EssenceClass.MOD, "Steel"),
        TERRASTEEL(EssenceClass.MOD, "Terrasteel");

        private final EssenceClass type;
        private final String tag;
        private Block cropID = null;
        private Item seedID = null;
        private Item essenceID = null;
        private static final EssenceType[] essenceList;
        private static final HashMap<Block, EssenceType> cropIDs;
        private static final HashMap<Item, EssenceType> essenceIDs;
        private static final HashMap<Item, EssenceType> seedIDs;

        private EssenceType(EssenceClass c, String name) {
            this.type = c;
            this.tag = name;
        }

        private void setIDs(Block crop, Item seed, Item essence) {
            this.seedID = seed;
            this.cropID = crop;
            this.essenceID = essence;
            cropIDs.put(crop, this);
            seedIDs.put(seed, this);
            essenceIDs.put(essence, this);
        }

        private String getSeedFieldName() {
            return this.tag + "Seeds";
        }

        private String getEssenceFieldName() {
            return this.tag + "Essence";
        }

        private String getCropFieldName() {
            return this.tag + "Crop";
        }

        public ItemStack getEssence() {
            return this.essenceID != null ? new ItemStack(this.essenceID) : null;
        }

        public ItemStack getSeeds() {
            return this.seedID != null ? new ItemStack(this.seedID, 1, 0) : null;
        }

        public ItemStack getCrop() {
            return this.cropID != null ? new ItemStack(this.cropID, 1, 0) : null;
        }

        private static boolean initialized() {
            int len = essenceList.length;
            return cropIDs.size() == len && seedIDs.size() == len && essenceIDs.size() == len;
        }

        public boolean isModEssence() {
            return this.type == EssenceClass.MOD;
        }

        static {
            essenceList = EssenceType.values();
            cropIDs = new HashMap();
            essenceIDs = new HashMap();
            seedIDs = new HashMap();
        }
    }
}

