/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.DeepInteract;

import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Auxiliary.Trackers.ReflectiveFailureTracker;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Extras.NeedsImplementation;
import Reika.DragonAPI.ModInteract.ItemHandlers.ExtraUtilsHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.MystCraftHandler;
import Reika.DragonAPI.ModInteract.ReikaTwilightHelper;
import Reika.DragonAPI.ModList;
import com.xcompwiz.mystcraft.api.APIInstanceProvider;
import com.xcompwiz.mystcraft.api.exception.APIUndefined;
import com.xcompwiz.mystcraft.api.exception.APIVersionRemoved;
import com.xcompwiz.mystcraft.api.exception.APIVersionUndefined;
import com.xcompwiz.mystcraft.api.hook.DimensionAPI;
import com.xcompwiz.mystcraft.api.hook.PageAPI;
import com.xcompwiz.mystcraft.api.hook.SymbolAPI;
import com.xcompwiz.mystcraft.api.hook.SymbolValuesAPI;
import com.xcompwiz.mystcraft.api.item.IItemOrderablePageProvider;
import com.xcompwiz.mystcraft.api.item.IItemPageProvider;
import com.xcompwiz.mystcraft.api.linking.ILinkInfo;
import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.api.world.logic.IPopulate;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.event.FMLInterModComms;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.fluids.Fluid;

public class ReikaMystcraftHelper {
    private static final Random rand = new Random();
    private static final HashMap<Integer, AgeInterface> ageData = new HashMap();
    private static final Method getTile;
    private static final Method getBook;
    private static final Method getLink;
    private static final Class biomeWrapper;
    private static final Field parentBiome;
    private static APIInstanceProvider apiProvider;
    private static final int API_VERSION = 1;
    private static final ArrayList<MystcraftPageRegistry> registries;

    public static void disableFluidPage(Fluid f) {
        FMLInterModComms.sendMessage((String)ModList.MYSTCRAFT.modLabel, (String)"blacklistfluid", (String)f.getName());
    }

    public static void disableBiomePage(BiomeGenBase b) {
        FMLInterModComms.sendMessage((String)ModList.MYSTCRAFT.modLabel, (String)"blacklist", (String)("Biome" + b.field_76756_M));
    }

    private static ILinkInfo getPortalInfo(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        if (b != MystCraftHandler.getInstance().portalID) {
            return null;
        }
        try {
            TileEntity te = (TileEntity)getTile.invoke((Object)MystCraftHandler.getInstance().portalID, world, x, y, z);
            ItemStack book = (ItemStack)getBook.invoke((Object)te, new Object[0]);
            if (book == null) {
                return null;
            }
            ILinkInfo info = ReikaMystcraftHelper.getLinkbookLink(book);
            return info;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ILinkInfo getLinkbookLink(ItemStack book) {
        try {
            return (ILinkInfo)getLink.invoke((Object)book.func_77973_b(), book);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getTargetDimensionIDFromPortalBlock(World world, int x, int y, int z) {
        ILinkInfo info = ReikaMystcraftHelper.getPortalInfo(world, x, y, z);
        return info != null ? info.getDimensionUID() : Integer.MIN_VALUE;
    }

    public static boolean isMystAge(World world) {
        int id = world.field_73011_w.field_76574_g;
        if (id == 0 || id == 1 || id == -1 || id == ReikaTwilightHelper.getDimensionID() || id == ExtraUtilsHandler.getInstance().darkID) {
            return false;
        }
        DimensionAPI d = (DimensionAPI)ReikaMystcraftHelper.getAPI(APISegment.DIMENSION);
        return world.field_73011_w.getClass().getSimpleName().equals("WorldProviderMyst");
    }

    public static int getInstabilityScoreForAge(World world) {
        if (!AgeInterface.loadedCorrectly) {
            return 0;
        }
        return ReikaMystcraftHelper.isMystAge(world) ? ReikaMystcraftHelper.getOrCreateInterface(world).getInstabilityScore() : 0;
    }

    public static int getBlockInstabilityForAge(World world) {
        if (!AgeInterface.loadedCorrectly) {
            return 0;
        }
        return ReikaMystcraftHelper.isMystAge(world) ? ReikaMystcraftHelper.getOrCreateInterface(world).getBlockInstability() : 0;
    }

    public static int getSymbolInstabilityForAge(World world) {
        if (!AgeInterface.loadedCorrectly) {
            return 0;
        }
        return ReikaMystcraftHelper.isMystAge(world) ? ReikaMystcraftHelper.getOrCreateInterface(world).getSymbolInstability() : 0;
    }

    public static short getBaseInstabilityForAge(World world) {
        if (!AgeInterface.loadedCorrectly) {
            return 0;
        }
        return ReikaMystcraftHelper.isMystAge(world) ? ReikaMystcraftHelper.getOrCreateInterface(world).getBaseInstability() : (short)0;
    }

    public static int decrInstabilityForAge(World world, int amt) {
        if (!AgeInterface.loadedCorrectly) {
            return 0;
        }
        return ReikaMystcraftHelper.isMystAge(world) ? ReikaMystcraftHelper.getOrCreateInterface(world).decrInstability(amt) : 0;
    }

    public static void addInstabilityForAge(World world, short amt) {
        if (AgeInterface.loadedCorrectly && ReikaMystcraftHelper.isMystAge(world)) {
            ReikaMystcraftHelper.getOrCreateInterface(world).addBaseInstability(amt);
        }
    }

    public static boolean isSymbolPresent(World world, String sym) {
        if (AgeInterface.loadedCorrectly && ReikaMystcraftHelper.isMystAge(world)) {
            return ReikaMystcraftHelper.getOrCreateInterface(world).symbolExists(sym);
        }
        return false;
    }

    public static Set<String> getAgeSymbols(World world) {
        if (AgeInterface.loadedCorrectly && ReikaMystcraftHelper.isMystAge(world)) {
            return ReikaMystcraftHelper.getOrCreateInterface(world).getSymbols();
        }
        return new HashSet<String>();
    }

    private static AgeInterface getOrCreateInterface(World world) {
        if (!AgeInterface.loadedCorrectly) {
            return null;
        }
        AgeInterface ii = ageData.get(world.field_73011_w.field_76574_g);
        if (ii == null) {
            ii = new AgeInterface(world);
            ageData.put(world.field_73011_w.field_76574_g, ii);
        }
        return ii;
    }

    public static ArrayList<IAgeSymbol> getAllSymbols() {
        ArrayList<IAgeSymbol> c = new ArrayList<IAgeSymbol>();
        SymbolAPI api = (SymbolAPI)ReikaMystcraftHelper.getAPI(APISegment.SYMBOL);
        if (api != null) {
            c.addAll(api.getAllRegisteredSymbols());
        }
        return c;
    }

    public static ArrayList<ItemStack> getAllAgePages() {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        ArrayList<IAgeSymbol> c = ReikaMystcraftHelper.getAllSymbols();
        for (IAgeSymbol a : c) {
            li.add(ReikaMystcraftHelper.getSymbolPage(a));
        }
        return li;
    }

    public static ItemStack getSymbolPage(IAgeSymbol a) {
        ItemStack is;
        PageAPI api = (PageAPI)ReikaMystcraftHelper.getAPI(APISegment.PAGE);
        if (api != null && (is = new ItemStack((Item)Item.field_150901_e.func_82594_a(ModList.MYSTCRAFT.modLabel + ":" + "page"))) != null && is.func_77973_b() != null) {
            is.field_77990_d = new NBTTagCompound();
            api.setPageSymbol(is, a.identifier());
            return is;
        }
        return null;
    }

    public static ItemStack getSymbolPage(String id) {
        PageAPI api = (PageAPI)ReikaMystcraftHelper.getAPI(APISegment.PAGE);
        if (api != null) {
            SymbolAPI api2 = (SymbolAPI)ReikaMystcraftHelper.getAPI(APISegment.SYMBOL);
            IAgeSymbol ias = api2.getSymbol(id);
            if (ias == null) {
                throw new IllegalArgumentException("No such symbol '" + id + "'!");
            }
            ItemStack is = new ItemStack((Item)Item.field_150901_e.func_82594_a(ModList.MYSTCRAFT.modLabel + ":" + "page"));
            if (is != null && is.func_77973_b() != null) {
                is.field_77990_d = new NBTTagCompound();
                api.setPageSymbol(is, id);
                return is;
            }
        }
        return null;
    }

    public static int getSymbolRank(IAgeSymbol ia) {
        return (int)((SymbolValuesAPI)ReikaMystcraftHelper.getAPI(APISegment.SYMBOLVALUES)).getSymbolItemWeight(ia.identifier());
    }

    public static IAgeSymbol getRandomPage() {
        ArrayList<IAgeSymbol> c = ReikaMystcraftHelper.getAllSymbols();
        return c.get(rand.nextInt(c.size()));
    }

    public static float getPageWeight(IAgeSymbol a) {
        SymbolValuesAPI api = (SymbolValuesAPI)ReikaMystcraftHelper.getAPI(APISegment.SYMBOLVALUES);
        if (api != null) {
            return api.getSymbolItemWeight(a.identifier());
        }
        return 0.0f;
    }

    public static void setPageRank(IAgeSymbol a, int rank) {
        SymbolValuesAPI api = (SymbolValuesAPI)ReikaMystcraftHelper.getAPI(APISegment.SYMBOLVALUES);
        if (api != null) {
            api.setSymbolCardRank(a, rank);
        }
    }

    @NeedsImplementation
    public static void setRandomAgeWeight(IAgeSymbol a, float weight) {
    }

    public static void registerAgeSymbol(IAgeSymbol a) {
        SymbolAPI api = (SymbolAPI)ReikaMystcraftHelper.getAPI(APISegment.SYMBOL);
        if (api != null) {
            boolean flag = api.registerSymbol(a, false);
            if (flag) {
                DragonAPICore.log("Registering MystCraft page '" + a.displayName() + "' (" + a.getClass() + "')");
            } else {
                DragonAPICore.logError("Could not register MystCraft page '" + a.displayName() + "' (" + a.getClass() + "')");
            }
        } else {
            DragonAPICore.logError("Could not register MystCraft page '" + a.displayName() + "' (" + a.getClass() + "'); API object was null.");
        }
    }

    @DependentMethodStripper.ModDependent(value=ModList.MYSTCRAFT)
    public static <A> A getAPI(APISegment type) {
        try {
            return (A)(apiProvider != null ? apiProvider.getAPIInstance(type.getTag(1)) : null);
        }
        catch (APIUndefined e) {
            throw new RuntimeException("Invalid API type coded into DragonAPI! This is a serious error!");
        }
        catch (APIVersionUndefined e) {
            e.printStackTrace();
        }
        catch (APIVersionRemoved e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void receiveAPI(APIInstanceProvider provider) {
        apiProvider = provider;
        for (MystcraftPageRegistry p : registries) {
            p.register();
        }
    }

    public static void registerPageRegistry(MystcraftPageRegistry p) {
        if (registries.contains(p)) {
            throw new MisuseException("You cannot register a MystCraft page provider twice!");
        }
        registries.add(p);
    }

    public static IAgeSymbol createIWorldGeneratorPage(IWorldGenerator gen, String[] poem, int instability) {
        return new IWGSymbol(gen, poem, instability);
    }

    public static List<ItemStack> getPagesInFolder(EntityPlayer ep, ItemStack is, boolean clear) {
        List li = ((IItemPageProvider)is.func_77973_b()).getPageList(ep, is);
        if (clear) {
            for (int i = 0; i < li.size(); ++i) {
                ((IItemOrderablePageProvider)is.func_77973_b()).removePage(ep, is, i);
            }
        }
        return li;
    }

    public static int getFlatWorldThickness(World world) {
        AgeInterface a = ReikaMystcraftHelper.getOrCreateInterface(world);
        return a != null ? a.getGroundLevel() : world.field_73011_w.func_76557_i();
    }

    public static BiomeGenBase getMystParentBiome(BiomeGenBase b) {
        if (b.getClass() != biomeWrapper) {
            return b;
        }
        try {
            return (BiomeGenBase)parentBiome.get(b);
        }
        catch (Exception e) {
            e.printStackTrace();
            return b;
        }
    }

    static {
        registries = new ArrayList();
        Method tile = null;
        Method book = null;
        Method link = null;
        Class<?> biome = null;
        Field base = null;
        boolean load = true;
        if (ModList.MYSTCRAFT.isLoaded()) {
            try {
                Class<?> portal = Class.forName("com.xcompwiz.mystcraft.portal.PortalUtils");
                tile = portal.getDeclaredMethod("getTileEntity", IBlockAccess.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                tile.setAccessible(true);
                Class<?> booktile = Class.forName("com.xcompwiz.mystcraft.tileentity.TileEntityBook");
                book = booktile.getDeclaredMethod("getBook", new Class[0]);
                book.setAccessible(true);
                Class<?> item = Class.forName("com.xcompwiz.mystcraft.item.ItemLinking");
                link = item.getDeclaredMethod("getLinkInfo", ItemStack.class);
                link.setAccessible(true);
                biome = Class.forName("com.xcompwiz.mystcraft.world.biome.BiomeWrapperMyst");
                base = biome.getDeclaredField("baseBiome");
                base.setAccessible(true);
            }
            catch (Exception e) {
                DragonAPICore.logError("Error loading Mystcraft linkbook interfacing!");
                e.printStackTrace();
                load = false;
                ReflectiveFailureTracker.instance.logModReflectiveFailure(ModList.MYSTCRAFT, e);
            }
        } else {
            load = false;
        }
        getTile = tile;
        getBook = book;
        getLink = link;
        biomeWrapper = biome;
        parentBiome = base;
    }

    public static class BasicAgeSymbol
    implements IAgeSymbol {
        public final String id;
        public final String name;
        private final String[] words;
        public final int instability;

        public BasicAgeSymbol(String id, String n, String[] poem) {
            this(id, n, poem, 0);
        }

        public BasicAgeSymbol(String id, String n, String[] poem, int inst) {
            this.id = id;
            this.name = n;
            this.words = poem;
            this.instability = inst;
        }

        public void registerLogic(AgeDirector controller, long seed) {
        }

        public int instabilityModifier(int count) {
            return this.instability;
        }

        public final String identifier() {
            return this.id;
        }

        public final String displayName() {
            return this.name;
        }

        public final String[] getPoem() {
            return this.words;
        }
    }

    private static final class IWGRelay
    implements IPopulate {
        private final IWorldGenerator generator;

        public IWGRelay(IWorldGenerator gen) {
            this.generator = gen;
        }

        public boolean populate(World world, Random rand, int x, int y, boolean flag) {
            IChunkProvider prov = world.func_72863_F();
            IChunkProvider gen = ((ChunkProviderServer)prov).field_73246_d;
            this.generator.generate(rand, x, y, world, gen, prov);
            return true;
        }
    }

    private static final class IWGSymbol
    extends BasicAgeSymbol {
        private final IWorldGenerator generator;

        public IWGSymbol(IWorldGenerator gen, String[] poem, int instability) {
            super(gen.getClass().getName().toLowerCase(Locale.ENGLISH).replaceAll("\\.", "_"), gen.getClass().getSimpleName(), poem, instability);
            this.generator = gen;
        }

        @Override
        public void registerLogic(AgeDirector age, long seed) {
            age.registerInterface((IPopulate)new IWGRelay(this.generator));
        }
    }

    public static enum APISegment {
        SYMBOL("symbol"),
        WORD("word"),
        GRAMMAR("grammar"),
        INSTABILITY("instability"),
        LINKING("linking"),
        LINKPROPERTY("linkingprop"),
        PAGE("page"),
        SYMBOLVALUES("symbolvals"),
        RENDER("render"),
        DIMENSION("dimension");

        private final String tag;

        private APISegment(String n2) {
            this.tag = n2;
        }

        public String getTag(int version) {
            return this.tag + "-" + version;
        }
    }

    public static interface MystcraftPageRegistry {
        public void register();
    }

    private static final class AgeInterface {
        private static final Field age_controller;
        private static final Field instability_controller;
        private static final Field data;
        private static final Field instabilityNumber;
        private static final Field blockInstabilityNumber;
        private static final Field baseInstability;
        private static final Field symbolList;
        private static final Method getScore;
        private static final Method getGroundLevel;
        private static boolean loadedCorrectly;
        public final int dimensionID;
        private final WorldProvider provider;
        private Object ageController;
        private Object instabilityController;
        private Object ageData;
        private HashSet<String> ageSymbols;

        private AgeInterface(World world) {
            if (!ReikaMystcraftHelper.isMystAge(world)) {
                throw new IllegalArgumentException("Dimension " + world.field_73011_w.field_76574_g + " is not a MystCraft age!");
            }
            this.provider = world.field_73011_w;
            this.dimensionID = world.field_73011_w.field_76574_g;
            try {
                this.ageController = age_controller.get(this.provider);
                this.instabilityController = instability_controller.get(this.ageController);
                this.ageData = data.get(this.ageController);
                this.ageSymbols = new HashSet((List)symbolList.get(this.ageData));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public int getBlockInstability() {
            try {
                Integer get = (Integer)blockInstabilityNumber.get(this.ageController);
                return get != null ? get : 0;
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        }

        public int getSymbolInstability() {
            try {
                return instabilityNumber.getInt(this.ageController);
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        }

        public short getBaseInstability() {
            try {
                return baseInstability.getShort(this.ageData);
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        }

        public int getInstabilityScore() {
            try {
                return (Integer)getScore.invoke(this.ageController, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        }

        public void addBaseInstability(short amt) {
            short base = this.getBaseInstability();
            this.setBaseInstability((short)(amt + base));
        }

        public int decrInstability(int amt) {
            int symbol = this.getSymbolInstability();
            if (symbol >= amt) {
                this.setSymbolInstability(symbol - amt);
                return 0;
            }
            this.setSymbolInstability(0);
            int rem = amt - symbol;
            int block = this.getBlockInstability();
            if (block >= rem) {
                this.setBlockInstability(block - rem);
                return 0;
            }
            int rem2 = rem - block;
            this.setBlockInstability(0);
            short base = this.getBaseInstability();
            if (base >= rem2) {
                this.setBaseInstability((short)(base - rem2));
                return 0;
            }
            this.setBaseInstability((short)0);
            return rem2 - base;
        }

        private void setBaseInstability(short amt) {
            if (amt < 0) {
                amt = 0;
            }
            try {
                baseInstability.set(this.ageData, amt);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void setBlockInstability(int amt) {
            if (amt < 0) {
                amt = 0;
            }
            try {
                blockInstabilityNumber.set(this.ageController, amt);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void setSymbolInstability(int amt) {
            if (amt < 0) {
                amt = 0;
            }
            try {
                instabilityNumber.set(this.ageController, amt);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public Set<String> getSymbols() {
            return Collections.unmodifiableSet(this.ageSymbols);
        }

        public boolean symbolExists(String s) {
            return this.ageSymbols.contains(s);
        }

        public boolean symbolExists(IAgeSymbol s) {
            return this.ageSymbols.contains(s.identifier());
        }

        public int getGroundLevel() {
            try {
                return (Integer)getGroundLevel.invoke(this.ageController, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                return 64;
            }
        }

        static {
            Field cont = null;
            Field insta = null;
            Field num = null;
            Field numblock = null;
            Field base = null;
            Field adata = null;
            Field sym = null;
            Method score = null;
            Method level = null;
            boolean load = true;
            if (ModList.MYSTCRAFT.isLoaded()) {
                try {
                    Class<?> prov = Class.forName("com.xcompwiz.mystcraft.world.WorldProviderMyst");
                    cont = prov.getDeclaredField("controller");
                    cont.setAccessible(true);
                    Class<?> age = Class.forName("com.xcompwiz.mystcraft.world.AgeController");
                    insta = age.getDeclaredField("instabilityController");
                    insta.setAccessible(true);
                    level = age.getDeclaredMethod("getAverageGroundLevel", new Class[0]);
                    level.setAccessible(true);
                    Class<?> controller = Class.forName("com.xcompwiz.mystcraft.instability.InstabilityController");
                    num = age.getDeclaredField("symbolinstability");
                    num.setAccessible(true);
                    numblock = age.getDeclaredField("blockinstability");
                    numblock.setAccessible(true);
                    Class<?> data = Class.forName("com.xcompwiz.mystcraft.world.agedata.AgeData");
                    base = data.getDeclaredField("instability");
                    base.setAccessible(true);
                    sym = data.getDeclaredField("symbols");
                    sym.setAccessible(true);
                    score = age.getDeclaredMethod("getInstabilityScore", new Class[0]);
                    score.setAccessible(true);
                    adata = age.getDeclaredField("agedata");
                    adata.setAccessible(true);
                    loadedCorrectly = true;
                }
                catch (Exception e) {
                    DragonAPICore.logError("Error loading Mystcraft instability interfacing!");
                    e.printStackTrace();
                    load = false;
                    ReflectiveFailureTracker.instance.logModReflectiveFailure(ModList.MYSTCRAFT, e);
                }
            } else {
                load = false;
            }
            age_controller = cont;
            instability_controller = insta;
            instabilityNumber = num;
            blockInstabilityNumber = numblock;
            getScore = score;
            baseInstability = base;
            symbolList = sym;
            data = adata;
            getGroundLevel = level;
        }
    }
}

