/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.Bees;

import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.NestedMap;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleArea;
import forestry.api.genetics.IAlleleFloat;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IAlleleTolerance;
import forestry.api.genetics.IChromosomeType;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.api.lepidopterology.IAlleleButterflyEffect;
import java.util.EnumMap;
import java.util.Locale;
import net.minecraftforge.common.util.EnumHelper;

public class ButterflyAlleleRegistry {
    private static final NestedMap<Class, String, ButterflyGene> geneMap = new NestedMap();
    private static final EnumMap<EnumButterflyChromosome, Class<? extends ButterflyGene>> classTypes = new EnumMap(EnumButterflyChromosome.class);

    public static Class<? extends ButterflyGene> getEnumType(EnumButterflyChromosome ebc) {
        return classTypes.get(ebc);
    }

    public static ButterflyGene getEnum(EnumButterflyChromosome ebc, String name) {
        return Enum.valueOf(ButterflyAlleleRegistry.getEnumType(ebc), name.toUpperCase(Locale.ENGLISH));
    }

    private static void register(ButterflyGene g, String n) {
        geneMap.put(g.getClass(), n, g);
    }

    public static ButterflyGene getEnum(IAllele allele, Class<? extends ButterflyGene> type) {
        return geneMap.get(type, allele.getUID());
    }

    static {
        classTypes.put(EnumButterflyChromosome.SPEED, Speeds.class);
        classTypes.put(EnumButterflyChromosome.SIZE, Size.class);
        classTypes.put(EnumButterflyChromosome.LIFESPAN, Life.class);
        classTypes.put(EnumButterflyChromosome.FERTILITY, Fertility.class);
        classTypes.put(EnumButterflyChromosome.METABOLISM, Metabolisms.class);
        classTypes.put(EnumButterflyChromosome.FLOWER_PROVIDER, Flower.class);
        classTypes.put(EnumButterflyChromosome.TERRITORY, Territory.class);
        classTypes.put(EnumButterflyChromosome.TEMPERATURE_TOLERANCE, Tolerance.class);
        classTypes.put(EnumButterflyChromosome.HUMIDITY_TOLERANCE, Tolerance.class);
        classTypes.put(EnumButterflyChromosome.EFFECT, Effect.class);
    }

    public static enum Effect implements ButterflyGene
    {
        NONE("effectNone");

        public final String tag;

        private Effect(String s) {
            this("forestry", s);
        }

        private Effect(String pre, String s) {
            this.tag = pre + "." + s;
            ButterflyAlleleRegistry.register(this, this.tag);
        }

        public IAlleleButterflyEffect getAllele() {
            return (IAlleleButterflyEffect)AlleleManager.alleleRegistry.getAllele(this.tag);
        }

        @Override
        public ButterflyGene oneBetter() {
            return null;
        }
    }

    public static enum Tolerance implements ButterflyGene
    {
        UP("Up"),
        DOWN("Down"),
        BOTH("Both"),
        NONE("None");

        public final String tag;

        private Tolerance(String s) {
            this("forestry", s);
        }

        private Tolerance(String pre, String s) {
            this.tag = pre + ".tolerance" + s;
            ButterflyAlleleRegistry.register(this, this.tag);
        }

        public IAlleleTolerance getAllele() {
            return (IAlleleTolerance)AlleleManager.alleleRegistry.getAllele(this.tag);
        }

        @Override
        public ButterflyGene oneBetter() {
            return null;
        }
    }

    public static enum Metabolisms implements ButterflyGene
    {
        SLOWEST("Slowest"),
        SLOWER("Slower"),
        SLOW("Slow"),
        NORMAL("Norm"),
        FAST("Fast"),
        FASTER("Faster"),
        FASTEST("Fastest");

        public final String tag;

        private Metabolisms(String s) {
            this("forestry", s);
        }

        private Metabolisms(String pre, String s) {
            this.tag = pre + ".metabolism" + s;
            ButterflyAlleleRegistry.register(this, this.tag);
        }

        public IAlleleInteger getAllele() {
            return (IAlleleInteger)AlleleManager.alleleRegistry.getAllele(this.tag);
        }

        public static Metabolisms createNew(String id, int Metabolisms2, boolean dominant) {
            id = ReikaStringParser.capFirstChar(id);
            IAlleleInteger allele = AlleleManager.alleleFactory.createInteger("dragonapi", "metabolism", id, Metabolisms2, dominant, new IChromosomeType[]{EnumButterflyChromosome.METABOLISM});
            AlleleManager.alleleRegistry.registerAllele((IAllele)allele, new IChromosomeType[]{EnumButterflyChromosome.METABOLISM});
            return (Metabolisms)EnumHelper.addEnum(Metabolisms.class, (String)id.toUpperCase(), (Class[])new Class[]{String.class, String.class}, (Object[])new Object[]{"dragonapi", id});
        }

        @Override
        public ButterflyGene oneBetter() {
            return null;
        }
    }

    public static enum Life implements ButterflyGene
    {
        SHORTEST("Shortest"),
        SHORTER("Shorter"),
        SHORT("Short"),
        SHORTENED("Shortened"),
        NORMAL("Normal"),
        ELONGATED("Elongated"),
        LONG("Long"),
        LONGER("Longer"),
        LONGEST("Longest");

        public final String tag;

        private Life(String s) {
            this("forestry", s);
        }

        private Life(String pre, String s) {
            this.tag = pre + ".lifespan" + s;
            ButterflyAlleleRegistry.register(this, this.tag);
        }

        public IAlleleInteger getAllele() {
            return (IAlleleInteger)AlleleManager.alleleRegistry.getAllele(this.tag);
        }

        public static Life createNew(String id, int life, boolean dominant) {
            id = ReikaStringParser.capFirstChar(id);
            IAlleleInteger allele = AlleleManager.alleleFactory.createInteger("dragonapi", "lifespan", id, life, dominant, new IChromosomeType[]{EnumButterflyChromosome.LIFESPAN});
            AlleleManager.alleleRegistry.registerAllele((IAllele)allele, new IChromosomeType[]{EnumButterflyChromosome.LIFESPAN});
            return (Life)EnumHelper.addEnum(Life.class, (String)id.toUpperCase(), (Class[])new Class[]{String.class, String.class}, (Object[])new Object[]{"dragonapi", id});
        }

        @Override
        public ButterflyGene oneBetter() {
            return null;
        }
    }

    public static enum Territory implements ButterflyGene
    {
        DEFAULT("Default"),
        LARGE("Large"),
        LARGER("Larger"),
        LARGEST("Largest");

        public final String tag;

        private Territory(String s) {
            this("forestry", s);
        }

        private Territory(String pre, String s) {
            this.tag = pre + ".territory" + s;
            ButterflyAlleleRegistry.register(this, this.tag);
        }

        public IAlleleArea getAllele() {
            return (IAlleleArea)AlleleManager.alleleRegistry.getAllele(this.tag);
        }

        public Coordinate getRange() {
            int[] val = this.getAllele().getValue();
            return new Coordinate(val[0], val[1], val[2]);
        }

        public static Territory createNew(String id, int rangeXZ, int rangeY, boolean dominant) {
            id = ReikaStringParser.capFirstChar(id);
            IAlleleArea allele = AlleleManager.alleleFactory.createArea("dragonapi", "territory", id, rangeXZ, rangeY, rangeXZ, dominant, new IChromosomeType[]{EnumButterflyChromosome.TERRITORY});
            AlleleManager.alleleRegistry.registerAllele((IAllele)allele, new IChromosomeType[]{EnumButterflyChromosome.TERRITORY});
            return (Territory)EnumHelper.addEnum(Territory.class, (String)id.toUpperCase(), (Class[])new Class[]{String.class, String.class}, (Object[])new Object[]{"dragonapi", id});
        }

        @Override
        public ButterflyGene oneBetter() {
            return this == LARGEST ? null : Territory.values()[this.ordinal() + 1];
        }
    }

    public static enum Flower implements ButterflyGene
    {
        VANILLA("Vanilla"),
        NETHER("Nether"),
        CACTUS("Cacti"),
        MUSHROOM("Mushrooms"),
        ENDER("End"),
        JUNGLE("Jungle"),
        SNOW("Snow"),
        WHEAT("Wheat"),
        GOURD("Gourd");

        public final String tag;

        private Flower(String s) {
            this("forestry", s);
        }

        private Flower(String pre, String s) {
            this.tag = pre + ".flowers" + s;
            ButterflyAlleleRegistry.register(this, this.tag);
        }

        public IAlleleFlowers getAllele() {
            return (IAlleleFlowers)AlleleManager.alleleRegistry.getAllele(this.tag);
        }

        @Override
        public ButterflyGene oneBetter() {
            return null;
        }
    }

    public static enum Fertility implements ButterflyGene
    {
        LOW("Low"),
        NORMAL("Normal"),
        HIGH("High"),
        MAXIMUM("Maximum");

        public final String tag;

        private Fertility(String s) {
            this("forestry", s);
        }

        private Fertility(String pre, String s) {
            this.tag = pre + ".fertility" + s;
            ButterflyAlleleRegistry.register(this, this.tag);
        }

        public IAlleleInteger getAllele() {
            return (IAlleleInteger)AlleleManager.alleleRegistry.getAllele(this.tag);
        }

        public static Fertility createNew(String id, int drones, boolean dominant) {
            id = ReikaStringParser.capFirstChar(id);
            IAlleleInteger allele = AlleleManager.alleleFactory.createInteger("dragonapi", "fertility", id, drones, dominant, new IChromosomeType[]{EnumButterflyChromosome.FERTILITY});
            AlleleManager.alleleRegistry.registerAllele((IAllele)allele, new IChromosomeType[]{EnumButterflyChromosome.FERTILITY});
            return (Fertility)EnumHelper.addEnum(Fertility.class, (String)id.toUpperCase(), (Class[])new Class[]{String.class, String.class}, (Object[])new Object[]{"dragonapi", id});
        }

        @Override
        public ButterflyGene oneBetter() {
            return this == MAXIMUM ? null : Fertility.values()[this.ordinal() + 1];
        }
    }

    public static enum Size implements ButterflyGene
    {
        SMALLEST("Smallest"),
        SMALLER("Smaller"),
        SMALL("Small"),
        AVERAGE("Average"),
        LARGE("Large"),
        LARGER("Larger"),
        LARGEST("Largest");

        public final String tag;

        private Size(String s) {
            this("forestry", s);
        }

        private Size(String pre, String s) {
            this.tag = pre + ".speed" + s;
            ButterflyAlleleRegistry.register(this, this.tag);
        }

        public IAlleleFloat getAllele() {
            return (IAlleleFloat)AlleleManager.alleleRegistry.getAllele(this.tag);
        }

        public static Speeds createNew(String id, float speed, boolean dominant) {
            id = ReikaStringParser.capFirstChar(id);
            IAlleleFloat allele = AlleleManager.alleleFactory.createFloat("dragonapi", "size", id, speed, dominant, new IChromosomeType[]{EnumButterflyChromosome.SIZE});
            AlleleManager.alleleRegistry.registerAllele((IAllele)allele, new IChromosomeType[]{EnumButterflyChromosome.SIZE});
            return (Speeds)EnumHelper.addEnum(Speeds.class, (String)id.toUpperCase(), (Class[])new Class[]{String.class, String.class}, (Object[])new Object[]{"dragonapi", id});
        }

        @Override
        public ButterflyGene oneBetter() {
            return this == LARGEST ? null : Size.values()[this.ordinal() + 1];
        }
    }

    public static enum Speeds implements ButterflyGene
    {
        SLOWEST("Slowest"),
        SLOWER("Slower"),
        SLOW("Slow"),
        NORMAL("Norm"),
        FAST("Fast"),
        FASTER("Faster"),
        FASTEST("Fastest");

        public final String tag;

        private Speeds(String s) {
            this("forestry", s);
        }

        private Speeds(String pre, String s) {
            this.tag = pre + ".speed" + s;
            ButterflyAlleleRegistry.register(this, this.tag);
        }

        public IAlleleFloat getAllele() {
            return (IAlleleFloat)AlleleManager.alleleRegistry.getAllele(this.tag);
        }

        public static Speeds createNew(String id, float speed, boolean dominant) {
            id = ReikaStringParser.capFirstChar(id);
            IAlleleFloat allele = AlleleManager.alleleFactory.createFloat("dragonapi", "speed", id, speed, dominant, new IChromosomeType[]{EnumButterflyChromosome.SPEED});
            AlleleManager.alleleRegistry.registerAllele((IAllele)allele, new IChromosomeType[]{EnumButterflyChromosome.SPEED});
            return (Speeds)EnumHelper.addEnum(Speeds.class, (String)id.toUpperCase(), (Class[])new Class[]{String.class, String.class}, (Object[])new Object[]{"dragonapi", id});
        }

        @Override
        public ButterflyGene oneBetter() {
            return this == FASTEST ? null : Speeds.values()[this.ordinal() + 1];
        }
    }

    public static interface ButterflyGene {
        public ButterflyGene oneBetter();

        public IAllele getAllele();
    }
}

