/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Instantiable.Recipe.ItemMatch;
import Reika.DragonAPI.Instantiable.TemporaryInventory;
import Reika.DragonAPI.Interfaces.Item.ActivatedInventoryItem;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.ModRegistry.InterfaceCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;

public final class ReikaInventoryHelper
extends DragonAPICore {
    public static boolean checkForItem(Item id, ItemStack[] inv) {
        for (int i = 0; i < inv.length; ++i) {
            ItemStack in = inv[i];
            if (in == null) continue;
            if (in.func_77973_b() == id) {
                return true;
            }
            if (!(in.func_77973_b() instanceof ActivatedInventoryItem) || !ReikaInventoryHelper.checkForItem(id, ((ActivatedInventoryItem)in.func_77973_b()).getInventory(in))) continue;
            return true;
        }
        return false;
    }

    public static boolean checkForItem(Block id, ItemStack[] inv) {
        return ReikaInventoryHelper.checkForItem(Item.func_150898_a((Block)id), inv);
    }

    public static boolean checkForItem(Item id, IInventory ii) {
        for (int i = 0; i < ii.func_70302_i_(); ++i) {
            ItemStack in = ii.func_70301_a(i);
            if (in == null) continue;
            if (in.func_77973_b() == id) {
                return true;
            }
            if (!(in.func_77973_b() instanceof ActivatedInventoryItem) || !ReikaInventoryHelper.checkForItem(id, ((ActivatedInventoryItem)in.func_77973_b()).getInventory(in))) continue;
            return true;
        }
        return false;
    }

    public static boolean checkForItem(Block id, IInventory ii) {
        return ReikaInventoryHelper.checkForItem(Item.func_150898_a((Block)id), ii);
    }

    public static boolean checkForItemStack(Item id, int dmg, ItemStack[] inv) {
        for (int i = 0; i < inv.length; ++i) {
            ItemStack in = inv[i];
            if (in == null) continue;
            if (in.func_77973_b() == id && in.func_77960_j() == dmg) {
                return true;
            }
            if (!(in.func_77973_b() instanceof ActivatedInventoryItem) || !ReikaInventoryHelper.checkForItemStack(id, dmg, ((ActivatedInventoryItem)in.func_77973_b()).getInventory(in))) continue;
            return true;
        }
        return false;
    }

    public static boolean checkForItemStack(Item id, int dmg, IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack is = inv.func_70301_a(i);
            if (is == null) continue;
            if (is.func_77973_b() == id && is.func_77960_j() == dmg) {
                return true;
            }
            if (!(is.func_77973_b() instanceof ActivatedInventoryItem) || !ReikaInventoryHelper.checkForItemStack(id, dmg, ((ActivatedInventoryItem)is.func_77973_b()).getInventory(is))) continue;
            return true;
        }
        return false;
    }

    public static boolean checkForItemStack(ItemStack is, ItemStack[] inv, boolean matchsize) {
        for (int i = 0; i < inv.length; ++i) {
            ItemStack in = inv[i];
            if (in == null) continue;
            if (in.func_77973_b() instanceof ActivatedInventoryItem && ReikaInventoryHelper.checkForItemStack(is, ((ActivatedInventoryItem)in.func_77973_b()).getInventory(in), matchsize)) {
                return true;
            }
            if (!(matchsize ? ItemStack.func_77989_b((ItemStack)is, (ItemStack)in) : ItemStack.func_77970_a((ItemStack)is, (ItemStack)in) && ReikaItemHelper.matchStacks(is, in))) continue;
            return true;
        }
        return false;
    }

    public static boolean checkForItemStack(KeyedItemStack is, ItemStack[] inv) {
        for (int i = 0; i < inv.length; ++i) {
            ItemStack in = inv[i];
            if (in == null) continue;
            if (in.func_77973_b() instanceof ActivatedInventoryItem && ReikaInventoryHelper.checkForItemStack(is, ((ActivatedInventoryItem)in.func_77973_b()).getInventory(in))) {
                return true;
            }
            if (!is.match(in)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkForItemStack(ItemMatch is, ItemStack[] inv) {
        for (int i = 0; i < inv.length; ++i) {
            ItemStack in = inv[i];
            if (in == null) continue;
            if (in.func_77973_b() instanceof ActivatedInventoryItem && ReikaInventoryHelper.checkForItemStack(is, ((ActivatedInventoryItem)in.func_77973_b()).getInventory(in))) {
                return true;
            }
            if (!is.match(in)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkForItemStack(ItemStack is, IInventory inv, boolean matchsize) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack in = inv.func_70301_a(i);
            if (in == null) continue;
            if (in.func_77973_b() instanceof ActivatedInventoryItem && ReikaInventoryHelper.checkForItemStack(is, ((ActivatedInventoryItem)in.func_77973_b()).getInventory(in), matchsize)) {
                return true;
            }
            if (!(matchsize ? ItemStack.func_77989_b((ItemStack)is, (ItemStack)in) : ItemStack.func_77970_a((ItemStack)is, (ItemStack)in) && ReikaItemHelper.matchStacks(is, in))) continue;
            return true;
        }
        return false;
    }

    public static ItemStack[] IInvToItemStackArray(IInventory ii) {
        ItemStack[] ret = new ItemStack[ii.func_70302_i_()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ii.func_70301_a(i);
        }
        return ret;
    }

    public static int locateInInventory(ItemStack is, ItemStack[] inv, boolean matchsize) {
        for (int i = 0; i < inv.length; ++i) {
            ItemStack in = inv[i];
            if (in == null) continue;
            if (in.func_77973_b() instanceof ActivatedInventoryItem && ReikaInventoryHelper.checkForItemStack(is, ((ActivatedInventoryItem)in.func_77973_b()).getInventory(in), matchsize)) {
                return i;
            }
            if (!(matchsize ? ItemStack.func_77989_b((ItemStack)is, (ItemStack)in) : ItemStack.func_77970_a((ItemStack)is, (ItemStack)in) && ReikaItemHelper.matchStacks(is, in))) continue;
            return i;
        }
        return -1;
    }

    public static int locateInInventory(KeyedItemStack is, ItemStack[] inv) {
        for (int i = 0; i < inv.length; ++i) {
            ItemStack in = inv[i];
            if (in == null) continue;
            if (in.func_77973_b() instanceof ActivatedInventoryItem && ReikaInventoryHelper.checkForItemStack(is, ((ActivatedInventoryItem)in.func_77973_b()).getInventory(in))) {
                return i;
            }
            if (!is.match(in)) continue;
            return i;
        }
        return -1;
    }

    public static int locateInInventory(ItemMatch is, ItemStack[] inv) {
        for (int i = 0; i < inv.length; ++i) {
            ItemStack in = inv[i];
            if (in == null) continue;
            if (in.func_77973_b() instanceof ActivatedInventoryItem && ReikaInventoryHelper.checkForItemStack(is, ((ActivatedInventoryItem)in.func_77973_b()).getInventory(in))) {
                return i;
            }
            if (!is.match(in)) continue;
            return i;
        }
        return -1;
    }

    public static int locateInInventory(ItemStack is, IInventory inv, boolean matchsize) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack in = inv.func_70301_a(i);
            if (in == null) continue;
            if (in.func_77973_b() instanceof ActivatedInventoryItem && ReikaInventoryHelper.checkForItemStack(is, ((ActivatedInventoryItem)in.func_77973_b()).getInventory(in), matchsize)) {
                return i;
            }
            if (!(matchsize ? ItemStack.func_77989_b((ItemStack)is, (ItemStack)in) : ItemStack.func_77970_a((ItemStack)is, (ItemStack)in) && ReikaItemHelper.matchStacks(is, in))) continue;
            return i;
        }
        return -1;
    }

    public static int locateInInventory(Item id, ItemStack[] inv) {
        for (int i = 0; i < inv.length; ++i) {
            ItemStack in = inv[i];
            if (in == null) continue;
            if (in.func_77973_b() == id) {
                return i;
            }
            if (!(in.func_77973_b() instanceof ActivatedInventoryItem) || ReikaInventoryHelper.locateInInventory(id, ((ActivatedInventoryItem)in.func_77973_b()).getInventory(in)) < 0) continue;
            return i;
        }
        return -1;
    }

    public static int locateInInventory(Block id, ItemStack[] inv) {
        return ReikaInventoryHelper.locateInInventory(Item.func_150898_a((Block)id), inv);
    }

    public static int locateInInventory(Block id, int meta, ItemStack[] inv) {
        return ReikaInventoryHelper.locateInInventory(Item.func_150898_a((Block)id), meta, inv);
    }

    public static int locateInInventory(Item id, int meta, ItemStack[] inv) {
        for (int i = 0; i < inv.length; ++i) {
            ItemStack in = inv[i];
            if (in == null) continue;
            if (in.func_77973_b() == id && (meta == -1 || in.func_77960_j() == meta)) {
                return i;
            }
            if (!(in.func_77973_b() instanceof ActivatedInventoryItem) || ReikaInventoryHelper.locateInInventory(id, meta, ((ActivatedInventoryItem)in.func_77973_b()).getInventory(in)) < 0) continue;
            return i;
        }
        return -1;
    }

    public static int countItem(Item id, ItemStack[] inv) {
        int count = 0;
        for (int i = 0; i < inv.length; ++i) {
            if (inv[i] == null || inv[i].func_77973_b() != id) continue;
            count += inv[i].field_77994_a;
        }
        return count;
    }

    public static int countItem(Item id, int meta, ItemStack[] inv) {
        int count = 0;
        for (int i = 0; i < inv.length; ++i) {
            if (inv[i] == null || inv[i].func_77973_b() != id || inv[i].func_77960_j() != meta) continue;
            count += inv[i].field_77994_a;
        }
        return count;
    }

    public static int countItem(Item id, int meta, IInventory inv) {
        int count = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i) == null || inv.func_70301_a(i).func_77973_b() != id || inv.func_70301_a(i).func_77960_j() != meta) continue;
            count += inv.func_70301_a((int)i).field_77994_a;
        }
        return count;
    }

    public static boolean findAndDecrStack(Block id, int meta, ItemStack[] inv) {
        return ReikaInventoryHelper.findAndDecrStack(Item.func_150898_a((Block)id), meta, inv);
    }

    public static boolean findAndDecrStack(Item id, int meta, ItemStack[] inv) {
        ItemStack is = meta >= 0 ? new ItemStack(id, 1, meta) : new ItemStack(id, 1, Short.MAX_VALUE);
        return ReikaInventoryHelper.findAndDecrStack(is, inv);
    }

    public static boolean findAndDecrStack(ItemStack is, ItemStack[] inv) {
        return ReikaInventoryHelper.findAndDecrStack(is, inv, false);
    }

    public static boolean findAndDecrStack(ItemStack is, ItemStack[] inv, boolean nbt) {
        int slot = is.func_77960_j() != Short.MAX_VALUE ? ReikaInventoryHelper.locateInInventory(is.func_77973_b(), is.func_77960_j(), inv) : ReikaInventoryHelper.locateInInventory(is.func_77973_b(), inv);
        if (slot == -1) {
            return false;
        }
        ReikaInventoryHelper.decrStack(slot, inv);
        return true;
    }

    public static ItemStack findAndDecrStack2(Item id, int meta, ItemStack[] inv) {
        int slot = meta != -1 ? ReikaInventoryHelper.locateInInventory(id, meta, inv) : ReikaInventoryHelper.locateInInventory(id, inv);
        if (slot == -1) {
            return null;
        }
        ItemStack inslot = inv[slot];
        ReikaInventoryHelper.decrStack(slot, inv);
        return inslot;
    }

    public static int countNumStacks(Item id, int meta, ItemStack[] inv) {
        int count = 0;
        for (int i = 0; i < inv.length; ++i) {
            if (inv[i] == null) continue;
            if (meta != -1) {
                if (inv[i].func_77973_b() != id || inv[i].func_77960_j() != meta) continue;
                ++count;
                continue;
            }
            if (inv[i].func_77973_b() != id) continue;
            ++count;
        }
        return count;
    }

    public static int countNumStacks(ItemStack item, ItemStack[] inv) {
        int count = 0;
        for (int i = 0; i < inv.length; ++i) {
            if (inv[i] == null || !ReikaItemHelper.matchStacks(item, inv[i])) continue;
            ++count;
        }
        return count;
    }

    public static boolean putStackInInventory(ItemStack is, IInventory ii, boolean overrideValid) {
        int space;
        ItemStack in;
        int slot;
        int i;
        ItemStack stack = is.func_77946_l();
        ArrayList<Integer> slots = ReikaInventoryHelper.getSlotsWithItemStack(stack, ii, false);
        int empty = ReikaInventoryHelper.findEmptySlot(ii);
        int max = Math.min(ii.func_70297_j_(), stack.func_77976_d());
        int addable = 0;
        ArrayList<Integer> validslots = new ArrayList<Integer>();
        for (i = 0; i < slots.size() && stack.field_77994_a > 0; ++i) {
            slot = slots.get(i);
            if (!overrideValid && !ii.func_94041_b(slot, stack) || !ReikaItemHelper.matchStacks(stack, in = ii.func_70301_a(slot)) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)in)) continue;
            space = Math.min(max - in.field_77994_a, stack.field_77994_a);
            addable += space;
            validslots.add(slot);
        }
        if (empty != -1) {
            addable += stack.func_77976_d();
        }
        if (addable < stack.field_77994_a) {
            return false;
        }
        for (i = 0; i < validslots.size() && stack.field_77994_a > 0; ++i) {
            slot = (Integer)validslots.get(i);
            in = ii.func_70301_a(slot);
            space = Math.min(max - in.field_77994_a, stack.field_77994_a);
            in.field_77994_a += space;
            stack.field_77994_a -= space;
        }
        if (stack.field_77994_a <= 0) {
            return true;
        }
        if (empty != -1) {
            ii.func_70299_a(empty, stack.func_77946_l());
            return true;
        }
        return false;
    }

    public static boolean putStackInInventory(Item id, int meta, int size, ItemStack[] inventory) {
        if (meta == -1) {
            boolean fits = ReikaInventoryHelper.putStackInInventory(id, size, inventory);
            return fits;
        }
        int slot = ReikaInventoryHelper.locateInInventory(id, meta, inventory);
        int empty = ReikaInventoryHelper.findEmptySlot(inventory);
        if (slot == -1) {
            if (empty == -1) {
                return false;
            }
            inventory[empty] = new ItemStack(id, size, meta);
            return true;
        }
        if (inventory[slot].field_77994_a + size <= inventory[slot].func_77976_d()) {
            inventory[slot].field_77994_a += size;
            return true;
        }
        return false;
    }

    private static boolean putStackInInventory(Item id, int size, ItemStack[] inventory) {
        int slot = ReikaInventoryHelper.locateInInventory(id, inventory);
        int empty = ReikaInventoryHelper.findEmptySlot(inventory);
        if (slot == -1) {
            if (empty == -1) {
                return false;
            }
            inventory[empty] = new ItemStack(id, size, 0);
            return true;
        }
        if (inventory[slot].field_77994_a + size <= inventory[slot].func_77976_d()) {
            inventory[slot].field_77994_a += size;
            return true;
        }
        return false;
    }

    public static int addToInventoryWithLeftover(Item id, int meta, int size, ItemStack[] inventory) {
        if (meta == -1) {
            int leftover = ReikaInventoryHelper.addToInventoryWithLeftover(id, size, inventory);
            return leftover;
        }
        int slot = ReikaInventoryHelper.locateInInventory(id, meta, inventory);
        int empty = ReikaInventoryHelper.findEmptySlot(inventory);
        if (slot == -1) {
            if (empty == -1) {
                return size;
            }
            inventory[empty] = new ItemStack(id, size, meta);
            return 0;
        }
        int space = inventory[slot].func_77976_d() - inventory[slot].field_77994_a;
        if (space >= size) {
            inventory[slot].field_77994_a += size;
            return 0;
        }
        inventory[slot].field_77994_a += space;
        return size -= space;
    }

    private static int addToInventoryWithLeftover(Item id, int size, ItemStack[] inventory) {
        int slot = ReikaInventoryHelper.locateInInventory(id, inventory);
        int empty = ReikaInventoryHelper.findEmptySlot(inventory);
        if (slot == -1) {
            if (empty == -1) {
                return size;
            }
            inventory[empty] = new ItemStack(id, size, 0);
            return 0;
        }
        int space = inventory[slot].func_77976_d() - inventory[slot].field_77994_a;
        if (space >= size) {
            inventory[slot].field_77994_a += size;
            return 0;
        }
        inventory[slot].field_77994_a += space;
        return size -= space;
    }

    public static int addToInventoryWithLeftover(ItemStack stack, ItemStack[] inventory) {
        int leftover = ReikaInventoryHelper.addToInventoryWithLeftover(stack.func_77973_b(), stack.func_77960_j(), stack.field_77994_a, inventory);
        return leftover;
    }

    public static int addToInventoryWithLeftover(ItemStack stack, IInventory inventory, boolean simulate) {
        if (InterfaceCache.DSU.instanceOf(inventory)) {
            return ReikaInventoryHelper.addToDSUWithLeftover((IDeepStorageUnit)inventory, stack, simulate);
        }
        int left = stack.field_77994_a;
        int max = Math.min(inventory.func_70297_j_(), stack.func_77976_d());
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            int space;
            int add;
            ItemStack in = inventory.func_70301_a(i);
            if (in == null) {
                int add2 = Math.min(max, left);
                if (!simulate) {
                    inventory.func_70299_a(i, ReikaItemHelper.getSizedItemStack(stack, add2));
                }
                if ((left -= add2) > 0) continue;
                return 0;
            }
            if (!ReikaItemHelper.matchStacks(stack, in) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)in) || (add = Math.min(space = max - in.field_77994_a, stack.field_77994_a)) <= 0) continue;
            if (!simulate) {
                in.field_77994_a += add;
            }
            if ((left -= add) > 0) continue;
            return 0;
        }
        return left;
    }

    public static boolean addToDSU(IDeepStorageUnit dsu, ItemStack stack, boolean simulate) {
        ItemStack in = dsu.getStoredItemType();
        if (in != null && !ReikaItemHelper.matchStacks(in, stack)) {
            return false;
        }
        int has = in != null ? in.field_77994_a : 0;
        int space = dsu.getMaxStoredCount() - has;
        if (space >= stack.field_77994_a) {
            if (!simulate) {
                dsu.setStoredItemType(stack, has + stack.field_77994_a);
            }
            return true;
        }
        return false;
    }

    public static int addToDSUWithLeftover(IDeepStorageUnit dsu, ItemStack stack, boolean simulate) {
        ItemStack in = dsu.getStoredItemType();
        if (in != null && !ReikaItemHelper.matchStacks(in, stack)) {
            return 0;
        }
        int has = in != null ? in.field_77994_a : 0;
        int space = dsu.getMaxStoredCount() - has;
        int add = Math.min(space, stack.field_77994_a);
        if (!simulate) {
            dsu.setStoredItemType(stack, has + add);
        }
        return stack.field_77994_a - add;
    }

    public static int findEmptySlot(ItemStack[] inventory) {
        for (int i = 0; i < inventory.length; ++i) {
            if (inventory[i] == null) {
                return i;
            }
            if (inventory[i].field_77994_a > 0) continue;
            inventory[i] = null;
            return i;
        }
        return -1;
    }

    public static int findEmptySlot(IInventory ii) {
        for (int i = 0; i < ii.func_70302_i_(); ++i) {
            ItemStack is = ii.func_70301_a(i);
            if (is == null) {
                return i;
            }
            if (is.field_77994_a > 0) continue;
            is = null;
            return i;
        }
        return -1;
    }

    public static ArrayList<Integer> findEmptySlots(ItemStack[] inventory) {
        ArrayList<Integer> li = new ArrayList<Integer>();
        for (int i = 0; i < inventory.length; ++i) {
            if (inventory[i] == null) {
                li.add(i);
            }
            if (inventory[i].field_77994_a > 0) continue;
            inventory[i] = null;
            li.add(i);
        }
        return li;
    }

    public static ArrayList<Integer> findEmptySlots(IInventory inventory) {
        ArrayList<Integer> li = new ArrayList<Integer>();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack is = inventory.func_70301_a(i);
            if (is == null) {
                li.add(i);
            }
            if (is.field_77994_a > 0) continue;
            inventory.func_70299_a(i, null);
            li.add(i);
        }
        return li;
    }

    public static boolean isEmpty(ItemStack[] inventory) {
        return ReikaInventoryHelper.isEmpty(inventory, 0, inventory.length);
    }

    public static boolean isEmpty(ItemStack[] inventory, int min, int max) {
        for (int i = min; i < max; ++i) {
            if (inventory[i] == null) continue;
            return false;
        }
        return true;
    }

    public static int addUpToStack(ItemStack init, int min, int max) {
        int num = min + rand.nextInt(max - min + 1);
        if (init == null) {
            return num;
        }
        while (num + init.field_77994_a > init.func_77976_d()) {
            --num;
        }
        return num;
    }

    public static void decrStack(int slot, ItemStack[] inv) {
        if (slot >= inv.length) {
            ReikaChatHelper.write("Tried to access Slot " + slot + ", which is larger than the inventory.");
            return;
        }
        if (slot < 0) {
            ReikaChatHelper.write("Tried to access Slot " + slot + ", which is < 0.");
            return;
        }
        ItemStack in = inv[slot];
        if (in == null) {
            ReikaChatHelper.write("Tried to access Slot " + slot + ", which is empty.");
            return;
        }
        if (in.func_77973_b() instanceof ActivatedInventoryItem) {
            ((ActivatedInventoryItem)in.func_77973_b()).decrementSlot(in, slot);
        } else if (in.field_77994_a > 1) {
            --in.field_77994_a;
        } else {
            inv[slot] = null;
        }
    }

    public static void decrStack(int slot, IInventory inv, int amount) {
        if (slot >= inv.func_70302_i_()) {
            ReikaChatHelper.write("Tried to access Slot " + slot + ", which is larger than the inventory.");
            return;
        }
        if (slot < 0) {
            ReikaChatHelper.write("Tried to access Slot " + slot + ", which is < 0.");
            return;
        }
        if (inv.func_70301_a(slot) == null) {
            ReikaChatHelper.write("Tried to access Slot " + slot + ", which is empty.");
            return;
        }
        if (inv.func_70301_a((int)slot).field_77994_a > amount) {
            inv.func_70301_a((int)slot).field_77994_a -= amount;
        } else {
            inv.func_70299_a(slot, null);
        }
    }

    public static boolean checkForItem(InventoryCrafting ic, Item id, int meta) {
        for (int i = 0; i < ic.func_70302_i_(); ++i) {
            ItemStack is = ic.func_70301_a(i);
            if (is == null || is.func_77973_b() != id || meta != -1 && is.func_77960_j() != meta) continue;
            return true;
        }
        return false;
    }

    public static ItemStack[] convertCraftToItemStacks(InventoryCrafting ic) {
        ItemStack[] slots = new ItemStack[ic.func_70302_i_()];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = ic.func_70301_a(i);
        }
        return slots;
    }

    public static ArrayList<ItemStack> convertCraftToItemList(InventoryCrafting ic) {
        ArrayList<ItemStack> slots = new ArrayList<ItemStack>();
        for (int i = 0; i < ic.func_70302_i_(); ++i) {
            ItemStack is = ic.func_70301_a(i);
            if (is == null) continue;
            slots.add(is);
        }
        return slots;
    }

    public static int countEmptySlots(ItemStack[] inv) {
        int num = 0;
        for (int i = 0; i < inv.length; ++i) {
            if (inv[i] != null) continue;
            ++num;
        }
        return num;
    }

    public static int findMaxMetadataOfID(Item id, ItemStack[] inv) {
        int max = -1;
        for (int i = 0; i < inv.length; ++i) {
            if (inv[i] == null || inv[i].func_77973_b() != id || inv[i].func_77960_j() <= max) continue;
            max = inv[i].func_77960_j();
        }
        return max;
    }

    public static boolean isInventoryFull(ItemStack[] inv) {
        if (ReikaInventoryHelper.countEmptySlots(inv) > 0) {
            return false;
        }
        for (int i = 0; i < inv.length; ++i) {
            if (inv[i].func_77976_d() <= inv[i].field_77994_a) continue;
            return false;
        }
        return true;
    }

    public static boolean canAcceptMoreOf(Item item, int meta, int amt, IInventory inv) {
        return ReikaInventoryHelper.canAcceptMoreOf(new ItemStack(item, amt, meta), inv);
    }

    public static boolean canAcceptMoreOf(ItemStack is, IInventory inv) {
        int space = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (!inv.func_94041_b(i, is)) continue;
            ItemStack in = inv.func_70301_a(i);
            if (in == null) {
                return true;
            }
            if (!ReikaItemHelper.matchStacks(in, is) || !ItemStack.func_77970_a((ItemStack)is, (ItemStack)in)) continue;
            int max = Math.min(in.func_77976_d(), inv.func_70297_j_());
            space += max - in.field_77994_a;
        }
        return space >= is.field_77994_a;
    }

    public static int getTotalUniqueStacks(ItemStack[] inv) {
        ItemStack[] cp = new ItemStack[inv.length];
        for (int i = 0; i < cp.length; ++i) {
            cp[i] = inv[i];
        }
        return 0;
    }

    public static boolean addToIInv(Block b, IInventory ii) {
        return ReikaInventoryHelper.addToIInv(new ItemStack(b), ii);
    }

    public static boolean addToIInv(Item is, IInventory ii) {
        return ReikaInventoryHelper.addToIInv(new ItemStack(is), ii);
    }

    public static boolean addToIInv(ItemStack is, IInventory ii) {
        return ReikaInventoryHelper.addToIInv(is, ii, false);
    }

    public static boolean addToIInv(ItemStack is, IInventory ii, boolean overrideValid) {
        return ReikaInventoryHelper.addToIInv(is, ii, overrideValid, 0, ii.func_70302_i_());
    }

    public static boolean addToIInv(ItemStack is, IInventory ii, int first, int last) {
        return ReikaInventoryHelper.addToIInv(is, ii, false, first, last);
    }

    public static boolean addToIInv(ItemStack is, IInventory ii, boolean overrideValid, int firstSlot, int maxSlot) {
        if (InterfaceCache.DSU.instanceOf(ii)) {
            return ReikaInventoryHelper.addToDSU((IDeepStorageUnit)ii, is, false);
        }
        if (!ReikaInventoryHelper.hasSpaceFor(is = is.func_77946_l(), ii, overrideValid, firstSlot, maxSlot)) {
            return false;
        }
        int max = Math.min(ii.func_70297_j_(), is.func_77976_d());
        for (int i = firstSlot; i < maxSlot; ++i) {
            if (!overrideValid && !ii.func_94041_b(i, is)) continue;
            ItemStack in = ii.func_70301_a(i);
            if (in == null) {
                int added = Math.min(is.field_77994_a, max);
                is.field_77994_a -= added;
                ii.func_70299_a(i, ReikaItemHelper.getSizedItemStack(is, added));
                return true;
            }
            if (!ReikaItemHelper.matchStacks(is, in) || !ItemStack.func_77970_a((ItemStack)is, (ItemStack)in)) continue;
            int space = max - in.field_77994_a;
            int added = Math.min(is.field_77994_a, space);
            is.field_77994_a -= added;
            ii.func_70301_a((int)i).field_77994_a += added;
            if (is.field_77994_a > 0) continue;
            return true;
        }
        return is.field_77994_a == 0;
    }

    public static boolean hasSpaceFor(ItemStack is, IInventory ii, boolean overrideValid) {
        return ReikaInventoryHelper.hasSpaceFor(is, ii, overrideValid, 0, ii.func_70302_i_());
    }

    public static boolean hasSpaceFor(ItemStack is, IInventory ii, boolean overrideValid, int firstSlot, int maxSlot) {
        int size = is.field_77994_a;
        int max = Math.min(ii.func_70297_j_(), is.func_77976_d());
        for (int i = firstSlot; i < maxSlot && size > 0; ++i) {
            if (!overrideValid && !ii.func_94041_b(i, is)) continue;
            ItemStack in = ii.func_70301_a(i);
            if (in == null) {
                size -= max;
                continue;
            }
            if (!ReikaItemHelper.matchStacks(is, in) || !ItemStack.func_77970_a((ItemStack)is, (ItemStack)in)) continue;
            int space = max - in.field_77994_a;
            size -= space;
        }
        return size <= 0;
    }

    public static int getFirstEmptySlot(IInventory ii) {
        for (int i = 0; i < ii.func_70302_i_(); ++i) {
            if (ii.func_70301_a(i) != null) continue;
            return i;
        }
        return -1;
    }

    public static boolean hasItemStack(ItemStack is, IInventory ii) {
        for (int i = 0; i < ii.func_70302_i_(); ++i) {
            if (ii.func_70301_a(i) == null || ii.func_70301_a(i).func_77973_b() != is.func_77973_b() || ii.func_70301_a(i).func_77960_j() != is.func_77960_j()) continue;
            return true;
        }
        return false;
    }

    public static int locateNonFullStackOf(ItemStack is, IInventory ii) {
        if (is == null) {
            return -1;
        }
        int slot = -1;
        for (int i = 0; i < ii.func_70302_i_(); ++i) {
            ItemStack in = ii.func_70301_a(i);
            if (in == null || !ReikaItemHelper.matchStacks(is, in) || !ItemStack.func_77970_a((ItemStack)is, (ItemStack)in) || in.field_77994_a >= is.func_77976_d()) continue;
            return i;
        }
        return -1;
    }

    public static boolean hasNonFullStackOf(ItemStack is, IInventory ii) {
        return ReikaInventoryHelper.locateNonFullStackOf(is, ii) != -1;
    }

    public static boolean hasItem(Item id, IInventory ii) {
        for (int i = 0; i < ii.func_70302_i_(); ++i) {
            if (ii.func_70301_a(i) == null || ii.func_70301_a(i).func_77973_b() != id) continue;
            return true;
        }
        return false;
    }

    public static int findMaxMetadataOfIDWithinMaximum(Item id, ItemStack[] inv, int maxmeta) {
        int max = -1;
        for (int i = 0; i < inv.length; ++i) {
            if (inv[i] == null || inv[i].func_77973_b() != id || inv[i].func_77960_j() <= max || inv[i].func_77960_j() > maxmeta) continue;
            max = inv[i].func_77960_j();
        }
        return max;
    }

    public static void convertItems(Item id0, int m0, Item id1, int m1, ItemStack[] inv) {
        for (int i = 0; i < inv.length; ++i) {
            if (inv[i] == null || inv[i].func_77973_b() != id0 && id0 != null || inv[i].func_77960_j() != m0 && m0 != -1) continue;
            if (id1 == null && m1 == -1) {
                return;
            }
            ItemStack to = m1 == -1 ? new ItemStack(id1, inv[i].field_77994_a, inv[i].func_77960_j()) : (id1 == null ? new ItemStack(inv[i].func_77973_b(), inv[i].field_77994_a, m1) : new ItemStack(id1, inv[i].field_77994_a, m1));
            inv[i] = to;
        }
    }

    public static void damageInventory(ItemStack[] inv) {
        for (int i = 0; i < inv.length; ++i) {
            ItemStack to;
            if (inv[i] == null) continue;
            inv[i] = to = new ItemStack(inv[i].func_77973_b(), inv[i].field_77994_a, inv[i].func_77960_j() + 1);
        }
    }

    public static void repairInventory(ItemStack[] inv) {
        for (int i = 0; i < inv.length; ++i) {
            ItemStack to;
            if (inv[i] == null) continue;
            inv[i] = to = new ItemStack(inv[i].func_77973_b(), inv[i].field_77994_a, 0);
        }
    }

    public static boolean hasNEmptyStacks(IInventory ii, int n) {
        int e = 0;
        for (int i = 0; i < ii.func_70302_i_(); ++i) {
            if (ii.func_70301_a(i) != null) continue;
            ++e;
        }
        return e == n;
    }

    public static boolean hasNEmptyStacks(ItemStack[] inv, int n) {
        int e = 0;
        for (int i = 0; i < inv.length; ++i) {
            if (inv[i] != null) continue;
            ++e;
        }
        return e == n;
    }

    public static int locateIDInInventory(Item id, IInventory ii) {
        for (int i = 0; i < ii.func_70302_i_(); ++i) {
            if (ii.func_70301_a(i) == null || ii.func_70301_a(i).func_77973_b() != id) continue;
            return i;
        }
        return -1;
    }

    public static int[] getWholeInventoryForISided(ISidedInventory ii) {
        return ReikaArrayHelper.getLinearArray(ii.func_70302_i_());
    }

    public static ItemStack getStackInSlotOnClosing(IInventory ii, int slot) {
        if (ii.func_70301_a(slot) != null) {
            ItemStack itemstack = ii.func_70301_a(slot);
            ii.func_70299_a(slot, null);
            return itemstack;
        }
        return null;
    }

    public static ItemStack decrStackSize(IInventory ii, int slot, int decr) {
        if (ii.func_70301_a(slot) != null) {
            if (ii.func_70301_a((int)slot).field_77994_a <= decr) {
                ItemStack itemstack = ii.func_70301_a(slot);
                ii.func_70299_a(slot, null);
                return itemstack;
            }
            ItemStack itemstack1 = ii.func_70301_a(slot).func_77979_a(decr);
            if (ii.func_70301_a((int)slot).field_77994_a == 0) {
                ii.func_70299_a(slot, null);
            }
            return itemstack1;
        }
        return null;
    }

    public static boolean addOrSetStack(ItemStack is, ItemStack[] inv, int slot) {
        if (is == null) {
            return false;
        }
        if (inv[slot] == null) {
            inv[slot] = is.func_77946_l();
            return true;
        }
        int max = inv[slot].func_77976_d();
        if (!ReikaItemHelper.matchStacks(is, inv[slot]) || !ItemStack.func_77970_a((ItemStack)is, (ItemStack)inv[slot]) || inv[slot].field_77994_a + is.field_77994_a > max) {
            return false;
        }
        inv[slot].field_77994_a += is.field_77994_a;
        return true;
    }

    public static boolean addOrSetStack(Item id, int size, int meta, ItemStack[] inv, int slot) {
        return ReikaInventoryHelper.addOrSetStack(new ItemStack(id, size, meta), inv, slot);
    }

    public static boolean addOrSetStack(Block id, int size, int meta, ItemStack[] inv, int slot) {
        return ReikaInventoryHelper.addOrSetStack(Item.func_150898_a((Block)id), size, meta, inv, slot);
    }

    public static List<ItemStack> getWholeInventory(IInventory ii) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        for (int i = 0; i < ii.func_70302_i_(); ++i) {
            li.add(ii.func_70301_a(i));
        }
        return li;
    }

    public static void clearInventory(IInventory ii) {
        for (int i = 0; i < ii.func_70302_i_(); ++i) {
            ii.func_70299_a(i, null);
        }
    }

    public static List<ItemStack> addMultipleItems(IInventory ii, List<ItemStack> items) {
        ArrayList<ItemStack> extra = new ArrayList<ItemStack>();
        for (int i = 0; i < items.size(); ++i) {
            if (ReikaInventoryHelper.addToIInv(items.get(i), ii)) continue;
            extra.add(items.get(i));
        }
        return extra;
    }

    public static ItemStack getNextBlockInInventory(ItemStack[] inv, boolean decr) {
        for (int i = 0; i < inv.length; ++i) {
            Item item;
            ItemStack is = inv[i];
            if (is == null || !((item = is.func_77973_b()) instanceof ItemBlock)) continue;
            if (decr) {
                ReikaInventoryHelper.decrStack(i, inv);
            }
            return inv[i];
        }
        return null;
    }

    public static boolean isFull(IInventory ii) {
        for (int i = 0; i < ii.func_70302_i_(); ++i) {
            ItemStack is = ii.func_70301_a(i);
            if (is == null) {
                return false;
            }
            int max = Math.min(is.func_77976_d(), ii.func_70297_j_());
            if (is.field_77994_a >= max) continue;
            return false;
        }
        return true;
    }

    public static void spillAndEmptyInventory(World world, int x, int y, int z, ItemStack[] inventory) {
        for (int i = 0; i < inventory.length; ++i) {
            ItemStack is = inventory[i];
            inventory[i] = null;
            if (is == null || world.field_72995_K) continue;
            EntityItem ei = new EntityItem(world, (double)((float)x + rand.nextFloat()), (double)((float)y + rand.nextFloat()), (double)((float)z + rand.nextFloat()), is);
            ReikaEntityHelper.addRandomDirVelocity((Entity)ei, 0.2);
            world.func_72838_d((Entity)ei);
        }
    }

    public static void spillAndEmptyInventory(World world, int x, int y, int z, IInventory ii) {
        int size = ii.func_70302_i_();
        for (int i = 0; i < size; ++i) {
            ItemStack s = ii.func_70301_a(i);
            if (s == null) continue;
            ii.func_70299_a(i, null);
            EntityItem ei = new EntityItem(world, (double)((float)x + rand.nextFloat()), (double)((float)y + rand.nextFloat()), (double)((float)z + rand.nextFloat()), s);
            ReikaEntityHelper.addRandomDirVelocity((Entity)ei, 0.2);
            ei.field_145804_b = 10;
            if (world.field_72995_K) continue;
            world.func_72838_d((Entity)ei);
        }
    }

    public static int getFirstNonEmptySlot(IInventory ii) {
        for (int i = 0; i < ii.func_70302_i_(); ++i) {
            if (ii.func_70301_a(i) == null) continue;
            return i;
        }
        return -1;
    }

    public static int addStackAndReturnCount(ItemStack stack, IInventory ii) {
        int transferred = 0;
        for (int i = 0; i < ii.func_70302_i_() && stack.field_77994_a > 0; ++i) {
            int max;
            int space;
            ItemStack is = ii.func_70301_a(i);
            if (is == null) {
                ii.func_70299_a(i, stack);
                transferred += stack.field_77994_a;
                stack.field_77994_a = 0;
                continue;
            }
            if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)is) || (space = (max = Math.min(stack.func_77976_d(), ii.func_70297_j_())) - is.field_77994_a) <= 0) continue;
            int added = Math.min(space, stack.field_77994_a);
            transferred += added;
            is.field_77994_a += added;
            stack.field_77994_a -= added;
        }
        return transferred;
    }

    public static ArrayList<ItemStack> getAllTransferrables(ForgeDirection from, IInventory source) {
        ArrayList<ItemStack> li;
        block3: {
            block2: {
                li = new ArrayList<ItemStack>();
                if (!(source instanceof ISidedInventory)) break block2;
                ISidedInventory ii = (ISidedInventory)source;
                for (int slot = 0; slot < source.func_70302_i_(); ++slot) {
                    ItemStack is = ii.func_70301_a(slot);
                    if (is == null || !ii.func_102008_b(slot, is, from.getOpposite().ordinal())) continue;
                    li.add(is);
                }
                break block3;
            }
            if (!(source instanceof IInventory)) break block3;
            IInventory ii = source;
            for (int slot = 0; slot < source.func_70302_i_(); ++slot) {
                ItemStack is = ii.func_70301_a(slot);
                if (is == null) continue;
                li.add(is);
            }
        }
        return li;
    }

    public static HashMap<Integer, ItemStack> getLocatedTransferrables(ForgeDirection from, IInventory source) {
        HashMap<Integer, ItemStack> li;
        block3: {
            block2: {
                li = new HashMap<Integer, ItemStack>();
                if (!(source instanceof ISidedInventory)) break block2;
                ISidedInventory ii = (ISidedInventory)source;
                for (int slot = 0; slot < source.func_70302_i_(); ++slot) {
                    ItemStack is = ii.func_70301_a(slot);
                    if (is == null || !ii.func_102008_b(slot, is, from.getOpposite().ordinal())) continue;
                    li.put(slot, is);
                }
                break block3;
            }
            if (!(source instanceof IInventory)) break block3;
            IInventory ii = source;
            for (int slot = 0; slot < source.func_70302_i_(); ++slot) {
                ItemStack is = ii.func_70301_a(slot);
                if (is == null) continue;
                li.put(slot, is);
            }
        }
        return li;
    }

    public static ArrayList<Integer> getSlotsWithItemStack(ItemStack is, IInventory ii, boolean matchSize) {
        ArrayList<Integer> li = new ArrayList<Integer>();
        for (int i = 0; i < ii.func_70302_i_(); ++i) {
            ItemStack in = ii.func_70301_a(i);
            if (!ReikaItemHelper.matchStacks(is, in) || matchSize && in.field_77994_a != is.field_77994_a) continue;
            li.add(i);
        }
        return li;
    }

    public static ArrayList<Integer> getSlotsWithItemStack(ItemStack is, ItemStack[] inv, boolean matchSize) {
        ArrayList<Integer> li = new ArrayList<Integer>();
        for (int i = 0; i < inv.length; ++i) {
            ItemStack in = inv[i];
            if (!ReikaItemHelper.matchStacks(is, in) || matchSize && in.field_77994_a != is.field_77994_a) continue;
            li.add(i);
        }
        return li;
    }

    public static HashSet<Integer> getSlotsBetweenWithItemStack(ItemStack is, IInventory ii, int min, int max, boolean matchSize) {
        HashSet<Integer> li = new HashSet<Integer>();
        for (int i = min; i <= max; ++i) {
            ItemStack in = ii.func_70301_a(i);
            if (!ReikaItemHelper.matchStacks(is, in) || matchSize && in.field_77994_a != is.field_77994_a) continue;
            li.add(i);
        }
        return li;
    }

    public static boolean inventoryContains(ItemHashMap<Integer> map, IInventory ii) {
        ItemHashMap<Integer> inv = ItemHashMap.getFromInventory(ii);
        for (ItemStack is : map.keySet()) {
            int need = map.get(is);
            Integer has = inv.get(is);
            if (has != null && need <= has) continue;
            return false;
        }
        return true;
    }

    public static void removeFromInventory(ItemHashMap<Integer> map, IInventory ii) {
        for (ItemStack is : map.keySet()) {
            int max;
            int loc = ReikaInventoryHelper.locateInInventory(is, ii, false);
            for (int need = map.get(is).intValue(); loc >= 0 && need > 0; need -= max) {
                ItemStack in = ii.func_70301_a(loc);
                max = Math.min(need, in.field_77994_a);
                ReikaInventoryHelper.decrStack(loc, ii, max);
                loc = ReikaInventoryHelper.locateInInventory(is, ii, false);
            }
        }
    }

    public static void generateMultipliedLoot(int bonus, Random r, String s, IInventory te) {
        for (int n = 0; n < bonus; ++n) {
            TemporaryInventory ii = new TemporaryInventory(te.func_70302_i_());
            WeightedRandomChestContent[] loot = ChestGenHooks.getItems((String)s, (Random)r);
            WeightedRandomChestContent.func_76293_a((Random)r, (WeightedRandomChestContent[])loot, (IInventory)ii, (int)ChestGenHooks.getCount((String)s, (Random)r));
            for (int i = 0; i < ii.func_70302_i_(); ++i) {
                ItemStack in = ii.func_70301_a(i);
                if (in == null) continue;
                int tg = r.nextInt(ii.func_70302_i_());
                for (int tries = 0; te.func_70301_a(tg) != null && tries < 10; ++tries) {
                    tg = r.nextInt(ii.func_70302_i_());
                }
                if (te.func_70301_a(tg) != null) continue;
                te.func_70299_a(tg, in);
            }
        }
    }

    public static void addItems(IInventory ii, ArrayList<ItemStack> li) {
        for (ItemStack is : li) {
            ReikaInventoryHelper.addToIInv(is, ii);
        }
    }

    public static int drawFromInventory(ItemStack is, int max, IInventory inventory) {
        int amt = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            int rem;
            ItemStack in = inventory.func_70301_a(i);
            if (!ReikaItemHelper.matchStacks(is, in) || (rem = Math.min(max, in.field_77994_a)) <= 0) continue;
            if (in.field_77994_a > rem) {
                in.field_77994_a -= rem;
            } else {
                inventory.func_70299_a(i, null);
            }
            amt += rem;
            if ((max -= rem) <= 0) break;
        }
        return amt;
    }

    public static boolean isEmpty(IInventory ii) {
        return ReikaInventoryHelper.isEmptyFrom(ii, 0, ii.func_70302_i_() - 1);
    }

    public static boolean isEmptyFrom(IInventory ii, int from, int to) {
        for (int i = from; i <= to; ++i) {
            ItemStack is = ii.func_70301_a(i);
            if (is == null) continue;
            return false;
        }
        return true;
    }
}

