/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.MathSci;

import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ReikaMusicHelper {
    public static Note getNote(int note) {
        return Note.notes[(note + 6) % Note.notes.length];
    }

    public static String getNoteName(int note) {
        return ReikaMusicHelper.getNote((int)note).name;
    }

    public static boolean isNoteSharpOrFlat(int note) {
        return !ReikaMusicHelper.getNote(note).isPure();
    }

    public static boolean isNoteSharp(int note) {
        return ReikaMusicHelper.getNoteName(note).endsWith("#");
    }

    public static boolean isNoteFlat(int note) {
        return ReikaMusicHelper.getNoteName(note).endsWith("b");
    }

    public static enum ChordType {
        OCTAVE(0, 12),
        POWER(0, 7, 12),
        MAJOR(0, 4, 7, 12),
        MINOR(0, 3, 7, 12),
        AUGMENTED(0, 4, 8, 12),
        DIMINISHED(0, 3, 6, 12);

        private final ArrayList<Integer> notes;

        private ChordType(int ... n2) {
            this.notes = ReikaJavaLibrary.makeIntListFromArray(n2);
        }

        public ArrayList<MusicKey> getChord(MusicKey tonic) {
            ArrayList<MusicKey> li = new ArrayList<MusicKey>();
            for (int note : this.notes) {
                li.add(tonic.getInterval(note));
            }
            return li;
        }

        public String toString() {
            return this.name() + " Chord: " + this.notes;
        }
    }

    public static enum KeySignature {
        C(Note.C, new Note[0]),
        F(Note.F, Note.B),
        BFLAT(Note.B, Note.B, Note.E),
        EFLAT(Note.E, Note.B, Note.E, Note.A),
        AFLAT(Note.A, Note.B, Note.E, Note.A, Note.D),
        DFLAT(Note.D, Note.B, Note.E, Note.A, Note.D, Note.G),
        GFLAT(Note.G, Note.B, Note.E, Note.A, Note.D, Note.G, Note.C),
        CFLAT(Note.C, Note.B, Note.E, Note.A, Note.D, Note.G, Note.C, Note.F),
        G(Note.G, Note.F),
        D(Note.D, Note.F, Note.C),
        A(Note.A, Note.F, Note.C, Note.G),
        E(Note.E, Note.F, Note.C, Note.G, Note.D),
        B(Note.B, Note.F, Note.C, Note.G, Note.D, Note.A),
        FSHARP(Note.F, Note.F, Note.C, Note.G, Note.D, Note.A, Note.E),
        CSHARP(Note.C, Note.F, Note.C, Note.G, Note.D, Note.A, Note.E, Note.B);

        private final HashSet<Note> sharps = new HashSet();
        private final HashSet<Note> flats = new HashSet();
        private final HashSet<Note> notes = new HashSet();
        private final ArrayList<Note> scale = new ArrayList();
        private final ArrayList<Note> minor = new ArrayList();
        public final Note tonic;
        private static final EnumMap<Note, KeySignature> keyMap;
        private static final EnumMap<Note, KeySignature> minorKeyMap;
        public static final KeySignature[] keys;

        private KeySignature(Note ton, Note ... key) {
            for (int i = 0; i < key.length; ++i) {
                Note n2 = key[i];
                if (this.isSharp()) {
                    this.sharps.add(n2);
                    continue;
                }
                if (!this.isFlat()) continue;
                this.flats.add(n2);
            }
            Note ctr = ton;
            if (this.sharps.contains((Object)ton)) {
                ton = ton.getSharp();
            } else if (this.flats.contains((Object)ton)) {
                ton = ton.getFlat();
            }
            this.tonic = ton;
            ArrayList<Note> li = new ArrayList<Note>(Note.pureNotes);
            ReikaJavaLibrary.cycleList(li, li.size() - li.indexOf((Object)ctr));
            for (int i = 0; i < li.size(); ++i) {
                Note n3 = (Note)((Object)li.get(i));
                if (this.sharps.contains((Object)n3)) {
                    li.set(i, n3.getSharp());
                    continue;
                }
                if (!this.flats.contains((Object)n3)) continue;
                li.set(i, n3.getFlat());
            }
            this.notes.addAll(li);
            this.scale.addAll(li);
            this.minor.addAll(li);
            ReikaJavaLibrary.cycleList(this.minor, 2);
        }

        public boolean isFlat() {
            return this.ordinal() != 0 && this.ordinal() < 8;
        }

        public boolean isSharp() {
            return this.ordinal() >= 8;
        }

        public Set<Note> getFlats() {
            return Collections.unmodifiableSet(this.flats);
        }

        public Set<Note> getSharps() {
            return Collections.unmodifiableSet(this.sharps);
        }

        public List<Note> getScale() {
            return Collections.unmodifiableList(this.scale);
        }

        public List<Note> getRelativeMinor() {
            return Collections.unmodifiableList(this.minor);
        }

        public String toString() {
            return "Scale '" + this.name() + "' (" + this.tonic.name + "): M+" + this.scale + " & m-" + this.minor;
        }

        public static KeySignature getByTonic(MusicKey key) {
            return KeySignature.getByTonic(key.getNote());
        }

        public static KeySignature getByTonic(Note key) {
            return keyMap.get((Object)key);
        }

        public static KeySignature getByMinorTonic(MusicKey key) {
            return KeySignature.getByMinorTonic(key.getNote());
        }

        public static KeySignature getByMinorTonic(Note key) {
            return minorKeyMap.get((Object)key);
        }

        public boolean isNoteValid(Note n) {
            return this.notes.contains((Object)n);
        }

        public static KeySignature findSignature(ArrayList<MusicKey> li) {
            HashSet<Note> notes = new HashSet<Note>();
            for (MusicKey key : li) {
                notes.add(key.getNote());
            }
            for (int i = 0; i < keys.length; ++i) {
                KeySignature ks = keys[i];
                boolean flag = true;
                for (Note n : notes) {
                    if (ks.isNoteValid(n)) continue;
                    flag = false;
                    break;
                }
                if (!flag) continue;
                return ks;
            }
            return null;
        }

        static {
            keyMap = new EnumMap(Note.class);
            minorKeyMap = new EnumMap(Note.class);
            keys = KeySignature.values();
            for (int i = 0; i < keys.length; ++i) {
                KeySignature ks = keys[i];
                keyMap.put(ks.tonic, ks);
                minorKeyMap.put((Note)((Enum)ks.minor.get(0)), ks);
            }
        }
    }

    public static enum MusicKey {
        C1(33),
        Cs1(35),
        D1(37),
        Eb1(39),
        E1(41),
        F1(44),
        Fs1(46),
        G1(49),
        Ab1(52),
        A1(55),
        Bb1(58),
        B1(62),
        C2(65),
        Cs2(69),
        D2(73),
        Eb2(78),
        E2(82),
        F2(87),
        Fs2(92),
        G2(98),
        Ab2(104),
        A2(110),
        Bb2(117),
        B2(123),
        C3(131),
        Cs3(139),
        D3(147),
        Eb3(156),
        E3(165),
        F3(175),
        Fs3(185),
        G3(196),
        Ab3(208),
        A3(220),
        Bb3(233),
        B3(247),
        C4(262),
        Cs4(277),
        D4(294),
        Eb4(311),
        E4(330),
        F4(349),
        Fs4(370),
        G4(392),
        Ab4(415),
        A4(440),
        Bb4(466),
        B4(494),
        C5(523),
        Cs5(554),
        D5(587),
        Eb5(622),
        E5(659),
        F5(698),
        Fs5(740),
        G5(784),
        Ab5(830),
        A5(880),
        Bb5(932),
        B5(988),
        C6(1046),
        Cs6(1109),
        D6(1175),
        Eb6(1245),
        E6(1319),
        F6(1397),
        Fs6(1480),
        G6(1568),
        Ab6(1661),
        A6(1760),
        Bb6(1865),
        B6(1976),
        C7(2093),
        Cs7(2218),
        D7(2349),
        Eb7(2489),
        E7(2637),
        F7(2794),
        Fs7(2960),
        G7(3136),
        Ab7(3322),
        A7(3520),
        Bb7(3729),
        B7(3951),
        C8(4186);

        public final int pitch;
        private static final MusicKey[] list;

        private MusicKey(int f) {
            this.pitch = f;
        }

        public MusicKey getMinorThird() {
            return this.getInterval(3);
        }

        public MusicKey getMajorThird() {
            return this.getInterval(4);
        }

        public MusicKey getFourth() {
            return this.getInterval(5);
        }

        public MusicKey getFifth() {
            return this.getInterval(7);
        }

        public MusicKey getOctave() {
            return this.getInterval(12);
        }

        public MusicKey getInterval(int n) {
            int o = this.ordinal() + n;
            return o >= 0 && o < list.length ? list[o] : this;
        }

        public double getRatio(MusicKey k) {
            return MusicKey.getRatio(k, this);
        }

        public static double getRatio(MusicKey k1, MusicKey k2) {
            return (double)k2.pitch / (double)k1.pitch;
        }

        public String toString() {
            return this.displayName() + " @ " + this.pitch + " Hz";
        }

        public Note getNote() {
            return Note.notes[this.ordinal() % Note.notes.length];
        }

        public static Collection<MusicKey> getAllOf(Note n) {
            ArrayList<MusicKey> li = new ArrayList<MusicKey>();
            for (int i = n.ordinal(); i < list.length; i += Note.notes.length) {
                li.add(list[i]);
            }
            return li;
        }

        public static MusicKey getKeyFromMIDI(int key) {
            int index = key - 60 + C5.ordinal();
            return index >= 0 && index < list.length ? list[index] : null;
        }

        public static MusicKey getByIndex(int key) {
            return key >= 0 && key < list.length ? list[key] : null;
        }

        public String displayName() {
            return this.name().replaceAll("s", "#");
        }

        static {
            list = MusicKey.values();
        }
    }

    public static enum Note {
        C("C"),
        CSHARP("C#"),
        D("D"),
        EFLAT("Eb"),
        E("E"),
        F("F"),
        FSHARP("F#"),
        G("G"),
        GSHARP("G#"),
        A("A"),
        BFLAT("Bb"),
        B("B");

        public final String name;
        private static final ArrayList<Note> pureNotes;
        private static final Note[] notes;

        private Note(String s) {
            this.name = s;
        }

        public boolean isPure() {
            return this.name().length() == 1;
        }

        public Note getFlat() {
            return this == C ? B : notes[this.ordinal() - 1];
        }

        public Note getSharp() {
            return this == B ? C : notes[this.ordinal() + 1];
        }

        public String toString() {
            return this.name;
        }

        static {
            pureNotes = new ArrayList();
            notes = Note.values();
            for (int i = 0; i < notes.length; ++i) {
                Note n = notes[i];
                if (!n.isPure()) continue;
                pureNotes.add(n);
            }
        }
    }
}

