/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.MathSci;

import Reika.DragonAPI.DragonAPICore;
import java.awt.Polygon;
import net.minecraft.util.MathHelper;

public final class ReikaMathLibrary
extends DragonAPICore {
    public static final double e = Math.E;
    public static final double pi = Math.PI;

    public static double py3d(double dx, double dy, double dz) {
        double val = dx * dx + dy * dy + dz * dz;
        return Math.sqrt(val);
    }

    public static boolean approxp(double input, double target, double percent) {
        double low = input - input * percent / 100.0;
        double hi = input + input * percent / 100.0;
        return target >= low && target <= hi;
    }

    public static boolean approxr(double input, double target, double range) {
        double low = input - range;
        double hi = input + range;
        return target >= low && target <= hi;
    }

    public static boolean approxpAbs(double input, double target, double percent) {
        return ReikaMathLibrary.approxp(Math.abs(input), Math.abs(target), percent);
    }

    public static boolean approxrAbs(double input, double target, double range) {
        return ReikaMathLibrary.approxr(Math.abs(input), Math.abs(target), range);
    }

    public static double intpow(double base, int pow) {
        double val = 1.0;
        if (pow == 0) {
            return val;
        }
        if (pow > 0) {
            for (int i = 0; i < pow; ++i) {
                val *= base;
            }
        } else {
            pow = -pow;
            for (int i = 0; i < pow; ++i) {
                val /= base;
            }
        }
        return val;
    }

    public static int intpow2(int base, int pow) {
        int val = 1;
        for (int i = 0; i < pow; ++i) {
            val *= base;
        }
        return val;
    }

    public static long longpow(int base, int pow) {
        long val = 1L;
        for (int i = 0; i < pow; ++i) {
            val *= (long)base;
        }
        return val;
    }

    public static double doubpow(double base, double pow) {
        return Math.pow(base, pow);
    }

    public static int randinrange(int low, int hi) {
        int val = low;
        return val;
    }

    @Deprecated
    public static double leftover(double a, double b) {
        return Math.abs(a - b);
    }

    public static int logbase2(long inp) {
        return inp > 0L ? 63 - Long.numberOfLeadingZeros(inp) : 0;
    }

    public static double logbase(long inp, int base) {
        return ReikaMathLibrary.logbase((double)inp, (double)base);
    }

    public static double logbase(double inp, double base) {
        if (base == 2.0 && ReikaMathLibrary.isInteger(inp) && ReikaMathLibrary.isPowerOfTwo((long)inp)) {
            return ReikaMathLibrary.logbase2((long)inp);
        }
        return Math.log(inp) / Math.log(base);
    }

    public static boolean isPositiveInteger(double num) {
        return num > 0.0 && (double)((int)num) == num;
    }

    public static boolean isInteger(double num) {
        return (double)MathHelper.func_76128_c((double)num) == num;
    }

    public static boolean isPowerOfTwo(long num) {
        return num > 0L && (num & num - 1L) == 0L;
    }

    public static int extrema(int a, int b, String control) {
        if ("min".equals(control)) {
            if (a > b) {
                return b;
            }
            return a;
        }
        if ("absmin".equals(control)) {
            if (a < 0) {
                a *= -1;
            }
            if (b < 0) {
                b *= -1;
            }
            if (a > b) {
                return b;
            }
            return a;
        }
        if ("max".equals(control)) {
            if (a > b) {
                return a;
            }
            return b;
        }
        if ("absmax".equals(control)) {
            if (a < 0) {
                a *= -1;
            }
            if (b < 0) {
                b *= -1;
            }
            if (a > b) {
                return a;
            }
            return b;
        }
        return -987654321;
    }

    public static double extremad(double a, double b, String control) {
        if (control == "min") {
            if (a > b) {
                return b;
            }
            return a;
        }
        if (control == "absmin") {
            if (a < 0.0) {
                a *= -1.0;
            }
            if (b < 0.0) {
                b *= -1.0;
            }
            if (a > b) {
                return b;
            }
            return a;
        }
        if (control == "max") {
            if (a > b) {
                return a;
            }
            return b;
        }
        if (control == "absmax") {
            if (a < 0.0) {
                a *= -1.0;
            }
            if (b < 0.0) {
                b *= -1.0;
            }
            if (a > b) {
                return a;
            }
            return b;
        }
        return -9.87654321E8;
    }

    public static int ceil2exp(int val) {
        if (val <= 0) {
            return 0;
        }
        --val;
        val = val >> 1 | val;
        val = val >> 2 | val;
        val = val >> 4 | val;
        val = val >> 8 | val;
        val = val >> 16 | val;
        return ++val;
    }

    public static int ceilPseudo2Exp(int val) {
        int pow = ReikaMathLibrary.ceil2exp(val);
        int prev = ReikaMathLibrary.intpow2(2, ReikaMathLibrary.logbase2(pow) - 1);
        int mid = prev * 3 / 2;
        if (prev >= val) {
            return prev;
        }
        if (mid >= val) {
            return mid;
        }
        return pow;
    }

    public static boolean isSameSign(double val1, double val2) {
        return Math.signum(val1) == Math.signum(val2);
    }

    public static int[] splitStacks(int number, int size) {
        int[] stacks = new int[2];
        if (number == 0) {
            stacks[0] = 0;
            stacks[1] = 0;
            return stacks;
        }
        while (number >= size) {
            stacks[0] = stacks[0] + 1;
            number -= size;
        }
        stacks[1] = number;
        return stacks;
    }

    public static int nextMultiple(int a, int b) {
        while (b % a != 0) {
            ++b;
        }
        return b;
    }

    public static boolean isPowerOf(int num, int base) {
        return ReikaMathLibrary.logbase(num, base) == (double)((int)ReikaMathLibrary.logbase(num, base));
    }

    public static double powerFalloff(double peakx, double peaky, double pos, double factor, double power) {
        double distance = pos - peakx;
        if (distance < 0.0) {
            distance = -distance;
        }
        distance = ReikaMathLibrary.doubpow(distance, power);
        double reduction = factor * distance;
        return peaky - reduction;
    }

    public static double expFalloff(double peakx, double peaky, double pos, double factor, double base) {
        double distance = pos - peakx;
        if (distance < 0.0) {
            distance = -distance;
        }
        double reduction = factor * ReikaMathLibrary.doubpow(base, distance);
        return peaky - reduction;
    }

    public static boolean isValueOutsideBounds(int low, int hi, int val) {
        return val < low || val > hi;
    }

    public static boolean isValueInsideBounds(int low, int hi, int val) {
        return val < hi && val > low;
    }

    public static boolean isValueInsideBoundsIncl(int low, int hi, int val) {
        return val <= hi && val >= low;
    }

    public static boolean isValueInsideBounds(double low, double hi, double val) {
        return val < hi && val > low;
    }

    public static boolean isValueInsideBoundsIncl(double low, double hi, double val) {
        return val <= hi && val >= low;
    }

    public static double[] getScientificNotation(double val) {
        int pow = 0;
        while (val >= 1000.0) {
            pow += 3;
            val /= 1000.0;
        }
        return new double[]{val, pow};
    }

    public static double getThousandBase(double val) {
        if (Math.abs(val) == Double.POSITIVE_INFINITY) {
            return val;
        }
        if (val == Double.NaN) {
            return val;
        }
        boolean neg = val < 0.0;
        for (val = Math.abs(val); val >= 1000.0; val /= 1000.0) {
        }
        while (val < 1.0 && val > 0.0) {
            val *= 1000.0;
        }
        return neg ? -val : val;
    }

    public static int factorial(int val) {
        int base = 1;
        for (int i = val; i > 0; --i) {
            base *= i;
        }
        return base;
    }

    public static boolean doRangesOverLap(int min1, int max1, int min2, int max2) {
        return max2 >= min1 && min2 <= max1;
    }

    public static boolean nBoolsAreTrue(int number, boolean ... args) {
        int count = 0;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i]) continue;
            ++count;
        }
        return count == number;
    }

    public static boolean nPlusBoolsAreTrue(int number, boolean ... args) {
        int count = 0;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i]) continue;
            ++count;
        }
        return count >= number;
    }

    public static int roundDownToX(int multiple, int val) {
        int ret = val - val % multiple;
        if (val < 0) {
            ret -= multiple;
        }
        return ret;
    }

    public static int roundUpToX(int multiple, int val) {
        return ReikaMathLibrary.roundDownToX(multiple, val) + multiple;
    }

    public static int roundToNearestX(int multiple, int val) {
        return (val + multiple / 2) / multiple * multiple;
    }

    public static double[] splitNumberByDigits(long num, int base) {
        int len = 1 + (int)ReikaMathLibrary.logbase(num, base);
        double[] arr = new double[len];
        for (int i = 0; i < len; ++i) {
            long val = num % (long)base;
            arr[i] = (double)val / (double)base;
            num /= (long)base;
        }
        return arr;
    }

    public static int multiMin(int ... vals) {
        int min = vals[0];
        for (int i = 1; i < vals.length; ++i) {
            min = Math.min(min, vals[i]);
        }
        return min;
    }

    public static int multiMax(int ... vals) {
        int max = vals[0];
        for (int i = 1; i < vals.length; ++i) {
            max = Math.max(max, vals[i]);
        }
        return max;
    }

    public static float getDecimalPart(float f) {
        return f - (float)((int)f);
    }

    public static double getDecimalPart(double d) {
        return d - (double)((int)d);
    }

    public static int addAndRollover(int a, int b, int min, int max) {
        int sum = a + b;
        int under = min - sum;
        int range = max - min;
        for (int over = sum - max; over > 0; over -= range) {
            sum = Math.min(max, min + over);
        }
        while (under > 0) {
            sum = Math.max(min, max - under);
            under -= range;
        }
        return sum;
    }

    public static boolean isPointInsideEllipse(double x, double y, double z, double ra, double rb, double rc) {
        return (ra > 0.0 ? x * x / (ra * ra) : 0.0) + (rb > 0.0 ? y * y / (rb * rb) : 0.0) + (rc > 0.0 ? z * z / (rc * rc) : 0.0) <= 1.0;
    }

    public static boolean isPointInsidePowerEllipse(double x, double y, double z, double rx, double ry, double rz, double pow) {
        x = Math.abs(x);
        y = Math.abs(y);
        z = Math.abs(z);
        return (rx > 0.0 ? Math.pow(x, pow) / Math.pow(rx, pow) : 0.0) + (ry > 0.0 ? Math.pow(y, pow) / Math.pow(ry, pow) : 0.0) + (rz > 0.0 ? Math.pow(z, pow) / Math.pow(rz, pow) : 0.0) <= 1.0;
    }

    public static double linterpolate(double x, double x1, double x2, double y1, double y2) {
        return y1 + (x - x1) / (x2 - x1) * (y2 - y1);
    }

    public static int bitRound(int val, int bits) {
        return val >> bits << bits;
    }

    public static double cosInterpolation(double min, double max, double val) {
        if (!ReikaMathLibrary.isValueInsideBoundsIncl(min, max, val)) {
            return 0.0;
        }
        double size = (max - min) / 2.0;
        double mid = min + size;
        if (val == mid) {
            return 1.0;
        }
        return 0.5 + 0.5 * Math.cos(Math.toRadians((val - mid) / size * 180.0));
    }

    public static double cosInterpolation(double min, double max, double val, double y1, double y2) {
        return y1 + (y2 - y1) * ReikaMathLibrary.cosInterpolation(min, max, val);
    }

    public static int toggleBit(int num, int bit) {
        return num ^ 1 << bit;
    }

    public static int getNBitflags(int length) {
        return ReikaMathLibrary.intpow2(2, length) - 1;
    }

    public static boolean isPerfectSquare(int val) {
        double sqrt = Math.sqrt(val);
        return sqrt == (double)((int)sqrt);
    }

    public static double normalizeToBounds(double val, double min, double max) {
        return ReikaMathLibrary.normalizeToBounds(val, min, max, -1.0, 1.0);
    }

    public static double normalizeToBounds(double val, double min, double max, double low, double high) {
        return min + (max - min) * (val - low) / (high - low);
    }

    public static float roundToDecimalPlaces(float f, int i) {
        float pow = (float)Math.pow(10.0, i);
        return (float)Math.round(f * pow) / pow;
    }

    public static double roundToNearestFraction(double val, double frac) {
        double fac = 1.0 / frac;
        return (double)Math.round(val * fac) / fac;
    }

    public static double roundUpToFraction(double val, double frac) {
        double fac = 1.0 / frac;
        return Math.ceil(val * fac) / fac;
    }

    public static double roundDownToFraction(double val, double frac) {
        double fac = 1.0 / frac;
        return Math.floor(val * fac) / fac;
    }

    public static int getWithinBoundsElse(int val, int min, int max, int fall) {
        return ReikaMathLibrary.isValueInsideBoundsIncl(min, max, val) ? val : fall;
    }

    public static int cycleBitsLeft(int num, int n) {
        return num << (n &= 0x1F) | num >> 32 - n;
    }

    public static long cycleBitsLeft(long num, int n) {
        return num << (n &= 0x3F) | num >> 64 - n;
    }

    public static int cycleBitsRight(int num, int n) {
        return num >> (n &= 0x1F) | num << 32 - n;
    }

    public static long cycleBitsRight(long num, int n) {
        return num >> (n &= 0x3F) | num << 64 - n;
    }

    public static boolean isPointInsidePolygon(double x, double z, double n, double r) {
        return ReikaMathLibrary.isPointInsidePolygon(x, z, n, r, r);
    }

    public static boolean isPointInsidePolygon(double x, double z, double n, double rx, double rz) {
        if (x * x + z * z > rx * rz) {
            return false;
        }
        double da = 360.0 / (2.0 * n);
        Polygon p = new Polygon();
        int i = 0;
        while ((double)i < n) {
            double a = Math.toRadians(da + (double)i * 360.0 / n);
            double dx = rx * Math.cos(a);
            double dz = rz * Math.sin(a);
            p.addPoint((int)Math.round(dx), (int)Math.round(dz));
            ++i;
        }
        return p.contains(x, z);
    }

    public static double getUnequalAverage(double a, double b, double bias) {
        return (1.0 - bias) * a + bias * b;
    }

    public static int clipLeadingHexBits(int val) {
        while (val > 0 && (val & 0xF) == 0) {
            val >>= 4;
        }
        return val;
    }

    public static double ellipticalInterpolation(double x, double x1, double x2, double y1, double y2) {
        return (y2 - y1) * Math.sqrt(Math.pow(x2 - x1, 2.0) - Math.pow(x - x1, 2.0)) / (x2 - x1);
    }

    public static double powerInterpolation(double x, double x1, double x2, double y1, double y2, double power) {
        return (y2 - y1) * Math.pow(Math.pow(x2 - x1, power) - Math.pow(x - x1, power), 1.0 / power) / (x2 - x1);
    }

    public static long cantorCombine(long ... vals) {
        long ret = ReikaMathLibrary.cantorCombine(vals[0], vals[1]);
        for (int i = 2; i < vals.length; ++i) {
            ret = ReikaMathLibrary.cantorCombine(ret, vals[i]);
        }
        return ret;
    }

    public static long cantorCombine(long a, long b) {
        long k1 = a * 2L;
        long k2 = b * 2L;
        if (a < 0L) {
            k1 = a * -2L - 1L;
        }
        if (b < 0L) {
            k2 = b * -2L - 1L;
        }
        return (long)(0.5 * (double)(k1 + k2) * (double)(k1 + k2 + 1L) + (double)k2);
    }
}

